/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DummyMemoryUtil;
import com.intellij.diagnostic.LinuxMemoryUtil;
import com.intellij.diagnostic.MacosMemoryUtil;
import com.intellij.diagnostic.PlatformMemoryUtilKt;
import com.intellij.diagnostic.WindowsMemoryUtil;
import com.intellij.openapi.util.SystemInfo;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u000e2\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\f\u0010\b\u001a\u00060\tR\u00020\u0000H&J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/PlatformMemoryUtil;", "", "<init>", "()V", "memoryStatsApiIsBroken", "", "getCurrentProcessMemoryStats", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "newMemoryStatsProvider", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "trimLinuxNativeHeap", "", "MemoryStats", "MemoryStatsProvider", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPlatformMemoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformMemoryUtil.kt\ncom/intellij/diagnostic/PlatformMemoryUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,643:1\n1#2:644\n*E\n"})
public abstract class PlatformMemoryUtil {
    @NotNull
    public static final Companion Companion;
    private boolean memoryStatsApiIsBroken;
    @NotNull
    private static final PlatformMemoryUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final MemoryStats getCurrentProcessMemoryStats() {
        MemoryStats memoryStats;
        AutoCloseable autoCloseable = this.newMemoryStatsProvider();
        Throwable throwable = null;
        try {
            MemoryStatsProvider it = (MemoryStatsProvider)autoCloseable;
            boolean bl = false;
            memoryStats = it.getCurrentProcessMemoryStats();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return memoryStats;
    }

    @NotNull
    public abstract MemoryStatsProvider newMemoryStatsProvider();

    public void trimLinuxNativeHeap() {
    }

    @JvmStatic
    @NotNull
    public static final PlatformMemoryUtil getInstance() {
        return Companion.getInstance();
    }

    static {
        PlatformMemoryUtil platformMemoryUtil;
        Companion = new Companion(null);
        try {
            platformMemoryUtil = SystemInfo.isLinux ? (PlatformMemoryUtil)new LinuxMemoryUtil() : (SystemInfo.isWin10OrNewer ? (PlatformMemoryUtil)new WindowsMemoryUtil() : (SystemInfo.isMac ? (PlatformMemoryUtil)new MacosMemoryUtil() : (PlatformMemoryUtil)new DummyMemoryUtil()));
        }
        catch (Throwable t) {
            PlatformMemoryUtilKt.access$getLOG$p().error("Failed to set up PlatformMemoryUtil", t);
            platformMemoryUtil = new DummyMemoryUtil();
        }
        INSTANCE = platformMemoryUtil;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/PlatformMemoryUtil$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "getInstance", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PlatformMemoryUtil getInstance() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "", "ram", "", "ramMinusFileMappings", "ramPlusSwapMinusFileMappings", "fileMappingsRam", "<init>", "(JJJJ)V", "getRam", "()J", "getRamMinusFileMappings", "getRamPlusSwapMinusFileMappings", "getFileMappingsRam", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class MemoryStats {
        private final long ram;
        private final long ramMinusFileMappings;
        private final long ramPlusSwapMinusFileMappings;
        private final long fileMappingsRam;

        public MemoryStats(long ram, long ramMinusFileMappings, long ramPlusSwapMinusFileMappings, long fileMappingsRam) {
            this.ram = ram;
            this.ramMinusFileMappings = ramMinusFileMappings;
            this.ramPlusSwapMinusFileMappings = ramPlusSwapMinusFileMappings;
            this.fileMappingsRam = fileMappingsRam;
        }

        public final long getRam() {
            return this.ram;
        }

        public final long getRamMinusFileMappings() {
            return this.ramMinusFileMappings;
        }

        public final long getRamPlusSwapMinusFileMappings() {
            return this.ramPlusSwapMinusFileMappings;
        }

        public final long getFileMappingsRam() {
            return this.fileMappingsRam;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H$J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "(Lcom/intellij/diagnostic/PlatformMemoryUtil;)V", "getCurrentProcessMemoryStats", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "getCurrentProcessMemoryStatsInner", "close", "", "intellij.platform.ide.impl"})
    public abstract class MemoryStatsProvider
    implements AutoCloseable {
        @Nullable
        public final MemoryStats getCurrentProcessMemoryStats() {
            MemoryStats memoryStats;
            if (PlatformMemoryUtil.this.memoryStatsApiIsBroken) {
                return null;
            }
            try {
                memoryStats = this.getCurrentProcessMemoryStatsInner();
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError || t instanceof StackOverflowError || t instanceof CancellationException) {
                    throw t;
                }
                PlatformMemoryUtilKt.access$getLOG$p().error("Failed to get current process memory stats", t);
                PlatformMemoryUtil.this.memoryStatsApiIsBroken = true;
                memoryStats = null;
            }
            return memoryStats;
        }

        @Nullable
        protected abstract MemoryStats getCurrentProcessMemoryStatsInner();

        @Override
        public void close() {
        }
    }
}

