/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.util.IDMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\b\u0007\u0018\u0000 C2\u00020\u0001:\u0001CBw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\u0010\u0010/\u001a\u0004\u0018\u00010\u00002\u0006\u00100\u001a\u000201J\n\u00102\u001a\u00020\tH\u0096\u0080\u0004J\u0006\u00103\u001a\u00020)J\u0006\u00104\u001a\u00020)J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003092\u0006\u00100\u001a\u000201J\u0016\u0010:\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u0010;\u001a\u00020\tJ\u000e\u0010<\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\tJ\u0015\u0010=\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u00032\u0006\u00100\u001a\u000201J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0019\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b'\u0010%R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0017R\u0011\u0010-\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017\u00a8\u0006D"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "", "name", "", "id", "", "superClassId", "classLoaderId", "instanceSize", "", "superClassOffset", "refInstanceFields", "", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "primitiveInstanceFields", "constantFields", "", "objectStaticFields", "Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "primitiveStaticFields", "<init>", "(Ljava/lang/String;JJJII[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;[J[Lcom/intellij/diagnostic/hprof/classstore/StaticField;[Lcom/intellij/diagnostic/hprof/classstore/StaticField;)V", "getName", "()Ljava/lang/String;", "getId", "()J", "getSuperClassId", "getClassLoaderId", "getInstanceSize", "()I", "getSuperClassOffset", "getRefInstanceFields", "()[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getConstantFields", "()[J", "getObjectStaticFields", "()[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "getPrimitiveStaticFields", "equals", "", "other", "prettyName", "getPrettyName", "undecoratedName", "getUndecoratedName", "getSuperClass", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "hashCode", "isArray", "isPrimitiveArray", "copyWithRemappedIDs", "idMapper", "Lcom/intellij/diagnostic/hprof/util/IDMapper;", "allRefFieldNames", "", "getRefField", "index", "getClassFieldName", "getPrimitiveStaticFieldValue", "(Ljava/lang/String;)Ljava/lang/Long;", "computeOffsetOfField", "fieldName", "copyWithName", "newName", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassDefinition.kt\ncom/intellij/diagnostic/hprof/classstore/ClassDefinition\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n11705#2:194\n12052#2,3:195\n1#3:198\n*S KotlinDebug\n*F\n+ 1 ClassDefinition.kt\ncom/intellij/diagnostic/hprof/classstore/ClassDefinition\n*L\n123#1:194\n123#1:195,3\n*E\n"})
public final class ClassDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final long id;
    private final long superClassId;
    private final long classLoaderId;
    private final int instanceSize;
    private final int superClassOffset;
    @NotNull
    private final InstanceField[] refInstanceFields;
    @NotNull
    private final InstanceField[] primitiveInstanceFields;
    @NotNull
    private final long[] constantFields;
    @NotNull
    private final StaticField[] objectStaticFields;
    @NotNull
    private final StaticField[] primitiveStaticFields;
    public static final int OBJECT_PREAMBLE_SIZE = 8;
    public static final int ARRAY_PREAMBLE_SIZE = 12;
    @NotNull
    private static final InstanceField CLASS_FIELD = new InstanceField("<class>", -1, Type.OBJECT);

    public ClassDefinition(@NotNull String name2, long id2, long superClassId, long classLoaderId, int instanceSize, int superClassOffset, @NotNull InstanceField[] refInstanceFields, @NotNull InstanceField[] primitiveInstanceFields, @NotNull long[] constantFields, @NotNull StaticField[] objectStaticFields, @NotNull StaticField[] primitiveStaticFields) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)refInstanceFields, (String)"refInstanceFields");
        Intrinsics.checkNotNullParameter((Object)primitiveInstanceFields, (String)"primitiveInstanceFields");
        Intrinsics.checkNotNullParameter((Object)constantFields, (String)"constantFields");
        Intrinsics.checkNotNullParameter((Object)objectStaticFields, (String)"objectStaticFields");
        Intrinsics.checkNotNullParameter((Object)primitiveStaticFields, (String)"primitiveStaticFields");
        this.name = name2;
        this.id = id2;
        this.superClassId = superClassId;
        this.classLoaderId = classLoaderId;
        this.instanceSize = instanceSize;
        this.superClassOffset = superClassOffset;
        this.refInstanceFields = refInstanceFields;
        this.primitiveInstanceFields = primitiveInstanceFields;
        this.constantFields = constantFields;
        this.objectStaticFields = objectStaticFields;
        this.primitiveStaticFields = primitiveStaticFields;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getId() {
        return this.id;
    }

    public final long getSuperClassId() {
        return this.superClassId;
    }

    public final long getClassLoaderId() {
        return this.classLoaderId;
    }

    public final int getInstanceSize() {
        return this.instanceSize;
    }

    public final int getSuperClassOffset() {
        return this.superClassOffset;
    }

    @NotNull
    public final InstanceField[] getRefInstanceFields() {
        return this.refInstanceFields;
    }

    @NotNull
    public final long[] getConstantFields() {
        return this.constantFields;
    }

    @NotNull
    public final StaticField[] getObjectStaticFields() {
        return this.objectStaticFields;
    }

    @NotNull
    public final StaticField[] getPrimitiveStaticFields() {
        return this.primitiveStaticFields;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.diagnostic.hprof.classstore.ClassDefinition");
        ClassDefinition cfr_ignored_0 = (ClassDefinition)object2;
        if (this.id != ((ClassDefinition)other).id) {
            return false;
        }
        if (this.id == 0L) {
            return Intrinsics.areEqual((Object)this.name, (Object)((ClassDefinition)other).name);
        }
        return true;
    }

    @NotNull
    public final String getPrettyName() {
        return Companion.computePrettyName(this.name);
    }

    @NotNull
    public final String getUndecoratedName() {
        return StringsKt.substringBefore$default((String)this.name, (char)'!', null, (int)2, null);
    }

    @Nullable
    public final ClassDefinition getSuperClass(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        return this.superClassId == 0L ? null : classStore.get((int)this.superClassId);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public final boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public final boolean isPrimitiveArray() {
        return this.isArray() && this.name.length() == 2;
    }

    @NotNull
    public final ClassDefinition copyWithRemappedIDs(@NotNull IDMapper idMapper) {
        Intrinsics.checkNotNullParameter((Object)idMapper, (String)"idMapper");
        int n = 0;
        int n2 = this.constantFields.length;
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = ClassDefinition.copyWithRemappedIDs$map(idMapper, this.constantFields[n3]);
        }
        long[] newConstantFields = lArray;
        n2 = 0;
        int n4 = this.objectStaticFields.length;
        StaticField[] staticFieldArray = new StaticField[n4];
        while (n2 < n4) {
            int n5 = n2++;
            StaticField oldStaticField = this.objectStaticFields[n5];
            staticFieldArray[n5] = new StaticField(oldStaticField.getName(), ClassDefinition.copyWithRemappedIDs$map(idMapper, oldStaticField.getValue()));
        }
        StaticField[] newStaticObjectFields = staticFieldArray;
        return new ClassDefinition(this.name, ClassDefinition.copyWithRemappedIDs$map(idMapper, this.id), ClassDefinition.copyWithRemappedIDs$map(idMapper, this.superClassId), ClassDefinition.copyWithRemappedIDs$map(idMapper, this.classLoaderId), this.instanceSize, this.superClassOffset, this.refInstanceFields, this.primitiveInstanceFields, newConstantFields, newStaticObjectFields, this.primitiveStaticFields);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allRefFieldNames(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        List result2 = new ArrayList();
        ClassDefinition currentClass = this;
        while (true) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InstanceField[] instanceFieldArray = currentClass.refInstanceFields;
            List list2 = result2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_12 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list2.addAll((List)destination$iv$iv);
            if (currentClass.getSuperClass(classStore) == null) break;
        }
        return result2;
    }

    @NotNull
    public final InstanceField getRefField(@NotNull ClassStore classStore, int index) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        int currentIndex = index;
        ClassDefinition currentClass = this;
        while (true) {
            int size2;
            if (currentIndex < (size2 = currentClass.refInstanceFields.length)) {
                return currentClass.refInstanceFields[currentIndex];
            }
            currentIndex -= size2;
            if (currentClass.getSuperClass(classStore) == null) break;
        }
        if (currentIndex == 0) {
            return CLASS_FIELD;
        }
        throw new IndexOutOfBoundsException(index + " on class " + this.name);
    }

    @NotNull
    public final String getClassFieldName(int index) {
        boolean bl = 0 <= index ? index < this.constantFields.length : false;
        if (bl) {
            return "<constant>";
        }
        int n = this.constantFields.length;
        boolean bl2 = index < this.constantFields.length + this.objectStaticFields.length ? n <= index : false;
        if (bl2) {
            return this.objectStaticFields[index - this.constantFields.length].getName();
        }
        if (index == this.constantFields.length + this.objectStaticFields.length) {
            return "<loader>";
        }
        throw new IndexOutOfBoundsException(index + " on class " + this.name);
    }

    @Nullable
    public final Long getPrimitiveStaticFieldValue(@NotNull String name2) {
        StaticField staticField;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            StaticField[] staticFieldArray = this.primitiveStaticFields;
            int n = staticFieldArray.length;
            for (int j = 0; j < n; ++j) {
                StaticField staticField2;
                StaticField it = staticField2 = staticFieldArray[j];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                staticField = staticField2;
                break block1;
            }
            staticField = null;
        }
        return staticField != null ? Long.valueOf(staticField.getValue()) : null;
    }

    public final int computeOffsetOfField(@NotNull String fieldName, @NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        int classOffset = 0;
        ClassDefinition currentClass = this;
        while (true) {
            InstanceField field;
            block6: {
                InstanceField it;
                InstanceField instanceField;
                int n;
                int n2;
                InstanceField[] instanceFieldArray;
                block5: {
                    InstanceField instanceField2;
                    instanceFieldArray = currentClass.refInstanceFields;
                    n2 = instanceFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = instanceField = instanceFieldArray[n];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                        instanceField2 = instanceField;
                        break block5;
                    }
                    instanceField2 = field = null;
                }
                if (field == null) {
                    InstanceField instanceField3;
                    instanceFieldArray = currentClass.primitiveInstanceFields;
                    n2 = instanceFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = instanceField = instanceFieldArray[n];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                        instanceField3 = instanceField;
                        break block6;
                    }
                    instanceField3 = field = null;
                }
            }
            if (field != null) {
                return classOffset + field.getOffset();
            }
            classOffset += currentClass.superClassOffset;
            if (currentClass.getSuperClass(classStore) != null) continue;
            return -1;
        }
    }

    @NotNull
    public final ClassDefinition copyWithName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ClassDefinition(newName, this.id, this.superClassId, this.classLoaderId, this.instanceSize, this.superClassOffset, this.refInstanceFields, this.primitiveInstanceFields, this.constantFields, this.objectStaticFields, this.primitiveStaticFields);
    }

    private static final long copyWithRemappedIDs$map(IDMapper $idMapper, long id2) {
        return $idMapper.getID(id2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition$Companion;", "", "<init>", "()V", "OBJECT_PREAMBLE_SIZE", "", "ARRAY_PREAMBLE_SIZE", "computePrettyName", "", "name", "CLASS_FIELD", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getCLASS_FIELD", "()Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NonNls
        @NotNull
        public final String computePrettyName(@NotNull String name2) {
            int arraySymbolsCount;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (!StringsKt.startsWith$default((CharSequence)name2, (char)'[', (boolean)false, (int)2, null)) {
                return name2;
            }
            for (arraySymbolsCount = 0; name2.length() > arraySymbolsCount && name2.charAt(arraySymbolsCount) == '['; ++arraySymbolsCount) {
            }
            if (name2.length() <= arraySymbolsCount) {
                return name2;
            }
            char arrayType = name2.charAt(arraySymbolsCount);
            String arrayString = StringsKt.repeat((CharSequence)"[]", (int)arraySymbolsCount);
            return switch (arrayType) {
                case 'B' -> "byte" + arrayString;
                case 'C' -> "char" + arrayString;
                case 'D' -> "double" + arrayString;
                case 'F' -> "float" + arrayString;
                case 'I' -> "int" + arrayString;
                case 'J' -> "long" + arrayString;
                case 'L' -> {
                    String v1 = name2.substring(arraySymbolsCount + 1, name2.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    yield v1 + arrayString;
                }
                case 'S' -> "short" + arrayString;
                case 'Z' -> "boolean" + arrayString;
                default -> name2;
            };
        }

        @NotNull
        public final InstanceField getCLASS_FIELD() {
            return CLASS_FIELD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

