/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.comments;

import com.intellij.formatting.comments.CommentLineData;
import com.intellij.formatting.comments.CommentLineDataBuilder;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CommentWrapper {
    private static final int MAX_SPLIT_ITERATIONS = 10;

    @Nullable
    public static String wrapCommentLines(@NotNull CommentLineDataBuilder commentLineDataBuilder, int rightMargin) {
        List<CommentLineData> lines;
        if (commentLineDataBuilder == null) {
            CommentWrapper.$$$reportNull$$$0(0);
        }
        if (!CommentWrapper.isWrappingNeeded(lines = commentLineDataBuilder.getLines(), rightMargin)) {
            return null;
        }
        List<CommentLineData> mergedLines = CommentWrapper.mergeLines(lines, rightMargin);
        StringBuilder docBuilder = new StringBuilder();
        boolean atStart = true;
        for (CommentLineData lineData : mergedLines) {
            if (atStart) {
                atStart = false;
            } else {
                docBuilder.append('\n');
            }
            CommentWrapper.splitLine(lineData, commentLineDataBuilder, docBuilder, rightMargin, 0);
        }
        return docBuilder.toString();
    }

    private static boolean isWrappingNeeded(List<CommentLineData> lines, int rightMargin) {
        for (CommentLineData lineData : lines) {
            if (lineData.getLineLength() <= rightMargin) continue;
            return true;
        }
        return false;
    }

    private static List<CommentLineData> mergeLines(List<CommentLineData> originalLines, int rightMargin) {
        ArrayList<CommentLineData> result2 = new ArrayList<CommentLineData>(originalLines.size());
        CommentLineData lastLine = null;
        for (CommentLineData line : originalLines) {
            if (lastLine != null && lastLine.hasText() && lastLine.getLineLength() > rightMargin && line.canBeMergedWithPrevious()) {
                lastLine.merge(line);
                continue;
            }
            result2.add(line);
            lastLine = line;
        }
        return result2;
    }

    private static void splitLine(CommentLineData lineData, CommentLineDataBuilder lineDataBuilder, StringBuilder docBuilder, int rightMargin, int depth) {
        String linePrefix;
        Pair<String, String> chunks;
        if (lineData.getLineLength() >= rightMargin && depth < 10 && (chunks = lineData.splitLine(rightMargin)) != null && !(linePrefix = lineData.getLinePrefix()).isEmpty() && linePrefix.length() + ((String)chunks.second).length() < lineData.getLineLength()) {
            docBuilder.append((String)chunks.first).append('\n');
            String newLine = linePrefix + (String)chunks.second;
            CommentLineData newLineData = lineDataBuilder.parseLine(newLine);
            newLineData.setTagLine(lineData.isTagLine());
            CommentWrapper.splitLine(newLineData, lineDataBuilder, docBuilder, rightMargin, depth + 1);
            return;
        }
        docBuilder.append(lineData.getLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentLineDataBuilder", "com/intellij/formatting/comments/CommentWrapper", "wrapCommentLines"));
    }
}

