/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PruneEmptyDirectoriesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PruneEmptyDirectoriesAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setEnabled(files2 != null && files2.length > 0);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PruneEmptyDirectoriesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PruneEmptyDirectoriesAction.$$$reportNull$$$0(2);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (files2 != null);
        FileTypeManager ftManager = FileTypeManager.getInstance();
        try {
            for (VirtualFile file2 : files2) {
                PruneEmptyDirectoriesAction.pruneEmptiesIn(file2, ftManager);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void pruneEmptiesIn(VirtualFile file2, final FileTypeManager ftManager) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory()) {
                    if (ftManager.isFileIgnored(file2)) {
                        return false;
                    }
                } else if (".DS_Store".equals(file2.getName())) {
                    PruneEmptyDirectoriesAction.delete(file2);
                    return false;
                }
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2.isDirectory() && file2.getChildren().length == 0) {
                    PruneEmptyDirectoriesAction.delete(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/actions/PruneEmptyDirectoriesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterChildrenVisited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void delete(VirtualFile file2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                file2.delete(PruneEmptyDirectoriesAction.class);
                System.out.println("Deleted: " + file2.getPresentableUrl());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"message.cannot.delete.0.1", (Object[])new Object[]{file2.getPresentableUrl(), e.getLocalizedMessage()}), (String)"IOException");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/PruneEmptyDirectoriesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/PruneEmptyDirectoriesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

