/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.logsUploader;

import com.fasterxml.jackson.jr.ob.JSON;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.PlatformHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LogUploader {
    private static final String SERVICE_URL = "https://uploads.jetbrains.com";
    private static final String BYTES_CONTENT_TYPE = "application/octet-stream";
    private static final String JSON_CONTENT_TYPE = "application/json";

    @NotNull
    public static String uploadFile(@NotNull Path file2) throws IOException {
        if (file2 == null) {
            LogUploader.$$$reportNull$$$0(0);
        }
        return LogUploader.uploadFile(file2, file2.getFileName().toString());
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String uploadFile(@NotNull Path file2, @NotNull String fileName) throws IOException {
        if (file2 == null) {
            LogUploader.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            LogUploader.$$$reportNull$$$0(2);
        }
        HttpClient client2 = PlatformHttpClient.client();
        String requestObj = JSON.std.asString(Map.of("filename", fileName, "method", "put", "contentType", BYTES_CONTENT_TYPE));
        HttpRequest request = PlatformHttpClient.requestBuilder((URI)new URI("https://uploads.jetbrains.com/sign")).header("Content-Type", "application/json; charset=utf-8").header("Accept", JSON_CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(requestObj)).build();
        HttpResponse response = PlatformHttpClient.checkResponse(client2.send(request, HttpResponse.BodyHandlers.ofString()));
        Map responseObj = JSON.std.mapFrom(response.body());
        String uploadUrl = responseObj.get("url").toString();
        Map headers = (Map)responseObj.get("headers");
        String id2 = responseObj.get("folderName").toString();
        HttpRequest.Builder builder = PlatformHttpClient.requestBuilder((URI)new URI(uploadUrl));
        headers.forEach(builder::header);
        request = builder.header("Content-Type", BYTES_CONTENT_TYPE).PUT(HttpRequest.BodyPublishers.ofFile(file2)).build();
        PlatformHttpClient.checkResponse(client2.send(request, HttpResponse.BodyHandlers.discarding()));
        String string = id2;
        if (client2 != null) {
            client2.close();
        }
        String string2 = string;
        if (string2 == null) {
            LogUploader.$$$reportNull$$$0(3);
        }
        return string2;
        {
            catch (Throwable throwable) {
                try {
                    if (client2 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void notify(@Nullable Project project2, @NotNull String id2) {
        if (id2 == null) {
            LogUploader.$$$reportNull$$$0(4);
        }
        String message = IdeBundle.message((String)"collect.logs.notification.sent.success", (Object[])new Object[]{SERVICE_URL, id2});
        new Notification("Collect Zipped Logs", message, NotificationType.INFORMATION).notify(project2);
    }

    @NotNull
    public static String getBrowseUrl(@NotNull String id2) {
        if (id2 == null) {
            LogUploader.$$$reportNull$$$0(5);
        }
        String string = "https://uploads.jetbrains.com/browse#" + id2;
        if (string == null) {
            LogUploader.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/logsUploader/LogUploader";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/logsUploader/LogUploader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowseUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadFile";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBrowseUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

