/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.matching.MatchingMode;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PluginsTableRenderer
extends DefaultTableCellRenderer {
    protected SimpleColoredComponent myName;
    private JLabel myStatus;
    private RatesPanel myRating;
    private JLabel myDownloads;
    private JLabel myLastUpdated;
    private JPanel myPanel;
    private SimpleColoredComponent myCategory;
    private JPanel myRightPanel;
    private JPanel myBottomPanel;
    private JPanel myInfoPanel;
    protected final IdeaPluginDescriptor myPluginDescriptor;
    private final boolean myPluginsView;

    public PluginsTableRenderer(IdeaPluginDescriptor pluginDescriptor, boolean showFullInfo) {
        this.myPluginDescriptor = pluginDescriptor;
        this.$$$setupUI$$$();
        this.myPluginsView = !showFullInfo;
        Font smallFont = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI);
        this.myName.setFont(StartupUiUtil.getLabelFont().deriveFont(UISettings.getInstance().getFontSize2D()));
        this.myStatus.setFont(smallFont);
        this.myCategory.setFont(smallFont);
        this.myDownloads.setFont(smallFont);
        this.myLastUpdated.setFont(smallFont);
        this.myStatus.setText("");
        if (this.myPluginsView || !(pluginDescriptor instanceof PluginNode) || ((PluginNode)pluginDescriptor).getDownloads() == null) {
            this.myPanel.remove(this.myRightPanel);
        }
        if (this.myPluginsView) {
            this.myInfoPanel.remove(this.myBottomPanel);
        }
        this.myPanel.setBorder((Border)(StartupUiUtil.isJreHiDPI((Component)this.myPanel) ? JBUI.Borders.empty((int)4, (int)3) : JBUI.Borders.empty((int)2, (int)3)));
    }

    private void createUIComponents() {
        this.myRating = new RatesPanel();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
        if (this.myPluginDescriptor != null) {
            String downloads;
            String vendor;
            String category;
            Couple colors = UIUtil.getCellColors((JTable)table2, (boolean)isSelected, (int)row2, (int)column);
            Color fg = (Color)colors.getFirst();
            Color background = (Color)colors.getSecond();
            Color grayedFg = isSelected ? fg : new JBColor((Color)Gray._130, (Color)Gray._120);
            this.myPanel.setBackground(background);
            this.myName.setForeground(fg);
            this.myCategory.setForeground(grayedFg);
            this.myStatus.setForeground(grayedFg);
            this.myLastUpdated.setForeground(grayedFg);
            this.myDownloads.setForeground(grayedFg);
            this.myName.clear();
            this.myName.setOpaque(false);
            this.myCategory.clear();
            this.myCategory.setOpaque(false);
            SpeedSearchSupply speedSearch2 = SpeedSearchSupply.getSupply((JComponent)table2);
            String query = speedSearch2 == null ? null : speedSearch2.getEnteredPrefix();
            SimpleTextAttributes attr = new SimpleTextAttributes(UIUtil.getListBackground((boolean)isSelected, (boolean)hasFocus), UIUtil.getListForeground((boolean)isSelected, (boolean)hasFocus), (Color)JBColor.RED, 0);
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + query), (MatchingMode)MatchingMode.IGNORE_CASE);
            String string = category = this.myPluginDescriptor.getDisplayCategory() == null ? null : StringUtil.toUpperCase((String)this.myPluginDescriptor.getDisplayCategory());
            if (category != null) {
                if (query != null) {
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)category, (SimpleColoredComponent)this.myCategory, (SimpleTextAttributes)attr, (Matcher)matcher, (Color)UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus), (boolean)true);
                } else {
                    this.myCategory.append(category);
                }
            } else if (!this.myPluginsView) {
                this.myCategory.append(IdeBundle.message((String)"plugin.info.not.available", (Object[])new Object[0]));
            }
            this.myStatus.setIcon(AllIcons.Nodes.Plugin);
            if (this.myPluginDescriptor.isBundled()) {
                this.myCategory.append(" [Bundled]");
                this.myStatus.setIcon(AllIcons.Nodes.PluginJB);
            }
            if ((vendor = this.myPluginDescriptor.getVendor()) != null && StringUtil.containsIgnoreCase((String)vendor, (String)"jetbrains")) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginJB);
            }
            if (this.myPluginDescriptor instanceof PluginNode && (downloads = ((PluginNode)this.myPluginDescriptor).getDownloads()) != null) {
                if (downloads.length() > 3) {
                    downloads = new DecimalFormat("#,###").format(Integer.parseInt(downloads));
                }
                this.myDownloads.setText(downloads);
                this.myRating.setRate(((PluginNode)this.myPluginDescriptor).getRating());
                this.myLastUpdated.setText(DateFormatUtil.formatBetweenDates((long)((PluginNode)this.myPluginDescriptor).getDate(), (long)System.currentTimeMillis()));
            }
            PluginId pluginId = this.myPluginDescriptor.getPluginId();
            IdeaPluginDescriptor installed = PluginManagerCore.getPlugin((PluginId)pluginId);
            Color initialNameForeground = this.myName.getForeground();
            if (installed != null && ((IdeaPluginDescriptorImpl)installed).isDeleted()) {
                this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                if (!isSelected) {
                    this.myName.setForeground(FileStatus.DELETED.getColor());
                }
                this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.uninstalled.tooltip", (Object[])new Object[0]));
            } else {
                Icon icon2;
                InstalledPluginsState state2 = InstalledPluginsState.getInstance();
                if (state2.wasInstalled(pluginId)) {
                    this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                    if (!isSelected) {
                        this.myName.setForeground(FileStatus.ADDED.getColor());
                    }
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.installed.tooltip", (Object[])new Object[0]));
                } else if (state2.wasUpdated(pluginId)) {
                    this.myStatus.setIcon(AllIcons.Nodes.PluginRestart);
                    if (!isSelected) {
                        this.myName.setForeground(FileStatus.ADDED.getColor());
                    }
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.updated.tooltip", (Object[])new Object[0]));
                } else if (state2.hasNewerVersion(pluginId)) {
                    this.myStatus.setIcon(AllIcons.Nodes.Pluginobsolete);
                    if (!isSelected) {
                        this.myName.setForeground(FileStatus.MODIFIED.getColor());
                    }
                    if (!this.myPluginsView && installed != null) {
                        this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.new.version.tooltip", (Object[])new Object[]{installed.getVersion()}));
                    } else {
                        this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.update.available.tooltip", (Object[])new Object[0]));
                    }
                } else if (PluginsTableRenderer.isIncompatible(this.myPluginDescriptor)) {
                    if (!isSelected) {
                        this.myName.setForeground((Color)JBColor.RED);
                    }
                    this.myPanel.setToolTipText(IdeBundle.message((String)"plugin.manager.incompatible.tooltip", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
                } else if (!this.myPluginDescriptor.isEnabled() && this.myPluginsView && (icon2 = this.myStatus.getIcon()) != null) {
                    this.myStatus.setIcon(IconLoader.getDisabledIcon((Icon)icon2));
                }
            }
            String pluginName = this.myPluginDescriptor.getName() + "  ";
            if (query != null) {
                if (!Objects.equals(initialNameForeground, this.myName.getForeground())) {
                    attr = attr.derive(attr.getStyle(), this.myName.getForeground(), attr.getBgColor(), attr.getWaveColor());
                }
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)pluginName, (SimpleColoredComponent)this.myName, (SimpleTextAttributes)attr, (Matcher)matcher, (Color)UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus), (boolean)true);
            } else {
                this.myName.append(pluginName);
            }
        }
        return this.myPanel;
    }

    private static boolean isIncompatible(IdeaPluginDescriptor descriptor2) {
        return PluginManagerCore.isIncompatible((IdeaPluginDescriptor)descriptor2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent simpleColoredComponent2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, "West");
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6), null, 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.myStatus = jBLabel;
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", PluginsTableRenderer.class).getString("label.plugin.status"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myInfoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setOpaque(false);
        jPanel4.add((Component)jPanel3, "Center");
        this.myBottomPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        jPanel3.add((Component)jPanel2, "South");
        this.myCategory = simpleColoredComponent2 = new SimpleColoredComponent();
        jPanel2.add((Component)simpleColoredComponent2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setOpaque(false);
        jPanel3.add((Component)jPanel6, "North");
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0), null, 0, 0, null, null));
        this.myName = simpleColoredComponent = new SimpleColoredComponent();
        jPanel6.add((Component)simpleColoredComponent, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRightPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, "East");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.myLastUpdated = jBLabel2;
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", PluginsTableRenderer.class).getString("label.plugin.last.updated"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setOpaque(false);
        jPanel.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        RatesPanel ratesPanel = this.myRating;
        ratesPanel.setOpaque(false);
        jPanel7.add((Component)ratesPanel, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.myDownloads = jBLabel3;
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/IdeBundle", PluginsTableRenderer.class).getString("label.plugin.downloads"));
        jPanel7.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

