/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.settings.json;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.settings.json.JsonSettingsModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\f\u0010\u001c\u001a\u00020\u0003*\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0002J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\nH\u00c6\u0003J?\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0014\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010.\u001a\u00020/H\u00d6\u0081\u0004J\n\u00100\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lcom/intellij/ide/settings/json/ComponentDescriptor;", "", "name", "", "aClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "state", "Lcom/intellij/openapi/components/State;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/openapi/components/State;)V", "getName", "()Ljava/lang/String;", "getAClass", "()Ljava/lang/Class;", "getPluginDescriptor", "()Lcom/intellij/openapi/extensions/PluginDescriptor;", "getState", "()Lcom/intellij/openapi/components/State;", "getRoamingTypeString", "getCategoryString", "findStorage", "Lcom/intellij/openapi/components/Storage;", "collectFieldInfo", "", "Lcom/intellij/ide/settings/json/JsonSettingsModel$ComponentPropertyInfo;", "getInternalName", "Lcom/intellij/serialization/MutableAccessor;", "toModelType", "Lcom/intellij/ide/settings/json/JsonSettingsModel$PropertyType;", "accessor", "getVariants", "Lcom/intellij/ide/settings/json/JsonSettingsModel$VariantInfo;", "valueClass", "getVariantString", "original", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsInspector.kt\ncom/intellij/ide/settings/json/ComponentDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,191:1\n14060#2,2:192\n14060#2,2:194\n11705#2:198\n12052#2,3:199\n1915#3,2:196\n1198#4,2:202\n*S KotlinDebug\n*F\n+ 1 SettingsInspector.kt\ncom/intellij/ide/settings/json/ComponentDescriptor\n*L\n77#1:192,2\n115#1:194,2\n173#1:198\n173#1:199,3\n129#1:196,2\n181#1:202,2\n*E\n"})
public final class ComponentDescriptor {
    @NotNull
    private final String name;
    @NotNull
    private final Class<PersistentStateComponent<?>> aClass;
    @Nullable
    private final PluginDescriptor pluginDescriptor;
    @Nullable
    private final State state;

    public ComponentDescriptor(@NotNull String name2, @NotNull Class<PersistentStateComponent<?>> aClass, @Nullable PluginDescriptor pluginDescriptor, @Nullable State state2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        this.name = name2;
        this.aClass = aClass;
        this.pluginDescriptor = pluginDescriptor;
        this.state = state2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Class<PersistentStateComponent<?>> getAClass() {
        return this.aClass;
    }

    @Nullable
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Nullable
    public final State getState() {
        return this.state;
    }

    @NotNull
    public final String getRoamingTypeString() {
        if (this.state != null) {
            String roamingType = null;
            Storage[] $this$forEach$iv = this.state.storages();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String storageRoamingType;
                Storage element$iv;
                Storage it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (it.deprecated()) continue;
                String string = storageRoamingType = Intrinsics.areEqual((Object)it.value(), (Object)"other.xml") || Intrinsics.areEqual((Object)it.value(), (Object)"$CACHE_FILE$") || Intrinsics.areEqual((Object)it.value(), (Object)"$WORKSPACE_FILE$") ? "DISABLED" : it.roamingType().toString();
                if (roamingType == null) {
                    roamingType = storageRoamingType;
                    continue;
                }
                if (Intrinsics.areEqual((Object)roamingType, (Object)storageRoamingType)) continue;
                roamingType = "MIXED";
            }
            String string = roamingType;
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    @NotNull
    public final String getCategoryString() {
        String roamingType = this.getRoamingTypeString();
        if (!Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DISABLED.toString()) && this.pluginDescriptor != null) {
            if (Intrinsics.areEqual((Object)this.pluginDescriptor.getName(), (Object)PluginManagerCore.SPECIAL_IDEA_PLUGIN_ID.getIdString())) {
                Object object = this.state;
                if (object == null || (object = object.category()) == null || (object = object.name()) == null) {
                    object = "";
                }
                return object;
            }
            return ComponentCategorizer.getPluginCategory(this.aClass, (PluginDescriptor)this.pluginDescriptor).toString();
        }
        return "";
    }

    @Nullable
    public final Storage findStorage() {
        block1: {
            Storage[] storageArray = this.state;
            if (this.state == null || (storageArray = storageArray.storages()) == null) break block1;
            Storage[] $this$forEach$iv = storageArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Storage element$iv;
                Storage storage = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (storage.deprecated()) continue;
                return storage;
            }
        }
        return null;
    }

    @NotNull
    public final List<JsonSettingsModel.ComponentPropertyInfo> collectFieldInfo() {
        List infoList;
        block2: {
            infoList = new ArrayList();
            PersistentStateComponent persistentStateComponent = (PersistentStateComponent)ApplicationManager.getApplication().getService(this.aClass);
            if (persistentStateComponent == null) break block2;
            PersistentStateComponent component2 = persistentStateComponent;
            boolean bl = false;
            Object object = component2.getState();
            if (object != null) {
                Object componentState = object;
                boolean bl2 = false;
                List accessors = BeanBindingKt.getBeanAccessors(componentState.getClass());
                Iterable $this$forEach$iv = accessors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MutableAccessor it = (MutableAccessor)element$iv;
                    boolean bl3 = false;
                    String internalName = this.getInternalName(it);
                    String jsonName = JsonSettingsModel.Companion.toJsonName(internalName);
                    Collection collection = infoList;
                    String string = Intrinsics.areEqual((Object)internalName, (Object)jsonName) ? null : internalName;
                    JsonSettingsModel.PropertyType propertyType = this.toModelType(it);
                    String string2 = it.getValueClass().getTypeName();
                    Class clazz = it.getValueClass();
                    Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getValueClass(...)");
                    collection.add(new JsonSettingsModel.ComponentPropertyInfo(jsonName, string, propertyType, string2, this.getVariants(clazz)));
                }
            }
        }
        return infoList;
    }

    private final String getInternalName(MutableAccessor $this$getInternalName) {
        OptionTag optionTag = (OptionTag)$this$getInternalName.getAnnotation(OptionTag.class);
        if (optionTag != null) {
            OptionTag it = optionTag;
            boolean bl = false;
            if (((CharSequence)it.value()).length() > 0) {
                return it.value();
            }
        }
        String string = $this$getInternalName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsonSettingsModel.PropertyType toModelType(MutableAccessor accessor) {
        Class clazz = accessor.getValueClass();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getValueClass(...)");
        Class valueClass = clazz;
        String original = valueClass.getTypeName();
        if (valueClass.isEnum()) {
            return JsonSettingsModel.PropertyType.Enum;
        }
        String string = original;
        if (string != null) {
            switch (string.hashCode()) {
                case 64711720: {
                    if (string.equals("boolean")) return JsonSettingsModel.PropertyType.Boolean;
                    break;
                }
                case 344809556: {
                    if (string.equals("java.lang.Boolean")) return JsonSettingsModel.PropertyType.Boolean;
                    break;
                }
                case 1195259493: {
                    if (string.equals("java.lang.String")) return JsonSettingsModel.PropertyType.String;
                    break;
                }
                case -2056817302: {
                    if (string.equals("java.lang.Integer")) return JsonSettingsModel.PropertyType.Integer;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    return JsonSettingsModel.PropertyType.Integer;
                }
            }
        }
        if ((string = accessor.getGenericType().getTypeName()) == null) return JsonSettingsModel.PropertyType.Unsupported;
        int n = -1;
        switch (string.hashCode()) {
            case 2123584667: {
                if (string.equals("java.util.List<java.lang.String>")) {
                    n = 1;
                }
                break;
            }
            case 1888799711: {
                if (string.equals("java.util.Set<java.lang.String>")) {
                    n = 2;
                }
                break;
            }
            case -183467365: {
                if (string.equals("java.util.Collection<java.lang.String>")) {
                    n = 3;
                }
                break;
            }
            case 1767743712: {
                if (string.equals("java.util.Map<java.lang.String, java.lang.String>")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                return JsonSettingsModel.PropertyType.StringList;
            }
            case 2: {
                return JsonSettingsModel.PropertyType.StringSet;
            }
            case 3: {
                return JsonSettingsModel.PropertyType.StringList;
            }
            case 4: {
                return JsonSettingsModel.PropertyType.StringMap;
            }
        }
        return JsonSettingsModel.PropertyType.Unsupported;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsonSettingsModel.VariantInfo> getVariants(Class<?> valueClass) {
        if (valueClass.isEnum()) {
            void $this$mapTo$iv$iv;
            ?[] objArray = valueClass.getEnumConstants();
            Intrinsics.checkNotNullExpressionValue(objArray, (String)"getEnumConstants(...)");
            ?[] $this$map$iv = objArray;
            boolean $i$f$map = false;
            ?[] objArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JsonSettingsModel.VariantInfo(this.getVariantString(it.toString()), it.toString()));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final String getVariantString(String original) {
        StringBuilder buf = new StringBuilder();
        CharSequence $this$forEach$iv = original;
        boolean $i$f$forEach = false;
        for (int j = 0; j < $this$forEach$iv.length(); ++j) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(j);
            boolean bl = false;
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') {
                buf.append(c);
                continue;
            }
            if (c != ' ') continue;
            buf.append('_');
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Class<PersistentStateComponent<?>> component2() {
        return this.aClass;
    }

    @Nullable
    public final PluginDescriptor component3() {
        return this.pluginDescriptor;
    }

    @Nullable
    public final State component4() {
        return this.state;
    }

    @NotNull
    public final ComponentDescriptor copy(@NotNull String name2, @NotNull Class<PersistentStateComponent<?>> aClass, @Nullable PluginDescriptor pluginDescriptor, @Nullable State state2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        return new ComponentDescriptor(name2, aClass, pluginDescriptor, state2);
    }

    public static /* synthetic */ ComponentDescriptor copy$default(ComponentDescriptor componentDescriptor, String string, Class clazz, PluginDescriptor pluginDescriptor, State state2, int n, Object object) {
        if ((n & 1) != 0) {
            string = componentDescriptor.name;
        }
        if ((n & 2) != 0) {
            clazz = componentDescriptor.aClass;
        }
        if ((n & 4) != 0) {
            pluginDescriptor = componentDescriptor.pluginDescriptor;
        }
        if ((n & 8) != 0) {
            state2 = componentDescriptor.state;
        }
        return componentDescriptor.copy(string, clazz, pluginDescriptor, state2);
    }

    @NotNull
    public String toString() {
        return "ComponentDescriptor(name=" + this.name + ", aClass=" + this.aClass + ", pluginDescriptor=" + this.pluginDescriptor + ", state=" + this.state + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.aClass.hashCode();
        result2 = result2 * 31 + (this.pluginDescriptor == null ? 0 : this.pluginDescriptor.hashCode());
        result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComponentDescriptor)) {
            return false;
        }
        ComponentDescriptor componentDescriptor = (ComponentDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)componentDescriptor.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.aClass, componentDescriptor.aClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pluginDescriptor, (Object)componentDescriptor.pluginDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.state, (Object)componentDescriptor.state);
    }
}

