/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.DateTimeFormatManager;
import java.text.SimpleDateFormat;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/ui/text/DateTimeFormatConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "<init>", "()V", "dateFormatField", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBTextField;", "use24HourCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "datePreviewField", "Ljavax/swing/JEditorPane;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validateDatePattern", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "pattern", "updateCommentField", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDateTimeFormatConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeFormatConfigurable.kt\ncom/intellij/ide/ui/text/DateTimeFormatConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class DateTimeFormatConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll {
    private Cell<? extends JBTextField> dateFormatField;
    private Cell<? extends JBCheckBox> use24HourCheckbox;
    private Cell<? extends JEditorPane> datePreviewField;

    public DateTimeFormatConfigurable() {
        String string = IdeBundle.message((String)"date.time.format.configurable", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.date.formats", "ide.date.format");
    }

    @NotNull
    public DialogPanel createPanel() {
        DateTimeFormatManager settings = DateTimeFormatManager.getInstance();
        return BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0(this, settings, arg_0)));
    }

    private final String validateDatePattern(String pattern) {
        try {
            new SimpleDateFormat(pattern);
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            return IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        if (StringsKt.contains$default((CharSequence)pattern, (CharSequence)"'", (boolean)false, (int)2, null)) {
            return null;
        }
        if (StringUtil.containsAnyChar((String)pattern, (String)"aHhKkmSs")) {
            return IdeBundle.message((String)"date.format.error.contains.time.pattern", (Object[])new Object[0]);
        }
        return null;
    }

    private final void updateCommentField() {
        String string;
        try {
            Cell<? extends JBCheckBox> cell = this.use24HourCheckbox;
            if (cell == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"use24HourCheckbox");
                cell = null;
            }
            String timeFmt = cell.getComponent().isSelected() ? "HH:mm" : "h:mm\u202fa";
            Cell<? extends JBTextField> cell2 = this.dateFormatField;
            if (cell2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dateFormatField");
                cell2 = null;
            }
            string = new SimpleDateFormat(cell2.getComponent().getText() + " " + timeFmt).format(DateFormatUtil.getSampleDateTime());
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        String text2 = string;
        Cell<? extends JEditorPane> cell = this.datePreviewField;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"datePreviewField");
            cell = null;
        }
        String string2 = StringUtil.escapeXmlEntities((String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        TextFieldKt.text(cell, string2);
    }

    private static final ValidationInfo createPanel$lambda$0$1$0$0(DateTimeFormatConfigurable this$0, ValidationInfoBuilder $this$validationOnInput, JBTextField field) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.validateDatePattern(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = $this$validationOnInput.error(it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createPanel$lambda$0$1$0$1(DateTimeFormatConfigurable this$0, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this$0){
            final /* synthetic */ DateTimeFormatConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DateTimeFormatConfigurable.access$updateCommentField(this.this$0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$0$1$1$0$0(DateTimeFormatConfigurable this$0, ChangeEvent it) {
        this$0.updateCommentField();
    }

    private static final Unit createPanel$lambda$0$1$1$0(DateTimeFormatConfigurable this$0, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addChangeListener(arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$1$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$0(DateTimeFormatConfigurable this$0, DateTimeFormatManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBTextField> cell = $this$row.textField();
        Intrinsics.checkNotNull((Object)$settings);
        this$0.dateFormatField = TextFieldKt.columns(TextFieldKt.bindText(cell, (Function0<String>)((Function0)new Function0<String>((Object)$settings){

            public final String invoke() {
                return ((DateTimeFormatManager)this.receiver).getDateFormatPattern();
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)$settings){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((DateTimeFormatManager)this.receiver).setDateFormatPattern(p0);
            }
        })), 16).validationOnInput((Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>)((Function2)(arg_0, arg_1) -> DateTimeFormatConfigurable.createPanel$lambda$0$1$0$0(this$0, arg_0, arg_1))).applyToComponent((Function1<JBTextField, Unit>)((Function1)arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$0$1(this$0, arg_0)));
        String string = IdeBundle.message((String)"date.format.date.patterns", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.browserLink(string, "https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html");
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$1(DateTimeFormatConfigurable this$0, DateTimeFormatManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"date.format.24.hours", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        this$0.use24HourCheckbox = ButtonKt.bindSelected(cell, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DateTimeFormatManager)this.receiver).isUse24HourTime();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DateTimeFormatManager)this.receiver).setUse24HourTime(p0);
            }
        })).applyToComponent((Function1<JBCheckBox, Unit>)((Function1)arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$1$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$2(DateTimeFormatConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.datePreviewField = Row.comment$default($this$row, "", Integer.MAX_VALUE, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(Ref.ObjectRef $overrideSystemDateFormatting, DateTimeFormatManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"date.format.override.system.date.and.time.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        $overrideSystemDateFormatting.element = ButtonKt.bindSelected(cell, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DateTimeFormatManager)this.receiver).isOverrideSystemDateFormat();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DateTimeFormatManager)this.receiver).setOverrideSystemDateFormat(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(DateTimeFormatConfigurable this$0, DateTimeFormatManager $settings, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        String string = IdeBundle.message((String)"date.format.date.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$0(this$0, $settings, arg_0)));
        Panel.row$default($this$indent, null, arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$1(this$0, $settings, arg_0), 1, null);
        Panel.row$default($this$indent, null, arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1$2(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(DateTimeFormatManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"date.format.pretty", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        Cell.comment$default(ButtonKt.bindSelected(cell, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DateTimeFormatManager)this.receiver).isPrettyFormattingAllowed();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DateTimeFormatManager)this.receiver).setPrettyFormattingAllowed(p0);
            }
        })), IdeBundle.message((String)"date.format.relative", (Object[])new Object[0]), 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(DateTimeFormatManager $settings) {
        $settings.resetFormats();
        LafManager.getInstance().updateUI();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(DateTimeFormatConfigurable this$0, DateTimeFormatManager $settings, Panel $this$panel) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef overrideSystemDateFormatting = new Ref.ObjectRef();
        Panel.row$default($this$panel, null, arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$0(overrideSystemDateFormatting, $settings, arg_0), 1, null);
        RowsRange rowsRange = $this$panel.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$1(this$0, $settings, arg_0)));
        if (overrideSystemDateFormatting.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overrideSystemDateFormatting");
            cell = null;
        } else {
            cell = (Cell)overrideSystemDateFormatting.element;
        }
        rowsRange.enabledIf(ButtonKt.getSelected(cell));
        Panel.row$default($this$panel, null, arg_0 -> DateTimeFormatConfigurable.createPanel$lambda$0$2($settings, arg_0), 1, null).topGap(TopGap.SMALL);
        this$0.updateCommentField();
        $this$panel.onApply((Function0<Unit>)((Function0)() -> DateTimeFormatConfigurable.createPanel$lambda$0$3($settings)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateCommentField(DateTimeFormatConfigurable $this) {
        $this.updateCommentField();
    }
}

