/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.impl.ui.NotificationComponent;
import com.intellij.notification.impl.ui.NotificationGroupComponent;
import com.intellij.notification.impl.ui.NotificationsPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import java.awt.Color;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notification/impl/ui/SearchController;", "", "mainContent", "Lcom/intellij/notification/impl/ui/NotificationsPanel;", "suggestions", "Lcom/intellij/notification/impl/ui/NotificationGroupComponent;", "timeline", "<init>", "(Lcom/intellij/notification/impl/ui/NotificationsPanel;Lcom/intellij/notification/impl/ui/NotificationGroupComponent;Lcom/intellij/notification/impl/ui/NotificationGroupComponent;)V", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "setSearchField", "(Lcom/intellij/ui/SearchTextField;)V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "setBackground", "(Ljava/awt/Color;)V", "startSearch", "", "doSearch", "update", "cancelSearch", "clearSearch", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nNotificationsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/SearchController\n+ 2 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/NotificationGroupComponent\n*L\n1#1,1514:1\n673#2,5:1515\n673#2,5:1520\n673#2,5:1525\n673#2,5:1530\n*S KotlinDebug\n*F\n+ 1 NotificationsPanel.kt\ncom/intellij/notification/impl/ui/SearchController\n*L\n402#1:1515,5\n403#1:1520,5\n421#1:1525,5\n422#1:1530,5\n*E\n"})
final class SearchController {
    @NotNull
    private final NotificationsPanel mainContent;
    @NotNull
    private final NotificationGroupComponent suggestions;
    @NotNull
    private final NotificationGroupComponent timeline;
    public SearchTextField searchField;
    public Color background;

    public SearchController(@NotNull NotificationsPanel mainContent, @NotNull NotificationGroupComponent suggestions, @NotNull NotificationGroupComponent timeline) {
        Intrinsics.checkNotNullParameter((Object)mainContent, (String)"mainContent");
        Intrinsics.checkNotNullParameter((Object)((Object)suggestions), (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)((Object)timeline), (String)"timeline");
        this.mainContent = mainContent;
        this.suggestions = suggestions;
        this.timeline = timeline;
    }

    @NotNull
    public final SearchTextField getSearchField() {
        SearchTextField searchTextField = this.searchField;
        if (searchTextField != null) {
            return searchTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"searchField");
        return null;
    }

    public final void setSearchField(@NotNull SearchTextField searchTextField) {
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"<set-?>");
        this.searchField = searchTextField;
    }

    @NotNull
    public final Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"background");
        return null;
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    public final void startSearch() {
        this.getSearchField().setVisible(true);
        this.getSearchField().selectText();
        this.getSearchField().requestFocus();
        this.mainContent.clearEmptyState();
        String string = this.getSearchField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() > 0) {
            this.doSearch();
        }
    }

    public final void doSearch() {
        int i$iv;
        String query = this.getSearchField().getText();
        Intrinsics.checkNotNull((Object)query);
        if (((CharSequence)query).length() == 0) {
            this.getSearchField().getTextEditor().setBackground(this.getBackground());
            this.clearSearch();
            return;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        Function1 function = arg_0 -> SearchController.doSearch$lambda$0(query, result2, arg_0);
        NotificationGroupComponent this_$iv = this.suggestions;
        boolean $i$f$iterateComponents = false;
        int count$iv = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponentCount();
        for (i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            function.invoke((Object)((NotificationComponent)((Object)component2)));
        }
        this_$iv = this.timeline;
        $i$f$iterateComponents = false;
        count$iv = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponentCount();
        for (i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component3 = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            function.invoke((Object)((NotificationComponent)((Object)component3)));
        }
        this.getSearchField().getTextEditor().setBackground(result2.element ? this.getBackground() : LightColors.RED);
        this.mainContent.fullRepaint();
    }

    public final void update() {
        if (this.getSearchField().isVisible()) {
            String string = this.getSearchField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() > 0) {
                this.doSearch();
            }
        }
    }

    public final void cancelSearch() {
        this.mainContent.setEmptyState();
        this.clearSearch();
    }

    private final void clearSearch() {
        int i$iv;
        Function1 function = SearchController::clearSearch$lambda$0;
        NotificationGroupComponent this_$iv = this.suggestions;
        boolean $i$f$iterateComponents = false;
        int count$iv = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponentCount();
        for (i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component2 = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            function.invoke((Object)((NotificationComponent)((Object)component2)));
        }
        this_$iv = this.timeline;
        $i$f$iterateComponents = false;
        count$iv = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponentCount();
        for (i$iv = 0; i$iv < count$iv; ++i$iv) {
            Component component3 = NotificationGroupComponent.access$getMyList$p(this_$iv).getComponent(i$iv);
            Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type com.intellij.notification.impl.ui.NotificationComponent");
            function.invoke((Object)((NotificationComponent)((Object)component3)));
        }
        this.mainContent.fullRepaint();
    }

    private static final Unit doSearch$lambda$0(String $query, Ref.BooleanRef $result, NotificationComponent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (it.applySearchQuery($query)) {
            $result.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final Unit clearSearch$lambda$0(NotificationComponent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.applySearchQuery(null);
        return Unit.INSTANCE;
    }
}

