/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.AddShortcutOperation;
import com.intellij.openapi.actionSystem.impl.KeymapShortcutOperation;
import com.intellij.openapi.actionSystem.impl.RemoveAllShortcutsOperation;
import com.intellij.openapi.actionSystem.impl.RemoveShortcutOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.util.xml.dom.XmlElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u001a:\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0000\u001a:\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u000e2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0000\u001aB\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0002\u001a$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"KEYMAP_ATTR_NAME", "", "processMouseShortcutNode", "", "element", "Lcom/intellij/util/xml/dom/XmlElement;", "actionId", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "keymapToOperations", "", "", "Lcom/intellij/openapi/actionSystem/impl/KeymapShortcutOperation;", "processKeyboardShortcutNode", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "processRemoveAndReplace", "keymap", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "reportActionError", "message", "cause", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nKeymapShortcutOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeymapShortcutOperation.kt\ncom/intellij/openapi/actionSystem/impl/KeymapShortcutOperationKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n13#2:121\n*S KotlinDebug\n*F\n+ 1 KeymapShortcutOperation.kt\ncom/intellij/openapi/actionSystem/impl/KeymapShortcutOperationKt\n*L\n119#1:121\n*E\n"})
public final class KeymapShortcutOperationKt {
    @NotNull
    private static final String KEYMAP_ATTR_NAME = "keymap";

    public static final void processMouseShortcutNode(@NotNull XmlElement element, @NotNull String actionId, @NotNull IdeaPluginDescriptor module, @NotNull Map<String, List<KeymapShortcutOperation>> keymapToOperations) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(keymapToOperations, (String)"keymapToOperations");
        String keystrokeString = (String)element.attributes.get("keystroke");
        CharSequence charSequence = keystrokeString;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            KeymapShortcutOperationKt.reportActionError$default((PluginDescriptor)module, "\"keystroke\" attribute must be specified for action with id=" + actionId, null, 4, null);
            return;
        }
        try {
            object = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception exception) {
            KeymapShortcutOperationKt.reportActionError$default((PluginDescriptor)module, "\"keystroke\" attribute has invalid value for action with id=" + actionId, null, 4, null);
            return;
        }
        MouseShortcut mouseShortcut = object;
        Intrinsics.checkNotNull((Object)mouseShortcut);
        MouseShortcut shortcut = mouseShortcut;
        String keymapName = (String)element.attributes.get(KEYMAP_ATTR_NAME);
        object = keymapName;
        if (object == null || object.length() == 0) {
            KeymapShortcutOperationKt.reportActionError$default((PluginDescriptor)module, "attribute \"keymap\" should be defined", null, 4, null);
            return;
        }
        KeymapShortcutOperationKt.processRemoveAndReplace(element, actionId, keymapName, (Shortcut)shortcut, keymapToOperations);
    }

    public static final void processKeyboardShortcutNode(@NotNull XmlElement element, @NotNull String actionId, @NotNull PluginDescriptor module, @NotNull Map<String, List<KeymapShortcutOperation>> keymapToOperations) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(keymapToOperations, (String)"keymapToOperations");
        String firstStrokeString = (String)element.attributes.get("first-keystroke");
        if (firstStrokeString == null) {
            KeymapShortcutOperationKt.reportActionError$default(module, "\"first-keystroke\" attribute must be specified for action with id=" + actionId, null, 4, null);
            return;
        }
        KeyStroke firstKeyStroke = KeymapUtil.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            KeymapShortcutOperationKt.reportActionError$default(module, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId, null, 4, null);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = (String)element.attributes.get("second-keystroke");
        if (secondStrokeString != null && (secondKeyStroke = KeymapUtil.getKeyStroke((String)secondStrokeString)) == null) {
            KeymapShortcutOperationKt.reportActionError$default(module, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId, null, 4, null);
            return;
        }
        String keymapName = (String)element.attributes.get(KEYMAP_ATTR_NAME);
        CharSequence charSequence = keymapName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            KeymapShortcutOperationKt.reportActionError$default(module, "attribute \"keymap\" should be defined", null, 4, null);
            return;
        }
        KeymapShortcutOperationKt.processRemoveAndReplace(element, actionId, keymapName, (Shortcut)new KeyboardShortcut(firstKeyStroke, secondKeyStroke), keymapToOperations);
    }

    private static final void processRemoveAndReplace(XmlElement element, String actionId, String keymap2, Shortcut shortcut, Map<String, List<KeymapShortcutOperation>> keymapToOperations) {
        boolean replace;
        List list2 = keymapToOperations.computeIfAbsent(keymap2, arg_0 -> KeymapShortcutOperationKt.processRemoveAndReplace$lambda$1(KeymapShortcutOperationKt::processRemoveAndReplace$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"computeIfAbsent(...)");
        List operations = list2;
        boolean remove2 = Boolean.parseBoolean((String)element.attributes.get("remove"));
        if (remove2) {
            operations.add(new RemoveShortcutOperation(actionId, shortcut));
        }
        if (replace = Boolean.parseBoolean((String)element.attributes.get("replace-all"))) {
            operations.add(new RemoveAllShortcutsOperation(actionId));
        }
        if (!remove2) {
            operations.add(new AddShortcutOperation(actionId, shortcut));
        }
    }

    private static final void reportActionError(PluginDescriptor module, String message, Throwable cause) {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ActionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.error((Throwable)new PluginException(message + " (module=" + module + ")", cause, module.getPluginId()));
    }

    static /* synthetic */ void reportActionError$default(PluginDescriptor pluginDescriptor, String string, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        KeymapShortcutOperationKt.reportActionError(pluginDescriptor, string, throwable);
    }

    private static final List processRemoveAndReplace$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List processRemoveAndReplace$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

