/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorAndState {
    @NotNull
    private final FileEditorState editorState;
    private final VirtualFile virtualFile;

    @Nullable
    static EditorAndState getStateFor(@Nullable Project project2, @NotNull CurrentEditorProvider editorProvider) {
        FileEditor editor2;
        if (editorProvider == null) {
            EditorAndState.$$$reportNull$$$0(0);
        }
        if ((editor2 = editorProvider.getCurrentEditor(project2)) != null && editor2.isValid()) {
            FileEditorState state2 = editor2.getState(FileEditorStateLevel.UNDO);
            return new EditorAndState(editor2, state2);
        }
        return null;
    }

    EditorAndState(@NotNull FileEditor editor2, @NotNull FileEditorState state2) {
        if (editor2 == null) {
            EditorAndState.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            EditorAndState.$$$reportNull$$$0(2);
        }
        this.virtualFile = editor2.getFile();
        this.editorState = state2;
    }

    boolean canBeAppliedTo(@Nullable FileEditor editor2) {
        if (editor2 == null || !Objects.equals(this.virtualFile, editor2.getFile())) {
            return false;
        }
        FileEditorState currentState = editor2.getState(FileEditorStateLevel.UNDO);
        return this.editorState.getClass() == currentState.getClass();
    }

    @NotNull
    FileEditorState getState() {
        FileEditorState fileEditorState = this.editorState;
        if (fileEditorState == null) {
            EditorAndState.$$$reportNull$$$0(3);
        }
        return fileEditorState;
    }

    public String toString() {
        return this.editorState.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/EditorAndState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/EditorAndState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

