/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.ImmutableActionChangeRange;
import com.intellij.openapi.command.undo.MutableActionChangeRange;
import com.intellij.openapi.command.undo.MutableActionChangeRangeImpl;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CompressionUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class EditorChangeAction
extends BasicUndoableAction
implements AdjustableUndoableAction {
    private final int myMoveOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    private final MutableActionChangeRange myChangeRange;

    EditorChangeAction(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorChangeAction.$$$reportNull$$$0(0);
        }
        this((DocumentImpl)e.getDocument(), e.getOffset(), e.getMoveOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    private EditorChangeAction(@NotNull DocumentImpl document2, int offset, int moveOffset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        if (document2 == null) {
            EditorChangeAction.$$$reportNull$$$0(1);
        }
        if (oldString == null) {
            EditorChangeAction.$$$reportNull$$$0(2);
        }
        if (newString == null) {
            EditorChangeAction.$$$reportNull$$$0(3);
        }
        super(new Document[]{document2});
        this.myMoveOffset = moveOffset;
        this.myOldString = CompressionUtil.compressStringRawBytes((CharSequence)oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes((CharSequence)newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document2.getModificationStamp();
        int newDocumentLength = document2.getTextLength();
        int oldDocumentLength = newDocumentLength - newString.length() + oldString.length();
        ImmutableActionChangeRange immutableActionChangeRange = ImmutableActionChangeRange.Companion.createNew(offset, oldString.length(), newString.length(), oldDocumentLength, newDocumentLength, (AdjustableUndoableAction)this);
        this.myChangeRange = new MutableActionChangeRangeImpl(immutableActionChangeRange);
    }

    public void undo() throws UnexpectedUndoException {
        long timeStamp = this.myChangeRange.isMoved() ? EditorChangeAction.createNextTimeStamp() : this.myOldTimeStamp;
        ImmutableActionChangeRange range = this.myChangeRange.getState();
        this.doChange(range.getNewDocumentLength(), this.myOldString, range.getOldDocumentLength(), timeStamp);
    }

    public void redo() throws UnexpectedUndoException {
        long timeStamp = this.myChangeRange.isMoved() ? EditorChangeAction.createNextTimeStamp() : this.myNewTimeStamp;
        ImmutableActionChangeRange range = this.myChangeRange.getState();
        this.doChange(range.getOldDocumentLength(), this.myNewString, range.getNewDocumentLength(), timeStamp);
    }

    private static long createNextTimeStamp() {
        return LocalTimeCounter.currentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(int fromLength, Object to, int toLength, long toTimeStamp) throws UnexpectedUndoException {
        DocumentImpl document2 = (DocumentImpl)this.getDocumentRef().getDocument();
        assert (document2 != null);
        if (document2.getTextLength() != fromLength) {
            throw new UnexpectedUndoException("Unexpected document state");
        }
        DocumentUndoProvider.startDocumentUndo((Document)document2);
        try {
            CharSequence toString = CompressionUtil.uncompressStringRawBytes((Object)to);
            int fromStringLength = toString.length() - toLength + fromLength;
            int offset = this.myChangeRange.getState().getOffset();
            int moveOffset = this.myChangeRange.isMoved() ? offset : this.myMoveOffset;
            document2.replaceString(offset, offset + fromStringLength, moveOffset, toString, toTimeStamp, false);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo((Document)document2);
        }
    }

    @NotNull
    public List<MutableActionChangeRange> getChangeRanges(@NotNull DocumentReference reference) {
        if (reference == null) {
            EditorChangeAction.$$$reportNull$$$0(4);
        }
        List<MutableActionChangeRange> list2 = this.isAffected(reference) ? Collections.singletonList(this.myChangeRange) : Collections.emptyList();
        if (list2 == null) {
            EditorChangeAction.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private boolean isAffected(@NotNull DocumentReference reference) {
        DocumentReference affected;
        VirtualFile affectedFile;
        if (reference == null) {
            EditorChangeAction.$$$reportNull$$$0(6);
        }
        if ((affectedFile = (affected = this.getDocumentRef()).getFile()) != null) {
            return affectedFile.equals(reference.getFile());
        }
        return affected.getDocument() == reference.getDocument();
    }

    @NotNull
    private DocumentReference getDocumentRef() {
        DocumentReference documentReference = this.getAffectedDocuments()[0];
        if (documentReference == null) {
            EditorChangeAction.$$$reportNull$$$0(7);
        }
        return documentReference;
    }

    @NonNls
    public String toString() {
        String oldString = this.myOldString.toString().replace("\n", "\\n");
        String newString = this.myNewString.toString().replace("\n", "\\n");
        DocumentReference ref2 = this.getDocumentRef();
        return "Change{%s:'%s'->'%s', ref=%s}".formatted(this.myChangeRange.getOffset(), oldString, newString, ref2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/EditorChangeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/EditorChangeAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeRanges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangeRanges";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAffected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

