/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class PasteFromX11Action
extends EditorAction {
    public PasteFromX11Action() {
        super((EditorActionHandler)new Handler());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PasteFromX11Action.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = e.getPresentation();
        DataContext dataContext2 = e.getDataContext();
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null || SystemInfo.isWindows || SystemInfo.isMac) {
            presentation2.setEnabled(false);
        } else {
            boolean rightPlace = true;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)inputEvent;
                rightPlace = false;
                if (dataContext2.getData(EditorGutter.KEY) == null) {
                    Component component2 = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
                    rightPlace = !(component2 instanceof JScrollBar);
                }
            }
            presentation2.setEnabled(rightPlace);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/PasteFromX11Action", "update"));
    }

    public static final class Handler
    extends BasePasteHandler {
        @Override
        protected Transferable getContentsToPaste(Editor editor2, DataContext dataContext2) {
            return CopyPasteManager.getInstance().getSystemSelectionContents();
        }
    }
}

