/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ToggleColumnModeAction
extends ToggleAction
implements DumbAware,
LightEditCompatible,
ActionRemoteBehaviorSpecification.Frontend {
    public ToggleColumnModeAction() {
        this.setEnabledInModalContext(true);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        if (e == null) {
            ToggleColumnModeAction.$$$reportNull$$$0(0);
        }
        EditorEx editor2 = ToggleColumnModeAction.getEditor(e);
        SelectionModel selectionModel = editor2.getSelectionModel();
        CaretModel caretModel = editor2.getCaretModel();
        if (state2) {
            LogicalPosition blockEnd;
            LogicalPosition blockStart;
            caretModel.removeSecondaryCarets();
            boolean hasSelection = selectionModel.hasSelection();
            int selStart = selectionModel.getSelectionStart();
            int selEnd = selectionModel.getSelectionEnd();
            if (caretModel.supportsMultipleCarets()) {
                LogicalPosition logicalSelStart = editor2.offsetToLogicalPosition(selStart);
                LogicalPosition logicalSelEnd = editor2.offsetToLogicalPosition(selEnd);
                int caretOffset = caretModel.getOffset();
                blockStart = selStart == caretOffset ? logicalSelEnd : logicalSelStart;
                blockEnd = selStart == caretOffset ? logicalSelStart : logicalSelEnd;
            } else {
                blockStart = selStart == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor2.offsetToLogicalPosition(selStart);
                blockEnd = selEnd == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor2.offsetToLogicalPosition(selEnd);
            }
            editor2.setColumnMode(true);
            if (hasSelection) {
                selectionModel.setBlockSelection(blockStart, blockEnd);
            } else {
                selectionModel.removeSelection();
            }
        } else {
            boolean hasSelection = false;
            int selStart = 0;
            int selEnd = 0;
            if (caretModel.supportsMultipleCarets()) {
                hasSelection = true;
                List allCarets = caretModel.getAllCarets();
                Caret fromCaret = (Caret)allCarets.get(0);
                Caret toCaret = (Caret)allCarets.get(allCarets.size() - 1);
                if (fromCaret == caretModel.getPrimaryCaret()) {
                    Caret tmp = fromCaret;
                    fromCaret = toCaret;
                    toCaret = tmp;
                }
                selStart = fromCaret.getLeadSelectionOffset();
                selEnd = toCaret.getSelectionStart() == toCaret.getLeadSelectionOffset() ? toCaret.getSelectionEnd() : toCaret.getSelectionStart();
            }
            editor2.setColumnMode(false);
            caretModel.removeSecondaryCarets();
            if (hasSelection) {
                selectionModel.setSelection(selStart, selEnd);
            } else {
                selectionModel.removeSelection();
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        EditorEx ex;
        if (e == null) {
            ToggleColumnModeAction.$$$reportNull$$$0(1);
        }
        return (ex = ToggleColumnModeAction.getEditor(e)) != null && ex.isColumnMode();
    }

    private static EditorEx getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleColumnModeAction.$$$reportNull$$$0(2);
        }
        return (EditorEx)e.getData(CommonDataKeys.EDITOR);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleColumnModeAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorEx editor2;
        if (e == null) {
            ToggleColumnModeAction.$$$reportNull$$$0(4);
        }
        if ((editor2 = ToggleColumnModeAction.getEditor(e)) == null || editor2.isOneLineMode()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            super.update(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/ToggleColumnModeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/ToggleColumnModeAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

