/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ComplementaryFontsRegistry {
    private static final Logger LOG = Logger.getInstance(ComplementaryFontsRegistry.class);
    private static final String DEFAULT_FALLBACK_FONT = "Monospaced";
    private static final Object lock = new Object();
    private static final List<String>[] ourFontNames = new List[4];
    private static final LinkedHashMap<String, FallBackInfo>[] ourUsedFonts = new LinkedHashMap[]{new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap()};
    private static final Map<Font, FallBackInfo> ourMainUsedFonts = new HashMap<Font, FallBackInfo>();
    private static final FallBackInfo UNDISPLAYABLE_FONT_INFO = new FallBackInfo("JetBrains Mono", 0);
    private static final IntSet[] ourUndisplayableChars = new IntOpenHashSet[]{new IntOpenHashSet(), new IntOpenHashSet(), new IntOpenHashSet(), new IntOpenHashSet()};
    private static String ourLastFontFamily = null;
    private static String ourLastRegularSubFamily;
    private static String ourLastBoldSubFamily;
    private static boolean ourLastTypographicNames;
    private static final FallBackInfo[] ourLastFallBackInfo;
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";
    private static final String ADOBE_BLANK = "Adobe Blank";

    private ComplementaryFontsRegistry() {
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(@NotNull CharSequence text2, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context2) {
        if (text2 == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(0);
        }
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(1);
        }
        assert (0 <= start2 && start2 < end && end <= text2.length()) : "Start: " + start2 + ", end: " + end + ", length: " + text2.length();
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text2.charAt(start2), style, preferences, context2);
        }
        int firstCodePoint = Character.codePointAt(text2, start2);
        int secondOffset = Character.offsetByCodePoints(text2, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context2);
        }
        char[] tmp = CharArrayUtil.fromSequence((CharSequence)text2, (int)secondOffset, (int)end);
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, tmp, 0, tmp.length, style, preferences, context2);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(2);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(char @NotNull [] text2, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context2) {
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(4);
        }
        assert (0 <= start2 && start2 < end && end <= text2.length) : "Start: " + start2 + ", end: " + end + ", length: " + text2.length;
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text2[start2], style, preferences, context2);
        }
        int firstCodePoint = Character.codePointAt(text2, start2);
        int secondOffset = Character.offsetByCodePoints(text2, start2, end - start2, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context2);
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, text2, secondOffset, end, style, preferences, context2);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(5);
        }
        return fontInfo;
    }

    private static FontInfo getFontAbleToDisplay(int codePoint, char @NotNull [] remainingText, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context2) {
        FontInfo result2;
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(6);
        }
        if (remainingText == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(7);
        }
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = preferences.useLigatures();
        Set variants = preferences.getCharacterVariants();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize2D(fontFamily), style, fontFamily, i2 == 0 ? preferences.getRegularSubFamily() : null, i2 == 0 ? preferences.getBoldSubFamily() : null, useLigatures, variants, context2, true, true);
            if (result2 != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
                return result2;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        float size2 = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size2 = preferences.getSize2D((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size2, style, DEFAULT_FALLBACK_FONT, null, null, useLigatures, Collections.emptySet(), context2, false, false)) != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
            return result2;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, remainingText, start2, end, size2, style, useLigatures, Collections.emptySet(), context2);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Fallback font: " + result2.getFont().getFontName());
        }
        return result2;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context2) {
        FontInfo result2;
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(8);
        }
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = preferences.useLigatures();
        Set variants = preferences.getCharacterVariants();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize2D(fontFamily), style, fontFamily, i2 == 0 ? preferences.getRegularSubFamily() : null, i2 == 0 ? preferences.getBoldSubFamily() : null, useLigatures, variants, context2, true, true);
            if (result2 != null) {
                FontInfo fontInfo = result2;
                if (fontInfo == null) {
                    ComplementaryFontsRegistry.$$$reportNull$$$0(9);
                }
                return fontInfo;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        float size2 = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size2 = preferences.getSize2D((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size2, style, DEFAULT_FALLBACK_FONT, null, null, useLigatures, Collections.emptySet(), context2, false, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(10);
            }
            return fontInfo;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size2, style, useLigatures, Collections.emptySet(), context2);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Fallback font: " + result2.getFont().getFontName());
        }
        FontInfo fontInfo = result2;
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(11);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size2, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, FontRenderContext context2) {
        FontInfo result2;
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(12);
        }
        if ((result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size2, style, defaultFontFamily, null, null, false, context2, false, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(13);
            }
            return fontInfo;
        }
        if (!DEFAULT_FALLBACK_FONT.equals(defaultFontFamily) && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size2, style, DEFAULT_FALLBACK_FONT, null, null, false, context2, false, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(14);
            }
            return fontInfo;
        }
        return ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size2, style, false, context2);
    }

    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, float size2, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, String regularSubFamily, String boldSubFamily, boolean useLigatures, FontRenderContext context2, boolean disableFontFallback, boolean useTypographicNames) {
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(15);
        }
        return ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size2, style, defaultFontFamily, regularSubFamily, boldSubFamily, useLigatures, Collections.emptySet(), context2, disableFontFallback, useTypographicNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, float size2, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, String regularSubFamily, String boldSubFamily, boolean useLigatures, @NotNull @Unmodifiable @NotNull Set<@NotNull String> variants, FontRenderContext context2, boolean disableFontFallback, boolean useTypographicNames) {
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(16);
        }
        if (variants == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(17);
        }
        if (style < 0 || style > 3) {
            style = 0;
        }
        Object object = lock;
        synchronized (object) {
            FallBackInfo fallBackInfo = null;
            if (useTypographicNames == ourLastTypographicNames && defaultFontFamily.equals(ourLastFontFamily) && (!useTypographicNames || Objects.equals(regularSubFamily, ourLastRegularSubFamily) && Objects.equals(boldSubFamily, ourLastBoldSubFamily))) {
                fallBackInfo = ourLastFallBackInfo[style];
            } else {
                ourLastTypographicNames = useTypographicNames;
                ourLastFontFamily = defaultFontFamily;
                ourLastRegularSubFamily = regularSubFamily;
                ourLastBoldSubFamily = boldSubFamily;
                Arrays.fill(ourLastFallBackInfo, null);
            }
            if (fallBackInfo == null) {
                if (useTypographicNames) {
                    Font font = FontFamilyService.getFont((String)defaultFontFamily, (String)regularSubFamily, (String)boldSubFamily, (int)style);
                    fallBackInfo = ourMainUsedFonts.computeIfAbsent(font, FallBackInfo::new);
                } else {
                    LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
                    fallBackInfo = usedFonts.get(defaultFontFamily);
                    if (fallBackInfo == null) {
                        fallBackInfo = new FallBackInfo(defaultFontFamily, style);
                        usedFonts.put(defaultFontFamily, fallBackInfo);
                    }
                }
                ComplementaryFontsRegistry.ourLastFallBackInfo[style] = fallBackInfo;
            }
            return fallBackInfo.canDisplay(codePoint, disableFontFallback) ? fallBackInfo.getFontInfo(size2, useLigatures, variants, context2) : null;
        }
    }

    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, char[] remainingText, int start2, int end, float size2, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext context2) {
        return ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, remainingText, start2, end, size2, style, useLigatures, Collections.emptySet(), context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, char[] remainingText, int start2, int end, float size2, @JdkConstants.FontStyle int style, boolean useLigatures, @NotNull @Unmodifiable @NotNull Set<@NotNull String> variants, FontRenderContext context2) {
        if (variants == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(18);
        }
        if (style < 0 || style > 3) {
            style = 0;
        }
        Object object = lock;
        // MONITORENTER : object
        FallBackInfo fallBackInfo = UNDISPLAYABLE_FONT_INFO;
        IntSet undisplayableChars = ourUndisplayableChars[style];
        if (!undisplayableChars.contains(codePoint)) {
            boolean canDisplayFirst = false;
            LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
            Collection<FallBackInfo> descriptors2 = usedFonts.values();
            for (FallBackInfo info : descriptors2) {
                if (!info.canDisplay(codePoint, false)) continue;
                canDisplayFirst = true;
                if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                fallBackInfo = info;
                break;
            }
            if (fallBackInfo == UNDISPLAYABLE_FONT_INFO) {
                List<String> fontNames = ourFontNames[style];
                for (int i2 = 0; i2 < fontNames.size(); ++i2) {
                    String name2 = fontNames.get(i2);
                    FallBackInfo info = new FallBackInfo(name2, style);
                    if (!info.canDisplay(codePoint, false)) continue;
                    canDisplayFirst = true;
                    if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                    usedFonts.put(name2, info);
                    fontNames.remove(i2);
                    fallBackInfo = info;
                    break;
                }
                if (fallBackInfo == UNDISPLAYABLE_FONT_INFO && !canDisplayFirst) {
                    undisplayableChars.add(codePoint);
                }
            }
        }
        FontInfo fontInfo = fallBackInfo.getFontInfo(size2, useLigatures, variants, context2);
        // MONITOREXIT : object
        if (fontInfo != null) return fontInfo;
        ComplementaryFontsRegistry.$$$reportNull$$$0(19);
        return fontInfo;
    }

    static {
        ourLastFallBackInfo = new FallBackInfo[4];
        ArrayList<String> fontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            fontNames.add(DEFAULT_FALLBACK_FONT);
        } else {
            String[] families;
            for (String fontName : families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX) || fontName.equals(ADOBE_BLANK)) continue;
                fontNames.add(fontName);
            }
        }
        ComplementaryFontsRegistry.ourFontNames[0] = fontNames;
        for (int i2 = 1; i2 < 4; ++i2) {
            ComplementaryFontsRegistry.ourFontNames[i2] = new ArrayList<String>(fontNames);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 10, 11, 13, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingText";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFontFamily";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontAbleToDisplay";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFontAbleToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFontAbleToDisplay";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetFontAbleToDisplay";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 10, 11, 13, 14, 19 -> new IllegalStateException(string);
        };
    }

    private static final class FallBackInfo {
        private final Font myBaseFont;
        private final Map<FontKey, FontInfo> myFontInfoMap = new HashMap<FontKey, FontInfo>();
        private final FontKey myLastFontKey = new FontKey(-1.0f, false, Collections.emptySet(), FontInfo.DEFAULT_CONTEXT);
        private FontInfo myLastFontInfo;

        private FallBackInfo(Font font) {
            this.myBaseFont = font;
        }

        private FallBackInfo(String familyName, @JdkConstants.FontStyle int style) {
            this.myBaseFont = new Font(familyName, style, 1);
        }

        private boolean canDisplay(int codePoint, boolean disableFontFallback) {
            return codePoint < 128 || FontInfo.canDisplay(this.myBaseFont, codePoint, disableFontFallback);
        }

        private FontInfo getFontInfo(float size2, boolean useLigatures, @NotNull @Unmodifiable @NotNull Set<@NotNull String> variants, FontRenderContext fontRenderContext) {
            if (variants == null) {
                FallBackInfo.$$$reportNull$$$0(0);
            }
            if (this.myLastFontKey.mySize == size2 && this.myLastFontKey.myUseLigatures == useLigatures && Objects.equals(this.myLastFontKey.myVariants, variants.isEmpty() ? Collections.emptyList() : new ArrayList<String>(variants)) && Objects.equals(this.myLastFontKey.myContext, fontRenderContext)) {
                return this.myLastFontInfo;
            }
            this.myLastFontKey.mySize = size2;
            this.myLastFontKey.myUseLigatures = useLigatures;
            this.myLastFontKey.myVariants = variants.isEmpty() ? Collections.emptyList() : new ArrayList<String>(variants);
            this.myLastFontKey.myContext = fontRenderContext;
            FontInfo fontInfo = this.myFontInfoMap.get(this.myLastFontKey);
            if (fontInfo == null) {
                fontInfo = new FontInfo(this.myBaseFont, size2, useLigatures, variants, fontRenderContext);
                this.myFontInfoMap.put(this.myLastFontKey.clone(), fontInfo);
            }
            this.myLastFontInfo = fontInfo;
            return fontInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry$FallBackInfo", "getFontInfo"));
        }
    }

    private static final class FontKey
    implements Cloneable {
        private float mySize;
        private boolean myUseLigatures;
        @NotNull
        private @NotNull List<@NotNull String> myVariants;
        private FontRenderContext myContext;

        private FontKey(float size2, boolean useLigatures, @NotNull @NotNull Set<@NotNull String> variants, FontRenderContext context2) {
            if (variants == null) {
                FontKey.$$$reportNull$$$0(0);
            }
            this.mySize = size2;
            this.myUseLigatures = useLigatures;
            this.myVariants = variants.isEmpty() ? Collections.emptyList() : new ArrayList<String>(variants);
            this.myContext = context2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontKey key = (FontKey)o;
            if (this.mySize != key.mySize) {
                return false;
            }
            if (this.myUseLigatures != key.myUseLigatures) {
                return false;
            }
            if (!Objects.equals(this.myContext, key.myContext)) {
                return false;
            }
            return Objects.equals(this.myVariants, key.myVariants);
        }

        public int hashCode() {
            int result2 = this.mySize != 0.0f ? Float.floatToIntBits(this.mySize) : 0;
            result2 = 31 * result2 + (this.myUseLigatures ? 1 : 0);
            result2 = 31 * result2 + (this.myContext != null ? this.myContext.hashCode() : 0);
            result2 = 31 * result2 + this.myVariants.hashCode();
            return result2;
        }

        protected FontKey clone() {
            try {
                return (FontKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry$FontKey", "<init>"));
        }
    }
}

