/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayKeys;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class InlayImpl<R extends EditorCustomElementRenderer, T extends InlayImpl<?, ?>>
extends RangeMarkerImpl
implements Inlay<R> {
    @NotNull
    final EditorImpl myEditor;
    @NotNull
    final R myRenderer;
    private final boolean myRelatedToPrecedingText;
    int myWidthInPixels;

    InlayImpl(@NotNull EditorImpl editor2, int offset, boolean relatesToPrecedingText, @NotNull R renderer2) {
        if (editor2 == null) {
            InlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            InlayImpl.$$$reportNull$$$0(1);
        }
        super(editor2.getDocument(), offset, offset, false, true);
        this.myEditor = editor2;
        this.myRelatedToPrecedingText = relatesToPrecedingText;
        this.myRenderer = renderer2;
        this.doUpdate();
        this.getTree().addInterval((RangeMarkerEx)this, offset, offset, false, false, relatesToPrecedingText, 0);
    }

    @ApiStatus.Internal
    public abstract RangeMarkerTree<T> getTree();

    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            InlayImpl.$$$reportNull$$$0(2);
        }
        return editorImpl;
    }

    public boolean isValid() {
        return !this.myEditor.isDisposed() && super.isValid();
    }

    public void update() {
        EditorImpl.assertIsDispatchThread();
        int oldWidth = this.getWidthInPixels();
        int oldHeight = this.getHeightInPixels();
        GutterIconRenderer oldIconRenderer = this.getGutterIconRenderer();
        this.doUpdate();
        int changeFlags = 0;
        if (oldWidth != this.getWidthInPixels()) {
            changeFlags |= 1;
        }
        if (oldHeight != this.getHeightInPixels()) {
            changeFlags |= 2;
        }
        if (!Objects.equals(oldIconRenderer, this.getGutterIconRenderer())) {
            changeFlags |= 4;
        }
        if (changeFlags != 0) {
            this.myEditor.getInlayModel().notifyChanged(this, changeFlags);
        } else {
            this.repaint();
        }
    }

    public void repaint() {
        Rectangle bounds;
        EditorComponentImpl contentComponent;
        if (this.isValid() && !this.myEditor.isDisposed() && !this.myEditor.getDocument().isInBulkUpdate() && !this.myEditor.getInlayModel().isInBatchMode() && (contentComponent = this.myEditor.getContentComponent()).isShowing() && (bounds = this.getBounds()) != null) {
            if (this instanceof BlockInlayImpl) {
                bounds.width = contentComponent.getWidth();
            }
            contentComponent.repaint(bounds);
        }
    }

    abstract void doUpdate();

    public void dispose() {
        EditorImpl.assertIsDispatchThread();
        if (this.isValid()) {
            int offset = this.getOffset();
            this.putUserData(InlayKeys.OFFSET_BEFORE_DISPOSAL, offset);
            this.putUserData(InlayKeys.ID_BEFORE_DISPOSAL, this.getId());
            this.getTree().removeInterval((RangeMarkerEx)this);
            this.myEditor.getInlayModel().notifyRemoved(this);
        }
    }

    public int getOffset() {
        Integer offsetBeforeDisposal = (Integer)this.getUserData(InlayKeys.OFFSET_BEFORE_DISPOSAL);
        return offsetBeforeDisposal == null ? this.getStartOffset() : offsetBeforeDisposal.intValue();
    }

    public boolean isRelatedToPrecedingText() {
        return this.myRelatedToPrecedingText;
    }

    abstract Point getPosition();

    @Nullable
    public Rectangle getBounds() {
        if (EditorUtil.isInlayFolded(this)) {
            return null;
        }
        Point pos = this.getPosition();
        return new Rectangle(pos.x, pos.y, this.getWidthInPixels(), this.getHeightInPixels());
    }

    @NotNull
    public R getRenderer() {
        R r = this.myRenderer;
        if (r == null) {
            InlayImpl.$$$reportNull$$$0(3);
        }
        return r;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

