/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.InlayModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.AfterLineEndInlayImpl;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlayKeys;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.IntervalTree;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.Ref;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class InlayModelImpl
implements InlayModel,
InlayModelEx,
PrioritizedDocumentListener,
Disposable,
Dumpable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<InlineInlayImpl<?>> INLINE_ELEMENTS_COMPARATOR = Comparator.comparingInt(i2 -> i2.getOffset()).thenComparing(i2 -> i2.isRelatedToPrecedingText()).thenComparing(i2 -> -i2.myPriority);
    private static final Comparator<BlockInlayImpl<?>> BLOCK_ELEMENTS_PRIORITY_COMPARATOR = Comparator.comparingInt(i2 -> -i2.myPriority);
    private static final Comparator<BlockInlayImpl<?>> BLOCK_ELEMENTS_COMPARATOR = Comparator.comparing(i2 -> i2.getPlacement()).thenComparing(i2 -> i2.getPlacement() == Inlay.Placement.ABOVE_LINE ? i2.myPriority : -i2.myPriority);
    private static final Comparator<AfterLineEndInlayImpl<?>> AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR = Comparator.comparingInt(i2 -> i2.getOffset()).thenComparing(i2 -> !i2.mySoftWrappable).thenComparingInt(i2 -> -i2.myPriority).thenComparingInt(i2 -> i2.myOrder);
    private static final Comparator<AfterLineEndInlayImpl<?>> AFTER_LINE_END_ELEMENTS_COMPARATOR = Comparator.comparing(i2 -> !i2.mySoftWrappable).thenComparingInt(i2 -> -i2.myPriority).thenComparingInt(i2 -> i2.myOrder);
    private static final Processor<InlayImpl<?, ?>> UPDATE_PROCESSOR = inlay -> {
        inlay.update();
        return true;
    };
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher;
    private final List<InlayImpl<?, ?>> myInlaysInvalidatedOnMove;
    final RangeMarkerTree<InlineInlayImpl<?>> myInlineElementsTree;
    final MarkerTreeWithPartialSums<BlockInlayImpl<?>> myBlockElementsTree;
    final RangeMarkerTree<AfterLineEndInlayImpl<?>> myAfterLineEndElementsTree;
    boolean myMoveInProgress;
    boolean myPutMergedIntervalsAtBeginning;
    private boolean myConsiderCaretPositionOnDocumentUpdates;
    private List<Inlay<?>> myInlaysAtCaret;
    private boolean myInBatchMode;

    InlayModelImpl(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            InlayModelImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
        this.myInlaysInvalidatedOnMove = new ArrayList();
        this.myConsiderCaretPositionOnDocumentUpdates = true;
        this.myEditor = editor2;
        this.myInlineElementsTree = new InlineElementsTree((Document)editor2.getDocument());
        this.myBlockElementsTree = new BlockElementsTree((Document)editor2.getDocument());
        this.myAfterLineEndElementsTree = new AfterLineEndElementTree((Document)editor2.getDocument());
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    public int getPriority() {
        return 150;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        List<Inlay<?>> inlays;
        int inlayCount;
        if (event == null) {
            InlayModelImpl.$$$reportNull$$$0(1);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (this.myInBatchMode) {
            LOG.error("Document shouldn't be changed during batch inlay operation");
        }
        int offset = event.getOffset();
        if (this.myConsiderCaretPositionOnDocumentUpdates && event.getOldLength() == 0 && offset == this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = this.getInlineElementsInRange(offset, offset)).size()) > 0) {
            VisualPosition inlaysStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
            VisualPosition caretPosition = this.myEditor.getCaretModel().getVisualPosition();
            if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                this.myInlaysAtCaret = inlays;
                for (int i2 = 0; i2 < inlayCount; ++i2) {
                    ((InlayImpl)inlays.get(i2)).setStickingToRight(i2 >= caretPosition.column - inlaysStartPosition.column);
                }
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            InlayModelImpl.$$$reportNull$$$0(2);
        }
        if (this.myInlaysAtCaret != null) {
            for (Inlay<?> inlay : this.myInlaysAtCaret) {
                ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
            }
            this.myInlaysAtCaret = null;
        }
        if (DocumentEventUtil.isMoveInsertion((DocumentEvent)event)) {
            for (InlayImpl inlayImpl : this.myInlaysInvalidatedOnMove) {
                this.notifyRemoved(inlayImpl);
            }
            this.myInlaysInvalidatedOnMove.clear();
        }
    }

    void reinitSettings() {
        this.myInlineElementsTree.processAll(UPDATE_PROCESSOR);
        this.myBlockElementsTree.processAll(UPDATE_PROCESSOR);
        this.myAfterLineEndElementsTree.processAll(UPDATE_PROCESSOR);
    }

    public void dispose() {
        this.myInlineElementsTree.dispose((Document)this.myEditor.getDocument());
        this.myBlockElementsTree.dispose((Document)this.myEditor.getDocument());
        this.myAfterLineEndElementsTree.dispose((Document)this.myEditor.getDocument());
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(3);
        }
        return this.addInlineElement(offset, relatesToPrecedingText, 0, renderer2);
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, int priority, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(4);
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document2 = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair((Document)document2, (int)offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document2.getTextLength(), offset));
        InlineInlayImpl<T> inlay = new InlineInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, priority, renderer2);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, @NotNull InlayProperties properties, @NotNull T renderer2) {
        if (properties == null) {
            InlayModelImpl.$$$reportNull$$$0(5);
        }
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(6);
        }
        return this.addInlineElement(offset, properties.isRelatedToPrecedingText(), properties.getPriority(), renderer2);
    }

    @NotNull
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(7);
        }
        Inlay<T> inlay = this.addBlockElement(offset, relatesToPrecedingText, showAbove, false, priority, renderer2);
        if (inlay == null) {
            InlayModelImpl.$$$reportNull$$$0(8);
        }
        return inlay;
    }

    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, @NotNull InlayProperties properties, @NotNull T renderer2) {
        if (properties == null) {
            InlayModelImpl.$$$reportNull$$$0(9);
        }
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(10);
        }
        return this.addBlockElement(offset, properties.isRelatedToPrecedingText(), properties.isShownAbove(), properties.isShownWhenFolded(), properties.getPriority(), renderer2);
    }

    private <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, int priority, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(11);
        }
        EditorImpl.assertIsDispatchThread();
        offset = Math.max(0, Math.min(this.myEditor.getDocument().getTextLength(), offset));
        BlockInlayImpl<T> inlay = new BlockInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, showAbove, showWhenFolded, priority, renderer2);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public <T extends EditorCustomElementRenderer> @NotNull Inlay<@NotNull T> addAfterLineEndElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(12);
        }
        return this.addAfterLineEndElement(offset, relatesToPrecedingText, true, 0, renderer2);
    }

    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int offset, @NotNull InlayProperties properties, @NotNull T renderer2) {
        if (properties == null) {
            InlayModelImpl.$$$reportNull$$$0(13);
        }
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(14);
        }
        return this.addAfterLineEndElement(offset, properties.isRelatedToPrecedingText(), !properties.isSoftWrappingDisabled(), properties.getPriority(), renderer2);
    }

    @NotNull
    private <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int offset, boolean relatesToPrecedingText, boolean softWrappable, int priority, @NotNull T renderer2) {
        if (renderer2 == null) {
            InlayModelImpl.$$$reportNull$$$0(15);
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document2 = this.myEditor.getDocument();
        offset = Math.max(0, Math.min(document2.getTextLength(), offset));
        AfterLineEndInlayImpl<T> inlay = new AfterLineEndInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, softWrappable, priority, renderer2);
        this.notifyAdded(inlay);
        AfterLineEndInlayImpl<T> afterLineEndInlayImpl = inlay;
        if (afterLineEndInlayImpl == null) {
            InlayModelImpl.$$$reportNull$$$0(16);
        }
        return afterLineEndInlayImpl;
    }

    @NotNull
    public List<Inlay<?>> getInlineElementsInRange(int startOffset, int endOffset) {
        List<Inlay<?>> range;
        List<Inlay<?>> list2 = range = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, Predicates.alwaysTrue(), INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(18);
        }
        List<Inlay<T>> list2 = range = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsInRange(int startOffset, int endOffset) {
        List<Inlay<?>> range;
        List<Inlay<?>> list2 = range = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, Predicates.alwaysTrue(), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(21);
        }
        List<Inlay<T>> list2 = range = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(22);
        }
        return list2;
    }

    private static <T extends Inlay<?>> List<T> getElementsInRange(@NotNull IntervalTree<? extends T> tree2, int startOffset, int endOffset, @NotNull Predicate<? super T> predicate, @NotNull Comparator<? super T> comparator) {
        if (tree2 == null) {
            InlayModelImpl.$$$reportNull$$$0(23);
        }
        if (predicate == null) {
            InlayModelImpl.$$$reportNull$$$0(24);
        }
        if (comparator == null) {
            InlayModelImpl.$$$reportNull$$$0(25);
        }
        ArrayList result2 = new ArrayList();
        tree2.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (predicate.test(inlay)) {
                result2.add((Object)inlay);
            }
            return true;
        });
        result2.sort(comparator);
        return result2;
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsForVisualLine(int visualLine, boolean above) {
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine < 0 || visualLine >= visibleLineCount || this.myBlockElementsTree.size() == 0) {
            List<Inlay<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(26);
            }
            return list2;
        }
        ArrayList result2 = new ArrayList();
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int endOffset = visualLine == visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (inlay.myShowAbove == above && !EditorUtil.isInlayFolded(inlay)) {
                result2.add((Inlay<?>)inlay);
            }
            return true;
        });
        if (above) {
            Collections.reverse(result2);
        }
        result2.sort(BLOCK_ELEMENTS_COMPARATOR);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Override
    @ApiStatus.Internal
    public int getHeightOfBlockElementsBeforeVisualLine(int visualLine, int startOffset, int prevFoldRegionIndex) {
        int endOffset;
        if (visualLine < 0 || !this.hasBlockElements()) {
            return 0;
        }
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine >= visibleLineCount) {
            return this.myBlockElementsTree.getSumOfValuesUpToOffset(Integer.MAX_VALUE) - this.myEditor.getFoldingModel().getTotalHeightOfFoldedBlockInlays();
        }
        int[] result2 = new int[]{0};
        int n = endOffset = visualLine >= visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        if (visualLine > 0) {
            result2[0] = result2[0] + (this.myBlockElementsTree.getSumOfValuesUpToOffset(startOffset - 1) - this.myEditor.getFoldingModel().getHeightOfFoldedBlockInlaysBefore(prevFoldRegionIndex));
        }
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (inlay.myShowAbove && !EditorUtil.isInlayFolded(inlay)) {
                result2[0] = result2[0] + inlay.getHeightInPixels();
            }
            return true;
        });
        return result2[0];
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public Inlay<?> getWidestVisibleBlockInlay() {
        AtomicInteger maxWidth = new AtomicInteger(-1);
        Ref inlayRef = new Ref(null);
        this.myBlockElementsTree.processAll(inlay -> {
            int width = inlay.getWidthInPixels();
            if (width > maxWidth.get() && !EditorUtil.isInlayFolded(inlay)) {
                maxWidth.set(width);
                inlayRef.set(inlay);
            }
            return true;
        });
        return (Inlay)inlayRef.get();
    }

    public boolean hasBlockElements() {
        return this.myBlockElementsTree.size() > 0;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlineElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> false);
    }

    public boolean hasInlineElements() {
        return this.myInlineElementsTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlineElementsTree.processOverlappingWith(offset, offset, inlay -> false);
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        int inlayCount;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(28);
        }
        if ((inlayCount = this.getInlineElementsInRange(offset = this.myEditor.visualPositionToOffset(visualPosition), offset).size()) == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay<?> getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        List<Inlay<?>> inlays;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(29);
        }
        if ((inlays = this.getInlineElementsInRange(offset = this.myEditor.visualPositionToOffset(visualPosition), offset)).isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay<?> getElementAt(@NotNull Point point) {
        if (point == null) {
            InlayModelImpl.$$$reportNull$$$0(30);
        }
        return this.getElementAt(new EditorLocation(this.myEditor, point), false);
    }

    Inlay<?> getElementAt(@NotNull EditorLocation location, boolean ignoreBlockElementWidth) {
        if (location == null) {
            InlayModelImpl.$$$reportNull$$$0(31);
        }
        return (Inlay)EditorThreading.compute(() -> {
            Inlay<?> inlay;
            int offset;
            List<Inlay<?>> inlays;
            Insets insets = this.myEditor.getContentComponent().getInsets();
            Point point = location.getPoint();
            if (point.y < insets.top) {
                return null;
            }
            int relX = point.x - insets.left;
            if (relX < 0) {
                return null;
            }
            boolean hasInlineElements = this.hasInlineElements();
            boolean hasBlockElements = this.hasBlockElements();
            boolean hasAfterLineEndElements = this.hasAfterLineEndElements();
            if (!(hasInlineElements || hasBlockElements || hasAfterLineEndElements)) {
                return null;
            }
            VisualPosition visualPosition = location.getVisualPosition();
            if (hasBlockElements) {
                int visualLine = visualPosition.line;
                int baseY = location.getVisualLineStartY();
                if (point.y < baseY) {
                    List<Inlay<?>> inlays2 = this.getBlockElementsForVisualLine(visualLine, true);
                    int yDiff = baseY - point.y;
                    for (int i2 = inlays2.size() - 1; i2 >= 0; --i2) {
                        Inlay<?> inlay2 = inlays2.get(i2);
                        if ((yDiff -= inlay2.getHeightInPixels()) > 0) continue;
                        return ignoreBlockElementWidth || relX < inlay2.getWidthInPixels() ? inlay2 : null;
                    }
                    LOG.error("Inconsistent state: " + String.valueOf(point) + ", " + String.valueOf(visualPosition) + ", baseY=" + baseY + ", " + String.valueOf(inlays2), new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                    return null;
                }
                int lineBottom = location.getVisualLineEndY();
                if (point.y >= lineBottom) {
                    List<Inlay<?>> inlays3 = this.getBlockElementsForVisualLine(visualLine, false);
                    int yDiff = point.y - lineBottom;
                    for (Inlay<?> inlay3 : inlays3) {
                        if ((yDiff -= inlay3.getHeightInPixels()) >= 0) continue;
                        return relX < inlay3.getWidthInPixels() ? inlay3 : null;
                    }
                    LOG.error("Inconsistent state: " + String.valueOf(point) + ", " + String.valueOf(visualPosition) + ", lineBottom=" + lineBottom + ", " + String.valueOf(inlays3), new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                    return null;
                }
            }
            if (hasInlineElements && location.getCollapsedRegion() == null && !(inlays = this.getInlineElementsInRange(offset = location.getOffset(), offset)).isEmpty()) {
                VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
                Point inlayPoint = this.myEditor.visualPositionToXY(startVisualPosition);
                if (point.y < inlayPoint.y || point.y >= inlayPoint.y + this.myEditor.getLineHeight()) {
                    return null;
                }
                inlay = InlayModelImpl.findInlay(inlays, point.x, inlayPoint.x);
                if (inlay != null) {
                    return inlay;
                }
            }
            if (hasAfterLineEndElements) {
                List<Inlay<?>> inlays4;
                offset = location.getOffset();
                int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
                if (offset == this.myEditor.getDocument().getLineEndOffset(logicalLine) && location.getCollapsedRegion() == null && !(inlays4 = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine)).isEmpty()) {
                    Rectangle bounds = inlays4.get(0).getBounds();
                    assert (bounds != null);
                    if (point.y < bounds.y || point.y >= bounds.y + bounds.height) {
                        return null;
                    }
                    inlay = InlayModelImpl.findInlay(inlays4, point.x, bounds.x);
                    if (inlay != null) {
                        return inlay;
                    }
                }
            }
            return null;
        });
    }

    private static Inlay<?> findInlay(List<? extends Inlay<?>> inlays, int x, int startX) {
        for (Inlay<?> inlay : inlays) {
            int endX = startX + inlay.getWidthInPixels();
            if (x >= startX && x < endX) {
                return inlay;
            }
            startX = endX;
        }
        return null;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsInRange(int startOffset, int endOffset) {
        List<Inlay<?>> range;
        if (!this.hasAfterLineEndElements()) {
            List<Inlay<?>> list2 = List.of();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(32);
            }
            return list2;
        }
        List<Inlay<?>> list3 = range = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, Predicates.alwaysTrue(), AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        if (list3 == null) {
            InlayModelImpl.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(34);
        }
        if (!this.hasAfterLineEndElements()) {
            List<Inlay<? extends T>> list2 = List.of();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(35);
            }
            return list2;
        }
        List<Inlay<T>> list3 = range = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        if (list3 == null) {
            InlayModelImpl.$$$reportNull$$$0(36);
        }
        return list3;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsForLogicalLine(int logicalLine) {
        DocumentEx document2 = this.myEditor.getDocument();
        if (!this.hasAfterLineEndElements() || logicalLine < 0 || logicalLine > 0 && logicalLine >= document2.getLineCount()) {
            List<Inlay<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(37);
            }
            return list2;
        }
        ArrayList result2 = new ArrayList();
        int startOffset = document2.getLineStartOffset(logicalLine);
        int endOffset = document2.getLineEndOffset(logicalLine);
        this.myAfterLineEndElementsTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            result2.add((Inlay<?>)inlay);
            return true;
        });
        result2.sort(AFTER_LINE_END_ELEMENTS_COMPARATOR);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    public boolean hasAfterLineEndElements() {
        return this.myAfterLineEndElementsTree.size() > 0;
    }

    public void setConsiderCaretPositionOnDocumentUpdates(boolean enabled2) {
        this.myConsiderCaretPositionOnDocumentUpdates = enabled2;
    }

    public void execute(boolean batchMode, @NotNull Runnable operation2) {
        if (operation2 == null) {
            InlayModelImpl.$$$reportNull$$$0(39);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myInBatchMode || !batchMode) {
            operation2.run();
        } else {
            try {
                this.notifyBatchModeStarting();
                this.myInBatchMode = true;
                operation2.run();
            }
            finally {
                this.myInBatchMode = false;
                this.notifyBatchModeFinished();
            }
        }
    }

    public boolean isInBatchMode() {
        return this.myInBatchMode;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            InlayModelImpl.$$$reportNull$$$0(40);
        }
        if (disposable == null) {
            InlayModelImpl.$$$reportNull$$$0(41);
        }
        EditorImpl.assertIsDispatchThread();
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    private void notifyAdded(InlayImpl<?, ?> inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded(inlay);
    }

    void notifyChanged(InlayImpl<?, ?> inlay, int changeFlags) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated(inlay, changeFlags);
    }

    void notifyRemoved(InlayImpl<?, ?> inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved(inlay);
    }

    private void notifyBatchModeStarting() {
        List listeners = this.myDispatcher.getListeners();
        for (int i2 = listeners.size() - 1; i2 >= 0; --i2) {
            ((InlayModel.Listener)listeners.get(i2)).onBatchModeStart((Editor)this.myEditor);
        }
    }

    private void notifyBatchModeFinished() {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onBatchModeFinish((Editor)this.myEditor);
    }

    @TestOnly
    public void validateState() {
        for (Inlay<?> inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair((Document)this.myEditor.getDocument(), (int)inlay.getOffset()));
        }
    }

    @NotNull
    public String dumpState() {
        String string = "Inline elements: " + InlayModelImpl.dumpInlays(this.myInlineElementsTree) + ", after-line-end elements: " + InlayModelImpl.dumpInlays(this.myAfterLineEndElementsTree) + ", block elements: " + InlayModelImpl.dumpInlays(this.myBlockElementsTree);
        if (string == null) {
            InlayModelImpl.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static String dumpInlays(RangeMarkerTree<? extends InlayImpl<?, ?>> tree2) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        tree2.processAll(o -> {
            joiner.add(Integer.toString(o.getOffset()));
            return true;
        });
        return joiner.toString();
    }

    public static boolean showWhenFolded(@NotNull Inlay<?> inlay) {
        if (inlay == null) {
            InlayModelImpl.$$$reportNull$$$0(43);
        }
        return inlay instanceof BlockInlayImpl && ((BlockInlayImpl)inlay).myShowWhenFolded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 16, 17, 19, 20, 22, 26, 27, 32, 33, 35, 36, 37, 38, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 18: 
            case 21: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addBlockElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addAfterLineEndElement";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineElementsInRange";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsInRange";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsForVisualLine";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterLineEndElementsInRange";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterLineEndElementsForLogicalLine";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInlineElement";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBlockElement";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAfterLineEndElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementsInRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBlockElementsInRange";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineElementAt";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementAt";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAfterLineEndElementsInRange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showWhenFolded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 16, 17, 19, 20, 22, 26, 27, 32, 33, 35, 36, 37, 38, 42 -> new IllegalStateException(string);
        };
    }

    private final class InlineElementsTree
    extends HardReferencingRangeMarkerTree<InlineInlayImpl<?>> {
        InlineElementsTree(Document document2) {
            if (document2 == null) {
                InlineElementsTree.$$$reportNull$$$0(0);
            }
            super(document2);
        }

        @NotNull
        protected RangeMarkerTree.RMNode<InlineInlayImpl<?>> createNewNode(@NotNull InlineInlayImpl<?> key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (key == null) {
                InlineElementsTree.$$$reportNull$$$0(1);
            }
            return new RangeMarkerTree.RMNode<InlineInlayImpl<?>>(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                protected void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<InlineInlayImpl<?>> otherNode) {
                    if (otherNode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.addIntervalsFrom(otherNode);
                    if (InlayModelImpl.this.myPutMergedIntervalsAtBeginning) {
                        List added = ContainerUtil.subList((List)this.intervals, (int)(this.intervals.size() - otherNode.intervals.size()));
                        ArrayList addedCopy = new ArrayList(added);
                        added.clear();
                        this.intervals.addAll(0, addedCopy);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherNode", "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree$1", "addIntervalsFrom"));
                }
            };
        }

        protected void fireBeforeRemoved(@NotNull InlineInlayImpl<?> inlay) {
            if (inlay == null) {
                InlineElementsTree.$$$reportNull$$$0(2);
            }
            if (inlay.getUserData(InlayKeys.OFFSET_BEFORE_DISPOSAL) == null) {
                if (InlayModelImpl.this.myMoveInProgress) {
                    InlayModelImpl.this.myInlaysInvalidatedOnMove.add(inlay);
                } else {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class BlockElementsTree
    extends MarkerTreeWithPartialSums<BlockInlayImpl<?>> {
        BlockElementsTree(Document document2) {
            if (document2 == null) {
                BlockElementsTree.$$$reportNull$$$0(0);
            }
            super(document2);
        }

        protected void fireBeforeRemoved(@NotNull BlockInlayImpl<?> inlay) {
            if (inlay == null) {
                BlockElementsTree.$$$reportNull$$$0(1);
            }
            if (inlay.getUserData(InlayKeys.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$BlockElementsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AfterLineEndElementTree
    extends HardReferencingRangeMarkerTree<AfterLineEndInlayImpl<?>> {
        AfterLineEndElementTree(Document document2) {
            if (document2 == null) {
                AfterLineEndElementTree.$$$reportNull$$$0(0);
            }
            super(document2);
        }

        protected void fireBeforeRemoved(@NotNull AfterLineEndInlayImpl<?> inlay) {
            if (inlay == null) {
                AfterLineEndElementTree.$$$reportNull$$$0(1);
            }
            if (inlay.getUserData(InlayKeys.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$AfterLineEndElementTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

