/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.CaretData;
import com.intellij.openapi.editor.impl.view.GuardedBlocksIndex;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.CommonProcessors;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IterationState {
    private static final Logger LOG = Logger.getInstance(IterationState.class);
    private static final Comparator<RangeHighlighterEx> BY_AFFECTED_END_OFFSET_REVERSED = (r1, r2) -> r2.getAffectedAreaEndOffset() - r1.getAffectedAreaEndOffset();
    private final int myInitialStartOffset;
    private final int myEnd;
    private final EditorColorsScheme myColorsScheme;
    private final int myDefaultFontType;
    @Nullable
    private final HighlighterIterator myHighlighterIterator;
    private final HighlighterSweep myEditorHighlighters;
    private final HighlighterSweep myDocumentHighlighters;
    private final FoldingModelEx myFoldingModel;
    private final SoftWrapModel mySoftWrapModel;
    private final TextAttributes myFoldTextAttributes;
    private final TextAttributes mySelectionAttributes;
    private final TextAttributes myCaretRowAttributes;
    private final TextAttributes myMergedAttributes;
    private final Color myDefaultBackground;
    private final Color myDefaultForeground;
    private final Color myReadOnlyColor;
    private final DocumentEx myDocument;
    private final CaretData myCaretData;
    private final boolean myUseOnlyFullLineHighlighters;
    private final boolean myUseOnlyFontOrForegroundAffectingHighlighters;
    private final boolean myStickyLinesPainting;
    private final boolean myEditorRightAligned;
    private final boolean myReverseIteration;
    private final List<RangeHighlighterEx> myCurrentHighlighters;
    private final List<TextAttributes> myCachedAttributesList;
    private final GuardedBlocksIndex myGuardedBlocks;
    private int myStartOffset;
    private int myEndOffset;
    private int myCurrentSelectionIndex;
    private Color myCurrentBackgroundColor;
    private Color myLastBackgroundColor;
    private FoldRegion myCurrentFold;
    private boolean myNextIsFoldRegion;
    private boolean myIsInSelection;

    @Contract(pure=true)
    @NotNull
    public static Comparator<RangeHighlighterEx> createByLayerThenByAttributesComparator(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            IterationState.$$$reportNull$$$0(0);
        }
        Comparator comparator = (o1, o2) -> {
            TextAttributes a2;
            int result2 = LayerComparator.HIGHER_FIRST.compare((RangeHighlighterEx)o1, (RangeHighlighterEx)o2);
            if (result2 != 0) {
                return result2;
            }
            TextAttributes a1 = o1.getTextAttributes(scheme);
            if (a1 == null ^ (a2 = o2.getTextAttributes(scheme)) == null) {
                return a1 == null ? 1 : -1;
            }
            if (a1 != null) {
                Color back2;
                Color fore2;
                Color fore1 = a1.getForegroundColor();
                if (fore1 == null ^ (fore2 = a2.getForegroundColor()) == null) {
                    return fore1 == null ? 1 : -1;
                }
                Color back1 = a1.getBackgroundColor();
                if (back1 == null ^ (back2 = a2.getBackgroundColor()) == null) {
                    return back1 == null ? 1 : -1;
                }
            }
            return IterationState.compareByHighlightInfoSeverity(o1, o2);
        };
        if (comparator == null) {
            IterationState.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    @ApiStatus.Internal
    public IterationState(@NotNull EditorEx editor2, int start2, int end, @Nullable CaretData caretData, boolean useOnlyFullLineHighlighters, boolean useOnlyFontOrForegroundAffectingHighlighters, boolean useFoldRegions, boolean iterateBackwards) {
        EditorImpl impl;
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(2);
        }
        this.myMergedAttributes = new TextAttributes();
        this.myCurrentHighlighters = new ArrayList<RangeHighlighterEx>();
        this.myCachedAttributesList = new ArrayList<TextAttributes>(5);
        this.myIsInSelection = false;
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.assertReadAccess();
        }
        LOG.assertTrue(iterateBackwards ? start2 >= end : start2 <= end);
        this.myDocument = IterationState.getDocument(editor2);
        assert (!DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)start2));
        assert (!DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)end));
        this.myColorsScheme = editor2.getColorsScheme();
        this.myInitialStartOffset = start2;
        this.myStartOffset = start2;
        this.myEnd = end;
        this.myUseOnlyFullLineHighlighters = useOnlyFullLineHighlighters;
        this.myUseOnlyFontOrForegroundAffectingHighlighters = useOnlyFontOrForegroundAffectingHighlighters;
        this.myStickyLinesPainting = editor2 instanceof EditorImpl && (impl = (EditorImpl)editor2).isStickyLinePainting();
        this.myEditorRightAligned = editor2 instanceof EditorImpl && (impl = (EditorImpl)editor2).isRightAligned();
        this.myReverseIteration = iterateBackwards;
        this.myHighlighterIterator = useOnlyFullLineHighlighters ? null : IterationState.getHighlighter(editor2).createIterator(start2);
        this.myCaretData = (CaretData)ObjectUtils.notNull((Object)caretData, (Object)CaretData.getNullCaret());
        this.myFoldingModel = !useFoldRegions ? null : IterationState.getFoldingModel(editor2);
        this.mySoftWrapModel = IterationState.getSoftWrapModel(editor2);
        this.myFoldTextAttributes = useFoldRegions ? this.myFoldingModel.getPlaceholderAttributes() : null;
        this.mySelectionAttributes = IterationState.getSelectionModel(editor2).getTextAttributes();
        this.myReadOnlyColor = this.myColorsScheme.getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        this.myCaretRowAttributes = editor2.isRendererMode() ? null : IterationState.getCaretModel(editor2).getTextAttributes();
        this.myDefaultBackground = this.myColorsScheme.getDefaultBackground();
        this.myDefaultForeground = this.myColorsScheme.getDefaultForeground();
        TextAttributes defaultAttributes = this.myColorsScheme.getAttributes(HighlighterColors.TEXT);
        this.myDefaultFontType = defaultAttributes == null ? 0 : defaultAttributes.getFontType();
        this.myEditorHighlighters = this.createSweep(IterationState.getEditorMarkupModel(editor2));
        this.myDocumentHighlighters = this.createSweep(IterationState.getDocumentMarkupModel(editor2));
        this.myGuardedBlocks = this.buildGuardedBlocks(start2, end);
        this.myEndOffset = this.myStartOffset;
        this.advance();
    }

    @ApiStatus.Internal
    public void retreat(int offset) {
        assert (!this.myReverseIteration && this.myCaretData == CaretData.getNullCaret() && offset >= this.myInitialStartOffset && offset <= this.myStartOffset && !DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)offset));
        if (offset == this.myStartOffset) {
            return;
        }
        if (this.myHighlighterIterator != null) {
            while (this.myHighlighterIterator.getStart() > offset) {
                this.myHighlighterIterator.retreat();
            }
        }
        this.myCurrentHighlighters.clear();
        this.myDocumentHighlighters.retreat(offset);
        this.myEditorHighlighters.retreat(offset);
        this.myEndOffset = offset;
        this.advance();
    }

    @ApiStatus.Internal
    public void advance() {
        this.myNextIsFoldRegion = false;
        this.myStartOffset = this.myEndOffset;
        this.advanceSegmentHighlighters();
        this.advanceCurrentSelectionIndex();
        if (!this.myUseOnlyFullLineHighlighters) {
            FoldRegion foldRegion = this.myFoldingModel == null ? null : (this.myCurrentFold = this.myFoldingModel.getCollapsedRegionAtOffset(this.myReverseIteration ? this.myStartOffset - 1 : this.myStartOffset));
        }
        if (this.myCurrentFold != null) {
            int n = this.myEndOffset = this.myReverseIteration ? this.myCurrentFold.getStartOffset() : this.myCurrentFold.getEndOffset();
            assert (!DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)this.myEndOffset));
        } else {
            int highlighterEnd = this.getHighlighterEnd(this.myStartOffset);
            int selectionEnd = this.getSelectionEnd();
            int minSegmentHighlightersEnd = this.getMinSegmentHighlightersEnd();
            int foldRangesEnd = this.getFoldRangesEnd(this.myStartOffset);
            int caretEnd = this.getCaretEnd(this.myStartOffset);
            int guardedBlockEnd = this.getGuardedBlockEnd(this.myStartOffset);
            this.myEndOffset = highlighterEnd;
            this.setEndOffsetIfCloser(selectionEnd);
            this.setEndOffsetIfCloser(minSegmentHighlightersEnd);
            this.setEndOffsetIfCloser(foldRangesEnd);
            this.setEndOffsetIfCloser(caretEnd);
            this.setEndOffsetIfCloser(guardedBlockEnd);
            boolean bl = this.myNextIsFoldRegion = this.myEndOffset == foldRangesEnd && this.myEndOffset < this.myEnd;
            assert (!DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)this.myEndOffset)) : "caret: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)caretEnd) + ", selection: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)selectionEnd) + ", guarded block: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)guardedBlockEnd) + ", folding: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)foldRangesEnd) + ", lexer: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)highlighterEnd) + ", highlighters: " + DocumentUtil.isInsideSurrogatePair((Document)this.myDocument, (int)minSegmentHighlightersEnd);
        }
        this.reinit();
    }

    @ApiStatus.Internal
    @NotNull
    public TextAttributes getBreakAttributes() {
        TextAttributes textAttributes = this.getBreakAttributes(false);
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(3);
        }
        return textAttributes;
    }

    @ApiStatus.Internal
    @NotNull
    public TextAttributes getBreakAttributes(boolean beforeBreak) {
        TextAttributes attributes = new TextAttributes();
        this.setAttributes(attributes, true, beforeBreak);
        TextAttributes textAttributes = attributes;
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(4);
        }
        return textAttributes;
    }

    @ApiStatus.Internal
    @NotNull
    public TextAttributes getMergedAttributes() {
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(5);
        }
        return textAttributes;
    }

    @ApiStatus.Internal
    public boolean atEnd() {
        return this.myReverseIteration ? this.myStartOffset <= this.myEnd : this.myStartOffset >= this.myEnd;
    }

    @ApiStatus.Internal
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @ApiStatus.Internal
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @ApiStatus.Internal
    public FoldRegion getCurrentFold() {
        return this.myCurrentFold;
    }

    @ApiStatus.Internal
    public boolean nextIsFoldRegion() {
        return this.myNextIsFoldRegion;
    }

    @ApiStatus.Internal
    @NotNull
    public TextAttributes getPastLineEndBackgroundAttributes() {
        this.myMergedAttributes.setBackgroundColor(this.hasSoftWrap() ? this.getBreakBackgroundColor(true) : (this.myEditorRightAligned && this.myLastBackgroundColor != null ? this.myLastBackgroundColor : this.myCurrentBackgroundColor));
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            IterationState.$$$reportNull$$$0(6);
        }
        return textAttributes;
    }

    @ApiStatus.Internal
    public boolean isInSelection() {
        return this.myIsInSelection;
    }

    @ApiStatus.Internal
    @NotNull
    public TextAttributes getBeforeLineStartBackgroundAttributes() {
        return this.myEditorRightAligned && !this.hasSoftWrap() ? this.getBreakAttributes() : new TextAttributes(null, this.getBreakBackgroundColor(false), null, null, 0);
    }

    @NotNull
    private HighlighterSweep createSweep(MarkupModelEx markupModel) {
        return new HighlighterSweep(this.myColorsScheme, markupModel, this.myStartOffset, this.myEnd, this.myUseOnlyFullLineHighlighters, this.myUseOnlyFontOrForegroundAffectingHighlighters);
    }

    private void setEndOffsetIfCloser(int offset) {
        if (this.myReverseIteration ? offset > this.myEndOffset : offset < this.myEndOffset) {
            this.myEndOffset = offset;
        }
    }

    private int getHighlighterEnd(int start2) {
        if (this.myHighlighterIterator == null) {
            return this.myEnd;
        }
        while (!this.myHighlighterIterator.atEnd()) {
            int end = this.alignOffset(this.myReverseIteration ? this.myHighlighterIterator.getStart() : this.myHighlighterIterator.getEnd());
            if (this.myReverseIteration ? end < start2 : end > start2) {
                return end;
            }
            if (this.myReverseIteration) {
                this.myHighlighterIterator.retreat();
                continue;
            }
            this.myHighlighterIterator.advance();
        }
        return this.myEnd;
    }

    private int getCaretEnd(int start2) {
        return this.getNearestValueAhead(start2, this.myCaretData.caretRowStart(), this.myCaretData.caretRowEnd());
    }

    private int getNearestValueAhead(int offset, int rangeStart, int rangeEnd) {
        if (this.myReverseIteration) {
            if (rangeEnd < offset) {
                return rangeEnd;
            }
            if (rangeStart < offset) {
                return rangeStart;
            }
        } else {
            if (rangeStart > offset) {
                return rangeStart;
            }
            if (rangeEnd > offset) {
                return rangeEnd;
            }
        }
        return this.myEnd;
    }

    private int getGuardedBlockEnd(int start2) {
        int end = this.myEnd;
        assert (this.myReverseIteration && start2 >= end || !this.myReverseIteration && start2 <= end);
        if (this.myUseOnlyFullLineHighlighters) {
            return end;
        }
        if (this.myReverseIteration) {
            int nearest = this.myGuardedBlocks.nearestLeft(start2 - 1);
            return nearest != -1 && nearest > end ? nearest : end;
        }
        int nearest = this.myGuardedBlocks.nearestRight(start2 + 1);
        return nearest != -1 && nearest < end ? nearest : end;
    }

    private void advanceCurrentSelectionIndex() {
        while (this.myCurrentSelectionIndex < this.myCaretData.selectionsSize() && (this.myReverseIteration ? this.myStartOffset <= this.myCaretData.selectionStart(this.myCurrentSelectionIndex, true) : this.myStartOffset >= this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, false))) {
            ++this.myCurrentSelectionIndex;
        }
    }

    private int getSelectionEnd() {
        if (this.myCurrentSelectionIndex >= this.myCaretData.selectionsSize()) {
            return this.myEnd;
        }
        return this.getNearestValueAhead(this.myStartOffset, this.myCaretData.selectionStart(this.myCurrentSelectionIndex, this.myReverseIteration), this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, this.myReverseIteration));
    }

    private boolean isInSelection(boolean atBreak) {
        return this.myCurrentSelectionIndex < this.myCaretData.selectionsSize() && (this.myReverseIteration ? IterationState.lessThan(this.myStartOffset, this.myCaretData.selectionEnd(this.myCurrentSelectionIndex, true), !atBreak) : IterationState.lessThan(this.myCaretData.selectionStart(this.myCurrentSelectionIndex, false), this.myStartOffset, !atBreak));
    }

    private GuardedBlocksIndex buildGuardedBlocks(int start2, int end) {
        if (this.myUseOnlyFullLineHighlighters) {
            return null;
        }
        GuardedBlocksIndex.DocumentBuilder guardedBlocks = new GuardedBlocksIndex.DocumentBuilder(this.myDocument);
        return this.myReverseIteration ? guardedBlocks.build(end, start2) : guardedBlocks.build(start2, end);
    }

    private boolean isInDocumentGuardedBlock(boolean atBreak, boolean beforeBreak) {
        if (this.myUseOnlyFullLineHighlighters || atBreak && beforeBreak) {
            return false;
        }
        if (this.myReverseIteration) {
            return this.myGuardedBlocks.isGuarded(this.myStartOffset - 1);
        }
        return this.myGuardedBlocks.isGuarded(this.myStartOffset);
    }

    private static boolean lessThan(int x, int y, boolean orEquals) {
        return x < y || orEquals && x == y;
    }

    private void advanceSegmentHighlighters() {
        this.myDocumentHighlighters.advance();
        this.myEditorHighlighters.advance();
        boolean fileEnd = this.myStartOffset == this.myDocument.getTextLength();
        for (int i2 = this.myCurrentHighlighters.size() - 1; i2 >= 0; --i2) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i2);
            if (!(this.myReverseIteration ? this.getAlignedStartOffset(highlighter) >= this.myStartOffset : (fileEnd && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE ? this.getAlignedEndOffset(highlighter) < this.myStartOffset : this.getAlignedEndOffset(highlighter) <= this.myStartOffset))) continue;
            this.myCurrentHighlighters.remove(i2);
        }
    }

    private int getFoldRangesEnd(int startOffset) {
        int end;
        block7: {
            if (this.myUseOnlyFullLineHighlighters || this.myFoldingModel == null) {
                return this.myEnd;
            }
            end = this.myEnd;
            FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
            if (topLevelCollapsed == null) break block7;
            if (this.myReverseIteration) {
                for (int i2 = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset); i2 >= 0 && i2 < topLevelCollapsed.length; --i2) {
                    int rangeEnd;
                    FoldRegion range = topLevelCollapsed[i2];
                    if (!range.isValid() || (rangeEnd = range.getEndOffset()) >= startOffset) continue;
                    if (rangeEnd > end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            } else {
                for (int i3 = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset) + 1; i3 >= 0 && i3 < topLevelCollapsed.length; ++i3) {
                    int rangeEnd;
                    FoldRegion range = topLevelCollapsed[i3];
                    if (!range.isValid() || (rangeEnd = range.getStartOffset()) <= startOffset) continue;
                    if (rangeEnd < end) {
                        end = rangeEnd;
                        continue;
                    }
                    break;
                }
            }
        }
        return end;
    }

    private int getMinSegmentHighlightersEnd() {
        int end = this.myEnd;
        for (int i2 = 0; i2 < this.myCurrentHighlighters.size(); ++i2) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i2);
            end = this.myReverseIteration ? Math.max(end, this.getAlignedStartOffset(highlighter)) : Math.min(end, this.getAlignedEndOffset(highlighter));
        }
        end = this.myReverseIteration ? Math.max(end, this.myDocumentHighlighters.getMinSegmentHighlighterEnd()) : Math.min(end, this.myDocumentHighlighters.getMinSegmentHighlighterEnd());
        end = this.myReverseIteration ? Math.max(end, this.myEditorHighlighters.getMinSegmentHighlighterEnd()) : Math.min(end, this.myEditorHighlighters.getMinSegmentHighlighterEnd());
        return end;
    }

    private void reinit() {
        this.setAttributes(this.myMergedAttributes, false, false);
        this.myLastBackgroundColor = this.myCurrentBackgroundColor;
        this.myCurrentBackgroundColor = this.myMergedAttributes.getBackgroundColor();
    }

    private void setAttributes(TextAttributes attributes, boolean atBreak, boolean beforeBreak) {
        boolean isInSelection;
        this.myIsInSelection = isInSelection = this.isInSelection(atBreak);
        boolean isInCaretRow = this.isInCaretRow(!this.myReverseIteration && (!atBreak || !beforeBreak), this.myReverseIteration || atBreak && beforeBreak);
        boolean isInGuardedBlock = this.isInDocumentGuardedBlock(atBreak, beforeBreak);
        TextAttributes syntax = this.myHighlighterIterator == null || this.myHighlighterIterator.atEnd() ? null : (atBreak && this.myStartOffset == (this.myReverseIteration ? this.myHighlighterIterator.getEnd() : this.myHighlighterIterator.getStart()) ? null : this.myHighlighterIterator.getTextAttributes());
        TextAttributes selection = this.getSelectionAttributes(isInSelection);
        if (!Registry.is((String)"editor.disable.new.selection") && selection != null) {
            selection.setBackgroundColor(null);
        }
        TextAttributes caret = this.getCaretRowAttributes(isInCaretRow);
        TextAttributes fold = this.myCurrentFold != null ? this.myFoldTextAttributes : null;
        TextAttributes guard = isInGuardedBlock ? new TextAttributes(null, this.myReadOnlyColor, null, EffectType.BOXED, 0) : null;
        int size2 = this.myCurrentHighlighters.size();
        if (size2 > 1) {
            ContainerUtil.quickSort(this.myCurrentHighlighters, IterationState.createByLayerThenByAttributesComparator(this.myColorsScheme));
        }
        for (int i2 = 0; i2 < size2; ++i2) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i2);
            if (highlighter.getTextAttributes(this.myColorsScheme) != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        List<TextAttributes> cachedAttributes = this.myCachedAttributesList;
        if (!cachedAttributes.isEmpty()) {
            cachedAttributes.clear();
        }
        for (int i3 = 0; i3 < size2; ++i3) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i3);
            if (atBreak && highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE && this.myStartOffset == (this.myReverseIteration ? highlighter.getEndOffset() : highlighter.getStartOffset())) continue;
            if (highlighter.getLayer() < 6000 && selection != null) {
                cachedAttributes.add(selection);
                selection = null;
            }
            if (fold != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(fold);
                fold = null;
            }
            if (guard != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(guard);
                guard = null;
            }
            if (caret != null && highlighter.getLayer() < 2000) {
                cachedAttributes.add(caret);
                caret = null;
            }
            if (syntax != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if ((textAttributes = highlighter.getTextAttributes(this.myColorsScheme)) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (selection != null) {
            cachedAttributes.add(selection);
        }
        if (fold != null) {
            cachedAttributes.add(fold);
        }
        if (guard != null) {
            cachedAttributes.add(guard);
        }
        if (caret != null) {
            cachedAttributes.add(caret);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color fore = null;
        Color back = isInGuardedBlock ? this.myReadOnlyColor : null;
        int fontType = 0;
        TextAttributesEffectsBuilder effectsBuilder = null;
        for (int i4 = 0; i4 < cachedAttributes.size(); ++i4) {
            TextAttributes attrs = cachedAttributes.get(i4);
            if (fore == null) {
                fore = attrs.getForegroundColor();
            }
            if (back == null) {
                back = attrs.getBackgroundColor();
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (!attrs.hasEffects()) continue;
            if (effectsBuilder == null) {
                effectsBuilder = TextAttributesEffectsBuilder.create();
            }
            effectsBuilder.slipUnder(attrs);
        }
        if (fore == null) {
            fore = this.myDefaultForeground;
        }
        if (back == null) {
            back = this.myDefaultBackground;
        }
        if (fontType == 0) {
            fontType = this.myDefaultFontType;
        }
        attributes.setAttributesNoCache(fore, back, null, null, null, fontType);
        if (effectsBuilder != null) {
            effectsBuilder.applyTo(attributes);
        }
    }

    private boolean isInCaretRow(boolean includeLineStart, boolean includeLineEnd) {
        return this.myCaretData.caretRowStart() < this.myStartOffset && this.myStartOffset < this.myCaretData.caretRowEnd() || includeLineStart && this.myStartOffset == this.myCaretData.caretRowStart() || includeLineEnd && this.myStartOffset == this.myCaretData.caretRowEnd();
    }

    @Nullable
    private TextAttributes getSelectionAttributes(boolean isInSelection) {
        return isInSelection ? this.mySelectionAttributes : null;
    }

    @Nullable
    private TextAttributes getCaretRowAttributes(boolean isInCaretRow) {
        if (this.myStickyLinesPainting) {
            return null;
        }
        return isInCaretRow ? this.myCaretRowAttributes : null;
    }

    private Color getBreakBackgroundColor(boolean lineEnd) {
        return this.getBreakAttributes(lineEnd).getBackgroundColor();
    }

    private boolean hasSoftWrap() {
        return this.mySoftWrapModel.getSoftWrap(this.myStartOffset) != null;
    }

    private int alignOffset(int offset) {
        return DocumentUtil.alignToCodePointBoundary((Document)this.myDocument, (int)offset);
    }

    private int getAlignedStartOffset(RangeHighlighterEx highlighter) {
        return this.alignOffset(highlighter.getAffectedAreaStartOffset());
    }

    private int getAlignedEndOffset(RangeHighlighterEx highlighter) {
        return this.alignOffset(highlighter.getAffectedAreaEndOffset());
    }

    private static DocumentEx getDocument(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(7);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getDocument();
        }
        return editor2.getDocument();
    }

    private static FoldingModelEx getFoldingModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(8);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getFoldingModel();
        }
        return editor2.getFoldingModel();
    }

    private static MarkupModelEx getEditorMarkupModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(9);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getEditorMarkupModel();
        }
        return editor2.getMarkupModel();
    }

    private static MarkupModelEx getDocumentMarkupModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(10);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getDocumentMarkupModel();
        }
        return editor2.getFilteredDocumentMarkupModel();
    }

    private static CaretModel getCaretModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(11);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getCaretModel();
        }
        return editor2.getCaretModel();
    }

    private static EditorHighlighter getHighlighter(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(12);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getHighlighter();
        }
        return editor2.getHighlighter();
    }

    private static SoftWrapModel getSoftWrapModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(13);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getSoftWrapModel();
        }
        return editor2.getSoftWrapModel();
    }

    private static SelectionModel getSelectionModel(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            IterationState.$$$reportNull$$$0(14);
        }
        if (editor2 instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor2;
            return editorImpl.getEditorModel().getSelectionModel();
        }
        return editor2.getSelectionModel();
    }

    private static int compareByHighlightInfoSeverity(@NotNull RangeHighlighterEx o1, @NotNull RangeHighlighterEx o2) {
        HighlightSeverity severity2;
        if (o1 == null) {
            IterationState.$$$reportNull$$$0(15);
        }
        if (o2 == null) {
            IterationState.$$$reportNull$$$0(16);
        }
        HighlightInfo info1 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)o1);
        HighlightInfo info2 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)o2);
        HighlightSeverity severity1 = info1 == null ? null : info1.getSeverity();
        HighlightSeverity highlightSeverity = severity2 = info2 == null ? null : info2.getSeverity();
        if (severity1 != null && severity2 != null) {
            return severity2.compareTo(severity1);
        }
        return Boolean.compare(severity1 == null, severity2 == null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/IterationState";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/IterationState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createByLayerThenByAttributesComparator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastLineEndBackgroundAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createByLayerThenByAttributesComparator";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditorMarkupModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentMarkupModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCaretModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSoftWrapModel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareByHighlightInfoSeverity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private final class HighlighterSweep {
        private final MarkupModelEx myMarkupModel;
        private final EditorColorsScheme myColorsScheme;
        private final boolean myOnlyFullLine;
        private final boolean myOnlyFontOrForegroundAffecting;
        private RangeHighlighterEx myNextHighlighter;
        int i;
        private final RangeHighlighterEx[] highlighters;

        private HighlighterSweep(@NotNull EditorColorsScheme scheme, MarkupModelEx markupModel, int start2, int end, boolean onlyFullLine, boolean onlyFontOrForegroundAffecting) {
            if (scheme == null) {
                HighlighterSweep.$$$reportNull$$$0(0);
            }
            if (markupModel == null) {
                HighlighterSweep.$$$reportNull$$$0(1);
            }
            this.myColorsScheme = scheme;
            this.myMarkupModel = markupModel;
            this.myOnlyFullLine = onlyFullLine;
            this.myOnlyFontOrForegroundAffecting = onlyFontOrForegroundAffecting;
            this.highlighters = this.collectHighlighters(IterationState.this.myReverseIteration ? end : start2, IterationState.this.myReverseIteration ? start2 : end, IterationState.this.myReverseIteration ? BY_AFFECTED_END_OFFSET_REVERSED : RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
            this.myNextHighlighter = this.firstAdvance();
        }

        private RangeHighlighterEx[] collectHighlighters(int start2, int end, Comparator<RangeHighlighterEx> comparator) {
            CommonProcessors.CollectProcessor<RangeHighlighterEx> processor2 = new CommonProcessors.CollectProcessor<RangeHighlighterEx>(){

                public boolean accept(RangeHighlighterEx h) {
                    return HighlighterSweep.this.acceptHighlighter(h);
                }
            };
            this.myMarkupModel.processRangeHighlightersOverlappingWith(start2, end, (Processor)processor2);
            RangeHighlighterEx[] highlights = processor2.getResults().isEmpty() ? RangeHighlighterEx.EMPTY_ARRAY : (RangeHighlighterEx[])processor2.toArray((Object[])RangeHighlighterEx.EMPTY_ARRAY);
            Arrays.sort(highlights, comparator);
            return highlights;
        }

        private RangeHighlighterEx firstAdvance() {
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                return highlighter;
            }
            return null;
        }

        private void advance() {
            if (this.myNextHighlighter != null) {
                if (IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(this.myNextHighlighter) < IterationState.this.myStartOffset : IterationState.this.getAlignedStartOffset(this.myNextHighlighter) > IterationState.this.myStartOffset) {
                    return;
                }
                IterationState.this.myCurrentHighlighters.add(this.myNextHighlighter);
                this.myNextHighlighter = null;
            }
            while (this.i < this.highlighters.length) {
                RangeHighlighterEx highlighter;
                if (this.skipHighlighter(highlighter = this.highlighters[this.i++])) continue;
                if (IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(highlighter) < IterationState.this.myStartOffset : IterationState.this.getAlignedStartOffset(highlighter) > IterationState.this.myStartOffset) {
                    this.myNextHighlighter = highlighter;
                    break;
                }
                IterationState.this.myCurrentHighlighters.add(highlighter);
            }
        }

        private void retreat(int offset) {
            for (int j = this.i - 2; j >= 0; --j) {
                RangeHighlighterEx highlighter = this.highlighters[j];
                if (this.skipHighlighter(highlighter)) continue;
                if (IterationState.this.getAlignedStartOffset(highlighter) <= offset) break;
                this.myNextHighlighter = highlighter;
                this.i = j + 1;
            }
            this.myMarkupModel.processRangeHighlightersOverlappingWith(offset, offset, h -> {
                if (this.acceptHighlighter((RangeHighlighterEx)h) && !this.skipHighlighter((RangeHighlighterEx)h)) {
                    IterationState.this.myCurrentHighlighters.add((RangeHighlighterEx)h);
                }
                return true;
            });
        }

        private boolean acceptHighlighter(RangeHighlighterEx highlighter) {
            return !(this.myOnlyFullLine && highlighter.getTargetArea() != HighlighterTargetArea.LINES_IN_RANGE || this.myOnlyFontOrForegroundAffecting && !EditorUtil.attributesImpactFontStyleOrColor(highlighter.getTextAttributes(this.myColorsScheme)));
        }

        private boolean skipHighlighter(@NotNull RangeHighlighterEx highlighter) {
            if (highlighter == null) {
                HighlighterSweep.$$$reportNull$$$0(2);
            }
            if (!highlighter.isValid() || highlighter.isAfterEndOfLine() || highlighter.getTextAttributes(this.myColorsScheme) == null) {
                return true;
            }
            FoldRegion region = IterationState.this.myFoldingModel == null ? null : IterationState.this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaStartOffset());
            return region != null && region == IterationState.this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaEndOffset());
        }

        private int getMinSegmentHighlighterEnd() {
            if (this.myNextHighlighter != null) {
                return IterationState.this.myReverseIteration ? IterationState.this.getAlignedEndOffset(this.myNextHighlighter) : IterationState.this.getAlignedStartOffset(this.myNextHighlighter);
            }
            return IterationState.this.myReverseIteration ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markupModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/view/IterationState$HighlighterSweep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "skipHighlighter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LayerComparator
    implements Comparator<RangeHighlighterEx> {
        private static final LayerComparator HIGHER_FIRST = new LayerComparator();

        private LayerComparator() {
        }

        @Override
        public int compare(RangeHighlighterEx o1, RangeHighlighterEx o2) {
            int layerDiff = o2.getLayer() - o1.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            int o1Length = o1.getAffectedAreaEndOffset() - o1.getAffectedAreaStartOffset();
            int o2Length = o2.getAffectedAreaEndOffset() - o2.getAffectedAreaStartOffset();
            return o1Length - o2Length;
        }
    }
}

