/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.EditorView;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

interface XCorrector {
    public float startX(int var1);

    public int lineWidth(int var1, float var2);

    public int emptyTextX();

    public int minX(int var1, int var2);

    public int maxX(int var1, int var2);

    public int lineSeparatorStart(int var1);

    public int lineSeparatorEnd(int var1);

    public float singleLineBorderStart(float var1);

    public float singleLineBorderEnd(float var1);

    public int marginX(float var1);

    public List<Integer> softMarginsX();

    @NotNull
    public static XCorrector create(@NotNull EditorView view2, @NotNull Insets insets) {
        if (view2 == null) {
            XCorrector.$$$reportNull$$$0(0);
        }
        if (insets == null) {
            XCorrector.$$$reportNull$$$0(1);
        }
        return view2.getEditor().isRightAligned() ? new RightAligned(view2) : new LeftAligned(view2, insets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "view";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "insets";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/XCorrector";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class RightAligned
    implements XCorrector {
        private final EditorView myView;

        private RightAligned(@NotNull EditorView view2) {
            if (view2 == null) {
                RightAligned.$$$reportNull$$$0(0);
            }
            this.myView = view2;
        }

        @Override
        public float startX(int line) {
            return this.myView.getRightAlignmentLineStartX(line);
        }

        @Override
        public int lineWidth(int line, float x) {
            return (int)(x - this.myView.getRightAlignmentLineStartX(line));
        }

        @Override
        public int emptyTextX() {
            return this.myView.getRightAlignmentMarginX();
        }

        @Override
        public int minX(int startLine, int endLine) {
            return this.myView.getRightAlignmentMarginX() - this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
        }

        @Override
        public int maxX(int startLine, int endLine) {
            return this.myView.getRightAlignmentMarginX() - 1;
        }

        @Override
        public float singleLineBorderStart(float x) {
            return x - 1.0f;
        }

        @Override
        public float singleLineBorderEnd(float x) {
            return x;
        }

        @Override
        public int lineSeparatorStart(int minX) {
            return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.max(this.marginX(EditorPainter.getBaseMarginWidth(this.myView)), minX) : minX;
        }

        @Override
        public int lineSeparatorEnd(int maxX) {
            return maxX;
        }

        @Override
        public int marginX(float marginWidth) {
            return (int)((float)this.myView.getRightAlignmentMarginX() - marginWidth);
        }

        @Override
        public List<Integer> softMarginsX() {
            List margins = this.myView.getEditor().getSettings().getSoftMargins();
            ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
            for (Integer margin : margins) {
                result2.add((int)((float)this.myView.getRightAlignmentMarginX() - (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/XCorrector$RightAligned", "<init>"));
        }
    }

    public static final class LeftAligned
    implements XCorrector {
        private final EditorView myView;
        private final int myLeftInset;

        private LeftAligned(@NotNull EditorView view2, @NotNull Insets insets) {
            if (view2 == null) {
                LeftAligned.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                LeftAligned.$$$reportNull$$$0(1);
            }
            this.myView = view2;
            this.myLeftInset = insets.left;
        }

        @Override
        public float startX(int line) {
            return this.myLeftInset;
        }

        @Override
        public int emptyTextX() {
            return this.myLeftInset;
        }

        @Override
        public int minX(int startLine, int endLine) {
            return this.myLeftInset;
        }

        @Override
        public int maxX(int startLine, int endLine) {
            return this.minX(startLine, endLine) + this.myView.getMaxTextWidthInLineRange(startLine, endLine - 1) - 1;
        }

        @Override
        public float singleLineBorderStart(float x) {
            return x;
        }

        @Override
        public float singleLineBorderEnd(float x) {
            return x + 1.0f;
        }

        @Override
        public int lineWidth(int line, float x) {
            return (int)x - this.myLeftInset;
        }

        @Override
        public int lineSeparatorStart(int maxX) {
            return this.myLeftInset;
        }

        @Override
        public int lineSeparatorEnd(int maxX) {
            return EditorPainter.isMarginShown(this.myView.getEditor()) ? Math.min(this.marginX(EditorPainter.getBaseMarginWidth(this.myView)), maxX) : maxX;
        }

        @Override
        public int marginX(float marginWidth) {
            return (int)((float)this.myLeftInset + marginWidth);
        }

        @Override
        public List<Integer> softMarginsX() {
            List margins = this.myView.getEditor().getSettings().getSoftMargins();
            ArrayList<Integer> result2 = new ArrayList<Integer>(margins.size());
            for (Integer margin : margins) {
                result2.add((int)((float)this.myLeftInset + (float)margin.intValue() * this.myView.getPlainSpaceWidth()));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/view/XCorrector$LeftAligned";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

