/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(FileTreeStructure.class);
    private final RootFileElement myRootElement;
    private final FileChooserDescriptor myChooserDescriptor;
    private boolean myShowHidden;
    private final Project myProject;

    public FileTreeStructure(Project project2, FileChooserDescriptor chooserDescriptor) {
        this.myProject = project2;
        List rootFiles = chooserDescriptor.getRoots();
        String name2 = rootFiles.size() == 1 && rootFiles.get(0) != null ? ((VirtualFile)rootFiles.get(0)).getPresentableUrl() : chooserDescriptor.getTitle();
        this.myRootElement = new RootFileElement(rootFiles, name2, chooserDescriptor.isShowFileSystemRoots());
        this.myChooserDescriptor = chooserDescriptor;
        this.myShowHidden = this.myChooserDescriptor.isShowHiddenFiles();
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            FileTreeStructure.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean areHiddenShown() {
        return this.myShowHidden;
    }

    public void showHidden(boolean showHidden) {
        this.myShowHidden = showHidden;
    }

    @NotNull
    public Object getRootElement() {
        RootFileElement rootFileElement = this.myRootElement;
        if (rootFileElement == null) {
            FileTreeStructure.$$$reportNull$$$0(1);
        }
        return rootFileElement;
    }

    public Object @NotNull [] getChildElements(@NotNull Object nodeElement) {
        if (nodeElement == null) {
            FileTreeStructure.$$$reportNull$$$0(2);
        }
        if (!(nodeElement instanceof FileElement)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileTreeStructure.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        FileElement element = (FileElement)nodeElement;
        VirtualFile file2 = element.getFile();
        if (file2 == null || !file2.isValid()) {
            if (element == this.myRootElement) {
                Object[] objectArray = this.myRootElement.getChildren();
                if (objectArray == null) {
                    FileTreeStructure.$$$reportNull$$$0(4);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileTreeStructure.$$$reportNull$$$0(5);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        VirtualFile[] children2 = null;
        if (element.isArchive() && this.myChooserDescriptor.isChooseJarContents()) {
            String path = file2.getPath();
            if (!(file2.getFileSystem() instanceof JarFileSystem)) {
                file2 = JarFileSystem.getInstance().findFileByPath(path + "!/");
            }
            if (file2 != null) {
                children2 = file2.getChildren();
            }
        } else {
            children2 = file2.getChildren();
        }
        if (children2 == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileTreeStructure.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        HashSet<FileElement> childrenSet = new HashSet<FileElement>();
        for (VirtualFile child : children2) {
            if (!this.myChooserDescriptor.isFileVisible(child, this.myShowHidden)) continue;
            FileElement childElement = new FileElement(child, child.getName());
            childElement.setParent(element);
            childrenSet.add(childElement);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(childrenSet);
        if (objectArray == null) {
            FileTreeStructure.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Nullable
    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            FileTreeStructure.$$$reportNull$$$0(8);
        }
        if (element instanceof FileElement) {
            VirtualFile parentFile;
            FileElement fileElement = (FileElement)element;
            VirtualFile elementFile = FileTreeStructure.getValidFile(fileElement);
            VirtualFile rootElementFile = this.myRootElement.getFile();
            if (rootElementFile != null && rootElementFile.equals(elementFile)) {
                return null;
            }
            VirtualFile parentElementFile = FileTreeStructure.getValidFile(fileElement.getParent());
            if (elementFile != null && parentElementFile != null && parentElementFile.equals(parentFile = elementFile.getParent())) {
                return fileElement.getParent();
            }
            VirtualFile file2 = fileElement.getFile();
            if (file2 == null) {
                return null;
            }
            VirtualFile parent = file2.getParent();
            if (parent != null && parent.getFileSystem() instanceof JarFileSystem && parent.getParent() == null) {
                String localPath = parent.getPath().substring(0, parent.getPath().length() - "!/".length());
                parent = LocalFileSystem.getInstance().findFileByPath(localPath);
            }
            if (parent == null || parent.isValid() && parent.equals(rootElementFile)) {
                return this.myRootElement;
            }
            return new FileElement(parent, parent.getName());
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidFile(FileElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file2 = element.getFile();
        return file2 != null && file2.isValid() ? file2 : null;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            FileTreeStructure.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(element instanceof FileElement, (Object)element.getClass().getName());
        VirtualFile file2 = ((FileElement)element).getFile();
        Icon closedIcon = file2 == null ? null : this.myChooserDescriptor.getIcon(file2);
        String name2 = file2 == null ? null : this.myChooserDescriptor.getName(file2);
        String comment2 = file2 == null ? null : this.myChooserDescriptor.getComment(file2);
        return new FileNodeDescriptor(this.myProject, (FileElement)element, parentDescriptor, closedIcon, name2, comment2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileTreeStructure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

