/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.MaximizeEditorInSplitAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowKt;
import com.intellij.openapi.fileEditor.impl.tabActions.CloseTab;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.concurrency.EdtScheduler;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001aD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0016H\u0000\u001a\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0000\u00a8\u0006\u001c"}, d2={"doProcessDoubleClick", "", "e", "Ljava/awt/event/MouseEvent;", "editorTabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "createKeepMousePositionRunnable", "Lkotlin/Function0;", "event", "createTabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "component", "Ljavax/swing/JComponent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "editorActionGroup", "Lcom/intellij/openapi/actionSystem/AnAction;", "customizer", "Lkotlin/Function1;", "isSingletonEditorInWindow", "", "editors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabbedContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabbedContainerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,763:1\n1807#2,3:764\n*S KotlinDebug\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabbedContainerKt\n*L\n762#1:764,3\n*E\n"})
public final class EditorTabbedContainerKt {
    private static final void doProcessDoubleClick(MouseEvent e, JBTabsImpl editorTabs, EditorWindow window) {
        block7: {
            Function0<Unit> runnable2;
            AnAction hideAllToolWindows;
            AnActionEvent event;
            AnAction maximizeEditorInSplit;
            TabInfo tabInfo = editorTabs.findInfo(e);
            if (tabInfo != null) {
                TabInfo info = tabInfo;
                boolean bl = false;
                EditorComposite composite2 = EditorWindowKt.getComposite(info);
                if (composite2.isPreview()) {
                    composite2.setPreview(false);
                    window.getOwner().scheduleUpdateFileColor$intellij_platform_ide_impl(composite2.getFile());
                    return;
                }
            }
            if (!AdvancedSettings.Companion.getBoolean("editor.maximize.on.double.click") && !AdvancedSettings.Companion.getBoolean("editor.maximize.in.splits.on.double.click")) {
                return;
            }
            ActionManager actionManager = ActionManager.getInstance();
            DataContext dataContext2 = DataManager.getInstance().getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            DataContext context2 = dataContext2;
            Boolean isEditorMaximized = null;
            Boolean areAllToolWindowsHidden = null;
            if (AdvancedSettings.Companion.getBoolean("editor.maximize.in.splits.on.double.click") && (maximizeEditorInSplit = actionManager.getAction("MaximizeEditorInSplit")) != null) {
                event = new AnActionEvent((InputEvent)e, context2, "EditorTab", new Presentation(), actionManager, e.getModifiersEx());
                maximizeEditorInSplit.update(event);
                isEditorMaximized = (Boolean)event.getPresentation().getClientProperty(MaximizeEditorInSplitAction.Companion.getCURRENT_STATE_IS_MAXIMIZED_KEY());
            }
            if (AdvancedSettings.Companion.getBoolean("editor.maximize.on.double.click") && (hideAllToolWindows = actionManager.getAction("HideAllWindows")) != null) {
                event = new AnActionEvent((InputEvent)e, context2, "EditorTab", new Presentation(), actionManager, e.getModifiersEx());
                hideAllToolWindows.update(event);
                areAllToolWindowsHidden = (Boolean)event.getPresentation().getClientProperty(MaximizeEditorInSplitAction.Companion.getCURRENT_STATE_IS_MAXIMIZED_KEY());
            }
            Function0<Unit> function0 = runnable2 = Registry.Companion.is("editor.position.mouse.cursor.on.doubleclicked.tab") ? EditorTabbedContainerKt.createKeepMousePositionRunnable(e) : null;
            if (areAllToolWindowsHidden != null && (isEditorMaximized == null || isEditorMaximized.booleanValue() == areAllToolWindowsHidden.booleanValue())) {
                actionManager.tryToExecute(actionManager.getAction("HideAllWindows"), (InputEvent)e, null, "EditorTab", true);
            }
            if (isEditorMaximized != null) {
                actionManager.tryToExecute(actionManager.getAction("MaximizeEditorInSplit"), (InputEvent)e, null, "EditorTab", true);
            }
            Function0<Unit> function02 = runnable2;
            if (function02 == null) break block7;
            function02.invoke();
        }
    }

    private static final Function0<Unit> createKeepMousePositionRunnable(MouseEvent event) {
        return () -> EditorTabbedContainerKt.createKeepMousePositionRunnable$lambda$0(event);
    }

    @NotNull
    public static final TabInfo createTabInfo(@NotNull JComponent component2, @NotNull VirtualFile file2, @NotNull Disposable parentDisposable, @NotNull EditorWindow window, @NotNull AnAction editorActionGroup, @NotNull Function1<? super TabInfo, Unit> customizer) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)editorActionGroup, (String)"editorActionGroup");
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        TabInfo tab = new TabInfo(component2).setObject((Object)file2);
        customizer.invoke((Object)tab);
        tab.setTestableUi(arg_0 -> EditorTabbedContainerKt.createTabInfo$lambda$0(tab, arg_0));
        CloseTab closeTab = new CloseTab(component2, file2, window, parentDisposable);
        AnAction[] anActionArray = new AnAction[]{editorActionGroup, closeTab};
        tab.setTabLabelActions((ActionGroup)new DefaultActionGroup(anActionArray), "EditorTab");
        return tab;
    }

    public static final boolean isSingletonEditorInWindow(@NotNull List<? extends FileEditor> editors) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(editors, (String)"editors");
            Iterable $this$any$iv = editors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileEditor it = (FileEditor)element$iv;
                    boolean bl2 = false;
                    Object object = FileEditorManagerKeys.SINGLETON_EDITOR_IN_WINDOW.get((UserDataHolder)it, (Object)false);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    if (!((Boolean)object).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void createKeepMousePositionRunnable$lambda$0$0(MouseEvent $event) {
        Component component2 = $event.getComponent();
        if (component2 != null && component2.isShowing()) {
            Point p = component2.getLocationOnScreen();
            p.translate($event.getX(), $event.getY());
            try {
                new Robot().mouseMove(p.x, p.y);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    private static final Unit createKeepMousePositionRunnable$lambda$0(MouseEvent $event) {
        EdtScheduler.Companion.getInstance().schedule(50, () -> EditorTabbedContainerKt.createKeepMousePositionRunnable$lambda$0$0($event));
        return Unit.INSTANCE;
    }

    private static final void createTabInfo$lambda$0(TabInfo $tab, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.put("editorTab", $tab.getText());
    }

    public static final /* synthetic */ void access$doProcessDoubleClick(MouseEvent e, JBTabsImpl editorTabs, EditorWindow window) {
        EditorTabbedContainerKt.doProcessDoubleClick(e, editorTabs, window);
    }
}

