/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpFileEditor
extends BaseRemoteFileEditor {
    private final RemoteFilePanel myPanel;
    @NotNull
    private final HttpVirtualFile myFile;

    HttpFileEditor(@NotNull Project project2, @NotNull HttpVirtualFile virtualFile2) {
        if (project2 == null) {
            HttpFileEditor.$$$reportNull$$$0(0);
        }
        if (virtualFile2 == null) {
            HttpFileEditor.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myFile = virtualFile2;
        this.myPanel = new RemoteFilePanel(project2, this.myFile, this);
        RemoteFileInfoImpl fileInfo = (RemoteFileInfoImpl)virtualFile2.getFileInfo();
        assert (fileInfo != null);
        fileInfo.download().onSuccess(file2 -> ApplicationManager.getApplication().invokeLater(() -> this.contentLoaded(), this.myProject.getDisposed())).onError(throwable -> this.contentRejected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel.getMainPanel();
        if (jPanel == null) {
            HttpFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getPreferredFocusedComponent();
        }
        return this.myPanel.getMainPanel();
    }

    @NotNull
    public VirtualFile getFile() {
        HttpVirtualFile httpVirtualFile = this.myFile;
        if (httpVirtualFile == null) {
            HttpFileEditor.$$$reportNull$$$0(3);
        }
        return httpVirtualFile;
    }

    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"http.editor.name", (Object[])new Object[0]);
        if (string == null) {
            HttpFileEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void selectNotify() {
        this.myPanel.selectNotify();
    }

    public void deselectNotify() {
        this.myPanel.deselectNotify();
    }

    @Override
    @Nullable
    protected TextEditor getTextEditor() {
        return this.myPanel.getFileEditor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPanel.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/http/HttpFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

