/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorTreeRendererContextProvider;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTree {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private final SimpleTextAttributes GRAY_LINK = new SimpleTextAttributes(16, (Color)JBColor.gray);
    private final JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private final JScrollPane myComponent;
    private Keymap myKeymap;
    private Group myMainGroup = new Group("");
    @NonNls
    private static final String ROOT = "ROOT";
    private String myFilter = null;
    private Condition<? super AnAction> myBaseFilter;
    private final Map<String, String> myPluginNames = ActionsTreeUtil.createPluginActionsMap();

    public ActionsTree() {
        this.myRoot = new DefaultMutableTreeNode(ROOT);
        this.myTree = new Tree(new MyModel(this.myRoot)){

            public void paint(Graphics g) {
                super.paint(g);
                Rectangle visibleRect = this.getVisibleRect();
                Insets insets = this.getInsets();
                if (insets != null && insets.right > 0) {
                    visibleRect.width -= JBUIScale.scale((int)9);
                }
                Rectangle clip = g.getClipBounds();
                for (int row2 = 0; row2 < this.getRowCount(); ++row2) {
                    Object data2;
                    Object node;
                    Rectangle rowBounds = this.getRowBounds(row2);
                    rowBounds.x = 0;
                    rowBounds.width = Integer.MAX_VALUE;
                    if (!rowBounds.intersects(clip) || !((node = this.getPathForRow(row2).getLastPathComponent()) instanceof DefaultMutableTreeNode) || (data2 = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink) continue;
                    Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                    ActionsTree.this.paintRowData(this, data2, fullRowRect, (Graphics2D)g);
                }
            }

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    String path = ActionsTree.this.getPath((DefaultMutableTreeNode)value, true);
                    return StringUtil.notNullize((String)path);
                }
                return super.convertValueToText(value, selected, expanded, leaf, row2, hasFocus);
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("mac.ui.striped", Boolean.TRUE);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new KeymapsRenderer()));
        new TreeLinkMouseListener(this, new KeymapsRenderer()){

            @Override
            protected boolean doCacheLastNode() {
                return false;
            }

            @Override
            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tag instanceof Hyperlink) {
                    ((Hyperlink)tag).onClick(event);
                } else {
                    super.handleTagClick(tag, event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/keymap/impl/ui/ActionsTree$2", "handleTagClick"));
            }
        }.installOn(this.myTree);
        this.myTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String description = this.getDescription(e);
                ActionMenu.showDescriptionInStatusBar(description != null, ActionsTree.this.myTree, description);
            }

            @Nullable
            @NlsActions.ActionDescription
            private String getDescription(@NotNull MouseEvent e) {
                Object userObject;
                TreePath path;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DefaultMutableTreeNode node = (path = ActionsTree.this.myTree.getPathForLocation(e.getX(), e.getY())) == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = userObject = node == null ? null : node.getUserObject();
                if (!(userObject instanceof String)) {
                    return null;
                }
                String actionId = (String)userObject;
                Presentation presentation2 = ActionsTreeUtil.getTemplatePresentation(actionId, null);
                return presentation2 == null ? null : presentation2.getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ActionsTree$3", "getDescription"));
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.getAccessibleContext().setAccessibleName(KeyMapBundle.message((String)"keymap.actions.tree.accessible.name", (Object[])new Object[0]));
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)22, (int)31);
    }

    void setKeymap(@NotNull Keymap keymap2) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(0);
        }
        this.myKeymap = keymap2;
    }

    public void setBaseFilter(@Nullable Condition<? super AnAction> baseFilter) {
        this.myBaseFilter = baseFilter;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.myTree.getSelectionModel().addTreeSelectionListener(l);
    }

    @Nullable
    private Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
    }

    @Nullable
    public String getSelectedActionId() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof String) {
            return (String)userObject;
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)((Object)userObject)).getActionId();
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getId();
        }
        return null;
    }

    public void reset(@NotNull Keymap keymap2, QuickList @NotNull [] allQuickLists) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(1);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(2);
        }
        this.reset(keymap2, allQuickLists, this.myFilter, null);
    }

    public void reset(@NotNull Keymap keymap2, QuickList @NotNull [] allQuickLists, @Nullable Shortcut shortcut) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(3);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(4);
        }
        this.reset(keymap2, allQuickLists, this.myFilter, shortcut);
    }

    public Group getMainGroup() {
        return this.myMainGroup;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void filter(String filter2, QuickList[] currentQuickListIds) {
        this.myFilter = filter2;
        this.reset(this.myKeymap, currentQuickListIds, filter2, null);
    }

    @Nullable
    private Condition<? super AnAction> combineWithBaseFilter(@Nullable Condition<? super AnAction> actionFilter) {
        if (actionFilter != null) {
            return this.myBaseFilter != null ? Conditions.and(this.myBaseFilter, actionFilter) : actionFilter;
        }
        return this.myBaseFilter;
    }

    private void reset(@NotNull Keymap keymap2, QuickList @NotNull [] allQuickLists, String filter2, @Nullable Shortcut shortcut) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(5);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(6);
        }
        this.myKeymap = keymap2;
        PathsKeeper pathsKeeper = new PathsKeeper();
        pathsKeeper.storePaths();
        this.myRoot.removeAllChildren();
        ActionManager actionManager = ActionManager.getInstance();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myComponent));
        Condition<? super AnAction> condFilter = this.combineWithBaseFilter(ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut, filter2, true));
        Group mainGroup = ActionsTreeUtil.createMainGroup(project2, keymap2, allQuickLists, filter2, true, condFilter);
        if ((StringUtil.isNotEmpty((String)filter2) || shortcut != null) && mainGroup.initIds().isEmpty()) {
            condFilter = this.combineWithBaseFilter(ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut, filter2, false));
            mainGroup = ActionsTreeUtil.createMainGroup(project2, keymap2, allQuickLists, filter2, false, condFilter);
        }
        this.myRoot = ActionsTreeUtil.createNode(mainGroup);
        this.myMainGroup = mainGroup;
        MyModel model2 = (MyModel)this.myTree.getModel();
        model2.setRoot(this.myRoot);
        model2.nodeStructureChanged(this.myRoot);
        pathsKeeper.restorePaths();
        this.getComponent().repaint();
    }

    public void filterTree(Shortcut shortcut, QuickList[] currentQuickListIds) {
        this.reset(this.myKeymap, currentQuickListIds, this.myFilter, shortcut);
    }

    public static boolean isShortcutCustomized(@NotNull String actionId, @NotNull Keymap keymap2) {
        if (actionId == null) {
            ActionsTree.$$$reportNull$$$0(7);
        }
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(8);
        }
        if (!keymap2.canModify()) {
            return false;
        }
        Keymap parent = keymap2.getParent();
        return parent != null && !Arrays.equals(parent.getShortcuts(actionId), keymap2.getShortcuts(actionId));
    }

    private static boolean areGroupShortcutsCustomized(@NotNull Group group2, @NotNull Keymap keymap2) {
        if (group2 == null) {
            ActionsTree.$$$reportNull$$$0(9);
        }
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(10);
        }
        if (!keymap2.canModify()) {
            return false;
        }
        ArrayList<Object> children2 = group2.getChildren();
        for (Object child : children2) {
            String actionId;
            String actionId2;
            if (!(child instanceof Group ? ActionsTree.areGroupShortcutsCustomized((Group)child, keymap2) : (child instanceof String ? ActionsTree.isShortcutCustomized(actionId2 = (String)child, keymap2) : child instanceof QuickList && ActionsTree.isShortcutCustomized(actionId = ((QuickList)((Object)child)).getActionId(), keymap2)))) continue;
            return true;
        }
        return group2.getId() != null && ActionsTree.isShortcutCustomized(group2.getId(), keymap2);
    }

    public void selectAction(String actionId) {
        String boundId;
        String path = this.myMainGroup.getActionQualifiedPath(actionId, false);
        String string = boundId = path == null ? ActionManagerEx.getInstanceEx().getActionBinding(actionId) : null;
        if (path == null && boundId != null && (path = this.myMainGroup.getActionQualifiedPath(boundId, false)) == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode getNodeForPath(String path) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!Objects.equals(this.getPath(node, false), path)) continue;
            return node;
        }
        return null;
    }

    private List<DefaultMutableTreeNode> getNodesByPaths(List<String> paths) {
        SmartList result2 = new SmartList();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String path = this.getPath(node, false);
            if (!paths.contains(path)) continue;
            result2.add(node);
        }
        return result2;
    }

    @Nullable
    private String getPath(DefaultMutableTreeNode node, boolean presentable) {
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            Object object;
            String actionId = (String)userObject;
            TreeNode parent = node.getParent();
            if (parent instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)parent).getUserObject()) instanceof Group) {
                return ((Group)object).getActionQualifiedPath(actionId, presentable);
            }
            return this.myMainGroup.getActionQualifiedPath(actionId, presentable);
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getQualifiedPath(presentable);
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)((Object)userObject)).getName();
        }
        return null;
    }

    public static Icon getEvenIcon(Icon icon2) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon2 != null && icon2.getIconHeight() <= EMPTY_ICON.getIconHeight() && icon2.getIconWidth() <= EMPTY_ICON.getIconWidth()) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        return layeredIcon;
    }

    @NotNull
    private RowData extractRowData(Object data2) {
        String actionId = null;
        if (data2 instanceof String) {
            actionId = (String)data2;
        } else if (data2 instanceof QuickList) {
            actionId = ((QuickList)((Object)data2)).getActionId();
        } else if (data2 instanceof Group) {
            actionId = ((Group)data2).getId();
        }
        if (actionId == null) {
            return new RowData(null, null);
        }
        Shortcut[] shortcuts = this.myKeymap.getShortcuts(actionId);
        Set abbreviations = AbbreviationManager.getInstance().getAbbreviations(actionId);
        return new RowData(shortcuts, abbreviations);
    }

    private void paintRowData(Tree tree2, Object data2, Rectangle bounds, Graphics2D g) {
        Color c2;
        Color c1;
        int fontHeight;
        RowData rowData = this.extractRowData(data2);
        Shortcut[] shortcuts = rowData.shortcuts;
        Set<String> abbreviations = rowData.abbreviations;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        if (ExperimentalUI.isNewUI()) {
            new ShortcutTextList(shortcuts, abbreviations, (JComponent)tree2, g).draw(bounds, g);
            config.restore();
            return;
        }
        int totalWidth = 0;
        FontMetrics metrics = tree2.getFontMetrics(tree2.getFont());
        if (shortcuts != null && shortcuts.length > 0) {
            for (Shortcut shortcut : shortcuts) {
                totalWidth += metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(234, 200, 162);
            c2 = new Color(208, 200, 66);
            g.translate(0, bounds.y - 1);
            for (Shortcut shortcut : shortcuts) {
                int width = metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(KeymapUtil.getShortcutText((Shortcut)shortcut), x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        if (abbreviations != null && !abbreviations.isEmpty()) {
            for (String abbreviation : abbreviations) {
                totalWidth += metrics.stringWidth(abbreviation);
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(206, 234, 176);
            c2 = new Color(126, 208, 82);
            g.translate(0, bounds.y - 1);
            for (String abbreviation : abbreviations) {
                int width = metrics.stringWidth(abbreviation);
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(abbreviation, x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        config.restore();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allQuickLists";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setKeymap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isShortcutCustomized";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "areGroupShortcutsCustomized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private MyModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public void setTree(JTree tree2) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> KeyMapBundle.message((String)"action.column.name", (Object[])new Object[0]);
                case 1 -> KeyMapBundle.message((String)"shortcuts.column.name", (Object[])new Object[0]);
                default -> "";
            };
        }

        public Object getValueAt(Object value, int column) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return "???";
            }
            if (column == 0) {
                return value;
            }
            if (column == 1) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof QuickList) {
                    userObject = ((QuickList)((Object)userObject)).getActionId();
                }
                return userObject instanceof String ? KeymapUtil.getShortcutsText((Shortcut[])ActionsTree.this.myKeymap.getShortcuts((String)userObject)) : "";
            }
            return "???";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }

    private final class KeymapsRenderer
    extends ColoredTreeCellRenderer
    implements UiInspectorTreeRendererContextProvider {
        private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
        private boolean myHaveLink;
        private int myLinkOffset;
        private int myLinkWidth;
        private int myRow;
        private boolean myIsSeparator;

        private KeymapsRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            AnAction boundAction;
            boolean changed;
            String text2;
            if (tree2 == null) {
                KeymapsRenderer.$$$reportNull$$$0(0);
            }
            this.myRow = row2;
            this.myHaveLink = false;
            this.myIsSeparator = false;
            Icon icon2 = null;
            String actionId = null;
            String boundId = null;
            String tooltipText = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof Group) {
                Group group2 = (Group)userObject;
                actionId = group2.getId();
                text2 = group2.getName();
                changed = ActionsTree.this.myKeymap != null && ActionsTree.areGroupShortcutsCustomized(group2, ActionsTree.this.myKeymap);
                icon2 = (Icon)ObjectUtils.chooseNotNull((Object)group2.getIcon(), (Object)AllIcons.Nodes.Folder);
            } else if (userObject instanceof String) {
                actionId = (String)userObject;
                boundId = ((KeymapImpl)ActionsTree.this.myKeymap).hasShortcutDefined(actionId) ? null : ActionManagerEx.getInstanceEx().getActionBinding(actionId);
                Presentation presentation2 = ActionsTreeUtil.getTemplatePresentation(actionId, null);
                if (presentation2 == null) {
                    text2 = actionId;
                } else {
                    text2 = StringUtil.notNullize((String)presentation2.getText(), (String)actionId);
                    icon2 = presentation2.getIcon();
                    tooltipText = presentation2.getDescription();
                }
                changed = ActionsTree.this.myKeymap != null && ActionsTree.isShortcutCustomized(actionId, ActionsTree.this.myKeymap);
            } else if (userObject instanceof QuickList) {
                QuickList list2 = (QuickList)((Object)userObject);
                text2 = list2.getName();
                changed = ActionsTree.this.myKeymap != null && ActionsTree.isShortcutCustomized(list2.getActionId(), ActionsTree.this.myKeymap);
            } else if (userObject instanceof Separator) {
                this.myIsSeparator = true;
                text2 = null;
                changed = false;
            } else if (userObject instanceof Hyperlink) {
                Hyperlink link = (Hyperlink)userObject;
                this.myHaveLink = true;
                text2 = null;
                changed = false;
                icon2 = link.getIcon();
                this.myLink.getTreeCellRendererComponent(tree2, value, selected, expanded, leaf, row2, hasFocus);
                this.myLink.append(link.getLinkText(), link.getTextAttributes(), link);
                this.getIpad().right = 0;
                this.myLink.getIpad().left = 0;
                Rectangle treeVisibleRect = tree2.getVisibleRect();
                int rowX = TreeUtil.getNodeRowX((JTree)tree2, (int)row2);
                this.setupLinkDimensions(treeVisibleRect, rowX);
            } else {
                throw new IllegalArgumentException("unknown userObject: " + String.valueOf(userObject));
            }
            if (UISettings.getInstance().getShowIconsInMenus()) {
                this.setIcon(ActionsTree.getEvenIcon(icon2));
            }
            Object foreground = selected ? UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus) : (changed ? JBColor.namedColor((String)"Tree.modifiedItemForeground", (Color)PlatformColors.BLUE) : UIUtil.getTreeForeground());
            Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)true);
            SearchUtil.appendFragments(ActionsTree.this.myFilter, text2, 0, (Color)foreground, background, (SimpleColoredComponent)this);
            if (boundId != null && (boundAction = ActionManager.getInstance().getActionOrStub(boundId)) != null) {
                this.append(" ");
                this.append(IdeBundle.message((String)"uses.shortcut.of", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.append(" ");
                Presentation boundPresentation = ActionsTreeUtil.getTemplatePresentation(boundId, actionId);
                String boundText = StringUtil.notNullize((String)(boundPresentation == null ? null : boundPresentation.getText()), (String)boundId);
                this.append(boundText, ActionsTree.this.GRAY_LINK, new SelectActionRunnable(boundId));
            }
            if (actionId != null && UISettings.getInstance().getShowInplaceCommentsInternal()) {
                Group parentGroup;
                @NlsSafe String pluginName = ActionsTree.this.myPluginNames.get(actionId);
                if (pluginName != null && pluginName.equals((parentGroup = (Group)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getName())) {
                    pluginName = null;
                }
                this.append("   ");
                this.append((String)(pluginName != null ? actionId + " (" + pluginName + ")" : actionId), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
            this.setToolTipText(tooltipText);
            this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, this.myHaveLink);
        }

        @NotNull
        public List<PropertyBean> getUiInspectorContext(@NotNull JTree tree2, @Nullable Object value, int row2) {
            Object userObject;
            if (tree2 == null) {
                KeymapsRenderer.$$$reportNull$$$0(1);
            }
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            Object object = userObject = value != null ? ((DefaultMutableTreeNode)value).getUserObject() : null;
            if (userObject instanceof Group) {
                Group group2 = (Group)userObject;
                result2.add(new PropertyBean("Action ID", (Object)group2.getId(), true));
            } else if (userObject instanceof String) {
                result2.add(new PropertyBean("Action ID", userObject, true));
            }
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                KeymapsRenderer.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private void setupLinkDimensions(Rectangle treeVisibleRect, int rowX) {
            Dimension linkSize = this.myLink.getPreferredSize();
            this.myLinkWidth = linkSize.width;
            this.myLinkOffset = Math.min(super.getPreferredSize().width - 1, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
            this.myLink.setSize(this.myLinkWidth, this.getHeight());
        }

        protected void doPaint(Graphics2D g) {
            if (this.myIsSeparator) {
                super.doPaint(g);
                g.setColor(JBUI.CurrentTheme.Popup.separatorColor());
                RectanglePainter.FILL.paint(g, 0, this.getHeight() / 2, this.getWidth(), 1, null);
            } else if (this.myHaveLink) {
                UIUtil.useSafely((Graphics)g.create(0, 0, this.myLinkOffset, g.getClipBounds().height), x$0 -> super.doPaint(x$0));
                g.translate(this.myLinkOffset, 0);
                this.myLink.setSize(this.myLink.getWidth(), this.getHeight());
                this.myLink.doPaint(g);
                g.translate(-this.myLinkOffset, 0);
            } else {
                super.doPaint(g);
            }
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            if (this.myHaveLink) {
                size2.width += this.myLinkWidth;
            }
            Dimension dimension = size2;
            if (dimension == null) {
                KeymapsRenderer.$$$reportNull$$$0(3);
            }
            return dimension;
        }

        @Nullable
        public Object getFragmentTagAt(int x) {
            if (this.myHaveLink) {
                return this.myLink.getFragmentTagAt(x - this.myLinkOffset);
            }
            return super.getFragmentTagAt(x);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleKeymapsRenderer();
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiInspectorContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUiInspectorContext";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        private final class SelectActionRunnable
        implements Runnable {
            private final String myActionId;

            SelectActionRunnable(String actionId) {
                this.myActionId = actionId;
            }

            @Override
            public void run() {
                ActionsTree.this.selectAction(this.myActionId);
            }
        }

        protected final class AccessibleKeymapsRenderer
        extends ColoredTreeCellRenderer.AccessibleColoredTreeCellRenderer {
            protected AccessibleKeymapsRenderer() {
                super((ColoredTreeCellRenderer)KeymapsRenderer.this);
            }

            public String getAccessibleName() {
                Object data2;
                String name2 = super.getAccessibleName();
                if (KeymapsRenderer.this.myIsSeparator && StringUtil.isEmpty((String)name2)) {
                    return KeyMapBundle.message((String)"keymap.actions.tree.separator.row.accessible.name", (Object[])new Object[0]);
                }
                @NlsSafe String shortcutName = null;
                TreePath path = KeymapsRenderer.this.myTree.getPathForRow(KeymapsRenderer.this.myRow);
                if (path == null) {
                    return KeyMapBundle.message((String)"accessible.name.unknown", (Object[])new Object[0]);
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DefaultMutableTreeNode && !((data2 = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink)) {
                    RowData rowData = ActionsTree.this.extractRowData(data2);
                    Shortcut[] shortcuts = rowData.shortcuts;
                    if (shortcuts != null && shortcuts.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (Shortcut shortcut : shortcuts) {
                            if (!sb.isEmpty()) {
                                sb.append(", ");
                            }
                            sb.append(KeyMapBundle.message((String)"accessible.name.shortcut", (Object[])new Object[0]));
                            sb.append(KeymapUtil.getShortcutText((Shortcut)shortcut));
                        }
                        if (!sb.isEmpty()) {
                            shortcutName = sb.toString();
                        }
                    }
                }
                return AccessibleContextUtil.combineAccessibleStrings((String)name2, (String)", ", shortcutName);
            }
        }
    }

    private final class PathsKeeper {
        private ArrayList<String> myPathsToExpand;
        private ArrayList<String> mySelectionPaths;

        private PathsKeeper() {
        }

        public void storePaths() {
            this.myPathsToExpand = new ArrayList();
            this.mySelectionPaths = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ActionsTree.this.myTree.getModel().getRoot();
            TreePath path = new TreePath(root.getPath());
            if (ActionsTree.this.myTree.isPathSelected(path)) {
                this.addPathToList(root, this.mySelectionPaths);
            }
            if (ActionsTree.this.myTree.isExpanded(path) || root.getChildCount() == 0) {
                this.addPathToList(root, this.myPathsToExpand);
                this._storePaths(root);
            }
        }

        private void addPathToList(DefaultMutableTreeNode root, ArrayList<? super String> list2) {
            String path = ActionsTree.this.getPath(root, false);
            if (!StringUtil.isEmpty((String)path)) {
                list2.add(path);
            }
        }

        private void _storePaths(DefaultMutableTreeNode root) {
            ArrayList<TreeNode> childNodes = PathsKeeper.childrenToArray(root);
            for (TreeNode childNode1 : childNodes) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
                TreePath path = new TreePath(childNode.getPath());
                if (ActionsTree.this.myTree.isPathSelected(path)) {
                    this.addPathToList(childNode, this.mySelectionPaths);
                }
                if (!ActionsTree.this.myTree.isExpanded(path) && childNode.getChildCount() != 0 || childNode.isLeaf()) continue;
                this.addPathToList(childNode, this.myPathsToExpand);
                this._storePaths(childNode);
            }
        }

        public void restorePaths() {
            Object jbTree;
            Object object;
            try {
                object = ActionsTree.this.myTree;
                if (object instanceof Tree) {
                    jbTree = (Tree)object;
                    jbTree.suspendExpandCollapseAccessibilityAnnouncements();
                }
                for (DefaultMutableTreeNode node : ActionsTree.this.getNodesByPaths(this.myPathsToExpand)) {
                    ActionsTree.this.myTree.expandPath(new TreePath(node.getPath()));
                }
            }
            finally {
                object = ActionsTree.this.myTree;
                if (object instanceof Tree) {
                    jbTree = (Tree)object;
                    jbTree.resumeExpandCollapseAccessibilityAnnouncements();
                }
            }
            if (ActionsTree.this.myTree.getSelectionModel().getSelectionCount() == 0) {
                List<DefaultMutableTreeNode> nodesToSelect = ActionsTree.this.getNodesByPaths(this.mySelectionPaths);
                if (!nodesToSelect.isEmpty()) {
                    for (DefaultMutableTreeNode node : nodesToSelect) {
                        TreeUtil.selectNode((JTree)ActionsTree.this.myTree, (TreeNode)node);
                    }
                } else {
                    ActionsTree.this.myTree.setSelectionRow(0);
                }
            }
        }

        private static ArrayList<TreeNode> childrenToArray(DefaultMutableTreeNode node) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                arrayList.add(node.getChildAt(i2));
            }
            return arrayList;
        }
    }

    private record RowData(Shortcut[] shortcuts, Set<String> abbreviations) {
    }

    private static final class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (tree2 == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/keymap/impl/ui/ActionsTree$MyColoredTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

