/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor.settings;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.options.newEditor.settings.SettingsVirtualFileHolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0001,B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J%\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H%0'H\u0016\u00a2\u0006\u0002\u0010(J-\u0010)\u001a\u00020\u0016\"\u0004\b\u0000\u0010%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H%0'2\b\u0010*\u001a\u0004\u0018\u0001H%H\u0016\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsFileEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "settingsFile", "Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;", "component", "Ljavax/swing/JComponent;", "preferredFocusedComponent", "dialogDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "myPanel", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getComponent", "getPreferredFocusedComponent", "getName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "setState", "", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "getState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "NavigationState", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class SettingsFileEditor
implements FileEditor {
    @NotNull
    private final SettingsVirtualFileHolder.SettingsVirtualFile settingsFile;
    @Nullable
    private final JComponent preferredFocusedComponent;
    @NotNull
    private final UserDataHolder userDataHolder;
    @NotNull
    private final JComponent myPanel;

    public SettingsFileEditor(@NotNull SettingsVirtualFileHolder.SettingsVirtualFile settingsFile, @NotNull JComponent component2, @Nullable JComponent preferredFocusedComponent, @NotNull Disposable dialogDisposable) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)dialogDisposable, (String)"dialogDisposable");
        this.settingsFile = settingsFile;
        this.preferredFocusedComponent = preferredFocusedComponent;
        this.userDataHolder = (UserDataHolder)new UserDataHolderBase();
        this.myPanel = component2;
        this.userDataHolder.putUserData(FileEditorManagerKeys.DUMB_AWARE, (Object)true);
        this.userDataHolder.putUserData(FileEditorManagerKeys.FORBID_PREVIEW_TAB, (Object)true);
        this.userDataHolder.putUserData(FileEditorManagerKeys.SINGLETON_EDITOR_IN_WINDOW, (Object)true);
        Disposer.register((Disposable)dialogDisposable, (Disposable)((Disposable)this));
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.settingsFile;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.preferredFocusedComponent;
    }

    @NotNull
    public String getName() {
        String string = CommonBundle.settingsTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsTitle(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(state2 instanceof NavigationState)) {
            return;
        }
        this.settingsFile.setConfigurableId(((NavigationState)state2).getPathId());
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level != FileEditorStateLevel.NAVIGATION) {
            FileEditorState fileEditorState = super.getState(level);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
            return fileEditorState;
        }
        String string = this.settingsFile.getConfigurableId();
        if (string == null) {
            FileEditorState fileEditorState = super.getState(level);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
            return fileEditorState;
        }
        String configurableId = string;
        return new NavigationState(configurableId);
    }

    public boolean isModified() {
        return this.settingsFile.isModified();
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void dispose() {
        this.settingsFile.disposeDialog();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.userDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.userDataHolder.putUserData(key, value);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsFileEditor$NavigationState;", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "pathId", "", "<init>", "(Ljava/lang/String;)V", "getPathId", "()Ljava/lang/String;", "canBeMergedWith", "", "otherState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "toString", "intellij.platform.ide.impl"})
    private static final class NavigationState
    implements FileEditorState {
        @NotNull
        private final String pathId;

        public NavigationState(@NotNull String pathId) {
            Intrinsics.checkNotNullParameter((Object)pathId, (String)"pathId");
            this.pathId = pathId;
        }

        @NotNull
        public final String getPathId() {
            return this.pathId;
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            Intrinsics.checkNotNullParameter((Object)otherState, (String)"otherState");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!(otherState instanceof NavigationState) || level != FileEditorStateLevel.NAVIGATION) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pathId, (Object)((NavigationState)otherState).pathId);
        }

        @NotNull
        public String toString() {
            return "NavigationState(pathId='" + this.pathId + "')";
        }
    }
}

