/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.ShutdownKt;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.ProjectUtilKt;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ExcludeRootsCache;
import com.intellij.openapi.project.impl.HeadlessProjectFrameAllocator;
import com.intellij.openapi.project.impl.IdeProjectFrameAllocator;
import com.intellij.openapi.project.impl.ProjectFrameAllocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectInitHelper;
import com.intellij.openapi.project.impl.ProjectLoadingCancelled;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectManagerImplKt;
import com.intellij.openapi.project.impl.SeparateProcessKt;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.TimedZipHandler;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessorKt;
import com.intellij.platform.diagnostic.telemetry.impl.TracerKt;
import com.intellij.platform.eel.provider.EelInitialization;
import com.intellij.platform.eel.provider.EelUnavailableException;
import com.intellij.platform.ide.diagnostic.startUpPerformanceReporter.FUSProjectHotStartUpMeasurer;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Suppressions;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u0088\u00012\u00020\u00012\u00020\u0002:\u0002\u0088\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\n\u0010\u001e\u001a\u00060\u0019j\u0002`\u001aH\u0007J\u0006\u0010\"\u001a\u00020\u001cJ\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007J\u0006\u0010*\u001a\u00020\u0007J\b\u0010+\u001a\u00020\u001cH\u0007J\u0011\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007J\u0010\u00100\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007H\u0004J\u0006\u00101\u001a\u00020\u001cJ\u0010\u00102\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00072\b\u00104\u001a\u0004\u0018\u00010\u000bJ\u000e\u00105\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0007J\u000e\u00106\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007J\u0016\u00107\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00072\u0006\u00108\u001a\u00020'J\u001e\u00109\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00072\u0006\u00108\u001a\u00020'H\u0086@\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020'J,\u00106\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00072\b\b\u0002\u0010=\u001a\u00020'2\b\b\u0002\u0010\"\u001a\u00020'2\u0006\u0010<\u001a\u00020'H\u0014J\u0010\u0010>\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0010H\u0017J\u0010\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0010H\u0017J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010?\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0010H\u0016J\u0018\u0010B\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0010H\u0016J\u0010\u0010C\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010/\u001a\u00020\u0007H\u0002J\u001a\u0010E\u001a\u00020\u00072\b\u0010F\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0010\u0010G\u001a\u0004\u0018\u00010\u00072\u0006\u0010H\u001a\u00020\u000bJ\u0018\u0010I\u001a\u0004\u0018\u00010\u00072\u0006\u0010J\u001a\u00020%2\u0006\u0010K\u001a\u00020LJ \u0010M\u001a\u0004\u0018\u00010\u00072\u0006\u0010N\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0086@\u00a2\u0006\u0002\u0010OJ \u0010P\u001a\u0004\u0018\u00010\u00072\u0006\u0010N\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0082@\u00a2\u0006\u0002\u0010OJ \u0010Q\u001a\u0004\u0018\u00010\u00072\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010RJ\u0018\u0010S\u001a\u00020T2\u0006\u0010J\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0014J$\u0010U\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010V\u001a\u0004\u0018\u00010WH\u0082@\u00a2\u0006\u0002\u0010XJ(\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020T2\b\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010K\u001a\u00020LH\u0082@\u00a2\u0006\u0002\u0010]J\u001a\u0010^\u001a\u0004\u0018\u00010\u00072\u0006\u0010_\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0016J\u001e\u0010`\u001a\u00020\u00072\u0006\u0010_\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0086@\u00a2\u0006\u0002\u0010OJ\u0010\u0010a\u001a\u00020\u001c2\u0006\u0010b\u001a\u00020\\H\u0014J6\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020%2\b\u0010f\u001a\u0004\u0018\u00010\u000b2\u0014\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c\u0018\u00010hH\u0094@\u00a2\u0006\u0002\u0010iJX\u0010j\u001a\u00020\u00072\u0006\u0010e\u001a\u00020%2\b\u0010f\u001a\u0004\u0018\u00010\u000b2\u0014\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c\u0018\u00010h2\u0006\u0010k\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010l\u001a\u00020'2\b\b\u0002\u0010m\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010nJ\u000e\u0010o\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0002\u0010pJP\u0010q\u001a\u00020\u00072\u0006\u0010N\u001a\u00020%2\b\u0010f\u001a\u0004\u0018\u00010\u000b2\u0014\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c\u0018\u00010h2\b\u0010r\u001a\u0004\u0018\u00010s2\u0006\u0010t\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010uJ\u0018\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010x\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010yJ\u0010\u0010z\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007H\u0014J(\u0010{\u001a\u0004\u0018\u00010|2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010J\u001a\u00020%2\u0006\u0010K\u001a\u00020LH\u0096@\u00a2\u0006\u0002\u0010}J(\u0010~\u001a\u00020'2\u0006\u0010\u007f\u001a\u00020\u00072\u0006\u0010K\u001a\u00020L2\u0007\u0010\u0080\u0001\u001a\u00020%H\u0082@\u00a2\u0006\u0003\u0010\u0081\u0001J5\u0010\u0082\u0001\u001a\u0004\u0018\u00010'2\u0006\u0010\u007f\u001a\u00020\u00072\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010K\u001a\u00020L2\u0007\u0010\u0080\u0001\u001a\u00020%H\u0082@\u00a2\u0006\u0003\u0010\u0085\u0001J\u0018\u0010\u0086\u0001\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0007H\u0082@\u00a2\u0006\u0003\u0010\u0087\u0001R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000e\u001a.\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0013\u00a2\u0006\u0002\b\u00120\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010(\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006\u0089\u0001"}, d2={"Lcom/intellij/openapi/project/impl/ProjectManagerImpl;", "Lcom/intellij/openapi/project/ex/ProjectManagerEx;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "openProjects", "", "Lcom/intellij/openapi/project/Project;", "[Lcom/intellij/openapi/project/Project;", "openProjectByHash", "Ljava/util/concurrent/ConcurrentHashMap;", "", "lock", "", "listeners", "", "Lcom/intellij/openapi/project/ProjectManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "defaultProject", "Lcom/intellij/openapi/project/impl/DefaultProject;", "excludeRootsCache", "Lcom/intellij/openapi/project/impl/ExcludeRootsCache;", "getAllExcludedUrlsCallback", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "testOnlyGetExcludedUrlsCallback", "", "parentDisposable", "callback", "allExcludedUrls", "getAllExcludedUrls", "()Ljava/util/List;", "dispose", "loadProject", "path", "Ljava/nio/file/Path;", "preloadServices", "", "isDefaultProjectInitialized", "()Z", "getDefaultProject", "disposeDefaultProjectAndCleanupComponentsForDynamicPluginTests", "getOpenProjects", "()[Lcom/intellij/openapi/project/Project;", "isProjectOpened", "project", "addToOpened", "updateTheOnlyProjectField", "removeFromOpened", "findOpenProjectByHash", "locationHash", "reloadProject", "closeProject", "forceCloseProject", "save", "forceCloseProjectAsync", "(Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeAndDisposeAllProjects", "checkCanClose", "saveProject", "closeAndDispose", "addProjectManagerListener", "listener", "Lcom/intellij/openapi/project/VetoableProjectManagerListener;", "removeProjectManagerListener", "canClose", "getAllListeners", "createProject", "name", "loadAndOpenProject", "originalFilePath", "openProject", "projectStoreBaseDir", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "openProjectAsync", "projectIdentityFile", "(Ljava/nio/file/Path;Lcom/intellij/ide/impl/OpenProjectTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openProjectAsyncImpl", "doOpenAsync", "(Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createFrameAllocator", "Lcom/intellij/openapi/project/impl/ProjectFrameAllocator;", "cancelProjectOpening", "e", "Ljava/util/concurrent/CancellationException;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/CancellationException;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "failedToOpenProject", "frameAllocator", "exception", "", "(Lcom/intellij/openapi/project/impl/ProjectFrameAllocator;Ljava/lang/Throwable;Lcom/intellij/ide/impl/OpenProjectTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newProject", "file", "newProjectAsync", "handleErrorOnNewProject", "t", "instantiateProject", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "identityFle", "projectName", "beforeInit", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareNewProject", "useDefaultProjectAsTemplate", "markAsNewlyCreated", "markAsNew", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;ZZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "acquireTemplateProject", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareProject", "projectInitHelper", "Lcom/intellij/openapi/project/impl/ProjectInitHelper;", "runConversionBeforeOpen", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/project/impl/ProjectInitHelper;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runConversion", "Lcom/intellij/conversion/ConversionResult;", "projectPath", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isRunStartUpActivitiesEnabled", "configureWorkspace", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lcom/intellij/ide/impl/OpenProjectTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkExistingProjectOnOpen", "projectToClose", "projectDir", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryToOpen", "processor", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/projectImport/ProjectAttachProcessor;Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeAndDisposeKeepingFrame", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectManagerImpl.kt\ncom/intellij/openapi/project/impl/ProjectManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1589:1\n1#2:1590\n55#3:1591\n55#3:1594\n29#4,2:1592\n31#4:1595\n29#4,3:1596\n29#4,3:1643\n60#5,5:1599\n60#5,5:1604\n74#6,10:1609\n83#6:1619\n83#6:1620\n83#6:1621\n83#6:1622\n74#6,10:1623\n74#6,10:1633\n*S KotlinDebug\n*F\n+ 1 ProjectManagerImpl.kt\ncom/intellij/openapi/project/impl/ProjectManagerImpl\n*L\n315#1:1591\n439#1:1594\n437#1:1592,2\n437#1:1595\n448#1:1596,3\n480#1:1643,3\n544#1:1599,5\n561#1:1604,5\n692#1:1609,10\n829#1:1619\n833#1:1620\n1049#1:1621\n1071#1:1622\n1097#1:1623,10\n1106#1:1633,10\n*E\n"})
public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project[] openProjects = new Project[0];
    @NotNull
    private final ConcurrentHashMap<String, Project> openProjectByHash = new ConcurrentHashMap();
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final List<ProjectManagerListener> listeners;
    @NotNull
    private final DefaultProject defaultProject;
    @NotNull
    private final ExcludeRootsCache excludeRootsCache;
    @Nullable
    private Runnable getAllExcludedUrlsCallback;

    public ProjectManagerImpl() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
        this.defaultProject = new DefaultProject();
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                for (ProjectManagerListener listener2 : this.getAllListeners(project2)) {
                    try {
                        listener2.projectOpened(project2);
                    }
                    catch (Exception e) {
                        ProjectManagerImplKt.access$handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosed(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                for (ProjectManagerListener listener2 : this.getAllListeners(project2)) {
                    try {
                        listener2.projectClosed(project2);
                    }
                    catch (Exception e) {
                        ProjectManagerImplKt.access$handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosing(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                for (ProjectManagerListener listener2 : this.getAllListeners(project2)) {
                    try {
                        listener2.projectClosing(project2);
                    }
                    catch (Exception e) {
                        ProjectManagerImplKt.access$handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosingBeforeSave(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                for (ProjectManagerListener listener2 : this.getAllListeners(project2)) {
                    try {
                        listener2.projectClosingBeforeSave(project2);
                    }
                    catch (Exception e) {
                        ProjectManagerImplKt.access$handleListenerError(e, listener2);
                    }
                }
            }
        });
        this.excludeRootsCache = new ExcludeRootsCache(connection);
    }

    @TestOnly
    public final void testOnlyGetExcludedUrlsCallback(@NotNull Disposable parentDisposable, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!(this.getAllExcludedUrlsCallback == null)) {
            boolean bl = false;
            String string = "This method is not reentrant. Expected null but got " + this.getAllExcludedUrlsCallback;
            throw new IllegalStateException(string.toString());
        }
        this.getAllExcludedUrlsCallback = callback;
        Disposer.register((Disposable)parentDisposable, () -> ProjectManagerImpl.testOnlyGetExcludedUrlsCallback$lambda$1(this));
    }

    @NotNull
    public final List<String> getAllExcludedUrls() {
        Runnable runnable2 = this.getAllExcludedUrlsCallback;
        if (runnable2 != null) {
            runnable2.run();
        }
        List<String> list2 = this.excludeRootsCache.getExcludedUrls();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExcludedUrls(...)");
        return list2;
    }

    public final void dispose() {
        ThreadingAssertions.assertWriteAccess();
        Disposer.dispose((Disposable)((Disposable)this.defaultProject));
    }

    @NotNull
    public Project loadProject(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.loadProject(path, true);
    }

    @RequiresBackgroundThread
    @NotNull
    public final Project loadProject(@NotNull Path path, boolean preloadServices) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ModalityState modalityState = CoreProgressManager.getCurrentThreadProgressModality();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getCurrentThreadProgressModality(...)");
        ModalityState modalityState2 = modalityState;
        return (Project)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(modalityState2, this, path, preloadServices, null){
            int label;
            final /* synthetic */ ModalityState $modalityState;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ Path $path;
            final /* synthetic */ boolean $preloadServices;
            {
                this.$modalityState = $modalityState;
                this.this$0 = $receiver;
                this.$path = $path;
                this.$preloadServices = $preloadServices;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)ModalityKt.asContextElement((ModalityState)this.$modalityState).plus((CoroutineContext)ClientIdKt.asContextElement((ClientId)ClientId.Companion.getLocalId())), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this.this$0, this.$path, this.$preloadServices, null){
                            int label;
                            final /* synthetic */ ProjectManagerImpl this$0;
                            final /* synthetic */ Path $path;
                            final /* synthetic */ boolean $preloadServices;
                            {
                                this.this$0 = $receiver;
                                this.$path = $path;
                                this.$preloadServices = $preloadServices;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ProjectManagerImpl.access$prepareProject(this.this$0, this.$path, null, null, null, false, this.$preloadServices, (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final boolean isDefaultProjectInitialized() {
        return this.defaultProject.isCached();
    }

    @NotNull
    public final Project getDefaultProject() {
        ProjectManagerImplKt.access$getLOG$p().assertTrue(!ApplicationManager.getApplication().isDisposed(), (Object)"Application has already been disposed!");
        this.defaultProject.markRequested();
        return this.defaultProject;
    }

    @TestOnly
    @ApiStatus.Internal
    public final void disposeDefaultProjectAndCleanupComponentsForDynamicPluginTests() {
        this.defaultProject.disposeDefaultProjectAndCleanupComponentsForDynamicPluginTests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Project[] getOpenProjects() {
        Project[] projectArray;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            projectArray = this.openProjects;
        }
        return projectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isProjectOpened(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            bl = ArraysKt.contains((Object[])this.openProjects, (Object)project2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean addToOpened(@NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl2 = bl = !project2.isDisposed();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Must not open already disposed project";
            throw new AssertionError((Object)string);
        }
        Object object = this.lock;
        synchronized (object) {
            block5: {
                boolean bl4 = false;
                if (this.openProjectByHash.putIfAbsent(project2.getLocationHash(), project2) == null) break block5;
                boolean bl5 = false;
                return bl5;
            }
            this.openProjects = (Project[])ArraysKt.plus((Object[])this.openProjects, (Object)project2);
            Unit unit = Unit.INSTANCE;
        }
        this.updateTheOnlyProjectField();
        ProjectManagerImplKt.access$getLOG$p().info("Project " + project2.getName() + " was added to the list of open projects");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTheOnlyProjectField() {
        boolean isLightEditActive;
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        LightEditService lightEditService = (LightEditService)(application != null ? application.getServiceIfCreated(LightEditService.class) : null);
        boolean bl = isLightEditActive = (lightEditService != null ? lightEditService.getProject() : null) != null;
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest()) {
            ProjectCoreUtil.INSTANCE.updateInternalTheOnlyProjectFieldTemporarily(null);
        } else {
            boolean isDefaultInitialized = this.isDefaultProjectInitialized();
            Object object = this.lock;
            synchronized (object) {
                boolean bl2 = false;
                Project theOnlyProject = this.openProjects.length == 1 && !isDefaultInitialized && !isLightEditActive ? (Project)ArraysKt.first((Object[])this.openProjects) : null;
                ProjectCoreUtil.INSTANCE.updateInternalTheOnlyProjectFieldTemporarily(theOnlyProject);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromOpened(Project project2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Object[] objectArray = ArrayUtil.remove((Object[])this.openProjects, (Object)project2);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"remove(...)");
            this.openProjects = (Project[])objectArray;
            boolean bl2 = this.openProjectByHash.values().remove(project2);
        }
    }

    @Nullable
    public final Project findOpenProjectByHash(@Nullable String locationHash) {
        return (Project)((Map)this.openProjectByHash).get(locationHash);
    }

    public final void reloadProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        StoreReloadManager.Companion.getInstance(project2).reloadProject();
    }

    public final boolean closeProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.closeProject(project2, true, false, true);
    }

    public final boolean forceCloseProject(@NotNull Project project2, boolean save2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ProjectManagerImpl.closeProject$default(this, project2, save2, false, false, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object forceCloseProjectAsync(@NotNull Project project, boolean save, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof forceCloseProjectAsync.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.forceCloseProjectAsync(null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (save) {
                    $continuation.L$0 = project;
                    $continuation.Z$0 = save;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, null){
                        int label;
                        final /* synthetic */ Project $project;
                        {
                            this.$project = $project;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = StoreUtilKt.saveSettings((ComponentManager)this.$project, true, (Continuation<? super Boolean>)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var6_6) {
                        return var6_6;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                save = $continuation.Z$0;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.Z$0 = save;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, this, save != false, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    final /* synthetic */ boolean $save;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$save = $save;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$project.isDisposed()) {
                                    return Boxing.boxBoolean((boolean)false);
                                }
                                this.label = 1;
                                Object object2 = com.intellij.openapi.application.CoroutinesKt.writeIntentReadAction(() -> forceCloseProjectAsync.3.invokeSuspend$lambda$0(this.this$0, this.$project, this.$save), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(ProjectManagerImpl this$0, Project $project, boolean $save) {
                        return ProjectManagerImpl.closeProject$default(this$0, $project, $save, false, false, 4, null);
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl37
            }
            case 2: {
                save = $continuation.Z$0;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean closeAndDisposeAllProjects(boolean checkCanClose) {
        Object[] projects = null;
        projects = this.openProjects;
        Project project2 = LightEditUtil.getProjectIfCreated();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            projects = ArraysKt.plus((Object[])projects, (Object)it);
        }
        for (Project project3 : projects) {
            if (ProjectManagerImpl.closeProject$default(this, project3, false, false, checkCanClose, 6, null)) continue;
            return false;
        }
        return true;
    }

    protected boolean closeProject(@NotNull Project project2, boolean saveProject, boolean dispose, boolean checkCanClose) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        long projectCloseStartedMs = System.currentTimeMillis();
        Application app = ApplicationManager.getApplication();
        if (!(!app.isWriteAccessAllowed())) {
            boolean bl = false;
            String string = "Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful";
            throw new IllegalStateException(string.toString());
        }
        ThreadingAssertions.assertWriteIntentReadAccess();
        if (Companion.isLight(project2)) {
            ProjectImpl projectImpl = (ProjectImpl)project2;
            if (!projectImpl.isTemporarilyDisposed()) {
                app.runWriteAction(() -> ProjectManagerImpl.closeProject$lambda$1(projectImpl, this, project2));
                this.updateTheOnlyProjectField();
                return true;
            }
            projectImpl.setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project2) && !LightEdit.owns((Project)project2)) {
            if (dispose) {
                if (project2 instanceof ComponentManagerEx) {
                    ((ComponentManagerEx)project2).stopServicePreloading();
                }
                app.runWriteAction(() -> ProjectManagerImpl.closeProject$lambda$2(project2));
            }
            return true;
        }
        if (checkCanClose && !this.canClose(project2)) {
            return false;
        }
        if (project2 instanceof ComponentManagerEx) {
            ((ComponentManagerEx)project2).stopServicePreloading();
        }
        ProjectManagerImplKt.access$getClosePublisher().projectClosingBeforeSave(project2);
        ProjectManagerImplKt.access$getPublisher().projectClosingBeforeSave(project2);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (saveProject) {
            boolean $i$f$serviceIfCreated = false;
            Application application = ApplicationManager.getApplication();
            FileDocumentManager fileDocumentManager = (FileDocumentManager)(application != null ? application.getServiceIfCreated(FileDocumentManager.class) : null);
            if (fileDocumentManager != null) {
                fileDocumentManager.saveAllDocuments();
            }
            SaveAndSyncHandler.Companion.getInstance().saveSettingsUnderModalProgress((ComponentManager)project2);
        }
        long projectSaveSettingsDurationMs = System.currentTimeMillis() - start$iv;
        if (checkCanClose && !ProjectManagerImplKt.access$ensureCouldCloseIfUnableToSave(project2)) {
            return false;
        }
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl2 = false;
        ProjectManagerImplKt.access$fireProjectClosing(project2);
        if (project2 instanceof ProjectImpl) {
            if (Registry.Companion.is("ide.await.project.scope.completion")) {
                ShutdownKt.cancelAndJoinBlocking((ProjectImpl)project2);
            } else {
                ShutdownKt.cancelAndTryJoin((ProjectImpl)project2);
            }
        }
        long projectClosingDurationMs = System.currentTimeMillis() - start$iv2;
        app.runWriteAction(() -> ProjectManagerImpl.closeProject$lambda$5(this, project2, dispose, projectCloseStartedMs, projectSaveSettingsDurationMs, projectClosingDurationMs));
        return true;
    }

    public static /* synthetic */ boolean closeProject$default(ProjectManagerImpl projectManagerImpl, Project project2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: closeProject");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return projectManagerImpl.closeProject(project2, bl, bl2, bl3);
    }

    public boolean closeAndDispose(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ProjectManagerImpl.closeProject$default(this, project2, false, false, true, 6, null);
    }

    @Deprecated(message="Deprecated in Java")
    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add((ProjectManagerListener)listener2);
    }

    @Deprecated(message="Deprecated in Java")
    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        boolean removed = this.listeners.remove(listener2);
        ProjectManagerImplKt.access$getLOG$p().assertTrue(removed);
    }

    public void removeProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        boolean removed = this.listeners.remove(listener2);
        ProjectManagerImplKt.access$getLOG$p().assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (project2.isDefault()) {
            return;
        }
        Object object = ConcurrencyUtil.computeIfAbsent((UserDataHolder)((UserDataHolder)project2), (Key)ProjectManagerImplKt.access$getLISTENERS_IN_PROJECT_KEY$p(), ProjectManagerImpl::addProjectManagerListener$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        List listeners = (List)object;
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (project2.isDefault()) {
            return;
        }
        List listeners = (List)project2.getUserData(ProjectManagerImplKt.access$getLISTENERS_IN_PROJECT_KEY$p());
        ProjectManagerImplKt.access$getLOG$p().assertTrue(listeners != null);
        List list2 = listeners;
        Intrinsics.checkNotNull((Object)list2);
        boolean removed = list2.remove(listener2);
        ProjectManagerImplKt.access$getLOG$p().assertTrue(removed);
    }

    public boolean canClose(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectManagerImplKt.access$getLOG$p().debug("enter: canClose()");
        for (ProjectCloseHandler handler2 : ProjectManagerImplKt.access$getCLOSE_HANDLER_EP$p().lazySequence()) {
            try {
                if (handler2.canClose(project2)) continue;
                Logger $this$debug_u24default$iv = ProjectManagerImplKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("close canceled by " + handler2, t$iv);
                }
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectManagerImplKt.access$getLOG$p().error(e);
            }
        }
        for (ProjectManagerListener listener2 : this.getAllListeners(project2)) {
            try {
                boolean canClose2 = listener2 instanceof VetoableProjectManagerListener ? ((VetoableProjectManagerListener)listener2).canClose(project2) : listener2.canCloseProject(project2);
                if (canClose2) continue;
                Logger $this$debug_u24default$iv = ProjectManagerImplKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger3 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger3.debug("close canceled by " + listener2, t$iv);
                }
                return false;
            }
            catch (Throwable e) {
                ProjectManagerImplKt.access$handleListenerError(e, listener2);
            }
        }
        return true;
    }

    private final List<ProjectManagerListener> getAllListeners(Project project2) {
        List projectLevelListeners = ProjectManagerImplKt.access$getListeners(project2);
        return projectLevelListeners.isEmpty() ? this.listeners : (this.listeners.isEmpty() ? projectLevelListeners : CollectionsKt.plus((Collection)projectLevelListeners, (Iterable)this.listeners));
    }

    @RequiresEdt
    @NotNull
    public final Project createProject(@Nullable String name2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (Project)ProjectUtilKt.runUnderModalProgressIfIsEdt((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this, path, name2, null){
            int label;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$name = $name;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$invokeSuspend_u24lambda_u240;
                        ResultKt.throwOnFailure((Object)$result);
                        String string = this.$name;
                        boolean $i$f$OpenProjectTask = false;
                        OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
                        boolean $i$f$build = false;
                        OpenProjectTaskBuilder openProjectTaskBuilder = this_$iv$iv;
                        Path path = ProjectManagerImplKt.access$toCanonicalName(this.$path);
                        ProjectManagerImpl projectManagerImpl = this.this$0;
                        boolean bl = false;
                        $this$invokeSuspend_u24lambda_u240.setProjectName(string);
                        $this$invokeSuspend_u24lambda_u240.setBeforeInit(null);
                        $this$invokeSuspend_u24lambda_u240.setUseDefaultProjectAsTemplate(Boxing.boxBoolean((boolean)true));
                        $this$invokeSuspend_u24lambda_u240.setPreloadServices(true);
                        Unit unit = Unit.INSTANCE;
                        if (this_$iv$iv.getProject() != null && this_$iv$iv.getCreateModule()) {
                            OpenProjectTaskBuilder $this$thisLogger$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$thisLogger = false;
                            Logger logger2 = Logger.getInstance(OpenProjectTaskBuilder.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                            Project project2 = this_$iv$iv.getProject();
                            logger2.warn("Project is explicitly set (name=" + (project2 != null ? project2.getName() : null) + "), but createModule is true");
                        }
                        boolean bl2 = this_$iv$iv.getForceOpenInNewFrame();
                        boolean bl3 = this_$iv$iv.getForceReuseFrame();
                        boolean bl4 = this_$iv$iv.getPreloadServices();
                        openProjectTaskBuilder = this_$iv$iv.getProjectToClose();
                        boolean bl5 = this_$iv$iv.isRefreshVfsNeeded();
                        String string2 = this_$iv$iv.getProjectName();
                        boolean bl6 = this_$iv$iv.isNewProject();
                        Boolean bl7 = this_$iv$iv.getUseDefaultProjectAsTemplate();
                        boolean bl8 = bl7 != null ? bl7.booleanValue() : this_$iv$iv.isNewProject();
                        boolean bl9 = this_$iv$iv.getRunConfigurators();
                        boolean bl10 = this_$iv$iv.isProjectCreatedWithWizard();
                        boolean bl11 = this_$iv$iv.getRunConversionBeforeOpen();
                        boolean bl12 = this_$iv$iv.getShowWelcomeScreen();
                        Function2 function2 = this_$iv$iv.getBeforeOpen();
                        Function1 function1 = this_$iv$iv.getBeforeInit();
                        Function2 function22 = this_$iv$iv.getPreparedToOpen();
                        ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
                        boolean bl13 = this_$iv$iv.getPreventIprLookup();
                        Function1 function12 = this_$iv$iv.getProcessorChooser();
                        String string3 = this_$iv$iv.getProjectWorkspaceId();
                        Object object2 = this_$iv$iv.getImplOptions();
                        boolean bl14 = this_$iv$iv.getCreateModule();
                        int n = this_$iv$iv.getLine();
                        int n2 = this_$iv$iv.getColumn();
                        Project project3 = this_$iv$iv.getProject();
                        Path path2 = this_$iv$iv.getProjectRootDir();
                        this.label = 1;
                        Object object3 = projectManagerImpl.newProjectAsync(path, new OpenProjectTask(bl2, bl3, (Project)openProjectTaskBuilder, bl6, bl8, project3, string2, bl12, projectOpenedCallback, n, n2, bl5, bl9, bl11, string3, bl10, bl4, function1, function2, function22, bl13, function12, object2, path2, bl14), (Continuation<? super Project>)((Continuation)this));
                        if (object3 != object) return object3;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Project loadAndOpenProject(@NotNull String originalFilePath) {
        Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
        return this.openProject(ProjectManagerImplKt.access$toCanonicalName(originalFilePath), new OpenProjectTask(false, null, false, false, 15, null));
    }

    @Nullable
    public final Project openProject(@NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2) {
        Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return (Project)ProjectUtilKt.runUnderModalProgressIfIsEdt((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this, projectStoreBaseDir, options2, null){
            int label;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ Path $projectStoreBaseDir;
            final /* synthetic */ OpenProjectTask $options;
            {
                this.this$0 = $receiver;
                this.$projectStoreBaseDir = $projectStoreBaseDir;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.openProjectAsync(this.$projectStoreBaseDir, this.$options, (Continuation<? super Project>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Nullable
    public final Object openProjectAsync(@NotNull Path projectIdentityFile, @NotNull OpenProjectTask options2, @NotNull Continuation<? super Project> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)ClientIdKt.asContextElement((ClientId)ClientId.Companion.getLocalId())), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this, projectIdentityFile, options2, null){
            int label;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ Path $projectIdentityFile;
            final /* synthetic */ OpenProjectTask $options;
            {
                this.this$0 = $receiver;
                this.$projectIdentityFile = $projectIdentityFile;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ProjectManagerImpl.access$openProjectAsyncImpl(this.this$0, this.$projectIdentityFile, this.$options, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object openProjectAsyncImpl(Path projectIdentityFile, OpenProjectTask options, Continuation<? super Project> $completion) {
        block27: {
            if (!($completion instanceof openProjectAsyncImpl.1)) ** GOTO lbl-1000
            var10_4 = $completion;
            if ((var10_4.label & -2147483648) != 0) {
                var10_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    boolean Z$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ProjectManagerImpl.access$openProjectAsyncImpl(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (Intrinsics.areEqual((Object)projectIdentityFile.getFileSystem().getClass().getName(), (Object)"javaClass")) {
                        $continuation.L$0 = projectIdentityFile;
                        $continuation.L$1 = options;
                        $continuation.label = 1;
                        v0 = TracerKt.span$default((String)"EelInitialization.runEelInitialization", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(projectIdentityFile, null){
                            int label;
                            final /* synthetic */ Path $projectIdentityFile;
                            {
                                this.$projectIdentityFile = $projectIdentityFile;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = EelInitialization.INSTANCE.runEelInitialization(((Object)this.$projectIdentityFile).toString(), (Continuation)this);
                                        Object object3 = object2;
                                        if (object2 != object) return object3;
                                        return object;
                                    }
                                    case 1: {
                                        Object object3;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            object3 = $result;
                                            return object3;
                                        }
                                        catch (EelUnavailableException e) {
                                            ProjectManagerImplKt.access$getLOG$p().error((Throwable)e);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation, (int)2, null);
                        if (v0 == var11_6) {
                            return var11_6;
                        }
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    options = (OpenProjectTask)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    JpsMetricsKt.getJpsMetrics().startNewSpan("project.opening", "jps.sync");
                    if (ProjectManagerImplKt.access$getLOG$p().isDebugEnabled() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        ProjectManagerImplKt.access$getLOG$p().debug("open project: " + options, (Throwable)new Exception());
                    }
                    if (options.getProject() != null) {
                        v1 = options.getProject();
                        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.intellij.openapi.project.Project");
                        if (this.isProjectOpened(v1)) {
                            ProjectManagerImplKt.access$getLOG$p().info("Project is already opened -> return null");
                            return null;
                        }
                    }
                    $continuation.L$0 = projectIdentityFile;
                    $continuation.L$1 = options;
                    $continuation.label = 2;
                    v2 = TracerKt.span$default((String)"checkChildProcess", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(projectIdentityFile, options, null){
                        int label;
                        final /* synthetic */ Path $projectIdentityFile;
                        final /* synthetic */ OpenProjectTask $options;
                        {
                            this.$projectIdentityFile = $projectIdentityFile;
                            this.$options = $options;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = SeparateProcessKt.checkChildProcess(this.$projectIdentityFile, this.$options, (Continuation<? super Boolean>)((Continuation)this));
                                    if (object2 != object) return Boxing.boxBoolean(((Boolean)object2 == false ? 1 : 0) != 0);
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Boxing.boxBoolean(((Boolean)object2 == false ? 1 : 0) != 0);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation, (int)2, null);
                    if (v2 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl47
                }
                case 2: {
                    options = (OpenProjectTask)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 2 sources

                    if (continueOpen = ((Boolean)v2).booleanValue()) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)options);
                    $continuation.Z$0 = continueOpen;
                    $continuation.label = 3;
                    v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, options, null){
                        int label;
                        final /* synthetic */ ProjectManagerImpl this$0;
                        final /* synthetic */ OpenProjectTask $options;
                        {
                            this.this$0 = $receiver;
                            this.$options = $options;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = ProjectManagerImpl.cancelProjectOpening$default(this.this$0, this.$options.getProject(), null, (Continuation)this, 2, null);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v3 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl62
                }
                case 3: {
                    continueOpen = $continuation.Z$0;
                    options = (OpenProjectTask)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl62:
                    // 2 sources

                    return null;
                }
            }
            if (options.getForceOpenInNewFrame() || (openProjects = this.openProjects).length == 0) break block27;
            projectToClose = options.getProjectToClose();
            if (projectToClose == null) {
                v4 = lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
                v5 /* !! */  = projectToClose = v4 != null ? v4.getProject() : null;
                if (projectToClose == null || projectToClose instanceof LightEditCompatible) {
                    projectToClose = (Project)ArraysKt.last((Object[])openProjects);
                }
            }
            $continuation.L$0 = projectIdentityFile;
            $continuation.L$1 = options;
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)openProjects);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)projectToClose);
            $continuation.Z$0 = continueOpen;
            $continuation.label = 4;
            v6 = this.checkExistingProjectOnOpen(projectToClose, options, projectIdentityFile, (Continuation<? super Boolean>)$continuation);
            if (v6 == var11_6) {
                return var11_6;
            }
            ** GOTO lbl88
            {
                case 4: {
                    continueOpen = $continuation.Z$0;
                    projectToClose = (Project)$continuation.L$3;
                    openProjects = (Project[])$continuation.L$2;
                    options = (OpenProjectTask)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl88:
                    // 2 sources

                    if (!((Boolean)v6).booleanValue()) break;
                    ProjectManagerImplKt.access$getLOG$p().info("Project check is not succeeded -> return null");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)options);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)openProjects);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)projectToClose);
                    $continuation.Z$0 = continueOpen;
                    $continuation.label = 5;
                    v7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, options, null){
                        int label;
                        final /* synthetic */ ProjectManagerImpl this$0;
                        final /* synthetic */ OpenProjectTask $options;
                        {
                            this.this$0 = $receiver;
                            this.$options = $options;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = ProjectManagerImpl.cancelProjectOpening$default(this.this$0, this.$options.getProject(), null, (Continuation)this, 2, null);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v7 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl108
                }
                case 5: {
                    continueOpen = $continuation.Z$0;
                    projectToClose = (Project)$continuation.L$3;
                    openProjects = (Project[])$continuation.L$2;
                    options = (OpenProjectTask)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl108:
                    // 2 sources

                    return null;
                }
            }
        }
        $continuation.L$0 = projectIdentityFile;
        $continuation.L$1 = options;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.Z$0 = continueOpen;
        $continuation.label = 6;
        v8 = TracerKt.span$default((String)"checkTrustedState", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessCanceledException>, Object>(projectIdentityFile, options, null){
            int label;
            final /* synthetic */ Path $projectIdentityFile;
            final /* synthetic */ OpenProjectTask $options;
            {
                this.$projectIdentityFile = $projectIdentityFile;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ProjectManagerImplKt.checkTrustedState(this.$projectIdentityFile, (Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) {
                            ProjectManagerImplKt.access$getLOG$p().info("Project is not trusted, aborting");
                            if (this.$options.getShowWelcomeScreen()) {
                                WelcomeFrame.Companion.showIfNoProjectOpened$default(WelcomeFrame.Companion, null, 1, null);
                            }
                            v1 = new ProcessCanceledException();
                        } else {
                            v1 = null;
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ProcessCanceledException> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation, (int)2, null);
        if (v8 == var11_6) {
            return var11_6;
        }
        ** GOTO lbl126
        {
            case 6: {
                continueOpen = $continuation.Z$0;
                options = (OpenProjectTask)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl126:
                // 2 sources

                if ((var5_12 = (ProcessCanceledException)v8) == null) break;
                it = var5_12;
                $i$a$-let-ProjectManagerImpl$openProjectAsyncImpl$6 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)options);
                $continuation.L$2 = it;
                $continuation.Z$0 = continueOpen;
                $continuation.I$0 = $i$a$-let-ProjectManagerImpl$openProjectAsyncImpl$6;
                $continuation.label = 7;
                v9 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, options, it, null){
                    int label;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    final /* synthetic */ OpenProjectTask $options;
                    final /* synthetic */ ProcessCanceledException $it;
                    {
                        this.this$0 = $receiver;
                        this.$options = $options;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = ProjectManagerImpl.access$cancelProjectOpening(this.this$0, this.$options.getProject(), (CancellationException)((Object)this.$it), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v9 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl147
            }
            case 7: {
                $i$a$-let-ProjectManagerImpl$openProjectAsyncImpl$6 = $continuation.I$0;
                continueOpen = $continuation.Z$0;
                it = (ProcessCanceledException)$continuation.L$2;
                options = (OpenProjectTask)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl147:
                // 2 sources

                throw it;
            }
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)options);
        $continuation.Z$0 = continueOpen;
        $continuation.label = 8;
        v10 = TracerKt.span$default((String)"ProjectManager.openAsync", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(projectIdentityFile, this, options, null){
            int label;
            final /* synthetic */ Path $projectIdentityFile;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ OpenProjectTask $options;
            {
                this.$projectIdentityFile = $projectIdentityFile;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FUSProjectHotStartUpMeasurer.INSTANCE.withProjectContextElement(this.$projectIdentityFile, (Function1)new Function1<Continuation<? super Project>, Object>(this.this$0, this.$options, this.$projectIdentityFile, null){
                            int label;
                            final /* synthetic */ ProjectManagerImpl this$0;
                            final /* synthetic */ OpenProjectTask $options;
                            final /* synthetic */ Path $projectIdentityFile;
                            {
                                this.this$0 = $receiver;
                                this.$options = $options;
                                this.$projectIdentityFile = $projectIdentityFile;
                                super(1, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ProjectManagerImpl.access$doOpenAsync(this.this$0, this.$options, this.$projectIdentityFile, (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Project> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation, (int)2, null);
        if (v10 == var11_6) {
            return var11_6;
        }
        ** GOTO lbl162
        {
            case 8: {
                continueOpen = $continuation.Z$0;
                options = (OpenProjectTask)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl162:
                // 2 sources

                return v10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object doOpenAsync(OpenProjectTask options, Path projectIdentityFile, Continuation<? super Project> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CASE], 9[SWITCH]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected ProjectFrameAllocator createFrameAllocator(@NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2) {
        Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Application app = ApplicationManager.getApplication();
        if (app.isHeadlessEnvironment() || app.isUnitTestMode()) {
            return new HeadlessProjectFrameAllocator();
        }
        return new IdeProjectFrameAllocator(options2, projectStoreBaseDir);
    }

    /*
     * Unable to fully structure code
     */
    private final Object cancelProjectOpening(Project project, CancellationException e, Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelProjectOpening.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProjectManagerImpl.access$cancelProjectOpening(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (project == null) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = project;
                $continuation.L$1 = e;
                $continuation.label = 1;
                v0 = JobKt.cancelAndJoin((Job)JobKt.getJob((CoroutineContext)((ProjectImpl)project).getCoroutineScope().getCoroutineContext()), (Continuation)$continuation);
                ** if (v0 != var7_6) goto lbl24
lbl23:
                // 1 sources

                return var7_6;
lbl24:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                e = (CancellationException)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                {
                    catch (Throwable secondException) {
                        v1 = e;
                        if (v1 == null) ** GOTO lbl38
                        ExceptionsKt.addSuppressed((Throwable)v1, (Throwable)secondException);
                    }
                }
lbl38:
                // 4 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = e;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, project, null){
                    int label;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = com.intellij.openapi.application.CoroutinesKt.writeIntentReadAction(() -> cancelProjectOpening.2.invokeSuspend$lambda$0(this.this$0, this.$project), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(ProjectManagerImpl this$0, Project $project) {
                        return ProjectManagerImpl.closeProject$default(this$0, $project, false, false, false, 4, null);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var7_6) goto lbl44
lbl43:
                // 1 sources

                return var7_6;
lbl44:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                e = (CancellationException)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (Throwable secondException) {
                    v3 = e;
                    if (v3 == null) ** GOTO lbl57
                    ExceptionsKt.addSuppressed((Throwable)v3, (Throwable)secondException);
                }
lbl57:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object cancelProjectOpening$default(ProjectManagerImpl projectManagerImpl, Project project2, CancellationException cancellationException, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: cancelProjectOpening");
        }
        if ((n & 2) != 0) {
            cancellationException = null;
        }
        return projectManagerImpl.cancelProjectOpening(project2, cancellationException, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object failedToOpenProject(ProjectFrameAllocator frameAllocator, Throwable exception, OpenProjectTask options, Continuation<? super Unit> $completion) {
        if (!($completion instanceof failedToOpenProject.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProjectManagerImpl.access$failedToOpenProject(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frameAllocator);
                $continuation.L$1 = exception;
                $continuation.L$2 = options;
                $continuation.label = 1;
                v0 = frameAllocator.projectNotLoaded(exception instanceof CannotConvertException != false ? (CannotConvertException)exception : null, (Continuation<? super Unit>)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                options = (OpenProjectTask)$continuation.L$2;
                exception = (Throwable)$continuation.L$1;
                frameAllocator = (ProjectFrameAllocator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                try {
                    v1 = ApplicationManager.getApplication().getMessageBus();
                    v2 = AppLifecycleListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"TOPIC");
                    ((AppLifecycleListener)v1.syncPublisher(v2)).projectOpenFailed();
                }
                catch (Throwable secondException) {
                    ProjectManagerImplKt.access$getLOG$p().error(secondException);
                }
                if (exception != null) {
                    v3 = ExceptionUtil.getThrowableText((Throwable)exception);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getThrowableText(...)");
                    stackTraceText = v3;
                    fullMessage = exception.getLocalizedMessage() + "\n\nStack Trace:\n" + stackTraceText;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)frameAllocator);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)exception);
                    $continuation.L$2 = options;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)stackTraceText);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)fullMessage);
                    $continuation.label = 2;
                    v4 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fullMessage, null){
                        int label;
                        final /* synthetic */ String $fullMessage;
                        {
                            this.$fullMessage = $fullMessage;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object[] objectArray = new Object[]{this.$fullMessage};
                                    Messages.showErrorDialog((String)IdeBundle.message((String)"ide.opening.failed.message", (Object[])objectArray), (String)CommonBundle.getErrorTitle());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v4 == var9_7) {
                        return var9_7;
                    }
                }
                ** GOTO lbl58
            }
            case 2: {
                fullMessage = (String)$continuation.L$4;
                stackTraceText = (String)$continuation.L$3;
                options = (OpenProjectTask)$continuation.L$2;
                exception = (Throwable)$continuation.L$1;
                frameAllocator = (ProjectFrameAllocator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl58:
                // 2 sources

                if (options.getShowWelcomeScreen()) {
                    WelcomeFrame.Companion.showIfNoProjectOpened$default(WelcomeFrame.Companion, null, 1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Project newProject(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        try {
            return (Project)ProjectUtilKt.runUnderModalProgressIfIsEdt((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this, file2, options2, null){
                int label;
                final /* synthetic */ ProjectManagerImpl this$0;
                final /* synthetic */ Path $file;
                final /* synthetic */ OpenProjectTask $options;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$options = $options;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.newProjectAsync(this.$file, this.$options, (Continuation<? super Project>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        catch (Throwable e) {
            this.handleErrorOnNewProject(e);
            return null;
        }
    }

    @Nullable
    public final Object newProjectAsync(@NotNull Path file2, @NotNull OpenProjectTask options2, @NotNull Continuation<? super Project> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)ClientIdKt.asContextElement((ClientId)ClientId.Companion.getLocalId())), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(file2, this, options2, null){
            int label;
            final /* synthetic */ Path $file;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ OpenProjectTask $options;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TrustedProjects.setProjectTrusted(this.$file, true);
                        this.label = 1;
                        v0 = ProjectManagerImpl.access$prepareNewProject(this.this$0, this.$file, this.$options.getProjectName(), this.$options.getBeforeInit(), this.$options.getUseDefaultProjectAsTemplate(), this.$options.getPreloadServices(), this.$options.isProjectCreatedWithWizard(), false, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        var2_3 = v0;
                        project = (Project)var2_3;
                        $i$a$-also-ProjectManagerImpl$newProjectAsync$2$1 = false;
                        TrustedProjects.setProjectTrusted(project, true);
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected void handleErrorOnNewProject(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        ProjectManagerImplKt.access$getLOG$p().warn(t);
        try {
            String errorMessage = ProjectManagerImplKt.access$message(t);
            ApplicationManager.getApplication().invokeAndWait(() -> ProjectManagerImpl.handleErrorOnNewProject$lambda$0(errorMessage));
        }
        catch (NoClassDefFoundError e) {
            ProjectManagerImplKt.access$getLOG$p().info((Throwable)e);
        }
    }

    @Nullable
    protected Object instantiateProject(@NotNull Path identityFle, @Nullable String projectName, @Nullable Function1<? super Project, Unit> beforeInit, @NotNull Continuation<? super ProjectImpl> $completion) {
        return ProjectManagerImpl.instantiateProject$suspendImpl(this, identityFle, projectName, beforeInit, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object instantiateProject$suspendImpl(ProjectManagerImpl $this, Path identityFle, String projectName, Function1<? super Project, Unit> beforeInit, Continuation<? super ProjectImpl> $completion) {
        if (!($completion instanceof instantiateProject.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProjectManagerImpl.instantiateProject$suspendImpl(this.this$0, null, null, null, (Continuation<? super ProjectImpl>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)identityFle);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectName);
                $continuation.L$3 = beforeInit;
                $continuation.label = 1;
                v0 = TracerKt.span$default((String)"project instantiation", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProjectImpl>, Object>(identityFle, projectName, null){
                    int label;
                    final /* synthetic */ Path $identityFle;
                    final /* synthetic */ String $projectName;
                    {
                        this.$identityFle = $identityFle;
                        this.$projectName = $projectName;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                boolean bl = ApplicationManager.getApplication().isUnitTestMode() && StringsKt.contains$default((CharSequence)((Object)this.$identityFle).toString(), (CharSequence)"light_temp", (boolean)false, (int)2, null);
                                Application application = ApplicationManager.getApplication();
                                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                                ComponentManagerImpl componentManagerImpl = ComponentManagerImplKt.getComponentManagerImpl((ComponentManager)((ComponentManager)application));
                                return new ProjectImpl(componentManagerImpl, bl, this.$projectName);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ProjectImpl> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)2, null);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                beforeInit = (Function1)$continuation.L$3;
                projectName = (String)$continuation.L$2;
                identityFle = (Path)$continuation.L$1;
                $this = (ProjectManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                project = (ProjectImpl)v0;
                v1 = beforeInit;
                if (v1 == null) break;
                beforeInit = v1;
                $i$a$-let-ProjectManagerImpl$instantiateProject$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)identityFle);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectName);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)beforeInit);
                $continuation.L$4 = project;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)beforeInit);
                $continuation.I$0 = $i$a$-let-ProjectManagerImpl$instantiateProject$2;
                $continuation.label = 2;
                v2 = TracerKt.span$default((String)"options.beforeInit", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Project, Unit>)beforeInit, project, null){
                    int label;
                    final /* synthetic */ Function1<Project, Unit> $beforeInit;
                    final /* synthetic */ ProjectImpl $project;
                    {
                        this.$beforeInit = $beforeInit;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$beforeInit.invoke((Object)((Object)this.$project));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)2, null);
                if (v2 == var10_7) {
                    return var10_7;
                }
                break;
            }
            case 2: {
                $i$a$-let-ProjectManagerImpl$instantiateProject$2 = $continuation.I$0;
                beforeInit = (Function1)$continuation.L$5;
                project = (ProjectImpl)$continuation.L$4;
                beforeInit = (Function1)$continuation.L$3;
                projectName = (String)$continuation.L$2;
                identityFle = (Path)$continuation.L$1;
                $this = (ProjectManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                break;
            }
        }
        return project;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object prepareNewProject(Path identityFle, String projectName, Function1<? super Project, Unit> beforeInit, boolean useDefaultProjectAsTemplate, boolean preloadServices, boolean markAsNewlyCreated, boolean markAsNew, Continuation<? super Project> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProjectImpl>, Object>(useDefaultProjectAsTemplate, this, identityFle, projectName, beforeInit, markAsNew, markAsNewlyCreated, preloadServices, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $useDefaultProjectAsTemplate;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ Path $identityFle;
            final /* synthetic */ String $projectName;
            final /* synthetic */ Function1<Project, Unit> $beforeInit;
            final /* synthetic */ boolean $markAsNew;
            final /* synthetic */ boolean $markAsNewlyCreated;
            final /* synthetic */ boolean $preloadServices;
            {
                this.$useDefaultProjectAsTemplate = $useDefaultProjectAsTemplate;
                this.this$0 = $receiver;
                this.$identityFle = $identityFle;
                this.$projectName = $projectName;
                this.$beforeInit = $beforeInit;
                this.$markAsNew = $markAsNew;
                this.$markAsNewlyCreated = $markAsNewlyCreated;
                this.$preloadServices = $preloadServices;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block11: {
                    var2_2 = (CoroutineScope)this.L$0;
                    var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            templateAsync = this.$useDefaultProjectAsTemplate != false ? BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ ProjectManagerImpl this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = ProjectManagerImpl.access$acquireTemplateProject(this.this$0, (Continuation)this);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null) : null;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = templateAsync;
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this.$identityFle, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ Path $identityFle;
                                {
                                    this.$identityFle = $identityFle;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void $this$withContext;
                                            ResultKt.throwOnFailure((Object)$result);
                                            BuildersKt.launch$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$identityFle, null){
                                                int I$0;
                                                int I$1;
                                                Object L$0;
                                                int label;
                                                final /* synthetic */ Path $identityFle;
                                                {
                                                    this.$identityFle = $identityFle;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            $i$f$serviceAsync = 0;
                                                            v0 = ApplicationManager.getApplication();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                                                            $this$serviceAsync$iv$iv = (ComponentManager)v0;
                                                            $i$f$serviceAsync = 0;
                                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                                                            this.I$0 = $i$f$serviceAsync;
                                                            this.I$1 = $i$f$serviceAsync;
                                                            this.label = 1;
                                                            v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ProjectStorePathManager.class, (Continuation)this);
                                                            ** if (v1 != var5_2) goto lbl19
lbl18:
                                                            // 1 sources

                                                            return var5_2;
lbl19:
                                                            // 1 sources

                                                            ** GOTO lbl30
                                                        }
                                                        case 1: {
                                                            $i$f$serviceAsync = this.I$1;
                                                            $i$f$serviceAsync = this.I$0;
                                                            $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                                                            try {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v1 = $result;
lbl30:
                                                                // 2 sources

                                                                ((ProjectStorePathManager)v1).getStoreDescriptor(this.$identityFle).removeProjectConfigurationAndCaches();
                                                            }
                                                            catch (IOException var2_5) {
                                                                // empty catch block
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                            return BuildersKt.launch$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$identityFle, null){
                                                int label;
                                                final /* synthetic */ Path $identityFle;
                                                {
                                                    this.$identityFle = $identityFle;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            try {
                                                                NioFiles.deleteRecursively((Path)ProjectUtil.getProjectDataPathRoot((Path)this.$identityFle));
                                                            }
                                                            catch (IOException iOException) {
                                                                // empty catch block
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl18
                        }
                        case 1: {
                            templateAsync = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = templateAsync;
                            this.label = 2;
                            v1 = this.this$0.instantiateProject(this.$identityFle, this.$projectName, this.$beforeInit, (Continuation<? super ProjectImpl>)((Continuation)this));
                            if (v1 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            templateAsync = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            project = (ProjectImpl)v1;
                            project.putUserData(PlatformProjectOpenProcessorKt.getPROJECT_NEWLY_OPENED(), Boxing.boxBoolean((boolean)this.$markAsNew));
                            project.putUserData(PlatformProjectOpenProcessorKt.getPROJECT_NEWLY_CREATED(), Boxing.boxBoolean((boolean)this.$markAsNewlyCreated));
                            v2 = templateAsync;
                            if (v2 == null) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)templateAsync);
                            this.L$2 = project;
                            this.label = 3;
                            v3 = v2.await((Continuation)this);
                            if (v3 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl47
                        }
                        case 3: {
                            project = (ProjectImpl)this.L$2;
                            templateAsync = (Deferred)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl47:
                            // 2 sources

                            v4 = (Project)v3;
                            break block11;
                        }
                    }
                    v4 = null;
                }
                template = v4;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)templateAsync);
                this.L$2 = project;
                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)template);
                this.label = 4;
                v5 = ProjectManagerImplKt.initProject$default(this.$identityFle, project, this.$preloadServices, template, null, (Continuation)this, 16, null);
                if (v5 == var6_3) {
                    return var6_3;
                }
                ** GOTO lbl67
                {
                    case 4: {
                        template = (Project)this.L$3;
                        project = (ProjectImpl)this.L$2;
                        templateAsync = (Deferred)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl67:
                        // 2 sources

                        return project;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ProjectImpl> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    static /* synthetic */ Object prepareNewProject$default(ProjectManagerImpl projectManagerImpl, Path path, String string, Function1 function1, boolean bl, boolean bl2, boolean bl3, boolean bl4, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareNewProject");
        }
        if ((n & 0x40) != 0) {
            bl4 = true;
        }
        return projectManagerImpl.prepareNewProject(path, string, (Function1<? super Project, Unit>)function1, bl, bl2, bl3, bl4, (Continuation<? super Project>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object acquireTemplateProject(Continuation<? super Project> $completion) {
        if (!($completion instanceof acquireTemplateProject.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProjectManagerImpl.access$acquireTemplateProject(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                project = this.defaultProject;
                $continuation.L$0 = project;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)new CoroutineName("save default project").plus((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, null){
                    int label;
                    final /* synthetic */ DefaultProject $project;
                    {
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = StoreUtilKt.saveSettings((ComponentManager)this.$project, true, (Continuation<? super Boolean>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                project = (DefaultProject)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return project;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object prepareProject(Path projectIdentityFile, String projectName, Function1<? super Project, Unit> beforeInit, ProjectInitHelper projectInitHelper, boolean runConversionBeforeOpen, boolean preloadServices, Continuation<? super Project> $completion) {
        block13: {
            if (!($completion instanceof prepareProject.1)) ** GOTO lbl-1000
            var13_8 = $completion;
            if ((var13_8.label & -2147483648) != 0) {
                var13_8.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    boolean Z$0;
                    boolean Z$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ProjectManagerImpl.access$prepareProject(this.this$0, null, null, null, null, false, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!runConversionBeforeOpen) break;
                    $continuation.L$0 = projectIdentityFile;
                    $continuation.L$1 = projectName;
                    $continuation.L$2 = beforeInit;
                    $continuation.L$3 = projectInitHelper;
                    $continuation.Z$0 = runConversionBeforeOpen;
                    $continuation.Z$1 = preloadServices;
                    $continuation.label = 1;
                    v0 = this.runConversion(projectIdentityFile, (Continuation<? super ConversionResult>)$continuation);
                    if (v0 == var14_10) {
                        return var14_10;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    preloadServices = $continuation.Z$1;
                    runConversionBeforeOpen = $continuation.Z$0;
                    projectInitHelper = (ProjectInitHelper)$continuation.L$3;
                    beforeInit = (Function1)$continuation.L$2;
                    projectName = (String)$continuation.L$1;
                    projectIdentityFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    v1 = (ConversionResult)v0;
                    break block13;
                }
            }
            v1 = null;
        }
        conversionResult = v1;
        $continuation.L$0 = projectIdentityFile;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectName);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)beforeInit);
        $continuation.L$3 = projectInitHelper;
        $continuation.L$4 = conversionResult;
        $continuation.Z$0 = runConversionBeforeOpen;
        $continuation.Z$1 = preloadServices;
        $continuation.label = 2;
        v2 = this.instantiateProject(projectIdentityFile, projectName, (Function1<? super Project, Unit>)beforeInit, (Continuation<? super ProjectImpl>)$continuation);
        if (v2 == var14_10) {
            return var14_10;
        }
        ** GOTO lbl60
        {
            case 2: {
                preloadServices = $continuation.Z$1;
                runConversionBeforeOpen = $continuation.Z$0;
                conversionResult = (ConversionResult)$continuation.L$4;
                projectInitHelper = (ProjectInitHelper)$continuation.L$3;
                beforeInit = (Function1)$continuation.L$2;
                projectName = (String)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl60:
                // 2 sources

                project = (ProjectImpl)v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)beforeInit);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)projectInitHelper);
                $continuation.L$4 = conversionResult;
                $continuation.L$5 = project;
                $continuation.Z$0 = runConversionBeforeOpen;
                $continuation.Z$1 = preloadServices;
                $continuation.label = 3;
                v3 = ProjectManagerImplKt.access$initProject(projectIdentityFile, project, preloadServices != false, null, projectInitHelper, (Continuation)$continuation);
                if (v3 == var14_10) {
                    return var14_10;
                }
                ** GOTO lbl85
            }
            case 3: {
                preloadServices = $continuation.Z$1;
                runConversionBeforeOpen = $continuation.Z$0;
                project = (ProjectImpl)$continuation.L$5;
                conversionResult = (ConversionResult)$continuation.L$4;
                projectInitHelper = (ProjectInitHelper)$continuation.L$3;
                beforeInit = (Function1)$continuation.L$2;
                projectName = (String)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl85:
                // 2 sources

                if (conversionResult == null || conversionResult.conversionNotNeeded()) ** GOTO lbl119
                $this$serviceAsync$iv = (ComponentManager)project;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectIdentityFile);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)beforeInit);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)projectInitHelper);
                $continuation.L$4 = conversionResult;
                $continuation.L$5 = project;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.Z$0 = runConversionBeforeOpen;
                $continuation.Z$1 = preloadServices;
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.label = 4;
                v4 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(StartupManager.class, (Continuation)$continuation);
                if (v4 == var14_10) {
                    return var14_10;
                }
                ** GOTO lbl118
            }
            case 4: {
                $i$f$serviceAsync = $continuation.I$0;
                preloadServices = $continuation.Z$1;
                runConversionBeforeOpen = $continuation.Z$0;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$6;
                project = (ProjectImpl)$continuation.L$5;
                conversionResult = (ConversionResult)$continuation.L$4;
                projectInitHelper = (ProjectInitHelper)$continuation.L$3;
                beforeInit = (Function1)$continuation.L$2;
                projectName = (String)$continuation.L$1;
                projectIdentityFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl118:
                // 2 sources

                ((StartupManager)v4).runAfterOpened((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, prepareProject$lambda$0(com.intellij.conversion.ConversionResult com.intellij.openapi.project.impl.ProjectImpl ), ()V)((ConversionResult)conversionResult, (ProjectImpl)project));
lbl119:
                // 2 sources

                return project;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runConversion(Path projectPath, Continuation<? super ConversionResult> $completion) {
        if (!($completion instanceof runConversion.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ProjectManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProjectManagerImpl.access$runConversion(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = projectPath;
                $continuation.label = 1;
                v1 = ((ComponentManagerEx)v0).getServiceAsyncIfDefined(ConversionService.class, (Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                projectPath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl24:
                // 2 sources

                v2 = (ConversionService)v1;
                if (v2 == null) {
                    return null;
                }
                conversionService = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)projectPath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)conversionService);
                $continuation.label = 2;
                v3 = TracerKt.span$default((String)"project conversion", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ConversionResult>, Object>(conversionService, projectPath, null){
                    int label;
                    final /* synthetic */ ConversionService $conversionService;
                    final /* synthetic */ Path $projectPath;
                    {
                        this.$conversionService = $conversionService;
                        this.$projectPath = $projectPath;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$conversionService.convert(this.$projectPath, (Continuation<? super ConversionResult>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ConversionResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation, (int)2, null);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                conversionService = (ConversionService)$continuation.L$1;
                projectPath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl40:
                // 2 sources

                if ((result = (ConversionResult)v3).openingIsCanceled()) {
                    throw new ProjectLoadingCancelled("ConversionResult.openingIsCanceled() returned true");
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected boolean isRunStartUpActivitiesEnabled(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return true;
    }

    @Nullable
    public Object configureWorkspace(@NotNull Project project2, @NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2, @NotNull Continuation<? super Module> $completion) {
        return ProjectManagerImpl.configureWorkspace$suspendImpl(this, project2, projectStoreBaseDir, options2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object configureWorkspace$suspendImpl(ProjectManagerImpl $this, Project project, Path projectStoreBaseDir, OpenProjectTask options, Continuation<? super Module> $completion) {
        block11: {
            if (!($completion instanceof configureWorkspace.1)) ** GOTO lbl-1000
            var8_5 = $completion;
            if ((var8_5.label & -2147483648) != 0) {
                var8_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl($this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ProjectManagerImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ProjectManagerImpl.configureWorkspace$suspendImpl(this.this$0, null, null, null, (Continuation<? super Module>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!options.getRunConfigurators()) ** GOTO lbl39
                    if (options.isNewProject()) ** GOTO lbl40
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                    $continuation.L$1 = project;
                    $continuation.L$2 = projectStoreBaseDir;
                    $continuation.L$3 = options;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(ModuleManager.class, (Continuation)$continuation);
                    if (v0 == var9_7) {
                        return var9_7;
                    }
                    ** GOTO lbl38
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$4;
                    options = (OpenProjectTask)$continuation.L$3;
                    projectStoreBaseDir = (Path)$continuation.L$2;
                    project = (Project)$continuation.L$1;
                    $this = (ProjectManagerImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    if (((ModuleManager)v0).getModules().length == 0) ** GOTO lbl40
lbl39:
                    // 2 sources

                    if (!PlatformProjectOpenProcessorKt.isLoadedFromCacheButHasNoModules(project)) break block11;
lbl40:
                    // 3 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectStoreBaseDir);
                    $continuation.L$3 = options;
                    $continuation.L$4 = null;
                    $continuation.label = 2;
                    v1 = PlatformProjectOpenProcessor.Companion.runDirectoryProjectConfigurators(projectStoreBaseDir, project, options.isProjectCreatedWithWizard(), options.getCreateModule(), (Continuation<? super Module>)$continuation);
                    if (v1 == var9_7) {
                        return var9_7;
                    }
                    ** GOTO lbl57
                }
                case 2: {
                    options = (OpenProjectTask)$continuation.L$3;
                    projectStoreBaseDir = (Path)$continuation.L$2;
                    project = (Project)$continuation.L$1;
                    $this = (ProjectManagerImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl57:
                    // 2 sources

                    if ((module = (Module)v1) == null) break;
                    v2 = options.getPreparedToOpen();
                    if (v2 == null) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectStoreBaseDir);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)options);
                    $continuation.L$4 = module;
                    $continuation.label = 3;
                    v3 = v2.invoke((Object)module, (Object)$continuation);
                    if (v3 == var9_7) {
                        return var9_7;
                    }
                    break;
                }
                case 3: {
                    module = (Module)$continuation.L$4;
                    options = (OpenProjectTask)$continuation.L$3;
                    projectStoreBaseDir = (Path)$continuation.L$2;
                    project = (Project)$continuation.L$1;
                    $this = (ProjectManagerImpl)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    break;
                }
            }
            return module;
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object checkExistingProjectOnOpen(Project projectToClose, OpenProjectTask options, Path projectDir, Continuation<? super Boolean> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final Object tryToOpen(Project projectToClose, ProjectAttachProcessor processor, OpenProjectTask options, Path projectDir, Continuation<? super Boolean> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Object closeAndDisposeKeepingFrame(Project project2, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, project2, null){
            Object L$1;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ProjectManagerImpl this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $i$f$serviceAsync = 0;
                        v0 = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                        $this$serviceAsync$iv$iv = (ComponentManager)v0;
                        $i$f$serviceAsync = 0;
                        this.L$0 = $this$withContext;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                        this.I$0 = $i$f$serviceAsync;
                        this.I$1 = $i$f$serviceAsync;
                        this.label = 1;
                        v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(WindowManager.class, (Continuation)this);
                        ** if (v1 != var8_3) goto lbl21
lbl20:
                        // 1 sources

                        return var8_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 1: {
                        $i$f$serviceAsync = this.I$1;
                        $i$f$serviceAsync = this.I$0;
                        $this$serviceAsync$iv$iv = (ComponentManager)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.WindowManagerEx");
                        windowManager = (WindowManagerEx)v1;
                        this.L$0 = $this$withContext;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)windowManager);
                        this.label = 2;
                        v2 = com.intellij.openapi.application.CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.wm.ex.WindowManagerEx com.intellij.openapi.project.impl.ProjectManagerImpl com.intellij.openapi.project.Project ), ()Ljava/lang/Boolean;)((WindowManagerEx)windowManager, (ProjectManagerImpl)this.this$0, (Project)this.$project), (Continuation)((Continuation)this));
                        ** if (v2 != var8_3) goto lbl40
lbl39:
                        // 1 sources

                        return var8_3;
lbl40:
                        // 1 sources

                        ** GOTO lbl47
                    }
                    case 2: {
                        windowManager = (WindowManagerEx)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl47:
                            // 2 sources

                            var3_11 = (Boolean)v2;
                        }
                        catch (CancellationException ce) {
                            CoroutineScopeKt.ensureActive((CoroutineScope)$this$withContext);
                            ProjectManagerImplKt.access$getLOG$p().error((Throwable)ce);
                            var3_11 = true;
                        }
                        catch (Throwable e) {
                            ProjectManagerImplKt.access$getLOG$p().error(e);
                            var3_11 = true;
                        }
                        return Boxing.boxBoolean((boolean)(var3_11 != false));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final boolean invokeSuspend$lambda$0(WindowManagerEx $windowManager, ProjectManagerImpl this$0, Project $project) {
                boolean bl;
                AutoCloseable autoCloseable = $windowManager.withFrameReuseEnabled();
                Throwable throwable = null;
                try {
                    AutoCloseable it = autoCloseable;
                    boolean bl2 = false;
                    bl = ProjectManagerImpl.closeProject$default(this$0, $project, false, false, true, 6, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return bl;
            }
        }), $completion);
    }

    private static final void testOnlyGetExcludedUrlsCallback$lambda$1(ProjectManagerImpl this$0) {
        this$0.getAllExcludedUrlsCallback = null;
    }

    private static final Unit closeProject$lambda$5$0() {
        TimedZipHandler.closeOpenZipReferences();
        return Unit.INSTANCE;
    }

    private static final Unit closeProject$lambda$5$1() {
        ZipHandler.clearFileAccessorCache();
        return Unit.INSTANCE;
    }

    private static final void closeProject$lambda$1(ProjectImpl $projectImpl, ProjectManagerImpl this$0, Project $project) {
        $projectImpl.disposeEarlyDisposable();
        $projectImpl.setTemporarilyDisposed(true);
        this$0.removeFromOpened($project);
    }

    private static final void closeProject$lambda$2(Project $project) {
        if ($project instanceof ProjectImpl) {
            ((ProjectImpl)$project).disposeEarlyDisposable();
            ((ProjectImpl)$project).startDispose();
        }
        Disposer.dispose((Disposable)((Disposable)$project));
    }

    private static final void closeProject$lambda$5(ProjectManagerImpl this$0, Project $project, boolean $dispose, long $projectCloseStartedMs, long $projectSaveSettingsDurationMs, long $projectClosingDurationMs) {
        this$0.removeFromOpened($project);
        if ($project instanceof ProjectImpl) {
            ((ProjectImpl)$project).disposeEarlyDisposable();
            if ($dispose) {
                ((ProjectImpl)$project).startDispose();
            }
        }
        ProjectManagerImplKt.access$fireProjectClosed($project);
        if (!ApplicationManagerEx.getApplicationEx().isExitInProgress()) {
            Function0[] function0Array = new Function0[]{ProjectManagerImpl::closeProject$lambda$5$0, ProjectManagerImpl::closeProject$lambda$5$1};
            Suppressions.runSuppressing((Function0[])function0Array);
        }
        LaterInvocator.purgeExpiredItems();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if ($dispose) {
            Disposer.dispose((Disposable)((Disposable)$project));
        }
        long projectDisposeDurationMs = System.currentTimeMillis() - start$iv;
        LifecycleUsageTriggerCollector.onProjectClosedAndDisposed($project, $projectCloseStartedMs, $projectSaveSettingsDurationMs, $projectClosingDurationMs, projectDisposeDurationMs);
    }

    private static final List addProjectManagerListener$lambda$0() {
        return ContainerUtil.createLockFreeCopyOnWriteList();
    }

    private static final void handleErrorOnNewProject$lambda$0(String $errorMessage) {
        Messages.showErrorDialog((String)$errorMessage, (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
    }

    private static final void prepareProject$lambda$0(ConversionResult $conversionResult, ProjectImpl $project) {
        $conversionResult.postStartupActivity((Project)$project);
    }

    private static final void checkExistingProjectOnOpen$lambda$0(ApplicationEx $app) {
        $app.exit(true, true);
    }

    @JvmStatic
    @TestOnly
    public static final boolean isLight(@NotNull Project project2) {
        return Companion.isLight(project2);
    }

    public static final /* synthetic */ Object access$prepareProject(ProjectManagerImpl $this, Path projectIdentityFile, String projectName, Function1 beforeInit, ProjectInitHelper projectInitHelper, boolean runConversionBeforeOpen, boolean preloadServices, Continuation $completion) {
        return $this.prepareProject(projectIdentityFile, projectName, (Function1<? super Project, Unit>)beforeInit, projectInitHelper, runConversionBeforeOpen, preloadServices, (Continuation<? super Project>)$completion);
    }

    public static final /* synthetic */ Object access$openProjectAsyncImpl(ProjectManagerImpl $this, Path projectIdentityFile, OpenProjectTask options2, Continuation $completion) {
        return $this.openProjectAsyncImpl(projectIdentityFile, options2, (Continuation<? super Project>)$completion);
    }

    public static final /* synthetic */ Object access$cancelProjectOpening(ProjectManagerImpl $this, Project project2, CancellationException e, Continuation $completion) {
        return $this.cancelProjectOpening(project2, e, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$doOpenAsync(ProjectManagerImpl $this, OpenProjectTask options2, Path projectIdentityFile, Continuation $completion) {
        return $this.doOpenAsync(options2, projectIdentityFile, (Continuation<? super Project>)$completion);
    }

    public static final /* synthetic */ Object access$failedToOpenProject(ProjectManagerImpl $this, ProjectFrameAllocator frameAllocator, Throwable exception, OpenProjectTask options2, Continuation $completion) {
        return $this.failedToOpenProject(frameAllocator, exception, options2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$prepareNewProject(ProjectManagerImpl $this, Path identityFle, String projectName, Function1 beforeInit, boolean useDefaultProjectAsTemplate, boolean preloadServices, boolean markAsNewlyCreated, boolean markAsNew, Continuation $completion) {
        return $this.prepareNewProject(identityFle, projectName, (Function1<? super Project, Unit>)beforeInit, useDefaultProjectAsTemplate, preloadServices, markAsNewlyCreated, markAsNew, (Continuation<? super Project>)$completion);
    }

    public static final /* synthetic */ Object access$acquireTemplateProject(ProjectManagerImpl $this, Continuation $completion) {
        return $this.acquireTemplateProject((Continuation<? super Project>)$completion);
    }

    public static final /* synthetic */ Object access$runConversion(ProjectManagerImpl $this, Path projectPath, Continuation $completion) {
        return $this.runConversion(projectPath, (Continuation<? super ConversionResult>)$completion);
    }

    public static final /* synthetic */ Object access$checkExistingProjectOnOpen(ProjectManagerImpl $this, Project projectToClose, OpenProjectTask options2, Path projectDir, Continuation $completion) {
        return $this.checkExistingProjectOnOpen(projectToClose, options2, projectDir, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$tryToOpen(ProjectManagerImpl $this, Project projectToClose, ProjectAttachProcessor processor2, OpenProjectTask options2, Path projectDir, Continuation $completion) {
        return $this.tryToOpen(projectToClose, processor2, options2, projectDir, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$closeAndDisposeKeepingFrame(ProjectManagerImpl $this, Project project2, Continuation $completion) {
        return $this.closeAndDisposeKeepingFrame(project2, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\tH\u0080@\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/project/impl/ProjectManagerImpl$Companion;", "", "<init>", "()V", "isLight", "", "project", "Lcom/intellij/openapi/project/Project;", "dispatchEarlyNotifications", "", "dispatchEarlyNotifications$intellij_platform_ide_impl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initEssentialProjectPreInit", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        public final boolean isLight(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return project2 instanceof ProjectEx && ((ProjectEx)project2).isLight();
        }

        @Nullable
        public final Object dispatchEarlyNotifications$intellij_platform_ide_impl(@NotNull Continuation<? super Unit> $completion) {
            NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
            Intrinsics.checkNotNull((Object)notificationsManager, (String)"null cannot be cast to non-null type com.intellij.notification.impl.NotificationsManagerImpl");
            NotificationsManagerImpl notificationManager = (NotificationsManagerImpl)notificationsManager;
            CoroutineContext coroutineContext = com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.nonModal();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
            Object object = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(notificationManager, null){
                int label;
                final /* synthetic */ NotificationsManagerImpl $notificationManager;
                {
                    this.$notificationManager = $notificationManager;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$notificationManager.dispatchEarlyNotifications();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public final Object initEssentialProjectPreInit(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
            Object object = ProjectManagerImplKt.access$runApprovedExtensions(project2, "com.intellij.projectPreInit", true, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

