/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.FileVisibilityProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.openapi.vfs.impl.FilePermissionManager;
import com.intellij.serviceContainer.ContextKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vfs/impl/FilePermissionManagerImpl;", "Lcom/intellij/openapi/vfs/impl/FilePermissionManager;", "<init>", "()V", "isReadGranted", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isWriteGranted", "getProject", "Lcom/intellij/openapi/project/Project;", "checkFileWritable", "project", "checkFileVisible", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFilePermissionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePermissionManagerImpl.kt\ncom/intellij/openapi/vfs/impl/FilePermissionManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n13#2:50\n*S KotlinDebug\n*F\n+ 1 FilePermissionManagerImpl.kt\ncom/intellij/openapi/vfs/impl/FilePermissionManagerImpl\n*L\n47#1:50\n*E\n"})
public final class FilePermissionManagerImpl
implements FilePermissionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public boolean isReadGranted(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project2 = this.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        return this.checkFileVisible(project3, file2);
    }

    public boolean isWriteGranted(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project2 = this.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        return this.checkFileVisible(project3, file2) && this.checkFileWritable(project3, file2);
    }

    private final Project getProject() {
        ComponentManager componentManager = ContextKt.contextComponentManager((CoroutineContext)ThreadContext.currentThreadContext());
        Project project2 = (Project)componentManager.getService(Project.class);
        if (project2 == null) {
            logger.warn("Can't get a project out of the current thread context. Current component manager: " + componentManager);
            return null;
        }
        return project2;
    }

    private final boolean checkFileWritable(Project project2, VirtualFile file2) {
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2, (Project)project2);
    }

    private final boolean checkFileVisible(Project project2, VirtualFile file2) {
        return FileVisibilityProvider.Companion.isVisible(project2, file2, ClientSessionsUtil.getCurrentSession((Project)project2).isOwner());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(FilePermissionManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vfs/impl/FilePermissionManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

