/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class VirtualFileInfoAction
extends AnAction
implements DumbAware {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(1, 1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathToFile;
        if (e == null) {
            VirtualFileInfoAction.$$$reportNull$$$0(0);
        }
        if ((pathToFile = Messages.showInputDialog((String)"Path to file: ", (String)"Virtual File Info", (Icon)Messages.getQuestionIcon())) == null) {
            return;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByIoFile(new File(pathToFile));
        if (virtualFile2 == null) {
            Messages.showErrorDialog((String)"Cannot find virtual file", (String)"Virtual File Info");
            return;
        }
        StringBuilder info = new StringBuilder();
        info.append("Path: ");
        info.append(virtualFile2.getPath());
        info.append("\n");
        info.append("Time stamp: ");
        info.append(DATE_FORMAT.format(new Date(virtualFile2.getTimeStamp())));
        info.append("\n");
        info.append("isValid: ");
        info.append(virtualFile2.isValid());
        info.append("\n");
        info.append("isWritable: ");
        info.append(virtualFile2.isWritable());
        info.append("\n");
        info.append("Content: ");
        try {
            info.append(VfsUtil.loadText((VirtualFile)virtualFile2));
        }
        catch (IOException e1) {
            info.append("<unable to load content>");
            info.append(e1.getMessage());
        }
        info.append("\n");
        Messages.showMessageDialog((String)info.toString(), (String)"Virtual File Info", (Icon)Messages.getInformationIcon());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VirtualFileInfoAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/VirtualFileInfoAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/VirtualFileInfoAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

