/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.dev;

import com.intellij.platform.util.io.storages.intmultimaps.Int2IntMultimap;
import java.util.Set;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InvertedFilenameHashBasedIndex {
    private final Int2IntMultimap nameHashToFileId;

    public InvertedFilenameHashBasedIndex() {
        this(16384);
    }

    public InvertedFilenameHashBasedIndex(int initialCapacity) {
        this.nameHashToFileId = new Int2IntMultimap(initialCapacity, 0.4f);
    }

    public boolean likelyFilesWithNames(@NotNull Set<String> names, @NotNull IntPredicate fileIdProcessor) {
        if (names == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(0);
        }
        if (fileIdProcessor == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(1);
        }
        for (String name2 : names) {
            int hash = InvertedFilenameHashBasedIndex.hashCodeOf(name2);
            if (this.nameHashToFileId.lookup(hash, fileIdProcessor)) continue;
            return false;
        }
        return true;
    }

    public void updateFileName(int fileId, @NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(3);
        }
        this.removeFileName(fileId, oldName);
        this.addFileName(fileId, newName);
    }

    public void removeFileName(int fileId, @NotNull String oldName) {
        if (oldName == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(4);
        }
        int oldHash = InvertedFilenameHashBasedIndex.hashCodeOf(oldName);
        this.nameHashToFileId.remove(oldHash, fileId);
    }

    public void addFileName(int fileId, @NotNull String newName) {
        if (newName == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(5);
        }
        int newHash = InvertedFilenameHashBasedIndex.hashCodeOf(newName);
        this.nameHashToFileId.put(newHash, fileId);
    }

    private static int hashCodeOf(@NotNull String oldName) {
        int hash;
        if (oldName == null) {
            InvertedFilenameHashBasedIndex.$$$reportNull$$$0(6);
        }
        if ((hash = oldName.hashCode()) == 0) {
            return -1;
        }
        return hash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIdProcessor";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/dev/InvertedFilenameHashBasedIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "likelyFilesWithNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hashCodeOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

