/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelperKt;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Rectangle;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ(\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0005R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "", "<init>", "()V", "value", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "info", "getInfo", "()Lcom/intellij/openapi/wm/impl/FrameInfo;", "isDirty", "", "()Z", "setDirty", "(Z)V", "updateFrameInfo", "", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "frame", "Ljavax/swing/JFrame;", "getModificationCount", "", "update", "project", "Lcom/intellij/openapi/project/Project;", "lastNormalFrameBounds", "Ljava/awt/Rectangle;", "windowManager", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "updateAndGetInfo", "copyFrom", "newInfo", "Companion", "intellij.platform.ide.impl"})
public final class FrameInfoHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FrameInfo info;
    private volatile boolean isDirty;

    @Nullable
    public final FrameInfo getInfo() {
        return this.info;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public final void updateFrameInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.info = FrameInfoHelperKt.updateFrameInfo(frameHelper, frame, null, this.info);
    }

    public final long getModificationCount() {
        FrameInfo frameInfo = this.info;
        return frameInfo != null ? frameInfo.getModificationCount() : 0L;
    }

    public final void update(@NotNull Project project2, @Nullable Rectangle lastNormalFrameBounds, @NotNull WindowManagerImpl windowManager) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)windowManager), (String)"windowManager");
        ProjectFrameHelper projectFrameHelper = windowManager.getFrameHelper(project2);
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper = projectFrameHelper;
        this.updateAndGetInfo(frameHelper, frameHelper.getFrame(), lastNormalFrameBounds, windowManager);
    }

    @NotNull
    public final FrameInfo updateAndGetInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame, @Nullable Rectangle lastNormalFrameBounds, @NotNull WindowManagerImpl windowManager) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)((Object)windowManager), (String)"windowManager");
        FrameInfo newInfo = FrameInfoHelperKt.updateFrameInfo(frameHelper, frame, lastNormalFrameBounds, this.info);
        windowManager.getDefaultFrameInfoHelper$intellij_platform_ide_impl().copyFrom(newInfo);
        this.info = newInfo;
        this.isDirty = false;
        return newInfo;
    }

    public final void copyFrom(@NotNull FrameInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)newInfo), (String)"newInfo");
        if (this.info == null) {
            this.info = new FrameInfo();
        }
        FrameInfo frameInfo = this.info;
        Intrinsics.checkNotNull((Object)((Object)frameInfo));
        BaseState.copyFrom$default((BaseState)frameInfo, (BaseState)newInfo, (boolean)false, (int)2, null);
        this.isDirty = false;
    }

    @JvmStatic
    public static final boolean isMaximized(int state2) {
        return Companion.isMaximized(state2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0001J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/FrameInfoHelper$Companion;", "", "<init>", "()V", "isFullScreenSupportedInCurrentOs", "", "isMaximized", "state", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="isFullScreenSupportedInCurrentOs")
        public final boolean isFullScreenSupportedInCurrentOs() {
            return SystemInfoRt.isMac || SystemInfoRt.isWindows || StartupUiUtil.isXToolkit() && X11UiUtil.isFullScreenSupported() || StartupUiUtil.isWaylandToolkit() && UIUtil.isFullScreenSupportedByDefaultGD();
        }

        @JvmStatic
        public final boolean isMaximized(int state2) {
            return (state2 & 6) == 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

