/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentComboLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class ComboContentLayout
extends ContentLayout {
    ContentComboLabel comboLabel;

    ComboContentLayout(ToolWindowContentUi ui) {
        super(ui);
    }

    @Override
    public void init(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            ComboContentLayout.$$$reportNull$$$0(0);
        }
        this.reset();
        this.idLabel = new BaseLabel(this.ui, ExperimentalUI.isNewUI());
        MouseDragHelper.setComponentDraggable((JComponent)this.idLabel, (boolean)true);
        this.comboLabel = new ContentComboLabel(this);
    }

    @Override
    public void reset() {
        this.idLabel = null;
        this.comboLabel = null;
    }

    @Override
    public void layout() {
        Rectangle bounds = this.ui.getTabComponent().getBounds();
        JBDimension idSize = this.isIdVisible() ? this.idLabel.getPreferredSize() : JBUI.emptySize();
        int eachX = 0;
        int eachY = 0;
        this.idLabel.setBounds(eachX, eachY, idSize.width, bounds.height);
        Dimension comboSize = this.comboLabel.getPreferredSize();
        int nonLabelWidth = this.getTabToolbarPreferredWidth();
        int spaceLeft = bounds.width - (eachX += idSize.width) - nonLabelWidth - (this.isToDrawCombo() && this.isIdVisible() ? 3 : 0);
        int width = comboSize.width;
        if (width > spaceLeft) {
            width = spaceLeft;
        }
        this.comboLabel.setBounds(eachX, eachY, width, bounds.height);
        eachX += width;
        ActionToolbar tabToolbar = this.ui.getTabToolbar();
        if (tabToolbar != null) {
            JComponent component2 = tabToolbar.getComponent();
            Dimension size2 = component2.getPreferredSize();
            component2.setBounds(eachX, eachY + (bounds.height - size2.height) / 2, size2.width, size2.height);
            eachX += component2.getWidth();
        }
    }

    @Override
    public int getMinimumWidth() {
        return (this.idLabel == null ? 0 : this.idLabel.getPreferredSize().width) + this.getTabToolbarPreferredWidth();
    }

    @Override
    public void update() {
        this.updateIdLabel(this.idLabel);
        this.comboLabel.update();
    }

    @Override
    public void rebuild() {
        JPanel tabComponent = this.ui.getTabComponent();
        tabComponent.removeAll();
        tabComponent.add(this.idLabel);
        ToolWindowContentUi.initMouseListeners(this.idLabel, this.ui, true);
        tabComponent.add(this.comboLabel);
        ToolWindowContentUi.initMouseListeners(this.comboLabel, this.ui, false);
        this.ui.connectTabToolbar();
    }

    boolean isToDrawCombo() {
        return this.ui.getContentManager().getContentCount() > 1;
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        int width = this.comboLabel.getSize().width;
        listPopup.setMinimumSize(new Dimension(width, 0));
        listPopup.show(new RelativePoint((Component)this.comboLabel, new Point(0, this.comboLabel.getHeight())));
    }

    @Override
    @NlsActions.ActionText
    public String getCloseActionName() {
        return IdeBundle.message((String)"action.ComboContentLayout.close.view.text", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getCloseAllButThisActionName() {
        return IdeBundle.message((String)"action.ComboContentLayout.close.other.views.text", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getPreviousContentActionName() {
        return IdeBundle.message((String)"action.ComboContentLayout.select.previous.view.text", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getNextContentActionName() {
        return IdeBundle.message((String)"action.ComboContentLayout.select.next.view.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/openapi/wm/impl/content/ComboContentLayout", "init"));
    }
}

