/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.bootstrap;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.Gray;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ide/bootstrap/Splash;", "Ljava/awt/Dialog;", "image", "Ljava/awt/image/BufferedImage;", "isAlwaysOnTop", "", "<init>", "(Ljava/awt/image/BufferedImage;Z)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.platform.ide.impl"})
public final class Splash
extends Dialog {
    @NotNull
    private final BufferedImage image;

    public Splash(@NotNull BufferedImage image2, boolean isAlwaysOnTop) {
        Insets insets;
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        super((Frame)null, "splash");
        this.image = image2;
        this.setUndecorated(true);
        this.setBackground(Gray.TRANSPARENT);
        if (isAlwaysOnTop) {
            this.setAlwaysOnTop(true);
        }
        this.setResizable(false);
        this.setFocusableWindowState(isAlwaysOnTop);
        Dimension size2 = new Dimension(this.image.getWidth(), this.image.getHeight());
        this.setSize(size2);
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Rectangle bounds = graphicsConfiguration.getBounds();
        if (SystemInfoRt.isWindows && (insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration)) != null) {
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        Intrinsics.checkNotNull((Object)bounds);
        this.setLocation(StartupUiUtil.getCenterPoint((Rectangle)bounds, (Dimension)size2));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        StartupUiUtil.drawImage$default((Graphics)g, (Image)this.image, (int)0, (int)0, (int)0, (int)0, null, null, null, (int)496, null);
    }
}

