/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class ContextFormattingRangesExtender {
    private static final Logger LOG = Logger.getInstance(ContextFormattingRangesExtender.class);
    private static final int MAX_EXTENSION_LINES = 10;
    private final Document myDocument;
    private final PsiFile myFile;

    ContextFormattingRangesExtender(@NotNull Document document2, PsiFile file2) {
        if (document2 == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(0);
        }
        this.myDocument = document2;
        this.myFile = file2;
    }

    public @Unmodifiable List<TextRange> getExtendedRanges(@NotNull List<? extends TextRange> ranges) {
        if (ranges == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(1);
        }
        return ContainerUtil.map(ranges, range -> this.processRange((TextRange)range));
    }

    private TextRange processRange(@NotNull TextRange originalRange) {
        TextRange validRange;
        ASTNode containingNode;
        if (originalRange == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(2);
        }
        if ((containingNode = CodeFormatterFacade.findContainingNode(this.myFile, this.expandToLine(validRange = this.ensureRangeIsValid(originalRange)))) != null && !validRange.isEmpty()) {
            return this.narrowToMaxExtensionLines(validRange, this.getRangeWithSiblings(containingNode));
        }
        return validRange;
    }

    private TextRange narrowToMaxExtensionLines(@NotNull TextRange original, @NotNull TextRange result2) {
        if (original == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(4);
        }
        int startLine = Math.max(this.myDocument.getLineNumber(result2.getStartOffset()), this.myDocument.getLineNumber(original.getStartOffset()) - 10);
        int endLine = Math.min(this.myDocument.getLineNumber(result2.getEndOffset() - 1), this.myDocument.getLineNumber(original.getEndOffset() - 1) + 10);
        int rangeStart = Math.max(result2.getStartOffset(), this.myDocument.getLineStartOffset(startLine));
        int rangeEnd = Math.min(result2.getEndOffset(), this.myDocument.getLineEndOffset(endLine));
        return new TextRange(rangeStart, rangeEnd);
    }

    private TextRange ensureRangeIsValid(@NotNull TextRange range) {
        int docLength;
        if (range == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(5);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > (docLength = this.myDocument.getTextLength())) {
            LOG.warn("The given range " + endOffset + " exceeds the document length " + docLength);
            return new TextRange(Math.min(startOffset, docLength), docLength);
        }
        return range;
    }

    @Nullable
    private TextRange trimSpaces(@NotNull TextRange range) {
        if (range == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(6);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        startOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset, (String)" \t");
        if (startOffset == endOffset) {
            return null;
        }
        endOffset = CharArrayUtil.shiftBackward((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset, (String)" \t");
        return new TextRange(startOffset, endOffset);
    }

    private TextRange expandToLine(@NotNull TextRange range) {
        int lineEnd;
        int lineStart;
        TextRange lineRange;
        int line;
        if (range == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(7);
        }
        if ((line = this.myDocument.getLineNumber(range.getStartOffset())) == this.myDocument.getLineNumber(Math.min(range.getEndOffset(), this.myDocument.getTextLength())) && (lineRange = this.trimSpaces(new TextRange(lineStart = this.myDocument.getLineStartOffset(line), lineEnd = this.myDocument.getLineEndOffset(line)))) != null) {
            return lineRange;
        }
        return range;
    }

    @NotNull
    private TextRange getRangeWithSiblings(@NotNull ASTNode astNode) {
        ASTNode sibling;
        if (astNode == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(8);
        }
        Ref result2 = Ref.create((Object)astNode.getTextRange());
        IElementType elementType = astNode.getElementType();
        for (sibling = astNode.getTreePrev(); sibling != null && ContextFormattingRangesExtender.processSibling(sibling, (Ref<TextRange>)result2, elementType); sibling = sibling.getTreePrev()) {
        }
        for (sibling = astNode.getTreeNext(); sibling != null && ContextFormattingRangesExtender.processSibling(sibling, (Ref<TextRange>)result2, elementType); sibling = sibling.getTreeNext()) {
        }
        assert (((TextRange)result2.get()).getEndOffset() <= this.myDocument.getTextLength()) : "PSI-document mismatch";
        TextRange textRange = (TextRange)result2.get();
        if (textRange == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static boolean processSibling(@NotNull ASTNode node, @NotNull Ref<TextRange> rangeRef, @NotNull IElementType siblingType) {
        if (node == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(10);
        }
        if (rangeRef == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(11);
        }
        if (siblingType == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(12);
        }
        if (node.getPsi() instanceof PsiWhiteSpace) {
            return !ContextFormattingRangesExtender.hasMinLineBreaks(node, 2);
        }
        if (node.getElementType() == siblingType) {
            rangeRef.set((Object)((TextRange)rangeRef.get()).union(node.getTextRange()));
        }
        return false;
    }

    private static boolean hasMinLineBreaks(@NotNull ASTNode node, int lineBreaks) {
        if (node == null) {
            ContextFormattingRangesExtender.$$$reportNull$$$0(13);
        }
        int count = 0;
        for (int i2 = 0; i2 < node.getChars().length(); ++i2) {
            if (node.getChars().charAt(i2) == '\n') {
                ++count;
            }
            if (count < lineBreaks) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/ContextFormattingRangesExtender";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeRef";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/ContextFormattingRangesExtender";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "narrowToMaxExtensionLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureRangeIsValid";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trimSpaces";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandToLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRangeWithSiblings";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSibling";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasMinLineBreaks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

