/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.ScalarProperty;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.stateProperties.ObjectStateStoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/serialization/stateProperties/ObjectStoredProperty;", "T", "Lcom/intellij/serialization/stateProperties/ObjectStateStoredPropertyBase;", "Lcom/intellij/openapi/components/ScalarProperty;", "defaultValue", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "isEqualToDefault", "", "getModificationCount", "", "parseAndSetValue", "", "rawValue", "", "intellij.platform.objectSerializer"})
public class ObjectStoredProperty<T>
extends ObjectStateStoredPropertyBase<T>
implements ScalarProperty {
    private final T defaultValue;

    public ObjectStoredProperty(T defaultValue) {
        super(defaultValue);
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public JsonSchemaType getJsonType() {
        return this.defaultValue instanceof Boolean ? JsonSchemaType.BOOLEAN : JsonSchemaType.OBJECT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualToDefault() {
        Object value = this.getValue();
        if (Intrinsics.areEqual(this.defaultValue, value)) return true;
        if (!(value instanceof BaseState)) return false;
        BaseState baseState = (BaseState)value;
        if (baseState == null) return false;
        boolean bl = baseState.isEqualToDefault();
        if (!bl) return false;
        return true;
    }

    public long getModificationCount() {
        Object t = this.getValue();
        ModificationTracker modificationTracker = t instanceof ModificationTracker ? (ModificationTracker)t : null;
        return modificationTracker != null ? modificationTracker.getModificationCount() : 0L;
    }

    public void parseAndSetValue(@Nullable String rawValue) {
        this.setValue(StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"yes") || StringUtil.equalsIgnoreCase((CharSequence)rawValue, (CharSequence)"on"));
    }
}

