/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<? super T, String> myToStringConvertor;

    protected ListSpeedSearch(@NotNull JList<T> list2, Void sig, @Nullable Function<? super T, String> convertor) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(0);
        }
        super(list2, sig);
        this.myToStringConvertor = convertor;
    }

    @NotNull
    public static <T> ListSpeedSearch<T> installOn(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(1);
        }
        return ListSpeedSearch.installOn(list2, null);
    }

    @NotNull
    public static <T> ListSpeedSearch<T> installOn(@NotNull JList<T> list2, @Nullable Function<? super T, String> convertor) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(2);
        }
        ListSpeedSearch<T> search = new ListSpeedSearch<T>(list2, null, convertor);
        search.setupListeners();
        ListSpeedSearch<T> listSpeedSearch = search;
        if (listSpeedSearch == null) {
            ListSpeedSearch.$$$reportNull$$$0(3);
        }
        return listSpeedSearch;
    }

    @Deprecated
    public ListSpeedSearch(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(4);
        }
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    @Deprecated
    public ListSpeedSearch(@NotNull JList<T> list2, @NotNull Function<? super T, String> convertor) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(5);
        }
        if (convertor == null) {
            ListSpeedSearch.$$$reportNull$$$0(6);
        }
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    @Override
    public void setupListeners() {
        super.setupListeners();
        this.registerSelectAll((JList)this.myComponent);
    }

    private void registerSelectAll(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(7);
        }
        new MySelectAllAction<T>(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        if (element != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected int getElementCount() {
        return ((JList)this.myComponent).getModel().getSize();
    }

    @Override
    protected Object getElementAt(int viewIndex) {
        return ((JList)this.myComponent).getModel().getElementAt(viewIndex);
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element);
        }
        return element == null ? null : element.toString();
    }

    @NotNull
    private IntList findAllFilteredElements(@NotNull String s) {
        if (s == null) {
            ListSpeedSearch.$$$reportNull$$$0(8);
        }
        IntArrayList indices = new IntArrayList();
        String trimmed = s.trim();
        ListIterator<Object> iterator2 = this.getElementIterator(0);
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            if (!this.isMatchingElement(element, trimmed)) continue;
            indices.add(iterator2.previousIndex());
        }
        IntArrayList intArrayList = indices;
        if (intArrayList == null) {
            ListSpeedSearch.$$$reportNull$$$0(9);
        }
        return intArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "installOn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerSelectAll";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAllFilteredElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }

    private static final class MySelectAllAction<T>
    extends DumbAwareAction {
        @NotNull
        private final JList<T> myList;
        @NotNull
        private final ListSpeedSearch<T> mySearch;

        MySelectAllAction(@NotNull JList<T> list2, @NotNull ListSpeedSearch<T> search) {
            if (list2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.mySearch = search;
            AnAction action2 = ActionManager.getInstance().getAction("$SelectAll");
            if (action2 != null) {
                this.copyShortcutFrom(action2);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(4);
            }
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            IntList filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toIntArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor);
                sm.setAnchorSelectionIndex(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    ListIterator<Object> iterator2 = this.mySearch.getElementIterator(0);
                    while (iterator2.hasNext()) {
                        if (iterator2.next() != currentElement) continue;
                        anchor = iterator2.previousIndex();
                        break;
                    }
                }
                if (anchor == -1) {
                    anchor = filtered.getInt(0);
                }
                this.myList.setSelectedIndices(filtered.toIntArray());
                sm.setAnchorSelectionIndex(anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ListSpeedSearch$MySelectAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ListSpeedSearch$MySelectAllAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

