/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.ShowUIDefaultsContent;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.speedSearch.FilteringTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GrayFilter;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(0);
        }
        Project project2 = ShowUIDefaultsAction.getEventProject((AnActionEvent)e);
        this.perform(project2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void perform(final Project project2) {
        new DialogWrapper(this, project2, true){
            private ShowUIDefaultsContent content;
            {
                super(arg0, arg1);
                this.setTitle(IdeBundle.message((String)"dialog.title.edit.laf.defaults", (Object[])new Object[0]));
                this.setModal(false);
                this.init();
            }

            protected void doOKAction() {
                super.doOKAction();
                LafManager.getInstance().updateUI();
                this.content.storeState();
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return project2 == null ? null : "UI.Defaults.Dialog";
            }

            protected JComponent createCenterPanel() {
                JBTable table2 = new JBTable((TableModel)ShowUIDefaultsAction.createFilteringModel()){

                    public boolean editCellAt(final int row2, final int column, EventObject e) {
                        if (this.isCellEditable(row2, column) && e instanceof MouseEvent) {
                            final Pair pair = (Pair)this.getValueAt(row2, 0);
                            Object key = pair.first;
                            Object value = pair.second;
                            final Ref changed = Ref.create((Object)false);
                            if (value instanceof Color) {
                                ColorChooserService.getInstance().showPopup(null, (Color)value, new ColorListener(){

                                    public void colorChanged(Color color, Object source) {
                                        if (color != null) {
                                            ColorUIResource colorUIResource = new ColorUIResource(color);
                                            this.updateValue(pair, colorUIResource, row2, column);
                                            changed.set((Object)true);
                                        }
                                    }
                                });
                            } else if (value instanceof Boolean) {
                                this.updateValue(pair, (Boolean)value == false, row2, column);
                                changed.set((Object)true);
                            } else if (value instanceof Integer) {
                                Integer newValue = this.editNumber(key.toString(), value.toString(), Integer::parseInt);
                                if (newValue != null) {
                                    this.updateValue(pair, newValue, row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof Float) {
                                Float newValue = this.editNumber(key.toString(), value.toString(), Float::parseFloat);
                                if (newValue != null) {
                                    this.updateValue(pair, newValue, row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof EmptyBorder) {
                                Insets i2 = ((Border)value).getBorderInsets(null);
                                String oldInsets = String.format("%d,%d,%d,%d", i2.top, i2.left, i2.bottom, i2.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, new JBEmptyBorder(newInsets), row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof Insets) {
                                Insets i3 = (Insets)value;
                                String oldInsets = String.format("%d,%d,%d,%d", i3.top, i3.left, i3.bottom, i3.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, newInsets, row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof GrayFilter) {
                                GrayFilter f = (GrayFilter)value;
                                String oldFilter = String.format("%d,%d,%d", f.getBrightness(), f.getContrast(), f.getAlpha());
                                GrayFilter newValue = this.editGrayFilter(key.toString(), oldFilter);
                                if (newValue != null) {
                                    this.updateValue(pair, newValue, row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof Font) {
                                Font newValue = this.editFontSize(key.toString(), (Font)value);
                                if (newValue != null) {
                                    UIManager.getDefaults().remove(key);
                                    UIManager.getDefaults().put(key, newValue);
                                    this.setValueAt(newValue, row2, column);
                                    changed.set((Object)true);
                                }
                            } else if (value instanceof Dimension) {
                                Dimension d = (Dimension)value;
                                String oldDimension = String.format("%d,%d", d.width, d.height);
                                Dimension newDimension = this.editDimension(key.toString(), oldDimension);
                                if (newDimension != null) {
                                    this.updateValue(pair, newDimension, row2, column);
                                    changed.set((Object)true);
                                }
                            }
                            if (((Boolean)changed.get()).booleanValue()) {
                                ApplicationManager.getApplication().invokeLater(() -> LafManager.getInstance().repaintUI());
                            }
                            PropertiesComponent.getInstance().setValue("LaFDialog.lastSelectedElement", key.toString());
                        }
                        return false;
                    }

                    void updateValue(Pair<?, ?> value, Object newValue, int row2, int col) {
                        UIManager.getDefaults().remove(value.first);
                        UIManager.getDefaults().put(value.first, newValue);
                        this.setValueAt(Pair.create((Object)value.first, (Object)newValue), row2, col);
                    }
                };
                table2.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                        TableCellRenderer renderer2;
                        Object object = value = column == 0 ? ((Pair)value).first : ((Pair)value).second;
                        if (value instanceof Boolean && (renderer2 = table2.getDefaultRenderer(Boolean.class)) != null) {
                            JCheckBox box = (JCheckBox)renderer2.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row2, column);
                            box.setHorizontalAlignment(2);
                            return box;
                        }
                        JLabel label2 = new JLabel(value == null ? "" : value.toString());
                        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)label2);
                        if (value instanceof Color) {
                            Color c = (Color)value;
                            label2.setText(String.format("  [%d,%d,%d] #%s", c.getRed(), c.getGreen(), c.getBlue(), StringUtil.toUpperCase((String)ColorUtil.toHex((Color)c))));
                            Gray fg = ColorUtil.isDark((Color)c) ? Gray.xFF : Gray.x00;
                            label2.setForeground((Color)fg);
                            panel2.setBackground(c);
                            return panel2;
                        }
                        if (value instanceof Icon) {
                            try {
                                IconWrap icon2 = new IconWrap((Icon)value);
                                if (icon2.getIconHeight() <= 20) {
                                    label2.setIcon(icon2);
                                }
                                label2.setText(String.format("(%dx%d) %s)", icon2.getIconWidth(), icon2.getIconHeight(), label2.getText()));
                            }
                            catch (Throwable icon2) {
                                // empty catch block
                            }
                            return panel2;
                        }
                        if (value instanceof Border) {
                            try {
                                Insets i2 = ((Border)value).getBorderInsets(null);
                                label2.setText(String.format("[%d, %d, %d, %d] %s", i2.top, i2.left, i2.bottom, i2.right, label2.getText()));
                                return panel2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row2, column);
                    }
                });
                TableSpeedSearch.installOn((JTable)table2, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, cell) -> cell.column == 1 ? null : String.valueOf(o)));
                table2.setShowGrid(false);
                TableHoverListener.DEFAULT.removeFrom((JComponent)table2);
                this.content = new ShowUIDefaultsContent(table2);
                DataProvider provider = dataId -> {
                    int[] rows;
                    if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && (this.content.searchField.hasFocus() && StringUtil.isEmpty((String)this.content.searchField.getSelectedText()) || this.content.table.hasFocus()) && (rows = this.content.table.getSelectedRows()).length > 0) {
                        return new TextCopyProvider(){

                            @NotNull
                            public ActionUpdateThread getActionUpdateThread() {
                                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                                if (actionUpdateThread == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                return actionUpdateThread;
                            }

                            public Collection<String> getTextLinesToCopy() {
                                ArrayList<String> result2 = new ArrayList<String>();
                                String tail = rows.length > 1 ? "," : "";
                                for (int row2 : rows) {
                                    Pair pair = (Pair)content.table.getModel().getValueAt(row2, 0);
                                    if (pair.second instanceof Color) {
                                        result2.add("\"" + pair.first.toString() + "\": \"" + ColorUtil.toHtmlColor((Color)((Color)pair.second)) + "\"" + tail);
                                        continue;
                                    }
                                    result2.add("\"" + pair.first.toString() + "\": \"" + String.valueOf(pair.second) + "\"" + tail);
                                }
                                return result2;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ShowUIDefaultsAction$1$3", "getActionUpdateThread"));
                            }
                        };
                    }
                    return null;
                };
                DataManager.registerDataProvider((JComponent)this.content.table, (DataProvider)provider);
                DataManager.registerDataProvider((JComponent)this.content.searchField, (DataProvider)provider);
                return this.content.panel;
            }

            @Nullable
            private <T> T editNumber(String key, String value, final Function<? super String, ? extends T> parser) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)IdeBundle.message((String)"dialog.message.enter.new.value.for.0", (Object[])new Object[]{key}), (String)IdeBundle.message((String)"dialog.title.number.editor", (Object[])new Object[0]), null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        try {
                            parser.apply(inputString);
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? (T)parser.apply(newValue) : null;
            }

            @Nullable
            private Insets editInsets(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)IdeBundle.message((String)"dialog.message.enter.new.value.for.0.in.form.top.left.bottom.right", (Object[])new Object[]{key}), (String)IdeBundle.message((String)"dialog.title.insets.editor", (Object[])new Object[0]), null, (String)value, (InputValidator)new InputValidator(this){

                    public boolean checkInput(String inputString) {
                        return 1.parseInsets(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? 1.parseInsets(newValue) : null;
            }

            @Nullable
            private static Insets parseInsets(String value) {
                Object[] parts = value.split(",");
                if (parts.length != 4) {
                    return null;
                }
                try {
                    List v = ContainerUtil.map((Object[])parts, p -> Integer.parseInt(p));
                    return JBUI.insets((int)((Integer)v.get(0)), (int)((Integer)v.get(1)), (int)((Integer)v.get(2)), (int)((Integer)v.get(3)));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private Dimension editDimension(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)IdeBundle.message((String)"dialog.message.enter.new.value.for.0.in.form.width.height", (Object[])new Object[]{key}), (String)IdeBundle.message((String)"dialog.title.dimension.editor", (Object[])new Object[0]), null, (String)value, (InputValidator)new InputValidator(this){

                    public boolean checkInput(String inputString) {
                        return 1.parseDimension(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? 1.parseDimension(newValue) : null;
            }

            @Nullable
            private static Dimension parseDimension(String value) {
                Object[] parts = value.split(",");
                if (parts.length != 2) {
                    return null;
                }
                try {
                    List v = ContainerUtil.map((Object[])parts, p -> Integer.parseInt(p));
                    return JBUI.size((int)((Integer)v.get(0)), (int)((Integer)v.get(1)));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private GrayFilter editGrayFilter(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)IdeBundle.message((String)"dialog.message.enter.new.value.for.0.in.form.brightness.contrast.alpha", (Object[])new Object[]{key}), (String)IdeBundle.message((String)"dialog.title.gray.filter.editor", (Object[])new Object[0]), null, (String)value, (InputValidator)new InputValidator(this){

                    public boolean checkInput(String inputString) {
                        return 1.parseGrayFilter(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? 1.parseGrayFilter(newValue) : null;
            }

            @Nullable
            private static GrayFilter parseGrayFilter(String value) {
                Object[] parts = value.split(",");
                if (parts.length != 3) {
                    return null;
                }
                try {
                    List v = ContainerUtil.map((Object[])parts, p -> Integer.parseInt(p));
                    return new GrayFilter(((Integer)v.get(0)).intValue(), ((Integer)v.get(1)).intValue(), ((Integer)v.get(2)).intValue());
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private Font editFontSize(String key, final Font font) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)IdeBundle.message((String)"label.enter.new.font.size.for.0", (Object[])new Object[]{key}), (String)IdeBundle.message((String)"dialog.title.font.size.editor", (Object[])new Object[0]), null, (String)Integer.toString(font.getSize()), (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return 1.parseFontSize(font, inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? 1.parseFontSize(font, newValue) : null;
            }

            @Nullable
            private static Font parseFontSize(Font font, String value) {
                try {
                    int newSize = Integer.parseInt(value);
                    return newSize > 0 ? font.deriveFont((float)newSize) : null;
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }
        }.show();
    }

    private static Object[] @NotNull [] getUIDefaultsData() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        Object[][] data2 = new Object[defaults.size()][2];
        int i2 = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Pair row2 = Pair.create(key, (Object)defaults.get(key));
            data2[i2][0] = row2;
            data2[i2][1] = row2;
            ++i2;
        }
        Arrays.sort(data2, (o1, o2) -> StringUtil.naturalCompare((String)((Pair)o1[0]).first.toString(), (String)((Pair)o2[0]).first.toString()));
        return data2;
    }

    @NotNull
    static FilteringTableModel<Object> createFilteringModel() {
        DefaultTableModel model2 = new DefaultTableModel(ShowUIDefaultsAction.getUIDefaultsData(), new Object[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int row2, int column) {
                if (column != 1) {
                    return false;
                }
                Object value = ((Pair)this.getValueAt((int)row2, (int)column)).second;
                return value instanceof Color || value instanceof Boolean || value instanceof Integer || value instanceof Float || value instanceof EmptyBorder || value instanceof Insets || value instanceof GrayFilter || value instanceof Font || value instanceof Dimension;
            }
        };
        FilteringTableModel filteringTableModel = new FilteringTableModel((TableModel)model2, Object.class);
        filteringTableModel.setFilter(null);
        FilteringTableModel filteringTableModel2 = filteringTableModel;
        if (filteringTableModel2 == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(2);
        }
        return filteringTableModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteringModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class IconWrap
    implements Icon {
        private final Icon myIcon;

        IconWrap(Icon icon2) {
            this.myIcon = icon2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            try {
                this.myIcon.paintIcon(c, g, x, y);
            }
            catch (Exception e) {
                EmptyIcon.ICON_0.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

