/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.impl.JBHtmlPaneRenderableImage;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.renderable.RenderableImageProducer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001a\u001bB\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0015H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneImageResolver;", "Ljava/util/Dictionary;", "Ljava/net/URL;", "Ljava/awt/Image;", "referenceComponent", "Ljava/awt/Component;", "additionalImageResolver", "Lcom/intellij/ui/components/impl/JBHtmlPaneImageResolver$AdditionalImageResolver;", "<init>", "(Ljava/awt/Component;Lcom/intellij/ui/components/impl/JBHtmlPaneImageResolver$AdditionalImageResolver;)V", "get", "key", "", "getImage", "url", "isUrlSafe", "", "size", "", "isEmpty", "keys", "Ljava/util/Enumeration;", "elements", "put", "value", "remove", "AdditionalImageResolver", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class JBHtmlPaneImageResolver
extends Dictionary<URL, Image> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Component referenceComponent;
    @Nullable
    private final AdditionalImageResolver additionalImageResolver;
    @NotNull
    private static final Regex SAFE_WINDOWS_FILE_LINK = new Regex("^file:(/{0,3})?[A-Za-z]:/");

    public JBHtmlPaneImageResolver(@NotNull Component referenceComponent, @Nullable AdditionalImageResolver additionalImageResolver) {
        Intrinsics.checkNotNullParameter((Object)referenceComponent, (String)"referenceComponent");
        this.referenceComponent = referenceComponent;
        this.additionalImageResolver = additionalImageResolver;
    }

    @Override
    @Nullable
    public Image get(@Nullable Object key) {
        URL uRL = key instanceof URL ? (URL)key : null;
        if (uRL == null) {
            return null;
        }
        return this.getImage(uRL);
    }

    private final Image getImage(URL url) {
        Image inMemory;
        if (!this.isUrlSafe(url)) {
            return null;
        }
        AdditionalImageResolver additionalImageResolver = this.additionalImageResolver;
        if (additionalImageResolver != null) {
            String string = url.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            v2 = additionalImageResolver.resolveImage(string);
        } else {
            v2 = inMemory = null;
        }
        if (inMemory != null) {
            return inMemory;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL uRL = JBHtmlPaneImageResolver.Companion.builtinServerUrl(url);
        if (uRL == null) {
            uRL = url;
        }
        return toolkit.createImage(new RenderableImageProducer(new JBHtmlPaneRenderableImage(uRL, this.referenceComponent), null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUrlSafe(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getProtocol();
        if (string == null) return true;
        switch (string.hashCode()) {
            case 3143036: {
                if (string.equals("file")) break;
                return true;
            }
            case -338481545: {
                if (string.equals("vbscript")) return false;
                return true;
            }
            case 113992: {
                if (string.equals("smb")) return false;
                return true;
            }
            case 188995949: {
                if (!string.equals("javascript")) return true;
                return false;
            }
        }
        if (!SystemInfo.isWindows) return true;
        String string2 = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toExternalForm(...)");
        if (!SAFE_WINDOWS_FILE_LINK.containsMatchIn((CharSequence)string2)) return false;
        return true;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Enumeration<URL> keys() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Enumeration<Image> elements() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Image put(@NotNull URL key, @Nullable Image value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Image remove(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneImageResolver$AdditionalImageResolver;", "", "resolveImage", "Ljava/awt/Image;", "url", "", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static interface AdditionalImageResolver {
        @RequiresEdt
        @Nullable
        public Image resolveImage(@NotNull String var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneImageResolver$Companion;", "", "<init>", "()V", "SAFE_WINDOWS_FILE_LINK", "Lkotlin/text/Regex;", "builtinServerUrl", "Ljava/net/URL;", "url", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nJBHtmlPaneImageResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBHtmlPaneImageResolver.kt\ncom/intellij/ui/components/impl/JBHtmlPaneImageResolver$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n23#2:113\n*S KotlinDebug\n*F\n+ 1 JBHtmlPaneImageResolver.kt\ncom/intellij/ui/components/impl/JBHtmlPaneImageResolver$Companion\n*L\n106#1:113\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final URL builtinServerUrl(URL url) {
            String string = url.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            Url parsedUrl = Urls.parseEncoded((String)string);
            if (parsedUrl == null) {
                return null;
            }
            BuiltInServerManager builtInServerManager = BuiltInServerManager.Companion.getInstance();
            if (!builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
                return null;
            }
            try {
                return new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
            }
            catch (MalformedURLException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn((Throwable)e);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

