/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefScrollbarsHelper {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    LazyInitializer.LazyValue<@NotNull String> OVERLAY_SCROLLBARS_CSS = LazyInitializer.create(() -> JBCefScrollbarsHelper.readResource("resources/overlayscrollbars/overlayscrollbars.css"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    LazyInitializer.LazyValue<@NotNull String> OVERLAY_SCROLLBARS_JS = LazyInitializer.create(() -> JBCefScrollbarsHelper.readResource("resources/overlayscrollbars/overlayscrollbars.browser.es6.js"));
    private static final String TRANSPARENT_CSS_COLOR = "rgba(0, 0, 0, 0.0)";

    @NotNull
    public static String buildScrollbarsStyle() {
        String thumbBorderHoveredColor;
        String transparent = "rgba(0, 0, 0, 0)";
        String thumbColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_BACKGROUND);
        String thumbHoveredColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_HOVERED_BACKGROUND);
        String thumbBorderColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_FOREGROUND);
        if (thumbBorderColor.equals(thumbColor)) {
            thumbBorderColor = TRANSPARENT_CSS_COLOR;
        }
        if ((thumbBorderHoveredColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_HOVERED_FOREGROUND)).equals(thumbHoveredColor)) {
            thumbBorderHoveredColor = TRANSPARENT_CSS_COLOR;
        }
        int trackSizePx = JBCefScrollbarsHelper.getTrackSizePx();
        int thumbPaddingPx = JBCefScrollbarsHelper.getThumbPaddingPx();
        int thumbRadiusPx = JBCefScrollbarsHelper.getThumbRadiusPx();
        String string = String.format(Locale.ROOT, "::-webkit-scrollbar {\n  width: %dpx;\n  height: %dpx;\n  background-color: %s;\n}\n", trackSizePx, trackSizePx, "rgba(0, 0, 0, 0)") + String.format(Locale.ROOT, "::-webkit-scrollbar-track {\n  background-color: %s;\n}\n", "rgba(0, 0, 0, 0)") + String.format(Locale.ROOT, "::-webkit-scrollbar-track:hover {\n  background-color: %s;\n}\n", "rgba(0, 0, 0, 0)") + String.format(Locale.ROOT, "::-webkit-scrollbar-thumb {\n  background-color: %s;\n  border-radius: %dpx;\n  border-width: %dpx;\n  border-style: solid;\n  border-color: %s;\n  background-clip: padding-box;\n  outline: 1px solid %s;\n  outline-offset: -%dpx;\n}\n", thumbColor, thumbRadiusPx, thumbPaddingPx, "rgba(0, 0, 0, 0)", thumbBorderColor, thumbPaddingPx) + String.format(Locale.ROOT, "::-webkit-scrollbar-thumb:hover {\n  background-color: %s;\n  border-radius: %dpx;\n  border-width: %dpx;\n  border-style: solid;\n  border-color: %s;\n  background-clip: padding-box;\n  outline: 1px solid %s;\n  outline-offset: -%dpx;\n}\n", thumbHoveredColor, thumbRadiusPx, thumbPaddingPx, "rgba(0, 0, 0, 0)", thumbBorderHoveredColor, thumbPaddingPx) + String.format(Locale.ROOT, "::-webkit-scrollbar-corner {\n  background-color: %s;\n}\n", "rgba(0, 0, 0, 0)") + "::-webkit-scrollbar-button {\n  display:none;\n}\n";
        if (string == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getOverlayScrollbarsSourceCSS() {
        String string = (String)OVERLAY_SCROLLBARS_CSS.get();
        if (string == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getOverlayScrollbarsSourceJS() {
        String string = (String)OVERLAY_SCROLLBARS_JS.get();
        if (string == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getOverlayScrollbarStyle() {
        String trackColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.TRACK_OPAQUE_BACKGROUND);
        String trackHoveredColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.TRACK_OPAQUE_HOVERED_BACKGROUND);
        String thumbColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_BACKGROUND);
        String thumbHoveredColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_HOVERED_BACKGROUND);
        String thumbBorderColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_FOREGROUND);
        String thumbBorderHoveredColor = JBCefScrollbarsHelper.getCssColor(ScrollBarPainter.THUMB_OPAQUE_HOVERED_FOREGROUND);
        if (thumbBorderColor.equals(thumbColor)) {
            thumbBorderColor = TRANSPARENT_CSS_COLOR;
        }
        if (thumbBorderHoveredColor.equals(thumbHoveredColor)) {
            thumbBorderHoveredColor = TRANSPARENT_CSS_COLOR;
        }
        boolean thumbBorderWidthPx = true;
        int trackSizePx = JBCefScrollbarsHelper.getTrackSizePx();
        int thumbPaddingPx = JBCefScrollbarsHelper.getThumbPaddingPx();
        int thumbRadiusPx = JBCefScrollbarsHelper.getThumbRadiusPx();
        int thumbSizePercent = 100;
        String string = ".os-scrollbar {\n  --os-size: " + trackSizePx + "px;\n  --os-padding-perpendicular: " + (thumbPaddingPx + 1) + "px;\n  --os-handle-border-radius: " + thumbRadiusPx + "px;\n  --os-track-border-radius: 0;  --os-track-bg: " + trackColor + ";\n  --os-track-bg-active: " + trackColor + ";\n  --os-track-bg-hover: " + trackHoveredColor + ";\n  --os-handle-bg: " + thumbColor + ";\n  --os-handle-bg-active: " + thumbColor + ";\n  --os-handle-bg-hover: " + thumbHoveredColor + ";\n  --os-handle-perpendicular-size: " + thumbSizePercent + "%;\n  --os-handle-perpendicular-size-hover: " + thumbSizePercent + "%;\n  --os-handle-perpendicular-size-active: " + thumbSizePercent + "%;\n}\n.os-scrollbar-handle {  outline: 1px solid " + thumbBorderColor + ";\n}.os-scrollbar-handle:hover {  outline: 1px solid " + thumbBorderHoveredColor + ";\n}.os-scrollbar-handle:active {  outline: 1px solid " + thumbBorderHoveredColor + ";\n}";
        if (string == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static int getTrackSizePx() {
        return (int)((float)JBCefApp.normalizeScaledSize(SystemInfo.isMac ? 14 : 10) * UISettingsUtils.getInstance().getCurrentIdeScale());
    }

    private static int getThumbPaddingPx() {
        return (int)((float)JBCefApp.normalizeScaledSize(SystemInfo.isMac ? 3 : 1) * UISettingsUtils.getInstance().getCurrentIdeScale());
    }

    private static int getThumbRadiusPx() {
        return (int)((float)JBCefApp.normalizeScaledSize(SystemInfo.isMac ? 7 : 0) * UISettingsUtils.getInstance().getCurrentIdeScale());
    }

    @Nullable
    private static Integer getScrollbarAlpha(ColorKey colorKey) {
        if (!LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() || !UISettings.getInstance().getUseContrastScrollbars()) {
            return null;
        }
        List<ColorKey> contrastElementsKeys = List.of(ScrollBarPainter.THUMB_OPAQUE_FOREGROUND, ScrollBarPainter.THUMB_OPAQUE_BACKGROUND, ScrollBarPainter.THUMB_OPAQUE_HOVERED_FOREGROUND, ScrollBarPainter.THUMB_OPAQUE_HOVERED_BACKGROUND, ScrollBarPainter.THUMB_FOREGROUND, ScrollBarPainter.THUMB_BACKGROUND, ScrollBarPainter.THUMB_HOVERED_FOREGROUND, ScrollBarPainter.THUMB_HOVERED_BACKGROUND);
        if (!contrastElementsKeys.contains(colorKey)) {
            return null;
        }
        int lightAlpha = SystemInfo.isMac ? 120 : 160;
        int darkAlpha = SystemInfo.isMac ? 255 : 180;
        int alpha = Registry.intValue((String)"contrast.scrollbars.alpha.level");
        if (alpha > 0) {
            return Integer.min(alpha, 255);
        }
        return UIUtil.isUnderDarcula() ? darkAlpha : lightAlpha;
    }

    @NotNull
    private static String getCssColor(ColorKey key) {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        Color color = (Color)ObjectUtils.notNull((Object)colorsScheme.getColor(key), (Object)key.getDefaultColor());
        double alpha = (double)((Integer)ObjectUtils.notNull((Object)JBCefScrollbarsHelper.getScrollbarAlpha(key), (Object)color.getAlpha())).intValue() / 255.0;
        String string = String.format(Locale.ROOT, "rgba(%d, %d, %d, %f)", color.getRed(), color.getGreen(), color.getBlue(), alpha);
        if (string == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String readResource(@NotNull String path) {
        if (path == null) {
            JBCefScrollbarsHelper.$$$reportNull$$$0(5);
        }
        try {
            return new String(FileUtil.loadBytes((InputStream)Objects.requireNonNull(JBCefApp.class.getResourceAsStream(path))), StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            Logger.getInstance(JBCefScrollbarsHelper.class).error("couldn't find " + path, (Throwable)e);
            return "";
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefScrollbarsHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildScrollbarsStyle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverlayScrollbarsSourceCSS";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverlayScrollbarsSourceJS";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverlayScrollbarStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefScrollbarsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readResource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

