/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.execution.Platform;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefAppCache;
import com.intellij.ui.jcef.JBCefAppRequiredArgumentsProvider;
import com.intellij.ui.jcef.JBCefProxySettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.cef.CefSettings;
import org.cef.misc.BoolRef;
import org.cef.misc.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SettingsHelper {
    private static final Logger LOG = Logger.getInstance(JBCefApp.class);
    private static final String MISSING_LIBS_SUPPORT_URL = "https://intellij-support.jetbrains.com/hc/en-us/articles/360016421559";
    @NotNull
    static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = NotNullLazyValue.createValue(() -> NotificationGroup.create((String)"JCEF", (NotificationDisplayType)NotificationDisplayType.BALLOON, (boolean)true, null, null, null));
    private static String ourLinuxDistribution = null;

    SettingsHelper() {
    }

    static boolean isOffScreenRenderingModeEnabled() {
        return RegistryManager.getInstance().is("ide.browser.jcef.osr.enabled");
    }

    static CefSettings loadSettings(@NotNull JCefAppConfig config) {
        if (config == null) {
            SettingsHelper.$$$reportNull$$$0(0);
        }
        CefSettings settings = config.getCefSettings();
        settings.windowless_rendering_enabled = SettingsHelper.isOffScreenRenderingModeEnabled();
        settings.log_severity = SettingsHelper.getLogLevel();
        settings.log_file = SettingsHelper.getChromiumLogPath();
        int debuggingPort = SettingsHelper.getRemoteDebugPort();
        if (debuggingPort > 0) {
            settings.remote_debugging_port = debuggingPort;
        }
        settings.cache_path = ((JBCefAppCache)ApplicationManager.getApplication().getService(JBCefAppCache.class)).getPath().toString();
        if (Registry.is((String)"ide.browser.jcef.sandbox.enable")) {
            String linuxDistrib;
            LOG.info("JCEF-sandbox is enabled");
            settings.no_sandbox = false;
            if (SystemInfoRt.isWindows) {
                String sandboxPtr = System.getProperty("jcef.sandbox.ptr");
                if (sandboxPtr != null && !sandboxPtr.trim().isEmpty()) {
                    if (SettingsHelper.isSandboxSupported() && SettingsHelper.checkWinLauncherCefVersion()) {
                        settings.browser_subprocess_path = "";
                    } else {
                        LOG.info("JCEF-sandbox was disabled because current jcef version doesn't support sandbox");
                        settings.no_sandbox = true;
                    }
                } else {
                    LOG.info("JCEF-sandbox was disabled because java-process initialized without sandbox");
                    settings.no_sandbox = true;
                }
            } else if (SystemInfoRt.isMac) {
                ProcessHandle.Info i2 = ProcessHandle.current().info();
                Optional<String> processAppPath = i2.command();
                String appBundlePath = SettingsHelper.getMacAppBundlePath();
                if (processAppPath.isPresent() && processAppPath.get().endsWith("/bin/java")) {
                    LOG.warn("JCEF-sandbox was disabled (to enable you should start IDE from launcher)");
                    settings.no_sandbox = true;
                } else if (appBundlePath == null || !SystemProperties.getJavaHome().startsWith(appBundlePath)) {
                    LOG.warn("JCEF-sandbox was disabled (jbr %s doesn't belong to the app bundle %s)".formatted(SystemProperties.getJavaHome(), appBundlePath));
                    settings.no_sandbox = true;
                }
            } else if (SystemInfoRt.isLinux && (linuxDistrib = SettingsHelper.readLinuxDistribution()) != null && (linuxDistrib.contains("debian") || linuxDistrib.contains("centos"))) {
                if (Boolean.getBoolean("ide.browser.jcef.sandbox.disable_linux_os_check")) {
                    LOG.warn("JCEF sandbox enabled via VM-option 'disable_linux_os_check', OS: " + linuxDistrib);
                } else {
                    LOG.info("JCEF sandbox was disabled because of unsupported OS: " + linuxDistrib + ". To skip this check run IDE with VM-option -Dide.browser.jcef.sandbox.disable_linux_os_check=true");
                    settings.no_sandbox = true;
                }
            }
            if (Registry.is((String)"ide.browser.jcef.run-under-superuser.allowed")) {
                LOG.warn("ide.browser.jcef.run-under-superuser.allowed applied, JCEF-sandbox is disabled");
                settings.no_sandbox = true;
            }
        }
        return settings;
    }

    @NotNull
    static @NotNull String @NotNull [] loadArgs(@NotNull JCefAppConfig config, @NotNull CefSettings settings, @Nullable BoolRef doTrackGPUCrashes) {
        Object[] extraArgs;
        String extraArgsProp;
        boolean trackGPUCrashes;
        if (config == null) {
            SettingsHelper.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            SettingsHelper.$$$reportNull$$$0(2);
        }
        String[] argsFromProviders = (String[])JBCefAppRequiredArgumentsProvider.getProviders().stream().flatMap(p -> {
            LOG.debug("got options: [" + String.valueOf(p.getOptions()) + "] from:" + p.getClass().getName());
            return p.getOptions().stream();
        }).distinct().toArray(String[]::new);
        String[] args = ArrayUtil.mergeArrays((String[])config.getAppArgs(), (String[])argsFromProviders);
        JBCefProxySettings proxySettings = JBCefProxySettings.getInstance();
        String[] proxyArgs = null;
        if (proxySettings.USE_PROXY_PAC) {
            if (proxySettings.USE_PAC_URL) {
                proxyArgs = new String[]{"--proxy-pac-url=" + proxySettings.PAC_URL};
            }
        } else if (proxySettings.USE_HTTP_PROXY) {
            String proxyScheme = proxySettings.PROXY_TYPE_IS_SOCKS ? "socks" : "http";
            String proxyServer = "--proxy-server=" + proxyScheme + "://" + proxySettings.PROXY_HOST + ":" + proxySettings.PROXY_PORT;
            if (StringUtil.isEmptyOrSpaces((String)proxySettings.PROXY_EXCEPTIONS)) {
                proxyArgs = new String[]{proxyServer};
            } else {
                String proxyBypassList = "--proxy-bypass-list=" + proxySettings.PROXY_EXCEPTIONS;
                proxyArgs = new String[]{proxyServer, proxyBypassList};
            }
        } else {
            proxyArgs = new String[]{"--no-proxy-server"};
        }
        if (proxyArgs != null) {
            args = ArrayUtil.mergeArrays((String[])args, proxyArgs);
        }
        if (Registry.is((String)"ide.browser.jcef.gpu.disable")) {
            args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--disable-gpu", "--disable-gpu-compositing"});
        }
        if (trackGPUCrashes = Registry.is((String)"ide.browser.jcef.gpu.infinitecrash")) {
            args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--disable-gpu-process-crash-limit"});
            if (doTrackGPUCrashes != null) {
                doTrackGPUCrashes.set(true);
            }
        }
        if (!(extraArgsProp = System.getProperty("ide.browser.jcef.extra.args", "")).isEmpty() && (extraArgs = extraArgsProp.split(",")).length > 0) {
            LOG.debug("add extra CEF args: [" + Arrays.toString(extraArgs) + "]");
            args = ArrayUtil.mergeArrays((String[])args, (String[])extraArgs);
        }
        if (settings.remote_debugging_port > 0) {
            args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--remote-allow-origins=*"});
        } else if (SettingsHelper.getRemoteDebugPort() == 0) {
            args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--remote-debugging-port=0", "--remote-allow-origins=*"});
        }
        args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--autoplay-policy=no-user-gesture-required", "--disable-component-update"});
        if (args == null) {
            SettingsHelper.$$$reportNull$$$0(3);
        }
        return args;
    }

    static void showNotificationDisableGPU() {
        Notification notification2 = ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(IdeBundle.message((String)"notification.content.jcef.gpucrash.title", (Object[])new Object[0]), IdeBundle.message((String)"notification.content.jcef.gpucrash.message", (Object[])new Object[]{ApplicationInfo.getInstance().getFullApplicationName()}), NotificationType.ERROR);
        notification2.addAction(new AnAction(IdeBundle.message((String)"notification.content.jcef.gpucrash.action.restart", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/SettingsHelper$1", "actionPerformed"));
            }
        });
        if (!Registry.is((String)"ide.browser.jcef.gpu.disable")) {
            notification2.addAction(new AnAction(IdeBundle.message((String)"notification.content.jcef.gpucrash.action.disable", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Registry.get((String)"ide.browser.jcef.gpu.disable").setValue(true);
                    ApplicationManager.getApplication().restart();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/SettingsHelper$2", "actionPerformed"));
                }
            });
        }
        notification2.notify(null);
    }

    static CefSettings.LogSeverity getLogLevel() {
        String level;
        return switch (level = Utils.getString((String)"ide.browser.jcef.log.level", (String)"disable").toLowerCase(Locale.ENGLISH)) {
            case "disable" -> CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
            case "verbose" -> CefSettings.LogSeverity.LOGSEVERITY_VERBOSE;
            case "info" -> CefSettings.LogSeverity.LOGSEVERITY_INFO;
            case "warning" -> CefSettings.LogSeverity.LOGSEVERITY_WARNING;
            case "error" -> CefSettings.LogSeverity.LOGSEVERITY_ERROR;
            case "fatal" -> CefSettings.LogSeverity.LOGSEVERITY_FATAL;
            default -> CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
        };
    }

    static boolean isDebugMode() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return Utils.getBoolean((String)"jcef_debug", (boolean)false);
    }

    static String getLogPath() {
        if (Utils.getBoolean((String)"JCEF_USE_IDE_LOG")) {
            return PathManager.getLogPath() + Platform.current().fileSeparator + "idea.log";
        }
        String def = PathManager.getLogPath() + Platform.current().fileSeparator + "jcef_" + ProcessHandle.current().pid() + ".log";
        String result2 = Utils.getString((String)"ide.browser.jcef.log.path", (String)def).trim();
        return result2.isEmpty() || result2.equals("null") || result2.equals("stderr") ? null : result2;
    }

    static String getChromiumLogPath() {
        String def = PathManager.getLogPath() + Platform.current().fileSeparator + "jcef_chromium_" + ProcessHandle.current().pid() + ".log";
        String result2 = Utils.getString((String)"ide.browser.jcef.log_chromium.path", (String)def).trim();
        return result2.isEmpty() || result2.equals("null") || result2.equals("stderr") ? null : result2;
    }

    @Nullable
    private static String readLinuxDistributionFromOsRelease() {
        String fileName = "/etc/os-release";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName, Charset.defaultCharset()));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("NAME=")) continue;
                return line.replace("NAME=", "").replace("\"", "").toLowerCase(Locale.US);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    private static String readLinuxDistributionFromLsbRelease() {
        String fileName = "/etc/lsb-release";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName, Charset.defaultCharset()));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("DISTRIB_DESCRIPTION")) continue;
                return line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "").toLowerCase(Locale.US);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static String readLinuxDistribution() {
        if (ourLinuxDistribution == null) {
            if (SystemInfoRt.isLinux) {
                String readResult2 = SettingsHelper.readLinuxDistributionFromLsbRelease();
                if (readResult2 == null) {
                    readResult2 = SettingsHelper.readLinuxDistributionFromOsRelease();
                }
                ourLinuxDistribution = readResult2 == null ? "linux" : readResult2;
            } else {
                ourLinuxDistribution = "";
            }
        }
        return ourLinuxDistribution;
    }

    private static boolean isSandboxSupported() {
        JCefVersionDetails version;
        try {
            version = JCefAppConfig.getVersionDetails();
        }
        catch (Throwable e) {
            LOG.error("JCEF runtime version is not supported");
            return false;
        }
        return version.cefVersion.major >= 104 && version.apiVersion.minor >= 9;
    }

    private static boolean checkWinLauncherCefVersion() {
        String cefVersion;
        String launcherCefVersion = System.getProperty("jcef.sandbox.cefVersion");
        if (launcherCefVersion == null) {
            LOG.error("The launcher cef version is unknown");
            return false;
        }
        try {
            JCefVersionDetails version = JCefAppConfig.getVersionDetails();
            cefVersion = "%d.%d.%d+g%s+chromium-%d.%d.%d.%d".formatted(version.cefVersion.major, version.cefVersion.api, version.cefVersion.patch, version.cefVersion.commitHash, version.chromiumVersion.major, version.chromiumVersion.minor, version.chromiumVersion.build, version.chromiumVersion.patch);
        }
        catch (Throwable e) {
            LOG.error("JCEF runtime version is not available");
            return false;
        }
        if (!cefVersion.equals(launcherCefVersion)) {
            LOG.warn("CEF version " + cefVersion + " doesn't match the launcher version " + launcherCefVersion);
            return false;
        }
        return true;
    }

    private static String getMacAppBundlePath() {
        Path p;
        String command = ProcessHandle.current().info().command().orElse(null);
        if (command == null) {
            return null;
        }
        for (p = Path.of(command, new String[0]).toAbsolutePath().normalize(); p != null; p = p.getParent()) {
            File infoPlist = Path.of(p.toString(), "Info.plist").toFile();
            if (!infoPlist.exists() || !infoPlist.isFile() || !Path.of("Contents", new String[0]).equals(p.getFileName())) continue;
            p = p.getParent();
            break;
        }
        return p == null ? null : p.toString();
    }

    private static int getRemoteDebugPort() {
        int result2 = Registry.intValue((String)"ide.browser.jcef.debug.port", (int)-1);
        if (result2 >= 0) {
            return result2;
        }
        if (Registry.is((String)"ide.browser.jcef.debug.port.random.enabled", (boolean)false)) {
            return 0;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/SettingsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/SettingsHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadArgs";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

