/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.tree.project.ProjectFileNodeUpdaterCoroutineInvoker;
import com.intellij.ui.tree.project.ProjectFileNodeUpdaterInvoker;
import com.intellij.ui.tree.project.ProjectFileNodeUpdaterLegacyInvoker;
import com.intellij.ui.tree.project.ProjectViewUpdateCauseUtilKt;
import com.intellij.ui.treeStructure.ProjectViewUpdateCause;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public abstract class ProjectFileNodeUpdater {
    private static final Logger LOG = Logger.getInstance(ProjectFileNodeUpdater.class);
    private final Ref<Set<VirtualFile>> reference;
    private final ProjectFileNodeUpdaterInvoker invoker;
    private volatile boolean root;
    private volatile long time;
    private volatile int size;
    private final Set<ProjectViewUpdateCause> updateFromRootCauses;
    private final Set<ProjectViewUpdateCause> updateByFileCauses;

    public ProjectFileNodeUpdater(@NotNull Project project2, @NotNull Invoker invoker) {
        if (project2 == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(0);
        }
        if (invoker == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(1);
        }
        this(project2, new ProjectFileNodeUpdaterLegacyInvoker(invoker));
    }

    public ProjectFileNodeUpdater(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        if (project2 == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(2);
        }
        if (coroutineScope == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(3);
        }
        this(project2, new ProjectFileNodeUpdaterCoroutineInvoker(coroutineScope));
    }

    private ProjectFileNodeUpdater(@NotNull Project project2, @NotNull ProjectFileNodeUpdaterInvoker invoker) {
        if (project2 == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(4);
        }
        if (invoker == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(5);
        }
        this.reference = new Ref();
        this.updateFromRootCauses = ConcurrentHashMap.newKeySet();
        this.updateByFileCauses = ConcurrentHashMap.newKeySet();
        this.invoker = invoker;
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)invoker);
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectFileNodeUpdater.this.updateFromRoot(ProjectViewUpdateCause.ROOTS_MODULE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/tree/project/ProjectFileNodeUpdater$1", "rootsChanged"));
            }
        });
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> this.updateFromRoot(ProjectViewUpdateCause.ROOTS_LIBRARY));
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile parent;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        VFileCreateEvent create2 = (VFileCreateEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(create2.getParent(), ProjectViewUpdateCause.VFS_CREATE);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCopyEvent) {
                        VFileCopyEvent copy2 = (VFileCopyEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(copy2.getNewParent(), ProjectViewUpdateCause.VFS_COPY);
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        VFileMoveEvent move2 = (VFileMoveEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(move2.getNewParent(), ProjectViewUpdateCause.VFS_MOVE);
                        ProjectFileNodeUpdater.this.updateFromFile(move2.getOldParent(), ProjectViewUpdateCause.VFS_MOVE);
                        ProjectFileNodeUpdater.this.updateFromFile(move2.getFile(), ProjectViewUpdateCause.VFS_MOVE);
                        continue;
                    }
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null) continue;
                    if (vFileEvent instanceof VFileDeleteEvent && (parent = file2.getParent()) != null) {
                        ProjectFileNodeUpdater.this.updateFromFile(parent, ProjectViewUpdateCause.VFS_DELETE);
                    }
                    ProjectFileNodeUpdater.this.updateFromFile(file2, ProjectViewUpdateCause.VFS);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ui/tree/project/ProjectFileNodeUpdater$2", "after"));
            }
        });
        PsiManager.getInstance((Project)project2).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event.getOldChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (event.getOldChild() instanceof PsiWhiteSpace && event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                ProjectFileNodeUpdater.this.updateFromElement(event.getParent(), ProjectViewUpdateCause.PSI_CHILDREN);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                ProjectFileNodeUpdater.this.updateFromElement(event.getOldParent(), ProjectViewUpdateCause.PSI_MOVE);
                ProjectFileNodeUpdater.this.updateFromElement(event.getNewParent(), ProjectViewUpdateCause.PSI_MOVE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileNodeUpdater$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)invoker);
        RootType.ROOT_EP.addChangeListener(() -> this.updateFromRoot(ProjectViewUpdateCause.ROOTS_EP), (Disposable)project2);
        connection.subscribe(VirtualFileAppearanceListener.TOPIC, (Object)new VirtualFileAppearanceListener(){

            public void virtualFileAppearanceChanged(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                ProjectFileNodeUpdater.this.updateFromFile(virtualFile2, ProjectViewUpdateCause.FILE_APPEARANCE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ui/tree/project/ProjectFileNodeUpdater$4", "virtualFileAppearanceChanged"));
            }
        });
    }

    public void updateFromRoot() {
        this.updateFromRootCauses.add(ProjectViewUpdateCauseUtilKt.guessProjectViewUpdateCauseByCaller(ProjectFileNodeUpdater.class));
        this.updateLater(null);
    }

    @ApiStatus.Internal
    public void updateFromRoot(@NotNull ProjectViewUpdateCause cause) {
        if (cause == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(6);
        }
        this.updateFromRootCauses.add(cause);
        this.updateLater(null);
    }

    public void updateFromFile(@Nullable VirtualFile file2) {
        if (file2 != null) {
            this.updateByFileCauses.add(ProjectViewUpdateCauseUtilKt.guessProjectViewUpdateCauseByCaller(ProjectFileNodeUpdater.class));
            this.updateLater(file2);
        }
    }

    @ApiStatus.Internal
    public void updateFromFile(@Nullable VirtualFile file2, @NotNull ProjectViewUpdateCause cause) {
        if (cause == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(7);
        }
        if (file2 != null) {
            this.updateByFileCauses.add(cause);
            this.updateLater(file2);
        }
    }

    public void updateFromElement(@Nullable PsiElement element) {
        this.updateFromFile(PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    @ApiStatus.Internal
    public void updateFromElement(@Nullable PsiElement element, @NotNull ProjectViewUpdateCause cause) {
        if (cause == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(8);
        }
        this.updateFromFile(PsiUtilCore.getVirtualFile((PsiElement)element), cause);
    }

    public void updateImmediately(@NotNull Runnable onDone) {
        if (onDone == null) {
            ProjectFileNodeUpdater.$$$reportNull$$$0(9);
        }
        this.invoker.invoke(() -> this.onInvokerThread(true)).onProcessed(o -> EdtExecutorService.getInstance().execute(onDone));
    }

    protected int getUpdatingDelay() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLater(@Nullable VirtualFile file2) {
        boolean start2 = false;
        Ref<Set<VirtualFile>> ref2 = this.reference;
        synchronized (ref2) {
            Set files2 = (Set)this.reference.get();
            if (files2 == null) {
                files2 = new SmartHashSet();
                this.time = System.currentTimeMillis();
                this.reference.set((Object)files2);
                start2 = true;
            }
            if (file2 == null) {
                this.root = true;
            } else if (files2.add(file2) && LOG.isTraceEnabled()) {
                LOG.debug("mark file ", new Object[]{file2, " to update @ ", this.invoker});
            }
            this.size = files2.size();
        }
        if (start2) {
            LOG.debug("start collecting files to update @ ", new Object[]{this.invoker});
            this.invoker.invokeLater(() -> this.onInvokerThread(false), this.getUpdatingDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInvokerThread(boolean now) {
        boolean fromRoot;
        long startedAt;
        Set files2;
        boolean restart = false;
        Ref<Set<VirtualFile>> ref2 = this.reference;
        synchronized (ref2) {
            files2 = (Set)this.reference.get();
            if (files2 == null) {
                LOG.debug("updating queue was already flushed @ ", new Object[]{this.invoker});
                return;
            }
            startedAt = this.time;
            fromRoot = this.root;
            if (fromRoot) {
                this.root = false;
                this.reference.set(null);
            } else if (now || this.size == files2.size()) {
                this.reference.set(null);
            } else {
                restart = true;
            }
        }
        if (restart) {
            LOG.debug("continue collecting files to update @ ", new Object[]{this.invoker});
            this.invoker.invokeLater(() -> this.onInvokerThread(false), this.getUpdatingDelay());
        } else {
            LOG.debug("spent ", new Object[]{System.currentTimeMillis() - startedAt, "ms to collect ", this.size, " files to update @ ", this.invoker});
            this.invoker.invoke(() -> this.updateStructure(fromRoot, files2));
        }
    }

    @ApiStatus.Internal
    protected Collection<ProjectViewUpdateCause> getAndClearUpdateFromRootCauses() {
        return ProjectFileNodeUpdater.getAndClear(this.updateFromRootCauses);
    }

    @ApiStatus.Internal
    protected Collection<ProjectViewUpdateCause> getAndClearUpdateByFileCauses() {
        return ProjectFileNodeUpdater.getAndClear(this.updateByFileCauses);
    }

    private static @NonNull HashSet<ProjectViewUpdateCause> getAndClear(Set<ProjectViewUpdateCause> causes) {
        HashSet<ProjectViewUpdateCause> result2 = new HashSet<ProjectViewUpdateCause>();
        Iterator<ProjectViewUpdateCause> iterator2 = causes.iterator();
        while (iterator2.hasNext()) {
            ProjectViewUpdateCause cause = iterator2.next();
            result2.add(cause);
            iterator2.remove();
        }
        return result2;
    }

    protected abstract void updateStructure(boolean var1, @NotNull Set<? extends VirtualFile> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileNodeUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImmediately";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

