/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.legacy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.RootJsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.EmptyJsonSchemaObject;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaObjectReadingUtils {
    private static final Logger LOG = Logger.getInstance(JsonSchemaObjectReadingUtils.class);
    @NotNull
    public static final JsonSchemaObject NULL_OBJ = EmptyJsonSchemaObject.INSTANCE;
    private static final Map<String, JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter> complexReferenceCache = FactoryMap.create(key -> new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter((String)key));

    public static boolean hasProperties(@NotNull JsonSchemaObject schemaObject) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(0);
        }
        return schemaObject.getPropertyNames().hasNext();
    }

    @Deprecated
    @Nullable
    public static JsonSchemaObject resolveRefSchema(@NotNull JsonSchemaObject schemaNode, @NotNull JsonSchemaService service) {
        VirtualFile virtualFile;
        if (schemaNode == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(1);
        }
        if (service == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(2);
        }
        String ref = schemaNode.getRef();
        assert (!StringUtil.isEmptyOrSpaces((String)ref));
        JsonSchemaObject value = JsonSchemaObjectReadingUtils.fetchSchemaFromRefDefinition(ref, schemaNode, service, schemaNode.isRefRecursive());
        if (!JsonFileResolver.isHttpPath(ref)) {
            service.registerReference(ref);
        } else if (value != null && (virtualFile = service.resolveSchemaFile(value)) != null && !(virtualFile instanceof HttpVirtualFile)) {
            service.registerReference(virtualFile.getName());
        }
        return value;
    }

    @Nullable
    public static JsonSchemaObject fetchSchemaFromRefDefinition(@NotNull String ref, @NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service, boolean recursive) {
        VirtualFile schemaFile;
        if (ref == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(3);
        }
        if (schema == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(4);
        }
        if (service == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(5);
        }
        if ((schemaFile = service.resolveSchemaFile(schema)) == null) {
            return null;
        }
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = complexReferenceCache.get(ref);
        String schemaId = splitter.getSchemaId();
        if (schemaId != null) {
            JsonSchemaObject refSchema = JsonSchemaObjectReadingUtils.resolveSchemaByReference(service, schemaFile, schemaId);
            if (refSchema == null || refSchema == NULL_OBJ) {
                return null;
            }
            return JsonSchemaObjectReadingUtils.findRelativeDefinition(refSchema, splitter, service);
        }
        JsonSchemaObject rootSchema = service.getSchemaObjectForSchemaFile(schemaFile);
        if (rootSchema == null) {
            LOG.debug(String.format("Schema object not found for %s", schemaFile.getPath()));
            return null;
        }
        return JsonSchemaObjectReadingUtils.findRelativeDefinition(rootSchema, splitter, service);
    }

    @Nullable
    private static JsonSchemaObject resolveSchemaByReference(@NotNull JsonSchemaService service, @NotNull VirtualFile schemaFile, @NotNull String schemaId) {
        VirtualFile refFile;
        if (service == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(6);
        }
        if (schemaFile == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(7);
        }
        if (schemaId == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(8);
        }
        if ((refFile = service.findSchemaFileByReference(schemaId, schemaFile)) == null) {
            LOG.debug(String.format("Schema file not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
            return null;
        }
        JsonSchemaObject refSchema = JsonSchemaObjectReadingUtils.downloadAndParseRemoteSchema(service, refFile);
        if (refSchema == null) {
            LOG.debug(String.format("Schema object not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
        }
        return refSchema;
    }

    @Nullable
    public static JsonSchemaObject downloadAndParseRemoteSchema(@NotNull JsonSchemaService service, @NotNull VirtualFile refFile) {
        RemoteFileInfo info;
        if (service == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(9);
        }
        if (refFile == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(10);
        }
        if (refFile instanceof HttpVirtualFile && (info = ((HttpVirtualFile)refFile).getFileInfo()) != null) {
            RemoteFileState state = info.getState();
            if (state == RemoteFileState.DOWNLOADING_NOT_STARTED) {
                JsonSchemaHighlightingSessionStatisticsCollector.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.ExecutedHttpVirtualFileDownloadRequest);
                JsonFileResolver.startFetchingHttpFileIfNeeded(refFile, service.getProject());
                return NULL_OBJ;
            }
            if (state == RemoteFileState.DOWNLOADING_IN_PROGRESS) {
                return NULL_OBJ;
            }
        }
        return service.getSchemaObjectForSchemaFile(refFile);
    }

    public static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter, @NotNull JsonSchemaService service) {
        String path;
        if (schema == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(11);
        }
        if (splitter == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(12);
        }
        if (service == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path = splitter.getRelativePath()))) {
            JsonSchemaObject rootSchemaObject;
            String id = splitter.getSchemaId();
            if (JsonPointerUtil.isSelfReference(id)) {
                return schema;
            }
            if (id != null && id.startsWith("#") && (rootSchemaObject = schema.getRootSchemaObject()) instanceof RootJsonSchemaObject) {
                RootJsonSchemaObject explicitRootSchemaObject = (RootJsonSchemaObject)((Object)rootSchemaObject);
                String resolvedId = explicitRootSchemaObject.resolveId(id);
                if (resolvedId == null || id.equals("#" + resolvedId)) {
                    return null;
                }
                return JsonSchemaObjectReadingUtils.findRelativeDefinition(schema, new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter("#" + resolvedId), service);
            }
            return schema;
        }
        JsonSchemaObject definition = JsonSchemaObjectReadingUtils.findRelativeDefinition(schema, path);
        if (definition == null && LOG.isDebugEnabled()) {
            VirtualFile schemaFile = service.resolveSchemaFile(schema);
            String debugMessage = String.format("Definition not found by reference: '%s' in file %s", path, schemaFile == null ? "(no file)" : schemaFile.getPath());
            LOG.debug(debugMessage);
        }
        return definition;
    }

    public static boolean hasArrayChecks(@NotNull JsonSchemaObject schemaObject) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(14);
        }
        return schemaObject.isUniqueItems() || schemaObject.getContainsSchema() != null || schemaObject.getItemsSchema() != null || schemaObject.getItemsSchemaList() != null || schemaObject.getMinItems() != null || schemaObject.getMaxItems() != null;
    }

    public static boolean hasObjectChecks(@NotNull JsonSchemaObject schemaObject) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(15);
        }
        return JsonSchemaObjectReadingUtils.hasProperties(schemaObject) || schemaObject.getPropertyNamesSchema() != null || schemaObject.getPropertyDependencies() != null || schemaObject.hasPatternProperties() || schemaObject.getRequired() != null || schemaObject.getMinProperties() != null || schemaObject.getMaxProperties() != null;
    }

    public static boolean hasNumericChecks(@NotNull JsonSchemaObject schemaObject) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(16);
        }
        return schemaObject.getMultipleOf() != null || schemaObject.getExclusiveMinimumNumber() != null || schemaObject.getExclusiveMaximumNumber() != null || schemaObject.getMaximum() != null || schemaObject.getMinimum() != null;
    }

    public static boolean hasStringChecks(@NotNull JsonSchemaObject schemaObject) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(17);
        }
        return schemaObject.getPattern() != null || schemaObject.getFormat() != null;
    }

    @Nullable
    public static JsonSchemaType guessType(@NotNull JsonSchemaObject schemaObject) {
        JsonSchemaType type;
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(18);
        }
        if ((type = schemaObject.getType()) != null) {
            return type;
        }
        Set<JsonSchemaType> typeVariants = schemaObject.getTypeVariants();
        if (typeVariants != null) {
            int size = typeVariants.size();
            if (size == 1) {
                return typeVariants.iterator().next();
            }
            if (size >= 2) {
                return null;
            }
        }
        boolean hasObjectChecks = JsonSchemaObjectReadingUtils.hasObjectChecks(schemaObject);
        boolean hasNumericChecks = JsonSchemaObjectReadingUtils.hasNumericChecks(schemaObject);
        boolean hasStringChecks = JsonSchemaObjectReadingUtils.hasStringChecks(schemaObject);
        boolean hasArrayChecks = JsonSchemaObjectReadingUtils.hasArrayChecks(schemaObject);
        if (hasObjectChecks && !hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._object;
        }
        if (!hasObjectChecks && hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._number;
        }
        if (!hasObjectChecks && !hasNumericChecks && hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._string;
        }
        if (!hasObjectChecks && !hasNumericChecks && !hasStringChecks && hasArrayChecks) {
            return JsonSchemaType._array;
        }
        return null;
    }

    @Nullable
    public static String getTypesDescription(boolean shortDesc, @Nullable Collection<JsonSchemaType> possibleTypes) {
        if (possibleTypes == null || possibleTypes.isEmpty()) {
            return null;
        }
        if (possibleTypes.size() == 1) {
            return possibleTypes.iterator().next().getDescription();
        }
        if (possibleTypes.contains((Object)JsonSchemaType._any)) {
            return JsonSchemaType._any.getDescription();
        }
        Stream<String> typeDescriptions = possibleTypes.stream().map(t -> t.getDescription()).distinct().sorted();
        boolean isShort = false;
        if (shortDesc) {
            typeDescriptions = typeDescriptions.limit(3L);
            if (possibleTypes.size() > 3) {
                isShort = true;
            }
        }
        return typeDescriptions.collect(Collectors.joining(" | ", "", isShort ? "| ..." : ""));
    }

    @Nullable
    public static String getTypeDescription(@NotNull JsonSchemaObject schemaObject, boolean shortDesc) {
        JsonSchemaType type;
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(19);
        }
        if ((type = schemaObject.getType()) != null) {
            return type.getDescription();
        }
        Set<JsonSchemaType> possibleTypes = schemaObject.getTypeVariants();
        String description = JsonSchemaObjectReadingUtils.getTypesDescription(shortDesc, possibleTypes);
        if (description != null) {
            return description;
        }
        List<Object> anEnum = schemaObject.getEnum();
        if (anEnum != null) {
            return shortDesc ? "enum" : anEnum.stream().map(o -> o.toString()).collect(Collectors.joining(" | "));
        }
        JsonSchemaType guessedType = JsonSchemaObjectReadingUtils.guessType(schemaObject);
        if (guessedType != null) {
            return guessedType.getDescription();
        }
        return null;
    }

    @Nullable
    public static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schemaObject, @NotNull String ref) {
        if (schemaObject == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(20);
        }
        if (ref == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(21);
        }
        if (JsonPointerUtil.isSelfReference(ref)) {
            return schemaObject;
        }
        if (!ref.startsWith("#/")) {
            return null;
        }
        return schemaObject.findRelativeDefinition(ref);
    }

    @Nullable
    private static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception __) {
            return null;
        }
    }

    public static boolean matchPattern(@NotNull Pattern pattern, @NotNull String s) {
        if (pattern == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(22);
        }
        if (s == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(23);
        }
        try {
            return pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)s, (long)300L)).matches();
        }
        catch (ProcessCanceledException e) {
            Logger.getInstance(JsonSchemaObjectReadingUtils.class).info("Pattern matching canceled");
            return false;
        }
        catch (Exception e) {
            Logger.getInstance(JsonSchemaObjectReadingUtils.class).info((Throwable)e);
            return false;
        }
    }

    public static Pair<Pattern, String> compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(24);
        }
        try {
            return Pair.create((Object)Pattern.compile(JsonSchemaObjectReadingUtils.adaptSchemaPattern(pattern)), null);
        }
        catch (PatternSyntaxException e) {
            return Pair.create(null, (Object)e.getMessage());
        }
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
        String string = pattern = pattern.replace("\\\\", "\\");
        if (string == null) {
            JsonSchemaObjectReadingUtils.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaNode";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/light/legacy/JsonSchemaObjectReadingUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/light/legacy/JsonSchemaObjectReadingUtils";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptSchemaPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefSchema";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fetchSchemaFromRefDefinition";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaByReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndParseRemoteSchema";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasArrayChecks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasObjectChecks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasNumericChecks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasStringChecks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "guessType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
            case 25: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 25 -> new IllegalStateException(string);
        };
    }
}

