/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentBindingListener;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManagerBase
extends FileDocumentManager {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Boolean> TRACK_NON_PHYSICAL = Key.create((String)"TRACK_NON_PHYSICAL");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create((String)"BIG_FILE_PREVIEW");
    private static final Object lock = new Object();
    private final Map<VirtualFile, Document> myDocumentCache = CollectionFactory.createConcurrentWeakValueMap();

    @ApiStatus.Experimental
    public static boolean isTrackable(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(0);
        }
        return !(file.getFileSystem() instanceof NonPhysicalFileSystem) || Boolean.TRUE.equals(file.getUserData(TRACK_NON_PHYSICAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLock
    @Nullable
    public final Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file);
        if (document != null) {
            return document;
        }
        if (!file.isValid() || file.isDirectory() || FileDocumentManagerBase.isBinaryWithoutDecompiler(file)) {
            return null;
        }
        boolean tooLarge = FileSizeLimit.isTooLargeForContentLoading((long)file.getLength(), (String)file.getExtension());
        if (file.getFileType().isBinary() && tooLarge) {
            return null;
        }
        CharSequence text = this.loadText(file, tooLarge);
        Object object = lock;
        synchronized (object) {
            document = (DocumentEx)this.getCachedDocument(file);
            if (document != null) {
                return document;
            }
            document = this.createDocument(text, file);
            document.setModificationStamp(file.getModificationStamp());
            FileDocumentManagerBase.setDocumentTooLarge(document, tooLarge);
            FileType fileType = file.getFileType();
            document.setReadOnly(tooLarge || !file.isWritable() || fileType.isBinary());
            if (FileDocumentManagerBase.isTrackable(file)) {
                document.addDocumentListener(this.getDocumentListener());
            }
            if (file instanceof LightVirtualFile) {
                FileDocumentManagerBase.registerDocument(document, file, false);
            } else {
                document.putUserData(FILE_KEY, file);
                this.cacheDocument(file, document);
            }
        }
        FileDocumentManagerBase.fireFileBindingChanged(document, null, file);
        this.fileContentLoaded(file, document);
        return document;
    }

    private static void fireFileBindingChanged(Document document, @Nullable VirtualFile oldFile, @Nullable VirtualFile newFile) {
        ((FileDocumentBindingListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentBindingListener.TOPIC)).fileDocumentBindingChanged(document, oldFile, newFile);
    }

    @ApiStatus.Internal
    public static void setDocumentTooLarge(@NotNull Document document, boolean tooLarge) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(2);
        }
        document.putUserData(BIG_FILE_PREVIEW, (Object)(tooLarge ? Boolean.TRUE : null));
    }

    @NotNull
    private CharSequence loadText(@NotNull VirtualFile file, boolean tooLarge) {
        FileViewProvider vp;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(3);
        }
        if (file instanceof LightVirtualFile && (vp = this.findCachedPsiInAnyProject(file)) != null) {
            String string = vp.getPsi(vp.getBaseLanguage()).getText();
            if (string == null) {
                FileDocumentManagerBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        CharSequence charSequence = tooLarge ? LoadTextUtil.loadText(file, FileDocumentManagerBase.getPreviewCharCount(file)) : LoadTextUtil.loadText(file);
        if (charSequence == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @NotNull
    protected abstract DocumentEx createDocument(@NotNull CharSequence var1, @NotNull VirtualFile var2);

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file) {
        Document hard;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(6);
        }
        return (hard = (Document)file.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file);
    }

    @ApiStatus.Internal
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(8);
        }
        FileDocumentManagerBase.registerDocument(document, virtualFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile, boolean fireBindingChangedEvent) {
        VirtualFile oldFile;
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(10);
        }
        if (!(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem)) {
            throw new IllegalArgumentException("Hard-coding file<->document association is permitted for non-physical files only (see FileViewProvider.isPhysical()) to avoid memory leaks. virtualFile=" + virtualFile);
        }
        Object object = lock;
        synchronized (object) {
            oldFile = (VirtualFile)document.getUserData(FILE_KEY);
            document.putUserData(FILE_KEY, (Object)virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        }
        if (fireBindingChangedEvent) {
            FileDocumentManagerBase.fireFileBindingChanged(document, oldFile, virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void rebindDocument(@NotNull Document document, @NotNull VirtualFile oldFile, @NotNull VirtualFile newFile) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(11);
        }
        if (oldFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(12);
        }
        if (newFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(13);
        }
        Object object = lock;
        synchronized (object) {
            oldFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
            document.putUserData(FILE_KEY, (Object)newFile);
            newFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        }
        FileDocumentManagerBase.fireFileBindingChanged(document, oldFile, newFile);
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(14);
        }
        return document instanceof FrozenDocument ? null : (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void reloadBinaryFiles() {
        List binaries = ContainerUtil.filter(this.myDocumentCache.keySet(), file -> file.getFileType().isBinary());
        FileContentUtilCore.reparseFiles((Collection)binaries);
    }

    @ApiStatus.Internal
    public void reloadFileTypes(@NotNull Set<FileType> fileTypes) {
        if (fileTypes == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(15);
        }
        List supported = ContainerUtil.filter(this.myDocumentCache.keySet(), file -> fileTypes.contains(file.getFileType()));
        FileContentUtilCore.reparseFiles((Collection)supported);
    }

    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(16);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    @ApiStatus.Internal
    protected void unbindFileFromDocument(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(17);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(18);
        }
        this.myDocumentCache.remove(file);
        file.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
        FileDocumentManagerBase.fireFileBindingChanged(document, file, null);
    }

    @ApiStatus.Internal
    public static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file) {
        FileType type;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(19);
        }
        return (type = file.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type) == null;
    }

    @ApiStatus.Internal
    public static int getPreviewCharCount(@NotNull VirtualFile file) {
        Charset charset;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(20);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        int largeFilePreviewSize = FileSizeLimit.getPreviewLimit((String)file.getExtension());
        return (int)((float)largeFilePreviewSize / bytesPerChar);
    }

    private void cacheDocument(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(21);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(22);
        }
        this.myDocumentCache.put(file, document);
    }

    private Document getDocumentFromCache(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(23);
        }
        return this.myDocumentCache.get(file);
    }

    @ApiStatus.Internal
    protected void clearDocumentCache() {
        this.myDocumentCache.clear();
    }

    protected abstract void fileContentLoaded(@NotNull VirtualFile var1, @NotNull Document var2);

    @NotNull
    protected abstract DocumentListener getDocumentListener();

    @ApiStatus.Internal
    public void forEachCachedDocument(@NotNull @NotNull Consumer<? super @NotNull Document> consumer) {
        if (consumer == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(24);
        }
        this.myDocumentCache.values().forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTrackable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDocumentTooLarge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rebindDocument";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reloadFileTypes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forEachCachedDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

