/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImpl;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImplKt;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\"\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0096@\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\"H\u0002J\b\u0010)\u001a\u00020\"H\u0002J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010;\u001a\u00020,H\u0016J\b\u0010<\u001a\u00020,H\u0016J\u0016\u0010=\u001a\u00020\u000f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\"H\u0014J\b\u0010A\u001a\u00020\"H\u0014J\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010C\u001a\u00020\"2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000e0E2\u0006\u0010F\u001a\u00020\u000eH\u0002J\u001a\u0010G\u001a\u00020\"2\b\u0010H\u001a\u0004\u0018\u00010\u000e2\u0006\u0010I\u001a\u00020\u000eH\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010K\u001a\u00020\u000fH\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020,X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010.R\u0014\u00103\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010.R\u0014\u00105\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010.R\u0014\u00107\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010.R\u0014\u00109\u001a\u00020,X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010.\u00a8\u0006L"}, d2={"Lcom/intellij/openapi/vcs/ExternallyAddedFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "addChosenFiles", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/vcs/AbstractVcs;Lkotlin/jvm/functions/Function1;)V", "UNPROCESSED_FILES_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "queue", "Lcom/intellij/util/concurrency/QueueProcessor;", "unprocessedFiles", "", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "kotlin.jvm.PlatformType", "install", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "unchangedFileStatusChanged", "upToDate", "", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doNothingSilently", "needProcessExternalFiles", "dispose", "notificationDisplayId", "", "getNotificationDisplayId", "()Ljava/lang/String;", "askedBeforeProperty", "getAskedBeforeProperty", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "showActionText", "getShowActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "viewFilesDialogTitle", "getViewFilesDialogTitle", "notificationTitle", "notificationMessage", "doActionOnChosenFiles", "files", "setForCurrentProject", "isEnabled", "needDoForCurrentProject", "doFilterFiles", "isUnder", "parents", "", "child", "isProjectConfigDirOrUnderIt", "configDir", "file", "getProjectConfigDir", "waitForEventsProcessedInTestMode", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nExternallyAddedFilesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternallyAddedFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/ExternallyAddedFilesProcessorImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,181:1\n60#2,5:182\n60#2,5:187\n1276#3,2:192\n*S KotlinDebug\n*F\n+ 1 ExternallyAddedFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/ExternallyAddedFilesProcessorImpl\n*L\n83#1:182,5\n99#1:187,5\n160#1:192,2\n*E\n"})
public final class ExternallyAddedFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements FilesProcessor,
AsyncVfsEventsListener,
ChangeListListener {
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final Function1<Collection<? extends VirtualFile>, Unit> addChosenFiles;
    @NotNull
    private final ReentrantReadWriteLock UNPROCESSED_FILES_LOCK;
    @NotNull
    private final QueueProcessor<Collection<VirtualFile>> queue;
    @NotNull
    private final Set<VirtualFile> unprocessedFiles;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String notificationDisplayId;
    @NotNull
    private final String askedBeforeProperty;
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @NotNull
    private final String muteActionText;
    @NotNull
    private final String viewFilesDialogTitle;

    public ExternallyAddedFilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull AbstractVcs vcs, @NotNull Function1<? super Collection<? extends VirtualFile>, Unit> addChosenFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter(addChosenFiles, (String)"addChosenFiles");
        super(project, parentDisposable);
        this.vcs = vcs;
        this.addChosenFiles = addChosenFiles;
        this.UNPROCESSED_FILES_LOCK = new ReentrantReadWriteLock();
        this.queue = new QueueProcessor(arg_0 -> ExternallyAddedFilesProcessorImpl.queue$lambda$1(arg_0 -> ExternallyAddedFilesProcessorImpl.queue$lambda$0(this, arg_0), arg_0));
        this.unprocessedFiles = new LinkedHashSet();
        this.vcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
        this.notificationDisplayId = "externally.added.files.notification";
        this.askedBeforeProperty = "ASKED_ADD_EXTERNAL_FILES";
        String string = VcsBundle.message((String)"external.files.add.notification.action.view", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showActionText = string;
        String string2 = VcsBundle.message((String)"external.files.add.notification.action.add", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.forCurrentProjectActionText = string2;
        String string3 = VcsBundle.message((String)"external.files.add.notification.action.mute", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.muteActionText = string3;
        Object[] objectArray = new Object[]{this.vcs.getDisplayName()};
        String string4 = VcsBundle.message((String)"external.files.add.view.dialog.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.viewFilesDialogTitle = string4;
    }

    public final void install(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        SimpleMessageBusConnection simpleMessageBusConnection = this.getProject().getMessageBus().connect(coroutineScope);
        Topic topic = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)this);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unchangedFileStatusChanged(boolean upToDate) {
        if (!upToDate) {
            return;
        }
        if (!this.needProcessExternalFiles()) {
            return;
        }
        HashSet files = null;
        Object[] objectArray = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = objectArray.readLock();
        int n = objectArray.getWriteHoldCount() == 0 ? objectArray.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = objectArray.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            files = CollectionsKt.toHashSet((Iterable)this.unprocessedFiles);
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (((Set)files).isEmpty()) {
            return;
        }
        if (this.needDoForCurrentProject()) {
            objectArray = new Object[]{files};
            ExternallyAddedFilesProcessorImplKt.access$getLOG$p().debug("Add external files to " + this.vcs.getDisplayName() + " silently ", objectArray);
            this.addChosenFiles.invoke(this.doFilterFiles(files));
        } else if (Registry.Companion.is("vcs.show.externally.added.files.notification", false)) {
            objectArray = new Object[]{files};
            ExternallyAddedFilesProcessorImplKt.access$getLOG$p().debug("Process external files and prompt to add if needed to " + this.vcs.getDisplayName() + " ", objectArray);
            this.queue.add((Object)files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        Logger logger;
        if (!this.needProcessExternalFiles()) {
            return Unit.INSTANCE;
        }
        Logger $this$debug_u24default$iv = ExternallyAddedFilesProcessorImplKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got events " + events, t$iv);
        }
        if (events.isEmpty()) {
            return Unit.INSTANCE;
        }
        VirtualFile configDir = this.getProjectConfigDir(this.getProject());
        List externallyAddedFiles2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), arg_0 -> ExternallyAddedFilesProcessorImpl.filesChanged$lambda$1(this, configDir, arg_0)), (Function1)filesChanged.externallyAddedFiles.2.INSTANCE));
        if (externallyAddedFiles2.isEmpty()) {
            return Unit.INSTANCE;
        }
        Logger $this$debug_u24default$iv2 = ExternallyAddedFilesProcessorImplKt.access$getLOG$p();
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Got external files from VFS events " + externallyAddedFiles2, t$iv2);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.unprocessedFiles.addAll(externallyAddedFiles2);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return Unit.INSTANCE;
    }

    private final boolean doNothingSilently() {
        return this.vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, this.vcs).getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    }

    private final boolean needProcessExternalFiles() {
        if (this.doNothingSilently()) {
            return false;
        }
        return Registry.Companion.is("vcs.process.externally.added.files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        this.queue.clear();
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public String getNotificationDisplayId() {
        return this.notificationDisplayId;
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        Object[] objectArray = new Object[]{this.vcs.getDisplayName()};
        String string = VcsBundle.message((String)"external.files.add.notification.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.addChosenFiles.invoke(files);
    }

    @Override
    protected void setForCurrentProject(boolean isEnabled) {
        if (isEnabled) {
            this.vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, this.vcs).setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
        }
        VcsConfiguration.getInstance((Project)this.getProject()).ADD_EXTERNAL_FILES_SILENTLY = isEnabled;
    }

    @Override
    protected boolean needDoForCurrentProject() {
        return this.vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, this.vcs).getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && VcsConfiguration.getInstance((Project)this.getProject()).ADD_EXTERNAL_FILES_SILENTLY;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        HashSet parents = CollectionsKt.toHashSet((Iterable)files);
        List<VirtualFile> list = ChangeListManagerImpl.getInstanceImpl(this.getProject()).getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFiles(...)");
        Sequence sequence = CollectionsKt.asSequence((Iterable)list);
        VcsIgnoreManager vcsIgnoreManager = this.vcsIgnoreManager;
        Intrinsics.checkNotNullExpressionValue((Object)vcsIgnoreManager, (String)"vcsIgnoreManager");
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)sequence, (Function1)((Function1)new Function1<VirtualFile, Boolean>((Object)vcsIgnoreManager){

            public final Boolean invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((VcsIgnoreManager)this.receiver).isPotentiallyIgnoredFile(p0);
            }
        })), arg_0 -> ExternallyAddedFilesProcessorImpl.doFilterFiles$lambda$0(this, parents, arg_0)));
    }

    private final boolean isUnder(Set<? extends VirtualFile> parents, VirtualFile child) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)child, ExternallyAddedFilesProcessorImpl::isUnder$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!parents.contains(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isProjectConfigDirOrUnderIt(VirtualFile configDir, VirtualFile file) {
        return configDir != null && VfsUtilCore.isAncestor((VirtualFile)configDir, (VirtualFile)file, (boolean)false);
    }

    private final VirtualFile getProjectConfigDir(Project project) {
        Path path = project.isDefault() ? null : ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
        if (path == null) {
            return null;
        }
        Path directoryStorePath = path;
        VirtualFile projectConfigDir = LocalFileSystem.getInstance().findFileByNioFile(directoryStorePath);
        if (projectConfigDir == null) {
            ExternallyAddedFilesProcessorImplKt.access$getLOG$p().warn("Cannot find project config directory for non-default and non-directory based project " + project.getName());
        }
        return projectConfigDir;
    }

    @Override
    @TestOnly
    protected void waitForEventsProcessedInTestMode() {
        super.waitForEventsProcessedInTestMode();
        this.queue.waitFor();
    }

    private static final Unit queue$lambda$0(ExternallyAddedFilesProcessorImpl this$0, Collection files) {
        Intrinsics.checkNotNull((Object)files);
        this$0.processFiles(files);
        return Unit.INSTANCE;
    }

    private static final void queue$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean filesChanged$lambda$1(ExternallyAddedFilesProcessorImpl this$0, VirtualFile $configDir, VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFromRefresh()) return false;
        if (!(it instanceof VFileCreateEvent)) return false;
        VirtualFile virtualFile = ((VFileCreateEvent)it).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        if (this$0.isProjectConfigDirOrUnderIt($configDir, virtualFile)) return false;
        return true;
    }

    private static final boolean doFilterFiles$lambda$0(ExternallyAddedFilesProcessorImpl this$0, HashSet $parents, VirtualFile it) {
        Set set2 = $parents;
        Intrinsics.checkNotNull((Object)it);
        return this$0.isUnder(set2, it);
    }

    private static final VirtualFile isUnder$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

