/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CachesHolder;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.ChangesCacheFile;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCacheState;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedListsSequencesZipper;
import com.intellij.openapi.vcs.changes.committed.CompositeCommittedChangesProvider;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.MessageBusUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.ProgressManagerQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="CommittedChangesCache", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class CommittedChangesCache
extends SimplePersistentStateComponent<CommittedChangesCacheState> {
    private static final Logger LOG = Logger.getInstance(CommittedChangesCache.class);
    private final Project myProject;
    private final ProgressManagerQueue myTaskQueue;
    private boolean myRefreshingIncomingChanges;
    private int myPendingUpdateCount;
    private ScheduledFuture myFuture;
    private List<CommittedChangeList> myCachedIncomingChangeLists;
    @NotNull
    private final Set<CommittedChangeList> myNewIncomingChanges;
    private MyRefreshRunnable refreshRunnable;
    private final Map<String, Pair<Long, List<CommittedChangeList>>> myExternallyLoadedChangeLists;
    private final CachesHolder myCachesHolder;
    private final RepositoryLocationCache myLocationCache;
    @Topic.ProjectLevel
    public static final Topic<CommittedChangesListener> COMMITTED_TOPIC = new Topic(CommittedChangesListener.class, Topic.BroadcastDirection.NONE);

    public static CommittedChangesCache getInstance(Project project) {
        return (CommittedChangesCache)((Object)project.getService(CommittedChangesCache.class));
    }

    @Nullable
    public static CommittedChangesCache getInstanceIfCreated(Project project) {
        return (CommittedChangesCache)((Object)project.getServiceIfCreated(CommittedChangesCache.class));
    }

    public CommittedChangesCache(@NotNull Project project) {
        if (project == null) {
            CommittedChangesCache.$$$reportNull$$$0(0);
        }
        super((BaseState)new CommittedChangesCacheState());
        this.myRefreshingIncomingChanges = false;
        this.myPendingUpdateCount = 0;
        this.myNewIncomingChanges = new LinkedHashSet<CommittedChangeList>();
        this.myProject = project;
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                CommittedChangesCache.this.myLocationCache.reset();
                CommittedChangesCache.this.myCachesHolder.reset();
                CommittedChangesCache.this.refreshAllCachesAsync(false, true);
                CommittedChangesCache.this.refreshIncomingChangesAsync();
                CommittedChangesCache.this.myTaskQueue.run(() -> {
                    for (ChangesCacheFile file : CommittedChangesCache.this.myCachesHolder.getAllCaches()) {
                        RepositoryLocation location = file.getLocation();
                        CommittedChangesCache.this.fireChangesLoaded(location, Collections.emptyList());
                    }
                    CommittedChangesCache.this.fireIncomingReloaded();
                });
            }
        };
        this.myLocationCache = new RepositoryLocationCache(project);
        this.myCachesHolder = new CachesHolder(project, this.myLocationCache);
        this.myTaskQueue = new ProgressManagerQueue(project, VcsBundle.message((String)"committed.changes.refresh.progress", (Object[])new Object[0]));
        ProjectLevelVcsManager.getInstance((Project)project).runAfterInitialization(() -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myTaskQueue.start();
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)vcsListener);
        }));
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                CommittedChangesCache.this.cancelRefreshTimer();
            }
        });
        this.myExternallyLoadedChangeLists = new ConcurrentHashMap<String, Pair<Long, List<CommittedChangeList>>>();
    }

    @ApiStatus.Internal
    public void loadState(@NotNull CommittedChangesCacheState state) {
        if (state == null) {
            CommittedChangesCache.$$$reportNull$$$0(1);
        }
        super.loadState((BaseState)state);
        this.updateRefreshTimer();
    }

    public boolean isMaxCountSupportedForProject() {
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CachingCommittedChangesProvider cachingProvider;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (!(provider instanceof CachingCommittedChangesProvider) || (cachingProvider = (CachingCommittedChangesProvider)provider).isMaxCountSupported()) continue;
            return false;
        }
        return true;
    }

    public void getProjectChangesAsync(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<? super List<CommittedChangeList>> consumer, Consumer<? super List<VcsException>> errorConsumer) {
        MyProjectChangesLoader loader = new MyProjectChangesLoader(settings, maxCount, cacheOnly, consumer, errorConsumer);
        this.myTaskQueue.run(loader);
    }

    @Nullable
    public List<CommittedChangeList> getChanges(ChangeBrowserSettings settings, VirtualFile file, @NotNull AbstractVcs vcs, int maxCount, boolean cacheOnly, CommittedChangesProvider provider, RepositoryLocation location) throws VcsException {
        if (vcs == null) {
            CommittedChangesCache.$$$reportNull$$$0(2);
        }
        if (settings instanceof CompositeCommittedChangesProvider.CompositeChangeBrowserSettings) {
            settings = ((CompositeCommittedChangesProvider.CompositeChangeBrowserSettings)settings).get(vcs);
        }
        if (provider instanceof CachingCommittedChangesProvider) {
            try {
                if (cacheOnly) {
                    ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, file, location);
                    if (!cacheFile.isEmpty()) {
                        RepositoryLocation fileLocation = cacheFile.getLocation();
                        fileLocation.onBeforeBatch();
                        List<CommittedChangeList> committedChangeLists = cacheFile.readChanges(settings, maxCount);
                        fileLocation.onAfterBatch();
                        return committedChangeLists;
                    }
                    return null;
                }
                if (this.canGetFromCache(vcs, settings, file, location, maxCount)) {
                    return this.getChangesWithCaching(vcs, settings, file, location, maxCount);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return provider.getCommittedChanges(settings, location, maxCount);
    }

    private boolean canGetFromCache(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            return true;
        }
        if (settings.USE_DATE_BEFORE_FILTER && !settings.USE_DATE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_BEFORE_FILTER && !settings.USE_CHANGE_AFTER_FILTER) {
            return cacheFile.hasCompleteHistory();
        }
        boolean hasDateFilter = settings.USE_DATE_AFTER_FILTER || settings.USE_CHANGE_AFTER_FILTER;
        boolean hasNonDateFilter = settings.isNonDateFilterSpecified();
        if (!hasDateFilter && hasNonDateFilter) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_DATE_AFTER_FILTER && settings.getDateAfter().getTime() < cacheFile.getFirstCachedDate().getTime()) {
            return cacheFile.hasCompleteHistory();
        }
        if (settings.USE_CHANGE_AFTER_FILTER && settings.getChangeAfterFilter() < cacheFile.getFirstCachedChangelist()) {
            return cacheFile.hasCompleteHistory();
        }
        return true;
    }

    public void hasCachesForAnyRoot(@Nullable Consumer<? super Boolean> continuation) {
        this.myTaskQueue.run(() -> {
            Ref success = new Ref();
            try {
                success.set((Object)this.hasCachesWithEmptiness(false));
            }
            catch (ProcessCanceledException e) {
                success.set((Object)true);
            }
            ApplicationManager.getApplication().invokeLater(() -> continuation.consume(success.get()), this.myProject.getDisposed());
        });
    }

    public boolean hasEmptyCaches() {
        try {
            return this.hasCachesWithEmptiness(true);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    private boolean hasCachesWithEmptiness(boolean emptiness) {
        Ref resultRef = new Ref((Object)Boolean.FALSE);
        this.myCachesHolder.iterateAllCaches((Processor<? super ChangesCacheFile>)((Processor)changesCacheFile -> {
            try {
                if (changesCacheFile.isEmpty() == emptiness) {
                    resultRef.set((Object)true);
                    return false;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            return true;
        }));
        return (Boolean)resultRef.get();
    }

    @Nullable
    public Iterator<ChangesBunch> getBackBunchedIterator(AbstractVcs vcs, VirtualFile root, RepositoryLocation location, int bunchSize) {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        try {
            if (!cacheFile.isEmpty()) {
                return cacheFile.getBackBunchedIterator(bunchSize);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private List<CommittedChangeList> getChangesWithCaching(AbstractVcs vcs, ChangeBrowserSettings settings, VirtualFile root, RepositoryLocation location, int maxCount) throws VcsException, IOException {
        ChangesCacheFile cacheFile = this.myCachesHolder.getCacheFile(vcs, root, location);
        if (cacheFile.isEmpty()) {
            List<CommittedChangeList> changes = this.initCache(cacheFile);
            if (this.canGetFromCache(vcs, settings, root, location, maxCount)) {
                settings.filterChanges(changes);
                return CommittedChangesCache.trimToSize(changes, maxCount);
            }
            return cacheFile.getProvider().getCommittedChanges(settings, location, maxCount);
        }
        RepositoryLocation fileLocation = cacheFile.getLocation();
        fileLocation.onBeforeBatch();
        List<CommittedChangeList> changes = cacheFile.readChanges(settings, maxCount);
        fileLocation.onAfterBatch();
        List<CommittedChangeList> newChanges = this.refreshCache(cacheFile);
        settings.filterChanges(newChanges);
        changes.addAll(newChanges);
        return CommittedChangesCache.trimToSize(changes, maxCount);
    }

    @TestOnly
    public void refreshAllCaches() throws IOException, VcsException {
        CommittedChangesCache.debug("Start refreshing all caches");
        Collection<ChangesCacheFile> files = this.myCachesHolder.getAllCaches();
        CommittedChangesCache.debug(files.size() + " caches found");
        for (ChangesCacheFile file : files) {
            if (file.isEmpty()) {
                this.initCache(file);
                continue;
            }
            this.refreshCache(file);
        }
        CommittedChangesCache.debug("Finished refreshing all caches");
    }

    @NotNull
    private List<CommittedChangeList> initCache(@NotNull ChangesCacheFile cacheFile) throws VcsException, IOException {
        if (cacheFile == null) {
            CommittedChangesCache.$$$reportNull$$$0(3);
        }
        CommittedChangesCache.debug("Initializing cache for " + String.valueOf(cacheFile.getLocation()));
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        int maxCount = 0;
        if (this.isMaxCountSupportedForProject()) {
            maxCount = ((CommittedChangesCacheState)this.getState()).getInitialCount();
        } else {
            settings.USE_DATE_AFTER_FILTER = true;
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -((CommittedChangesCacheState)this.getState()).getInitialDays());
            settings.setDateAfter(calendar.getTime());
        }
        List changes = provider.getCommittedChanges(settings, location, maxCount);
        CommittedChangesCache.writeChangesInReadAction(cacheFile, changes);
        if (maxCount > 0 && changes.size() < ((CommittedChangesCacheState)this.getState()).getInitialCount()) {
            cacheFile.setHaveCompleteHistory(true);
        }
        if (!changes.isEmpty()) {
            this.fireChangesLoaded(location, changes);
        }
        List list = changes;
        if (list == null) {
            CommittedChangesCache.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void fireChangesLoaded(@NotNull RepositoryLocation location, @NotNull List<CommittedChangeList> changes) {
        if (location == null) {
            CommittedChangesCache.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            CommittedChangesCache.$$$reportNull$$$0(6);
        }
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher((Project)this.myProject, COMMITTED_TOPIC, listener2 -> listener2.changesLoaded(location, changes));
    }

    private void fireIncomingReloaded() {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher((Project)this.myProject, COMMITTED_TOPIC, listener2 -> listener2.incomingChangesUpdated(Collections.emptyList()));
    }

    @NotNull
    private List<CommittedChangeList> refreshCache(@NotNull ChangesCacheFile cacheFile) throws VcsException, IOException {
        if (cacheFile == null) {
            CommittedChangesCache.$$$reportNull$$$0(7);
        }
        CommittedChangesCache.debug("Refreshing cache for " + String.valueOf(cacheFile.getLocation()));
        ArrayList<CommittedChangeList> newLists = new ArrayList<CommittedChangeList>();
        CachingCommittedChangesProvider provider = cacheFile.getProvider();
        RepositoryLocation location = cacheFile.getLocation();
        Pair<Long, List<CommittedChangeList>> externalLists = this.myExternallyLoadedChangeLists.get(location.getKey());
        long latestChangeList = CommittedChangesCache.getLatestListForFile(cacheFile);
        if (externalLists != null && latestChangeList == (Long)externalLists.first) {
            newLists.addAll(this.appendLoadedChanges(cacheFile, (List)externalLists.second));
            this.myExternallyLoadedChangeLists.clear();
        }
        ChangeBrowserSettings defaultSettings = provider.createDefaultSettings();
        int maxCount = 0;
        if (provider.refreshCacheByNumber()) {
            long number = cacheFile.getLastCachedChangelist();
            CommittedChangesCache.debug("Refreshing cache for " + String.valueOf(location) + " since #" + number);
            if (number >= 0L) {
                defaultSettings.CHANGE_AFTER = Long.toString(number);
                defaultSettings.USE_CHANGE_AFTER_FILTER = true;
            } else {
                maxCount = ((CommittedChangesCacheState)this.getState()).getInitialCount();
            }
        } else {
            Date date = cacheFile.getLastCachedDate();
            CommittedChangesCache.debug("Refreshing cache for " + String.valueOf(location) + " since " + String.valueOf(date));
            defaultSettings.setDateAfter(date);
            defaultSettings.USE_DATE_AFTER_FILTER = true;
        }
        defaultSettings.STRICTLY_AFTER = true;
        List newChanges = provider.getCommittedChanges(defaultSettings, location, maxCount);
        CommittedChangesCache.debug("Loaded " + newChanges.size() + " new changelists");
        newLists.addAll(this.appendLoadedChanges(cacheFile, newChanges));
        ArrayList<CommittedChangeList> arrayList = newLists;
        if (arrayList == null) {
            CommittedChangesCache.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private List<CommittedChangeList> appendLoadedChanges(@NotNull ChangesCacheFile cacheFile, @NotNull List<? extends CommittedChangeList> newChanges) throws IOException {
        List<CommittedChangeList> savedChanges;
        if (cacheFile == null) {
            CommittedChangesCache.$$$reportNull$$$0(9);
        }
        if (newChanges == null) {
            CommittedChangesCache.$$$reportNull$$$0(10);
        }
        if (!(savedChanges = CommittedChangesCache.writeChangesInReadAction(cacheFile, newChanges)).isEmpty()) {
            this.fireChangesLoaded(cacheFile.getLocation(), savedChanges);
        }
        return savedChanges;
    }

    @Contract(mutates="param1,param2")
    private static List<CommittedChangeList> writeChangesInReadAction(ChangesCacheFile cacheFile, @NotNull List<? extends CommittedChangeList> newChanges) throws IOException {
        if (newChanges == null) {
            CommittedChangesCache.$$$reportNull$$$0(11);
        }
        for (CommittedChangeList committedChangeList : newChanges) {
            committedChangeList.getChanges();
        }
        Ref ref = new Ref();
        List list = (List)ReadAction.compute(() -> {
            try {
                return cacheFile.writeChanges(newChanges);
            }
            catch (IOException e) {
                ref.set((Object)e);
                return null;
            }
        });
        if (!ref.isNull()) {
            throw (IOException)ref.get();
        }
        return list;
    }

    @NotNull
    private static List<CommittedChangeList> trimToSize(@NotNull List<CommittedChangeList> changes, int maxCount) {
        if (changes == null) {
            CommittedChangesCache.$$$reportNull$$$0(12);
        }
        if (maxCount > 0) {
            while (changes.size() > maxCount) {
                changes.remove(0);
            }
        }
        List<CommittedChangeList> list = changes;
        if (list == null) {
            CommittedChangesCache.$$$reportNull$$$0(13);
        }
        return list;
    }

    public List<CommittedChangeList> loadIncomingChanges(boolean inBackground) {
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        CommittedChangesCache.debug(caches.size() + " caches found");
        MultiMap byVcs = new MultiMap();
        for (ChangesCacheFile cache : caches) {
            try {
                if (inBackground && !cache.getVcs().isVcsBackgroundOperationsAllowed(cache.getRootPath().getVirtualFile())) continue;
                if (!cache.isEmpty()) {
                    CommittedChangesCache.debug("Loading incoming changes for " + String.valueOf(cache.getLocation()));
                    List<CommittedChangeList> incomingChanges = cache.loadIncomingChanges();
                    byVcs.putValue((Object)cache.getVcs(), (Object)Pair.create((Object)cache.getLocation(), incomingChanges));
                    continue;
                }
                CommittedChangesCache.debug("Empty cache found for " + String.valueOf(cache.getLocation()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (AbstractVcs vcs : byVcs.keySet()) {
            CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
            VcsCommittedListsZipper vcsZipper = committedChangesProvider.getZipper();
            if (vcsZipper != null) {
                IncomingListsZipper incomingZipper = new IncomingListsZipper(vcsZipper);
                CommittedListsSequencesZipper zipper = new CommittedListsSequencesZipper((VcsCommittedListsZipper)incomingZipper);
                for (Pair pair : byVcs.get((Object)vcs)) {
                    zipper.add((RepositoryLocation)pair.getFirst(), (List)pair.getSecond());
                }
                result2.addAll(zipper.execute());
                continue;
            }
            for (Pair pair : byVcs.get((Object)vcs)) {
                result2.addAll((Collection)pair.getSecond());
            }
        }
        this.myCachedIncomingChangeLists = result2;
        CommittedChangesCache.debug("Incoming changes loaded");
        this.fireIncomingChangesUpdated(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public void commitMessageChanged(@NotNull RepositoryLocation location, long number, String string) {
        void newMessage;
        if (location == null) {
            CommittedChangesCache.$$$reportNull$$$0(14);
        }
        this.myTaskQueue.run(() -> this.lambda$commitMessageChanged$8(location, number, (String)newMessage));
    }

    public void loadIncomingChangesAsync(@Nullable Consumer<? super List<CommittedChangeList>> consumer, boolean inBackground) {
        CommittedChangesCache.debug("Loading incoming changes");
        Runnable task = () -> {
            List<CommittedChangeList> list = this.loadIncomingChanges(inBackground);
            if (consumer != null) {
                consumer.consume(new ArrayList<CommittedChangeList>(list));
            }
        };
        this.myTaskQueue.run(task);
    }

    public void clearCaches(@Nullable Runnable continuation) {
        this.myTaskQueue.run(() -> {
            this.myCachesHolder.clearAllCaches();
            this.myCachedIncomingChangeLists = null;
            if (continuation != null) {
                continuation.run();
            }
            MessageBusUtil.invokeLaterIfNeededOnSyncPublisher((Project)this.myProject, COMMITTED_TOPIC, listener2 -> listener2.changesCleared());
        });
    }

    @Nullable
    public List<CommittedChangeList> getCachedIncomingChanges() {
        return this.myCachedIncomingChangeLists;
    }

    public void processUpdatedFiles(UpdatedFiles updatedFiles) {
        this.processUpdatedFiles(updatedFiles, null);
    }

    public void processUpdatedFiles(UpdatedFiles updatedFiles, @Nullable Consumer<? super List<CommittedChangeList>> incomingChangesConsumer) {
        Runnable task = () -> {
            CommittedChangesCache.debug("Processing updated files");
            Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
            this.myPendingUpdateCount += caches.size();
            for (ChangesCacheFile cache : caches) {
                try {
                    if (cache.isEmpty()) {
                        this.pendingUpdateProcessed(incomingChangesConsumer);
                        continue;
                    }
                    CommittedChangesCache.debug("Processing updated files in " + String.valueOf(cache.getLocation()));
                    boolean needRefresh = cache.processUpdatedFiles(updatedFiles, this.myNewIncomingChanges);
                    if (needRefresh) {
                        CommittedChangesCache.debug("Found unaccounted files, requesting refresh");
                        this.processUpdatedFilesAfterRefresh(cache, updatedFiles, incomingChangesConsumer);
                        continue;
                    }
                    CommittedChangesCache.debug("Clearing cached incoming changelists");
                    this.myCachedIncomingChangeLists = null;
                    this.pendingUpdateProcessed(incomingChangesConsumer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        this.myTaskQueue.run(task);
    }

    private void pendingUpdateProcessed(@Nullable Consumer<? super List<CommittedChangeList>> incomingChangesConsumer) {
        --this.myPendingUpdateCount;
        if (this.myPendingUpdateCount == 0) {
            this.fireIncomingChangesUpdated(this.myNewIncomingChanges);
            if (incomingChangesConsumer != null) {
                incomingChangesConsumer.consume(new ArrayList<CommittedChangeList>(this.myNewIncomingChanges));
            }
            this.myNewIncomingChanges.clear();
        }
    }

    private void processUpdatedFilesAfterRefresh(final ChangesCacheFile cache, final UpdatedFiles updatedFiles, final @Nullable Consumer<? super List<CommittedChangeList>> incomingChangesConsumer) {
        this.refreshCacheAsync(cache, false, new RefreshResultConsumer(){

            @Override
            public void receivedChanges(List<CommittedChangeList> committedChangeLists) {
                try {
                    CommittedChangesCache.debug("Processing updated files after refresh in " + String.valueOf(cache.getLocation()));
                    boolean result2 = true;
                    if (!committedChangeLists.isEmpty()) {
                        result2 = cache.processUpdatedFiles(updatedFiles, CommittedChangesCache.this.myNewIncomingChanges);
                    }
                    CommittedChangesCache.debug(result2 ? "Still have unaccounted files" : "No more unaccounted files");
                    if (result2) {
                        cache.refreshIncomingChanges();
                        CommittedChangesCache.debug("Clearing cached incoming changelists");
                        CommittedChangesCache.this.myCachedIncomingChangeLists = null;
                    }
                    CommittedChangesCache.this.pendingUpdateProcessed((Consumer<? super List<CommittedChangeList>>)incomingChangesConsumer);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (VcsException e) {
                    CommittedChangesCache.this.notifyRefreshError(e);
                }
            }

            @Override
            public void receivedError(VcsException ex) {
                CommittedChangesCache.this.notifyRefreshError(ex);
            }
        });
    }

    private void fireIncomingChangesUpdated(@NotNull Collection<? extends CommittedChangeList> incomingChanges) {
        if (incomingChanges == null) {
            CommittedChangesCache.$$$reportNull$$$0(15);
        }
        List incomingChangesCopy = ContainerUtil.unmodifiableOrEmptyList(new ArrayList<CommittedChangeList>(incomingChanges));
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher((Project)this.myProject, COMMITTED_TOPIC, listener2 -> listener2.incomingChangesUpdated(incomingChangesCopy));
    }

    private void notifyRefreshError(VcsException e) {
        MessageBusUtil.invokeLaterIfNeededOnSyncPublisher((Project)this.myProject, COMMITTED_TOPIC, listener2 -> listener2.refreshErrorStatusChanged(e));
    }

    public boolean isRefreshingIncomingChanges() {
        return this.myRefreshingIncomingChanges;
    }

    public boolean refreshIncomingChanges() {
        boolean hasChanges = false;
        Collection<ChangesCacheFile> caches = this.myCachesHolder.getAllCaches();
        for (ChangesCacheFile file : caches) {
            try {
                if (file.isEmpty()) continue;
                CommittedChangesCache.debug("Refreshing incoming changes for " + String.valueOf(file.getLocation()));
                boolean changesForCache = file.refreshIncomingChanges();
                hasChanges |= changesForCache;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (VcsException e) {
                this.notifyRefreshError(e);
            }
        }
        return hasChanges;
    }

    public void refreshIncomingChangesAsync() {
        CommittedChangesCache.debug("Refreshing incoming changes in background");
        this.myRefreshingIncomingChanges = true;
        this.myTaskQueue.run(() -> {
            this.refreshIncomingChanges();
            this.refreshIncomingUi();
        });
    }

    private void refreshIncomingUi() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myRefreshingIncomingChanges = false;
            CommittedChangesCache.debug("Incoming changes refresh complete, clearing cached incoming changes");
            this.notifyReloadIncomingChanges();
        }, ModalityState.nonModal(), this.myProject.getDisposed());
    }

    public void refreshAllCachesAsync(boolean initIfEmpty, boolean inBackground) {
        Runnable task = () -> {
            final Collection<ChangesCacheFile> files = this.myCachesHolder.getAllCaches();
            RefreshResultConsumer notifyConsumer = new RefreshResultConsumer(){
                private VcsException myError = null;
                private int myCount = 0;
                private int totalChangesCount = 0;

                @Override
                public void receivedChanges(List<CommittedChangeList> changes) {
                    this.totalChangesCount += changes.size();
                    this.checkDone();
                }

                @Override
                public void receivedError(VcsException ex) {
                    this.myError = ex;
                    this.checkDone();
                }

                private void checkDone() {
                    ++this.myCount;
                    if (this.myCount == files.size()) {
                        CommittedChangesCache.this.myTaskQueue.run(() -> {
                            if (this.totalChangesCount > 0) {
                                CommittedChangesCache.this.notifyReloadIncomingChanges();
                            } else {
                                ((CommittedChangesTreeBrowser.CommittedChangesReloadListener)CommittedChangesCache.this.myProject.getMessageBus().syncPublisher(CommittedChangesTreeBrowser.ITEMS_RELOADED)).emptyRefresh();
                            }
                        });
                        CommittedChangesCache.this.notifyRefreshError(this.myError);
                    }
                }
            };
            for (ChangesCacheFile file : files) {
                if (inBackground && !file.getVcs().isVcsBackgroundOperationsAllowed(file.getRootPath().getVirtualFile())) continue;
                this.refreshCacheAsync(file, initIfEmpty, notifyConsumer, false);
            }
        };
        this.myTaskQueue.run(task);
    }

    private void notifyReloadIncomingChanges() {
        this.myCachedIncomingChangeLists = null;
        Runnable runnable = () -> this.loadIncomingChanges(true);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.myTaskQueue.run(runnable);
        } else {
            runnable.run();
        }
    }

    private void refreshCacheAsync(ChangesCacheFile cache, boolean initIfEmpty, @Nullable RefreshResultConsumer consumer) {
        this.refreshCacheAsync(cache, initIfEmpty, consumer, true);
    }

    private void refreshCacheAsync(ChangesCacheFile cache, boolean initIfEmpty, @Nullable RefreshResultConsumer consumer, boolean asynch) {
        try {
            if (!initIfEmpty && cache.isEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        Runnable task = () -> {
            block5: {
                try {
                    List<CommittedChangeList> list = initIfEmpty && cache.isEmpty() ? this.initCache(cache) : this.refreshCache(cache);
                    if (consumer != null) {
                        consumer.receivedChanges(list);
                    }
                }
                catch (ProcessCanceledException list) {
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (VcsException e) {
                    if (consumer == null) break block5;
                    consumer.receivedError(e);
                }
            }
        };
        if (asynch) {
            this.myTaskQueue.run(task);
        } else {
            task.run();
        }
    }

    private void updateRefreshTimer() {
        this.cancelRefreshTimer();
        if (((CommittedChangesCacheState)this.getState()).isRefreshEnabled()) {
            this.refreshRunnable = new MyRefreshRunnable(this);
            this.myFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(this.refreshRunnable, (long)((CommittedChangesCacheState)this.getState()).getRefreshInterval() * 60L, (long)((CommittedChangesCacheState)this.getState()).getRefreshInterval() * 60L, TimeUnit.SECONDS);
        }
    }

    private void cancelRefreshTimer() {
        if (this.refreshRunnable != null) {
            this.refreshRunnable.cancel();
            this.refreshRunnable = null;
        }
        if (this.myFuture != null) {
            this.myFuture.cancel(false);
            this.myFuture = null;
        }
    }

    @Nullable
    public Pair<CommittedChangeList, Change> getIncomingChangeList(VirtualFile file) {
        if (this.myCachedIncomingChangeLists != null) {
            File ioFile = new File(file.getPath());
            for (CommittedChangeList changeList : this.myCachedIncomingChangeLists) {
                for (Change change : changeList.getChanges()) {
                    if (!change.affectsFile(ioFile)) continue;
                    return Pair.create((Object)changeList, (Object)change);
                }
            }
        }
        return null;
    }

    private static long getLatestListForFile(ChangesCacheFile file) {
        try {
            if (file == null || file.isEmpty()) {
                return -1L;
            }
            return file.getLastCachedChangelist();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @ApiStatus.Internal
    public CachesHolder getCachesHolder() {
        return this.myCachesHolder;
    }

    public void submitExternallyLoaded(RepositoryLocation location, long myLastCl, List<CommittedChangeList> lists) {
        this.myExternallyLoadedChangeLists.put(location.getKey(), (Pair<Long, List<CommittedChangeList>>)new Pair((Object)myLastCl, lists));
    }

    public RepositoryLocationCache getLocationCache() {
        return this.myLocationCache;
    }

    private /* synthetic */ void lambda$commitMessageChanged$8(RepositoryLocation location, long number, String newMessage) {
        ChangesCacheFile file = this.myCachesHolder.haveCache(location);
        if (file != null) {
            try {
                if (file.isEmpty()) {
                    return;
                }
                file.editChangelist(number, newMessage);
                this.loadIncomingChanges(true);
                this.fireChangesLoaded(location, Collections.emptyList());
            }
            catch (IOException e) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsBundle.message((String)"notification.content.didn.t.update.repository.changes", (Object[])new Object[]{e.getMessage()}), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFile";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesCache";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChanges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incomingChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "trimToSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initCache";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireChangesLoaded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendLoadedChanges";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeChangesInReadAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trimToSize";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "commitMessageChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireIncomingChangesUpdated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 13 -> new IllegalStateException(string);
        };
    }

    private final class MyProjectChangesLoader
    implements Runnable {
        private final ChangeBrowserSettings mySettings;
        private final int myMaxCount;
        private final boolean myCacheOnly;
        private final Consumer<? super List<CommittedChangeList>> myConsumer;
        private final Consumer<? super List<VcsException>> myErrorConsumer;
        private final LinkedHashSet<CommittedChangeList> myResult = new LinkedHashSet();
        private final List<VcsException> myExceptions = new ArrayList<VcsException>();
        private boolean myDisposed = false;

        private MyProjectChangesLoader(ChangeBrowserSettings settings, int maxCount, boolean cacheOnly, Consumer<? super List<CommittedChangeList>> consumer, Consumer<? super List<VcsException>> errorConsumer) {
            this.mySettings = settings;
            this.myMaxCount = maxCount;
            this.myCacheOnly = cacheOnly;
            this.myConsumer = consumer;
            this.myErrorConsumer = errorConsumer;
        }

        @Override
        public void run() {
            for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance((Project)CommittedChangesCache.this.myProject).getAllActiveVcss()) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                if (provider == null) continue;
                VcsCommittedListsZipper vcsZipper = provider.getZipper();
                CommittedListsSequencesZipper zipper = null;
                if (vcsZipper != null) {
                    zipper = new CommittedListsSequencesZipper(vcsZipper);
                }
                boolean zipSupported = zipper != null;
                Map<VirtualFile, RepositoryLocation> map2 = CommittedChangesCache.this.myCachesHolder.getAllRootsUnderVcs(vcs);
                for (VirtualFile root : map2.keySet()) {
                    if (CommittedChangesCache.this.myProject.isDisposed()) {
                        return;
                    }
                    RepositoryLocation location = map2.get(root);
                    try {
                        List<CommittedChangeList> lists = CommittedChangesCache.this.getChanges(this.mySettings, root, vcs, this.myMaxCount, this.myCacheOnly, provider, location);
                        if (lists == null) continue;
                        if (zipSupported) {
                            zipper.add(location, lists);
                            continue;
                        }
                        this.myResult.addAll(lists);
                    }
                    catch (VcsException e) {
                        this.myExceptions.add(e);
                    }
                    catch (ProcessCanceledException e) {
                        this.myDisposed = true;
                    }
                }
                if (!zipSupported) continue;
                this.myResult.addAll(zipper.execute());
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                LOG.info("FINISHED CommittedChangesCache.getProjectChangesAsync - execution in queue");
                if (CommittedChangesCache.this.myProject.isDisposed()) {
                    return;
                }
                if (!this.myExceptions.isEmpty()) {
                    this.myErrorConsumer.consume(this.myExceptions);
                } else if (!this.myDisposed) {
                    this.myConsumer.consume(new ArrayList<CommittedChangeList>(this.myResult));
                }
            }, ModalityState.nonModal());
        }
    }

    private static final class IncomingListsZipper
    extends VcsCommittedListsZipperAdapter {
        private final VcsCommittedListsZipper myVcsZipper;

        private IncomingListsZipper(VcsCommittedListsZipper vcsZipper) {
            super(null);
            this.myVcsZipper = vcsZipper;
        }

        @NotNull
        public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(@NotNull List<? extends RepositoryLocation> in) {
            if (in == null) {
                IncomingListsZipper.$$$reportNull$$$0(0);
            }
            Pair pair = this.myVcsZipper.groupLocations(in);
            if (pair == null) {
                IncomingListsZipper.$$$reportNull$$$0(1);
            }
            return pair;
        }

        @NotNull
        public CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<? extends CommittedChangeList> lists) {
            if (group == null) {
                IncomingListsZipper.$$$reportNull$$$0(2);
            }
            if (lists == null) {
                IncomingListsZipper.$$$reportNull$$$0(3);
            }
            if (lists.size() == 1) {
                CommittedChangeList committedChangeList = lists.get(0);
                if (committedChangeList == null) {
                    IncomingListsZipper.$$$reportNull$$$0(4);
                }
                return committedChangeList;
            }
            CommittedChangeList victim = ReceivedChangeList.unwrap(lists.get(0));
            ReceivedChangeList result2 = new ReceivedChangeList(victim);
            result2.setForcePartial(false);
            HashSet baseChanges = new HashSet();
            for (CommittedChangeList committedChangeList : lists) {
                baseChanges.addAll(ReceivedChangeList.unwrap(committedChangeList).getChanges());
                Collection changes = committedChangeList.getChanges();
                for (Change change : changes) {
                    if (result2.getChanges().contains(change)) continue;
                    result2.addChange(change);
                }
            }
            result2.setForcePartial(baseChanges.size() != result2.getChanges().size());
            ReceivedChangeList receivedChangeList = result2;
            if (receivedChangeList == null) {
                IncomingListsZipper.$$$reportNull$$$0(5);
            }
            return receivedChangeList;
        }

        public long getNumber(@NotNull CommittedChangeList list) {
            if (list == null) {
                IncomingListsZipper.$$$reportNull$$$0(6);
            }
            return this.myVcsZipper.getNumber(list);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesCache$IncomingListsZipper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lists";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesCache$IncomingListsZipper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupLocations";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "zip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "groupLocations";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "zip";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getNumber";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static interface RefreshResultConsumer {
        public void receivedChanges(List<CommittedChangeList> var1);

        public void receivedError(VcsException var1);
    }

    private static final class MyRefreshRunnable
    implements Runnable {
        private CommittedChangesCache myCache;

        private MyRefreshRunnable(CommittedChangesCache cache) {
            this.myCache = cache;
        }

        private void cancel() {
            this.myCache = null;
        }

        @Override
        public void run() {
            CommittedChangesCache cache = this.myCache;
            if (cache == null) {
                return;
            }
            cache.refreshAllCachesAsync(false, true);
            for (ChangesCacheFile file : cache.getCachesHolder().getAllCaches()) {
                if (!file.getVcs().isVcsBackgroundOperationsAllowed(file.getRootPath().getVirtualFile()) || !file.getProvider().refreshIncomingWithCommitted()) continue;
                cache.refreshIncomingChangesAsync();
                break;
            }
        }
    }
}

