/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/merge/MergeConflictsTreeTable;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "<init>", "(Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;)V", "doLayout", "", "updateColumnSizes", "calcColumnWidth", "", "maxStringValue", "", "columnInfo", "Lcom/intellij/util/ui/ColumnInfo;", "", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class MergeConflictsTreeTable
extends TreeTable {
    @NotNull
    private final ListTreeTableModelOnColumns tableModel;

    public MergeConflictsTreeTable(@NotNull ListTreeTableModelOnColumns tableModel) {
        Intrinsics.checkNotNullParameter((Object)tableModel, (String)"tableModel");
        super((TreeTableModel)tableModel);
        this.tableModel = tableModel;
        this.getTableHeader().setReorderingAllowed(false);
        this.getTree().setRootVisible(false);
        if (this.tableModel.getColumnCount() > 1) {
            this.setShowColumns(true);
        }
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateColumnSizes();
        }
        super.doLayout();
    }

    private final void updateColumnSizes() {
        ColumnInfo[] columnInfoArray = this.tableModel.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)columnInfoArray, (String)"getColumns(...)");
        ColumnInfo[] columnInfoArray2 = columnInfoArray;
        int n = columnInfoArray2.length;
        for (int i = 0; i < n; ++i) {
            String it;
            int index = i;
            ColumnInfo columnInfo = columnInfoArray2[i];
            TableColumn column = this.columnModel.getColumn(index);
            if (columnInfo.getMaxStringValue() == null) continue;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)columnInfo);
            int width = this.calcColumnWidth(it, (ColumnInfo<Object, Object>)columnInfo);
            column.setPreferredWidth(width);
        }
        int size = this.getWidth();
        int fileColumn = 0;
        int n2 = this.tableModel.getColumns().length;
        for (int i = 0; i < n2; ++i) {
            if (i == 0) continue;
            size -= this.columnModel.getColumn(i).getPreferredWidth();
        }
        this.columnModel.getColumn(fileColumn).setPreferredWidth(Math.max(size, JBUI.scale((int)200)));
    }

    private final int calcColumnWidth(String maxStringValue, ColumnInfo<Object, Object> columnInfo) {
        String string = StringUtil.shortenTextWithEllipsis((String)columnInfo.getName(), (int)15, (int)7, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String columnName = string;
        return Math.max(this.getFontMetrics(this.getFont()).stringWidth(maxStringValue), this.getFontMetrics(this.tableHeader.getFont()).stringWidth(columnName)) + columnInfo.getAdditionalWidth();
    }
}

