/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0005H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/update/UpdateOptionsDialog;", "Lcom/intellij/openapi/vcs/update/UpdateOrStatusOptionsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsSafe;", "envToConfMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lkotlin/collections/LinkedHashMap;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/LinkedHashMap;)V", "getActionNameForDimensions", "getDoNotShowMessage", "isToBeShown", "", "setToBeShown", "", "value", "onOk", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public class UpdateOptionsDialog
extends UpdateOrStatusOptionsDialog {
    public UpdateOptionsDialog(@NotNull Project project, @NotNull String title, @NotNull LinkedHashMap<Configurable, AbstractVcs> envToConfMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(envToConfMap, (String)"envToConfMap");
        super(project, title, (Map<Configurable, AbstractVcs>)envToConfMap);
    }

    @Override
    @NotNull
    protected String getActionNameForDimensions() {
        return "update-v2";
    }

    @NotNull
    protected String getDoNotShowMessage() {
        String string = VcsBundle.message((String)"update.checkbox.don.t.show.again", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected boolean isToBeShown() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectLevelVcsManagerEx.Companion.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.UPDATE).getValue();
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        if (onOk) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            ProjectLevelVcsManagerEx.Companion.getInstanceEx(project).getOptions(VcsConfiguration.StandardOption.UPDATE).setValue(value);
        }
    }
}

