/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.branch;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.LinkedBranchData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u001a\u0010\t\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\bH\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\bH\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/branch/BranchPresentation;", "", "<init>", "()V", "getText", "", "branches", "", "Lcom/intellij/vcs/branch/BranchData;", "getPresentableText", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "branch", "getTooltip", "getSingleTooltip", "getMultiTooltip", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nBranchPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchPresentation.kt\ncom/intellij/vcs/branch/BranchPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1696#2,8:48\n1696#2,8:56\n1068#2:64\n1#3:65\n*S KotlinDebug\n*F\n+ 1 BranchPresentation.kt\ncom/intellij/vcs/branch/BranchPresentation\n*L\n11#1:48,8\n24#1:56,8\n28#1:64\n*E\n"})
public final class BranchPresentation {
    @NotNull
    public static final BranchPresentation INSTANCE = new BranchPresentation();

    private BranchPresentation() {
    }

    @Nls
    @NotNull
    public final String getText(@NotNull Collection<? extends BranchData> branches) {
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String key$iv = it.getBranchName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        return switch (distinct.size()) {
            case 0 -> "";
            case 1 -> this.getPresentableText((BranchData)CollectionsKt.first((List)distinct));
            default -> this.getPresentableText((BranchData)CollectionsKt.first((List)distinct)) + ",...";
        };
    }

    @Nls
    @NotNull
    public final String getPresentableText(@NotNull BranchData branch) {
        String string;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (branch instanceof LinkedBranchData) {
            string = ((LinkedBranchData)branch).getBranchName();
            if (string == null) {
                string = "!";
            }
        } else {
            string = branch.getBranchName();
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    @Nls
    @Nullable
    public final String getTooltip(@NotNull Collection<? extends BranchData> branches) {
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            LinkedBranchData linkedBranchData = it instanceof LinkedBranchData ? (LinkedBranchData)it : null;
            Pair key$iv = TuplesKt.to((Object)it.getBranchName(), (Object)(linkedBranchData != null ? linkedBranchData.getLinkedBranchName() : null));
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        return switch (distinct.size()) {
            case 0 -> null;
            case 1 -> this.getSingleTooltip((BranchData)CollectionsKt.first((List)distinct));
            default -> {
                Iterable $this$sortedBy$iv = branches;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        BranchData it = (BranchData)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getPresentableRootName());
                        it = (BranchData)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPresentableRootName())));
                    }
                }), (CharSequence)"", null, null, (int)0, null, BranchPresentation::getTooltip$lambda$2, (int)30, null);
            }
        };
    }

    @Nls
    @Nullable
    public final String getSingleTooltip(@NotNull BranchData branch) {
        Object object;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    object = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string = ((LinkedBranchData)branch).getBranchName() + " " + UIUtil.rightArrow() + " " + it;
                    object = string;
                    if (string != null) break block4;
                }
                String string = VcsBundle.message((String)"changes.no.tracking.branch", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                break block4;
            }
            object = null;
        }
        return object;
    }

    @Nls
    @NotNull
    public final String getMultiTooltip(@NotNull BranchData branch) {
        Object object;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    object = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string = " " + UIUtil.rightArrow() + " " + it;
                    object = string;
                    if (string != null) break block4;
                }
                String string = VcsBundle.message((String)"changes.no.tracking.branch.suffix", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                break block4;
            }
            object = "";
        }
        String linkedBranchPart = object;
        return "<tr><td>" + branch.getPresentableRootName() + ":</td><td>" + this.getPresentableText(branch) + linkedBranchPart + "</td></tr>";
    }

    private static final CharSequence getTooltip$lambda$2(BranchData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getMultiTooltip(it);
    }
}

