/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ShareProjectActionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.CommitExceptionWithActions;
import com.intellij.vcs.commit.CommitNotification;
import com.intellij.vcs.commit.CommitSuccessNotificationActionProvider;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0002J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0003J\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lcom/intellij/vcs/commit/VcsCommitter;", "<init>", "(Lcom/intellij/vcs/commit/VcsCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "Lorg/jetbrains/annotations/NotNull;", "onSuccess", "", "onCancel", "onFailure", "reportResult", "getCommitSummary", "", "Lcom/intellij/openapi/util/NlsSafe;", "countChangesIgnoringChangeLists", "", "", "Lcom/intellij/openapi/vcs/changes/Change;", "CommitNotificationType", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nShowNotificationCommitResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n812#2,12:128\n1391#2:140\n1480#2,5:141\n1915#2,2:146\n1391#2:148\n1480#2,5:149\n777#2:154\n873#2,2:155\n1924#2,3:157\n1586#2:160\n1661#2,3:161\n1586#2:164\n1661#2,3:165\n*S KotlinDebug\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n*L\n60#1:128,12\n60#1:140\n60#1:141,5\n67#1:146,2\n72#1:148\n72#1:149,5\n78#1:154\n78#1:155,2\n79#1:157,3\n105#1:160\n105#1:161,3\n110#1:164\n110#1:165,3\n*E\n"})
public final class ShowNotificationCommitResultHandler
implements CommitterResultHandler {
    @NotNull
    private final VcsCommitter committer;
    @NotNull
    private final VcsNotifier notifier;

    public ShowNotificationCommitResultHandler(@NotNull VcsCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(this.committer.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
        this.notifier = vcsNotifier;
    }

    @Override
    public void onSuccess() {
        this.reportResult();
    }

    @Override
    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message((String)"vcs.commit.canceled", (Object[])new Object[0]));
    }

    @Override
    public void onFailure() {
        this.reportResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportResult() {
        Object it;
        void $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        CommitNotification commitNotification;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        String string;
        Object object;
        String message = this.getCommitSummary();
        List<VcsException> commitExceptions = this.committer.getExceptions();
        List<VcsException> commitErrors = Committer.Companion.collectErrors(commitExceptions);
        int warningsSize = commitExceptions.size() - commitErrors.size();
        int changesCommitted = this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getChanges()) - this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getFailedToCommitChanges());
        Set<VirtualFile> set2 = LocalChangesCommitterKt.getFreshUnhostedRoots(this.committer.getCommitContext());
        VirtualFile freshRoot = set2 != null ? (VirtualFile)CollectionsKt.singleOrNull((Iterable)set2) : null;
        CommitNotificationType type = !((Collection)commitErrors).isEmpty() ? CommitNotificationType.Failed : (!((Collection)commitExceptions).isEmpty() ? CommitNotificationType.SuccessfulWithWarnings : (freshRoot != null ? CommitNotificationType.SuccessfulInitial : CommitNotificationType.Successful));
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object = new Object[]{commitErrors.size()};
                String string2 = VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])object);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 2: {
                object = new Object[]{warningsSize};
                String string3 = VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])object);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            case 3: 
            case 4: {
                object = new Object[]{changesCommitted};
                String string4 = VcsBundle.message((String)"vcs.commit.files.committed", (Object[])object);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String title = string;
        Iterable $this$filterIsInstance$iv = commitExceptions;
        boolean $i$f$filterIsInstance = false;
        object = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CommitExceptionWithActions)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            CommitExceptionWithActions it2 = (CommitExceptionWithActions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getActions();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List notificationActions = (List)destination$iv$iv2;
        CommitNotification $this$reportResult_u24lambda_u241 = commitNotification = new CommitNotification(VcsNotifier.importantNotification().getDisplayId(), title, message, type.getNotificationType());
        boolean bl = false;
        $this$reportResult_u24lambda_u241.setDisplayId(type.getDisplayId());
        if (!((Collection)commitExceptions).isEmpty()) {
            Iterable $this$forEach$iv = notificationActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction p0 = (AnAction)element$iv;
                boolean bl2 = false;
                $this$reportResult_u24lambda_u241.addAction(p0);
            }
            VcsNotifier.addShowDetailsAction(this.committer.getProject(), $this$reportResult_u24lambda_u241);
        }
        if (commitErrors.isEmpty()) {
            void $this$flatMap$iv2;
            Object element$iv$iv;
            Iterable $this$forEach$iv = CommitSuccessNotificationActionProvider.EP_NAME.getExtensionList();
            CommitNotification commitNotification2 = $this$reportResult_u24lambda_u241;
            boolean $i$f$flatMap2 = false;
            element$iv$iv = $this$flatMap$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                it = (CommitSuccessNotificationActionProvider)element$iv$iv2;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getActions(this.committer, $this$reportResult_u24lambda_u241);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            commitNotification2.addActions((List)destination$iv$iv);
        }
        if (freshRoot != null && commitErrors.isEmpty()) {
            void $this$forEachIndexed$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $this$flatMap$iv2 = ShareProjectActionProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (ShareProjectActionProvider)element$iv$iv2;
                boolean bl4 = false;
                if (!it.isApplicableForRoot(this.committer.getProject(), freshRoot)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string5;
                void ep;
                int n;
                Object element$iv$iv2;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (ShareProjectActionProvider)item$iv;
                int index = n;
                boolean bl5 = false;
                if (index == 0) {
                    var24_42 = new Object[]{ep.getHostServiceName()};
                    string5 = VcsBundle.message((String)"vcs.commit.notification.shareProjectOn", (Object[])var24_42);
                } else {
                    var24_42 = new Object[]{ep.getHostServiceName()};
                    string5 = VcsBundle.message((String)"vcs.commit.notification.shareProjectOn.orOn", (Object[])var24_42);
                }
                $this$reportResult_u24lambda_u241.addAction((AnAction)NotificationAction.create((String)string5, (arg_0, arg_1) -> ShowNotificationCommitResultHandler.reportResult$lambda$1$2$1((arg_0, arg_1) -> ShowNotificationCommitResultHandler.reportResult$lambda$1$2$0((ShareProjectActionProvider)ep, freshRoot, arg_0, arg_1), arg_0, arg_1)));
            }
        }
        CommitNotification notification = commitNotification;
        notification.expirePreviousAndNotify(this.committer.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions;
        Collection<HtmlChunk> collection;
        Collection destination$iv$iv;
        HtmlBuilder htmlBuilder;
        HtmlChunk htmlChunk;
        Set<String> feedback;
        HtmlBuilder htmlBuilder2;
        HtmlBuilder $this$getCommitSummary_u24lambda_u240 = htmlBuilder2 = new HtmlBuilder();
        boolean bl = false;
        String commitMessage = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage)) {
            $this$getCommitSummary_u24lambda_u240.append(commitMessage);
        }
        if (!((Collection)(feedback = this.committer.getFeedback())).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!$this$getCommitSummary_u24lambda_u240.isEmpty()) {
                $this$getCommitSummary_u24lambda_u240.br();
            }
            Iterable iterable = feedback;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u240;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(HtmlChunk.text((String)p0));
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!$this$getCommitSummary_u24lambda_u240.isEmpty()) {
                $this$getCommitSummary_u24lambda_u240.br();
            }
            Iterable $i$f$map = exceptions;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u240;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsException bl2 = (VcsException)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(HtmlChunk.text((String)it.getMessage()));
            }
            collection = (List)destination$iv$iv2;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        String string = htmlBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int countChangesIgnoringChangeLists(Collection<? extends Change> $this$countChangesIgnoringChangeLists) {
        return new HashSet<Change>($this$countChangesIgnoringChangeLists).size();
    }

    private static final Unit reportResult$lambda$1$2$0(ShareProjectActionProvider $ep, VirtualFile $freshRoot, AnActionEvent e, Notification notification) {
        $ep.getAction().actionPerformed(e.withDataContext(SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.VIRTUAL_FILE, (Object)$freshRoot, (DataContext)e.getDataContext())));
        return Unit.INSTANCE;
    }

    private static final void reportResult$lambda$1$2$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler$CommitNotificationType;", "", "displayId", "", "notificationType", "Lcom/intellij/notification/NotificationType;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lcom/intellij/notification/NotificationType;)V", "getDisplayId", "()Ljava/lang/String;", "getNotificationType", "()Lcom/intellij/notification/NotificationType;", "Successful", "SuccessfulInitial", "SuccessfulWithWarnings", "Failed", "intellij.platform.vcs.impl"})
    private static final class CommitNotificationType
    extends Enum<CommitNotificationType> {
        @NotNull
        private final String displayId;
        @NotNull
        private final NotificationType notificationType;
        public static final /* enum */ CommitNotificationType Successful = new CommitNotificationType("vcs.commit.finished", NotificationType.INFORMATION);
        public static final /* enum */ CommitNotificationType SuccessfulInitial = new CommitNotificationType("vcs.commit.finished.initial", NotificationType.INFORMATION);
        public static final /* enum */ CommitNotificationType SuccessfulWithWarnings = new CommitNotificationType("vcs.commit.finished.with.warnings", NotificationType.WARNING);
        public static final /* enum */ CommitNotificationType Failed = new CommitNotificationType("vcs.commit.failed", NotificationType.ERROR);
        private static final /* synthetic */ CommitNotificationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CommitNotificationType(String displayId, NotificationType notificationType) {
            this.displayId = displayId;
            this.notificationType = notificationType;
        }

        @NotNull
        public final String getDisplayId() {
            return this.displayId;
        }

        @NotNull
        public final NotificationType getNotificationType() {
            return this.notificationType;
        }

        public static CommitNotificationType[] values() {
            return (CommitNotificationType[])$VALUES.clone();
        }

        public static CommitNotificationType valueOf(String value) {
            return Enum.valueOf(CommitNotificationType.class, value);
        }

        @NotNull
        public static EnumEntries<CommitNotificationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = commitNotificationTypeArray = new CommitNotificationType[]{CommitNotificationType.Successful, CommitNotificationType.SuccessfulInitial, CommitNotificationType.SuccessfulWithWarnings, CommitNotificationType.Failed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommitNotificationType.values().length];
            try {
                nArray[CommitNotificationType.Failed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommitNotificationType.SuccessfulWithWarnings.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommitNotificationType.Successful.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommitNotificationType.SuccessfulInitial.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

