/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.promo;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.java.promo.Framework;
import com.intellij.openapi.module.Module;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"APPLICATION_PROPERTIES", "", "APPLICATION_YAML", "APPLICATION_YML", "SPRING_BOOT_MAVEN", "MICRONAUT_MAVEN", "QUARKUS_MAVEN", "KTOR_MAVEN", "detectFramework", "Lcom/intellij/java/promo/Framework;", "module", "Lcom/intellij/openapi/module/Module;", "FRAMEWORK_SUGGESTION_DISMISSED_PREFIX", "dismissPluginSuggestion", "", "framework", "isPluginSuggestionDismissed", "", "intellij.java.promo"})
public final class FrameworkSuggestionProviderKt {
    @NotNull
    private static final String APPLICATION_PROPERTIES = "application.properties";
    @NotNull
    private static final String APPLICATION_YAML = "application.yaml";
    @NotNull
    private static final String APPLICATION_YML = "application.yml";
    @NotNull
    private static final String SPRING_BOOT_MAVEN = "org.springframework.boot:spring-boot";
    @NotNull
    private static final String MICRONAUT_MAVEN = "io.micronaut:micronaut-core";
    @NotNull
    private static final String QUARKUS_MAVEN = "io.quarkus:quarkus-core";
    @NotNull
    private static final String KTOR_MAVEN = "io.ktor:ktor-http";
    @NotNull
    private static final String FRAMEWORK_SUGGESTION_DISMISSED_PREFIX = "promo.framework.suggestion.dismissed.";

    private static final Framework detectFramework(Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_BOOT_MAVEN) ? new Framework("spring.boot", "com.intellij.spring.boot", "Spring Boot") : (JavaLibraryUtil.hasLibraryJar((Module)module, (String)MICRONAUT_MAVEN) ? new Framework("micronaut", "com.intellij.micronaut", "Micronaut") : (JavaLibraryUtil.hasLibraryJar((Module)module, (String)QUARKUS_MAVEN) ? new Framework("quarkus", "com.intellij.quarkus", "Quarkus") : (JavaLibraryUtil.hasLibraryJar((Module)module, (String)KTOR_MAVEN) ? new Framework("ktor", "intellij.ktor", "Ktor") : null)));
    }

    private static final void dismissPluginSuggestion(Framework framework) {
        PropertiesComponent.getInstance().setValue(FRAMEWORK_SUGGESTION_DISMISSED_PREFIX + framework.getKey(), true);
    }

    public static final boolean isPluginSuggestionDismissed(@NotNull Framework framework) {
        Intrinsics.checkNotNullParameter((Object)framework, (String)"framework");
        return PropertiesComponent.getInstance().isTrueValue(FRAMEWORK_SUGGESTION_DISMISSED_PREFIX + framework.getKey());
    }

    public static final /* synthetic */ Framework access$detectFramework(Module module) {
        return FrameworkSuggestionProviderKt.detectFramework(module);
    }

    public static final /* synthetic */ void access$dismissPluginSuggestion(Framework framework) {
        FrameworkSuggestionProviderKt.dismissPluginSuggestion(framework);
    }
}

