/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.CacheAvoidingVirtualFileWrapper;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.FileNavigator;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.TransientVirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.VirtualFileFilteringListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewVirtualFileSystem
extends VirtualFileSystem
implements FileSystemInterface,
CachingVirtualFileSystem {
    static final Logger LOG = Logger.getInstance(NewVirtualFileSystem.class);
    private final Map<VirtualFileListener, VirtualFileListener> myListenerWrappers = new ConcurrentHashMap<VirtualFileListener, VirtualFileListener>();
    private static final String FILE_SEPARATORS = "/" + (File.separatorChar == '/' ? "" : File.separator);

    @ApiStatus.OverrideOnly
    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.OverrideOnly
    @NotNull
    protected abstract String extractRootPath(@NotNull String var1);

    @Nullable
    public abstract VirtualFile findFileByPathIfCached(@NonNls @NotNull String var1);

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        this.refresh(asynchronous);
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return false;
    }

    public String resolveSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(3);
        }
        VirtualFileFilteringListener wrapper = new VirtualFileFilteringListener(listener, this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)wrapper);
        this.myListenerWrappers.put(listener, wrapper);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        VirtualFileListener wrapper;
        if (listener == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if ((wrapper = this.myListenerWrappers.remove(listener)) != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(wrapper);
        }
    }

    public abstract int getRank();

    @NotNull
    public abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    @NotNull
    public abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    public abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    public abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    public abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    public abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    public boolean markNewFilesAsDirty() {
        return false;
    }

    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(5);
        }
        String string = file.getName();
        if (string == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public abstract FileAttributes getAttributes(@NotNull VirtualFile var1);

    public boolean hasChildren(@NotNull VirtualFile file) {
        if (file == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(7);
        }
        return this.list(file).length != 0;
    }

    @ApiStatus.Internal
    @Nullable
    public VirtualFile findFileByPathWithoutCaching(@NotNull String path) {
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(8);
        }
        FileNavigator.NavigateResult<VirtualFile> result = NewVirtualFileSystem.findCachedOrTransientFileByPath(this, path);
        return result.resolvedFileOr(null);
    }

    @NotNull
    public static Pair<NewVirtualFile, NewVirtualFile> findCachedFileByPath(final @NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        FileNavigator<NewVirtualFile> navigator;
        FileNavigator.NavigateResult<NewVirtualFile> result;
        if (fileSystem == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(9);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(10);
        }
        if ((result = FileNavigator.navigate(fileSystem, path, navigator = new FileNavigator<NewVirtualFile>(){

            @Override
            @Nullable
            public NewVirtualFile parentOf(@NotNull NewVirtualFile file) {
                NewVirtualFile canonicalFile;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.is(VFileProperty.SYMLINK)) {
                    return file.getParent();
                }
                String canonicalPath = file.getCanonicalPath();
                if (canonicalPath != null && (canonicalFile = (NewVirtualFile)((Object)NewVirtualFileSystem.findCachedFileByPath((NewVirtualFileSystem)fileSystem, (String)canonicalPath).first)) != null) {
                    return canonicalFile.getParent();
                }
                return null;
            }

            @Override
            @Nullable
            public NewVirtualFile childOf(@NotNull NewVirtualFile parent, @NotNull String childName) {
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (childName == null) {
                    1.$$$reportNull$$$0(2);
                }
                return parent.findChildIfCached(childName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "childName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "parentOf";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childOf";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).isResolved()) {
            Pair pair = Pair.pair((Object)((Object)result.resolvedFileOrFail()), null);
            if (pair == null) {
                NewVirtualFileSystem.$$$reportNull$$$0(11);
            }
            return pair;
        }
        Pair pair = Pair.pair(null, (Object)((Object)result.lastResolvedFile()));
        if (pair == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @ApiStatus.Internal
    @NotNull
    public static FileNavigator.NavigateResult<VirtualFile> findCachedOrTransientFileByPath(final @NotNull NewVirtualFileSystem fileSystem, final @NotNull String path) {
        FileNavigator<VirtualFile> navigator;
        FileNavigator.NavigateResult<VirtualFile> result;
        if (fileSystem == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(13);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(14);
        }
        if (!(result = FileNavigator.navigate(fileSystem, path, navigator = new FileNavigator<VirtualFile>(){

            @Override
            @Nullable
            public VirtualFile parentOf(@NotNull VirtualFile file) {
                NewVirtualFile canonicalFile;
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!file.is(VFileProperty.SYMLINK)) {
                    return file.getParent();
                }
                String canonicalPath = file.getCanonicalPath();
                if (canonicalPath != null && (canonicalFile = (NewVirtualFile)((Object)NewVirtualFileSystem.findCachedFileByPath((NewVirtualFileSystem)fileSystem, (String)canonicalPath).first)) != null) {
                    return canonicalFile.getParent();
                }
                return null;
            }

            @Override
            public VirtualFile childOf(@NotNull VirtualFile parent, @NotNull String childName) {
                NewVirtualFile child;
                if (parent == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (childName == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (parent instanceof NewVirtualFile && (child = ((NewVirtualFile)parent).findChildIfCached(childName)) != null) {
                    return child;
                }
                return new TransientVirtualFileImpl(childName, path, fileSystem, parent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "childName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "parentOf";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childOf";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).isResolved()) {
            FileNavigator.NavigateResult<VirtualFile> navigateResult = FileNavigator.NavigateResult.empty();
            if (navigateResult == null) {
                NewVirtualFileSystem.$$$reportNull$$$0(15);
            }
            return navigateResult;
        }
        VirtualFile resolvedFile = result.resolvedFileOrFail();
        if (resolvedFile instanceof NewVirtualFile) {
            CacheAvoidingVirtualFileWrapper wrappedFile = new CacheAvoidingVirtualFileWrapper((NewVirtualFile)resolvedFile);
            FileNavigator.NavigateResult<VirtualFile> navigateResult = FileNavigator.NavigateResult.resolved(wrappedFile);
            if (navigateResult == null) {
                NewVirtualFileSystem.$$$reportNull$$$0(16);
            }
            return navigateResult;
        }
        FileNavigator.NavigateResult<VirtualFile> navigateResult = FileNavigator.NavigateResult.resolved(resolvedFile);
        if (navigateResult == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(17);
        }
        return navigateResult;
    }

    @ApiStatus.Internal
    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(18);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(19);
        }
        return (NewVirtualFile)((Object)NewVirtualFileSystem.findCachedFileByPath((NewVirtualFileSystem)fileSystem, (String)path).first);
    }

    @ApiStatus.Internal
    public static @Nullable Pair<@NotNull NewVirtualFile, @NotNull Iterable<String>> extractRootAndPathSegments(@NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        PathFromRoot pair;
        if (fileSystem == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(20);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(21);
        }
        if ((pair = NewVirtualFileSystem.extractRootFromPath(fileSystem, path)) == null) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)pair.pathFromRoot(), (String)FILE_SEPARATORS);
        return Pair.create((Object)((Object)pair.root()), (Object)parts);
    }

    @ApiStatus.Internal
    @Nullable
    public static PathFromRoot extractRootFromPath(@NotNull NewVirtualFileSystem fileSystem, @NotNull String path) {
        String normalizedPath;
        if (fileSystem == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(22);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(23);
        }
        if ((normalizedPath = fileSystem.normalize(path)) == null || normalizedPath.isBlank()) {
            return null;
        }
        String rootPath = fileSystem.extractRootPath(normalizedPath);
        if (rootPath.isBlank() || rootPath.length() > normalizedPath.length()) {
            LOG.warn(String.valueOf((Object)fileSystem) + " has extracted incorrect root '" + rootPath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(rootPath, fileSystem);
        if (root == null || !root.exists()) {
            return null;
        }
        int restPathStart = rootPath.length();
        if (restPathStart < normalizedPath.length() && normalizedPath.charAt(restPathStart) == '/') {
            ++restPathStart;
        }
        return new PathFromRoot(root, normalizedPath.substring(restPathStart));
    }

    @Nullable
    protected static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(24);
        }
        if (path == null) {
            NewVirtualFileSystem.$$$reportNull$$$0(25);
        }
        FileNavigator.NavigateResult<NewVirtualFile> result = FileNavigator.navigate(vfs, path, FileNavigator.POSIX_LIGHT);
        return result.resolvedFileOr(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedFileByPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedOrTransientFileByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathWithoutCaching";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCachedFileByPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCachedOrTransientFileByPath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractRootAndPathSegments";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractRootFromPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public record PathFromRoot(@NotNull NewVirtualFile root, @NotNull String pathFromRoot) {
        @NotNull
        private final NewVirtualFile root;
        @NotNull
        private final String pathFromRoot;

        public PathFromRoot(@NotNull NewVirtualFile root, @NotNull String pathFromRoot) {
            if (root == null) {
                PathFromRoot.$$$reportNull$$$0(0);
            }
            if (pathFromRoot == null) {
                PathFromRoot.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public NewVirtualFile root() {
            NewVirtualFile newVirtualFile = this.root;
            if (newVirtualFile == null) {
                PathFromRoot.$$$reportNull$$$0(2);
            }
            return newVirtualFile;
        }

        @NotNull
        public String pathFromRoot() {
            String string = this.pathFromRoot;
            if (string == null) {
                PathFromRoot.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathFromRoot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem$PathFromRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/NewVirtualFileSystem$PathFromRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "root";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pathFromRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

