/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsMetrics;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityBuilder;
import com.intellij.platform.workspace.jps.entities.ModuleEntityModifications;
import com.intellij.platform.workspace.jps.entities.ModuleExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleGroupPathEntity;
import com.intellij.platform.workspace.jps.entities.ModuleGroupPathEntityBuilder;
import com.intellij.platform.workspace.jps.entities.ModuleGroupPathEntityModifications;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.jps.entities.ModuleTypeId;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.serviceContainer.PrecomputedExtensionModelKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModifiableModuleModelBridgeImpl$disposeModule$;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModifiableModuleModelBridgeImplKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleBridgeUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.LegacyBridgeJpsEntitySourceFactory;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableModuleModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0004H\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\nH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0010\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u000fH\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001fH\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u001f2\u0006\u00107\u001a\u00020\u000fH\u0016J\b\u00108\u001a\u000204H\u0016J\b\u00109\u001a\u00020\nH\u0016J\b\u0010:\u001a\u000204H\u0016J\b\u0010;\u001a\u000204H\u0016J\b\u0010<\u001a\u00020\bH\u0016J\u0018\u0010=\u001a\u0002042\u0006\u00105\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u001f2\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u001fH\u0016J\u001d\u0010B\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010#2\u0006\u00105\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\nH\u0016J'\u0010E\u001a\u0002042\u0006\u00105\u001a\u00020\u001f2\u0010\u0010F\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010GR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\r\u001a#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000e\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0018j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0016`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001bj\b\u0012\u0004\u0012\u00020\u0016`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModifiableModuleModelBridgeImpl;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeModifiableBase;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModifiableModuleModelBridge;", "project", "Lcom/intellij/openapi/project/Project;", "moduleManager", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleManagerBridgeImpl;", "diff", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "cacheStorageResult", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleManagerBridgeImpl;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Z)V", "moduleTypes", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/workspace/jps/entities/ModuleTypeId;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "modulesToAdd", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "modulesToDispose", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "uncommittedModulesToDispose", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "currentModuleSet", "", "Lcom/intellij/openapi/module/Module;", "newNameToModule", "moduleGroupsAreModified", "getModules", "", "()[Lcom/intellij/openapi/module/Module;", "newNonPersistentModule", "moduleName", "moduleTypeId", "newModule", "filePath", "resolveShortWindowsName", "createModuleInstance", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "isNew", "getModuleByFilePath", "loadModule", "file", "Ljava/nio/file/Path;", "disposeModule", "", "module", "findModuleByName", "name", "dispose", "isChanged", "commit", "prepareForCommit", "collectChanges", "renameModule", "newName", "getModuleToBeRenamed", "getNewName", "getActualName", "getModuleGroupPath", "(Lcom/intellij/openapi/module/Module;)[Ljava/lang/String;", "hasModuleGroups", "setModuleGroupPath", "groupPath", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)V", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nModifiableModuleModelBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiableModuleModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModifiableModuleModelBridgeImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n37#2,2:361\n44#3,2:363\n46#3:368\n44#3,2:369\n46#3:374\n44#3,2:378\n46#3:383\n44#3,2:386\n46#3:391\n29#4,3:365\n29#4,3:371\n29#4,3:380\n29#4,3:388\n479#5:375\n1342#5,2:376\n1915#6,2:384\n*S KotlinDebug\n*F\n+ 1 ModifiableModuleModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModifiableModuleModelBridgeImpl\n*L\n60#1:361,2\n86#1:363,2\n86#1:368\n159#1:369,2\n159#1:374\n219#1:378,2\n219#1:383\n261#1:386,2\n261#1:391\n86#1:365,3\n159#1:371,3\n219#1:380,3\n261#1:388,3\n198#1:375\n201#1:376,2\n253#1:384,2\n*E\n"})
public final class ModifiableModuleModelBridgeImpl
extends LegacyBridgeModifiableBase
implements ModifiableModuleModelBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleManagerBridgeImpl moduleManager;
    @NotNull
    private final ConcurrentMap<String, ModuleTypeId> moduleTypes;
    @NotNull
    private final BidirectionalMap<String, ModuleBridge> modulesToAdd;
    @NotNull
    private final HashMap<String, ModuleBridge> modulesToDispose;
    @NotNull
    private final ArrayList<ModuleBridge> uncommittedModulesToDispose;
    @NotNull
    private final Set<Module> currentModuleSet;
    @NotNull
    private final BidirectionalMap<String, ModuleBridge> newNameToModule;
    private boolean moduleGroupsAreModified;
    @NotNull
    private static final AtomicLong moduleRenamingTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong disposingTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong loadModuleTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong newModuleTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public ModifiableModuleModelBridgeImpl(@NotNull Project project, @NotNull ModuleManagerBridgeImpl moduleManager, @NotNull MutableEntityStorage diff, boolean cacheStorageResult) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)moduleManager), (String)"moduleManager");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        super(diff, cacheStorageResult);
        this.project = project;
        this.moduleManager = moduleManager;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> ModifiableModuleModelBridgeImpl.moduleTypes$lambda$1(ModifiableModuleModelBridgeImpl::moduleTypes$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.moduleTypes = concurrentMap;
        this.modulesToAdd = new BidirectionalMap();
        this.modulesToDispose = new HashMap();
        this.uncommittedModulesToDispose = new ArrayList();
        this.currentModuleSet = ArraysKt.toMutableSet((Object[])this.moduleManager.getModules());
        this.newNameToModule = new BidirectionalMap();
    }

    public /* synthetic */ ModifiableModuleModelBridgeImpl(Project project, ModuleManagerBridgeImpl moduleManagerBridgeImpl, MutableEntityStorage mutableEntityStorage, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, moduleManagerBridgeImpl, mutableEntityStorage, bl);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Module[] getModules() {
        Collection $this$toTypedArray$iv = this.currentModuleSet;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Module[0]);
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)moduleTypeId, (String)"moduleTypeId");
        ModuleEntity moduleEntity = (ModuleEntity)this.getDiff().addEntity((WorkspaceEntity.Builder)ModuleEntityModifications.createModuleEntity$default((String)moduleName, (List)CollectionsKt.listOf((Object)ModuleSourceDependency.INSTANCE), (EntitySource)NonPersistentEntitySource.INSTANCE, null, (int)8, null));
        ModuleBridge module = this.moduleManager.createModule(moduleEntity.getSymbolicId(), moduleName, null, this.getEntityStorageOnDiff(), this.getDiff(), (Function1<? super ModuleBridge, Unit>)((Function1)ModifiableModuleModelBridgeImpl::newNonPersistentModule$lambda$0));
        ModuleManagerBridgeImpl.Companion.getMutableModuleMap(this.getDiff()).addMapping((WorkspaceEntity)moduleEntity, (Object)module);
        this.modulesToAdd.put((Object)moduleName, (Object)module);
        this.currentModuleSet.add(module);
        module.initNewlyAddedModule();
        module.setModuleType(moduleTypeId);
        return module;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        ModuleBridge moduleBridge;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)moduleTypeId, (String)"moduleTypeId");
        AtomicLong arg0$iv = newModuleTimeMs;
        boolean bl = false;
        ModuleBridge value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = FileUtilRt.toSystemIndependentName((String)this.resolveShortWindowsName(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String canonicalPath = string;
        ModuleBridge existingModule = this.getModuleByFilePath(canonicalPath);
        if (existingModule != null) {
            moduleBridge = existingModule;
        } else {
            String moduleName = ModulePath.Companion.getModuleNameByFilePath(canonicalPath);
            if (this.findModuleByName(moduleName) != null) {
                throw new ModuleWithNameAlreadyExists("Module already exists: " + moduleName, moduleName);
            }
            String string2 = PathUtilRt.getParentPath((String)canonicalPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
            String parentPath = string2;
            VirtualFileUrlManager virtualFileUrlManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
            String string3 = VfsUtilCore.pathToUrl((String)parentPath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathToUrl(...)");
            VirtualFileUrl baseModuleDir = virtualFileUrlManager.getOrCreateFromUrl(string3);
            EntitySource entitySource = LegacyBridgeJpsEntitySourceFactory.Companion.getInstance(this.project).createEntitySourceForModule(baseModuleDir, null);
            ModuleEntity moduleEntity = (ModuleEntity)this.getDiff().addEntity((WorkspaceEntity.Builder)ModuleEntityModifications.createModuleEntity((String)moduleName, (List)CollectionsKt.listOf((Object)ModuleSourceDependency.INSTANCE), (EntitySource)entitySource, arg_0 -> ModifiableModuleModelBridgeImpl.newModule$lambda$0$0(this, moduleTypeId, arg_0)));
            moduleBridge = this.createModuleInstance(moduleEntity, true);
        }
        value$iv = moduleBridge;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    private final String resolveShortWindowsName(String filePath) {
        String string;
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException iOException) {
            string = filePath;
        }
        return string;
    }

    private final ModuleBridge createModuleInstance(ModuleEntity moduleEntity, boolean isNew) {
        ModuleBridge moduleInstance = this.moduleManager.createModuleInstance$intellij_platform_projectModel_impl(moduleEntity, this.getEntityStorageOnDiff(), this.getDiff(), isNew, PrecomputedExtensionModelKt.precomputeModuleLevelExtensionModel());
        ModuleManagerBridgeImpl.Companion.getMutableModuleMap(this.getDiff()).addMapping((WorkspaceEntity)moduleEntity, (Object)moduleInstance);
        this.modulesToAdd.put((Object)moduleEntity.getName(), (Object)moduleInstance);
        this.currentModuleSet.add(moduleInstance);
        return moduleInstance;
    }

    private final ModuleBridge getModuleByFilePath(String filePath) {
        for (Module module : this.getModules()) {
            boolean bl;
            boolean bl2 = SystemInfo.isFileSystemCaseSensitive;
            if (bl2) {
                bl = Intrinsics.areEqual((Object)module.getModuleFilePath(), (Object)filePath);
            } else if (!bl2) {
                bl = StringsKt.equals((String)module.getModuleFilePath(), (String)filePath, (boolean)true);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean sameFilePath = bl;
            if (!sameFilePath) continue;
            Intrinsics.checkNotNull((Object)module, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge");
            return (ModuleBridge)module;
        }
        return null;
    }

    @NotNull
    public Module loadModule(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.loadModule(PathsKt.getInvariantSeparatorsPathString((Path)file));
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        AtomicLong arg0$iv = loadModuleTimeMs;
        boolean bl = false;
        ModuleBridge value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        String moduleName = ModulePath.Companion.getModuleNameByFilePath(filePath);
        if (this.findModuleByName(moduleName) != null) {
            throw new IllegalStateException(("Module name '" + moduleName + "' already exists. Trying to load module: " + filePath).toString());
        }
        ModuleEntity moduleEntity = this.moduleManager.loadModuleToBuilder(moduleName, filePath, this.getDiff());
        value$iv = this.createModuleInstance(moduleEntity, false);
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    public void disposeModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.getProject().isDisposed()) {
            return;
        }
        ModuleBridge cfr_ignored_0 = (ModuleBridge)module;
        String string = ((ModuleBridge)module).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (this.findModuleByName(string) == null) {
            ModifiableModuleModelBridgeImplKt.access$getLOG().error("Module '" + ((ModuleBridge)module).getName() + "' is not found. Probably it's already disposed.");
            return;
        }
        if (this.modulesToAdd.containsValue((Object)module)) {
            this.modulesToAdd.removeValue((Object)module);
            this.uncommittedModulesToDispose.add((ModuleBridge)module);
        }
        this.currentModuleSet.remove(module);
        this.newNameToModule.removeValue((Object)module);
        ((Map)this.modulesToDispose).put(((ModuleBridge)module).getName(), module);
        ModuleEntity moduleEntity = ModuleBridgeUtils.findModuleEntity((ModuleBridge)module, (EntityStorage)this.getDiff());
        if (moduleEntity == null) {
            ModifiableModuleModelBridgeImplKt.access$getLOG().error("Could not find module entity to remove by " + module);
            return;
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)moduleEntity.getDependencies());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)disposeModule$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> ModifiableModuleModelBridgeImpl.disposeModule$lambda$0(module, arg_0)), arg_0 -> ModifiableModuleModelBridgeImpl.disposeModule$lambda$1(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity it = (LibraryEntity)element$iv;
            boolean bl = false;
            this.getDiff().removeEntity((WorkspaceEntity)it);
        }
        this.getDiff().removeEntity((WorkspaceEntity)moduleEntity);
    }

    @Nullable
    public Module findModuleByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ModuleBridge addedModule = (ModuleBridge)this.modulesToAdd.get((Object)name);
        if (addedModule != null) {
            return addedModule;
        }
        if (this.modulesToDispose.containsKey(name)) {
            return null;
        }
        ModuleBridge newNameModule = (ModuleBridge)this.newNameToModule.get((Object)name);
        if (newNameModule != null) {
            return null;
        }
        return this.moduleManager.findModuleByName(name);
    }

    public void dispose() {
        AtomicLong arg0$iv = disposingTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        this.assertModelIsLive();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (ModuleBridge moduleToAdd : this.modulesToAdd.values()) {
            Disposer.dispose((Disposable)((Disposable)moduleToAdd));
        }
        Iterator<ModuleBridge> iterator = this.uncommittedModulesToDispose.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            ModuleBridge module = (ModuleBridge)object;
            Disposer.dispose((Disposable)((Disposable)module));
        }
        this.modulesToAdd.clear();
        this.modulesToDispose.clear();
        this.newNameToModule.clear();
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    public boolean isChanged() {
        return !((Map)this.modulesToAdd).isEmpty() || !((Map)this.modulesToDispose).isEmpty() || !((Map)this.newNameToModule).isEmpty() || this.moduleGroupsAreModified;
    }

    public void commit() {
        MutableEntityStorage diff = this.collectChanges();
        WorkspaceModel.Companion.getInstance(this.project).updateProjectModel("Module model commit", arg_0 -> ModifiableModuleModelBridgeImpl.commit$lambda$0(diff, arg_0));
    }

    @Override
    public void prepareForCommit() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Iterable $this$forEach$iv = this.uncommittedModulesToDispose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleBridge module = (ModuleBridge)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)module));
        }
    }

    @Override
    @NotNull
    public MutableEntityStorage collectChanges() {
        this.prepareForCommit();
        return this.getDiff();
    }

    public void renameModule(@NotNull Module module, @NotNull String newName) {
        List oldName;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        AtomicLong arg0$iv = moduleRenamingTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ModuleBridge cfr_ignored_0 = (ModuleBridge)module;
        Module oldModule = this.findModuleByName(newName);
        List uncommittedOldName = this.newNameToModule.getKeysByValue((Object)module);
        this.newNameToModule.removeValue((Object)module);
        this.newNameToModule.remove((Object)newName);
        Object object = uncommittedOldName;
        if (object == null) {
            String string = ((ModuleBridge)module).getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        if (!Intrinsics.areEqual((Object)(oldName = object), (Object)newName)) {
            ModuleBridge moduleToAdd = (ModuleBridge)TypeIntrinsics.asMutableMap((Object)((Map)this.modulesToAdd)).remove(oldName);
            if (moduleToAdd != null) {
                moduleToAdd.rename(newName, true);
                var16_15 = (Map)this.modulesToAdd;
                ModuleBridge moduleBridge = moduleToAdd;
                var16_15.put(newName, moduleBridge);
            } else {
                var16_15 = (Map)this.newNameToModule;
                Module module2 = module;
                var16_15.put(newName, module2);
            }
            ModuleEntity moduleEntity = ModuleBridgeUtils.findModuleEntity((ModuleBridge)module, this.getEntityStorageOnDiff().getCurrent());
            if (moduleEntity == null) {
                String string = "Unable to find module entity for " + module;
                throw new IllegalStateException(string.toString());
            }
            ModuleEntity entity = moduleEntity;
            ModuleEntityModifications.modifyModuleEntity((MutableEntityStorage)this.getDiff(), (ModuleEntity)entity, arg_0 -> ModifiableModuleModelBridgeImpl.renameModule$lambda$0$0(newName, arg_0));
        }
        if (oldModule != null) {
            Object[] objectArray = new Object[]{newName};
            throw new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])objectArray), newName);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @Nullable
    public Module getModuleToBeRenamed(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return (Module)this.newNameToModule.get((Object)newName);
    }

    @Nullable
    public String getNewName(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List list = this.newNameToModule.getKeysByValue((Object)((ModuleBridge)module));
        return list != null ? (String)CollectionsKt.single((List)list) : null;
    }

    @NotNull
    public String getActualName(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = this.getNewName(module);
        if (string == null) {
            String string2 = module.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @Nullable
    public String[] getModuleGroupPath(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ModuleManagerBridgeImpl.Companion.getModuleGroupPath$intellij_platform_projectModel_impl((ModuleBridge)module, this.getEntityStorageOnDiff());
    }

    public boolean hasModuleGroups() {
        return ModuleManagerBridgeImpl.Companion.hasModuleGroups$intellij_platform_projectModel_impl(this.getEntityStorageOnDiff());
    }

    public void setModuleGroupPath(@NotNull Module module, @Nullable String[] groupPath) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        EntityStorage storage = this.getEntityStorageOnDiff().getCurrent();
        ModuleEntity moduleEntity = ModuleBridgeUtils.findModuleEntity((ModuleBridge)module, storage);
        if (moduleEntity == null) {
            throw new IllegalStateException(("Could not resolve module entity for " + module).toString());
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        ModuleGroupPathEntity moduleGroupEntity = ModuleExtensions.getGroupPath((ModuleEntity)moduleEntity2);
        List groupPathList = groupPath != null ? ArraysKt.toMutableList((Object[])groupPath) : null;
        ModuleGroupPathEntity moduleGroupPathEntity = moduleGroupEntity;
        if (Intrinsics.areEqual((Object)(moduleGroupPathEntity != null ? moduleGroupPathEntity.getPath() : null), (Object)groupPathList)) {
            return;
        }
        if (moduleGroupEntity == null && groupPathList != null) {
            v2 = ModuleEntityModifications.modifyModuleEntity((MutableEntityStorage)this.getDiff(), (ModuleEntity)moduleEntity2, arg_0 -> ModifiableModuleModelBridgeImpl.setModuleGroupPath$lambda$0(groupPathList, moduleEntity2, arg_0));
        } else if (moduleGroupEntity == null && groupPathList == null) {
            v2 = Unit.INSTANCE;
        } else if (moduleGroupEntity != null && groupPathList == null) {
            v2 = this.getDiff().removeEntity((WorkspaceEntity)moduleGroupEntity);
        } else if (moduleGroupEntity != null && groupPathList != null) {
            v2 = ModuleGroupPathEntityModifications.modifyModuleGroupPathEntity((MutableEntityStorage)this.getDiff(), (ModuleGroupPathEntity)moduleGroupEntity, arg_0 -> ModifiableModuleModelBridgeImpl.setModuleGroupPath$lambda$1(groupPathList, arg_0));
        } else {
            throw new IllegalStateException("Should not be reached".toString());
        }
        this.moduleGroupsAreModified = true;
    }

    private static final ModuleTypeId moduleTypes$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return new ModuleTypeId(it);
    }

    private static final ModuleTypeId moduleTypes$lambda$1(Function1 $tmp0, Object p0) {
        return (ModuleTypeId)$tmp0.invoke(p0);
    }

    private static final Unit newNonPersistentModule$lambda$0(ModuleBridge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit newModule$lambda$0$0(ModifiableModuleModelBridgeImpl this$0, String $moduleTypeId, ModuleEntityBuilder $this$ModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ModuleEntity, (String)"$this$ModuleEntity");
        $this$ModuleEntity.setType((ModuleTypeId)this$0.moduleTypes.get($moduleTypeId));
        return Unit.INSTANCE;
    }

    private static final boolean disposeModule$lambda$0(Module $module, LibraryDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LibraryTableId libraryTableId = it.getLibrary().getTableId();
        LibraryTableId.ModuleLibraryTableId moduleLibraryTableId = libraryTableId instanceof LibraryTableId.ModuleLibraryTableId ? (LibraryTableId.ModuleLibraryTableId)libraryTableId : null;
        return Intrinsics.areEqual((Object)(moduleLibraryTableId != null ? moduleLibraryTableId.getModuleId() : null), (Object)((ModuleBridge)$module).getModuleEntityId());
    }

    private static final LibraryEntity disposeModule$lambda$1(ModifiableModuleModelBridgeImpl this$0, LibraryDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LibraryEntity)it.getLibrary().resolve((EntityStorage)this$0.getDiff());
    }

    private static final Unit commit$lambda$0(MutableEntityStorage $diff, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.applyChangesFrom($diff);
        return Unit.INSTANCE;
    }

    private static final Unit renameModule$lambda$0$0(String $newName, ModuleEntityBuilder $this$modifyModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
        $this$modifyModuleEntity.setName($newName);
        return Unit.INSTANCE;
    }

    private static final Unit setModuleGroupPath$lambda$0(List $groupPathList, ModuleEntity $moduleEntity, ModuleEntityBuilder $this$modifyModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
        ModuleEntityModifications.setGroupPath((ModuleEntityBuilder)$this$modifyModuleEntity, (ModuleGroupPathEntityBuilder)ModuleGroupPathEntityModifications.createModuleGroupPathEntity$default((List)$groupPathList, (EntitySource)$moduleEntity.getEntitySource(), null, (int)4, null));
        return Unit.INSTANCE;
    }

    private static final Unit setModuleGroupPath$lambda$1(List $groupPathList, ModuleGroupPathEntityBuilder $this$modifyModuleGroupPathEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyModuleGroupPathEntity, (String)"$this$modifyModuleGroupPathEntity");
        $this$modifyModuleGroupPathEntity.setPath($groupPathList);
        return Unit.INSTANCE;
    }

    static {
        Meter meter = JpsMetrics.getInstance().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        ModifiableModuleModelBridgeImpl.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModifiableModuleModelBridgeImpl$Companion;", "", "<init>", "()V", "moduleRenamingTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "disposingTimeMs", "loadModuleTimeMs", "newModuleTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement moduleRenamingTimeCounter = meter.counterBuilder("jps.modifiable.module.model.bridge.renaming.ms").buildObserver();
            ObservableLongMeasurement disposingTimeCounter = meter.counterBuilder("jps.modifiable.module.model.bridge.disposing.ms").buildObserver();
            ObservableLongMeasurement loadModuleTimeCounter = meter.counterBuilder("jps.modifiable.module.model.bridge.load.module.ms").buildObserver();
            ObservableLongMeasurement newModuleTimeCounter = meter.counterBuilder("jps.modifiable.module.model.bridge.new.module.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{disposingTimeCounter, loadModuleTimeCounter, newModuleTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(moduleRenamingTimeCounter, disposingTimeCounter, loadModuleTimeCounter, newModuleTimeCounter), (ObservableMeasurement)moduleRenamingTimeCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $moduleRenamingTimeCounter, ObservableLongMeasurement $disposingTimeCounter, ObservableLongMeasurement $loadModuleTimeCounter, ObservableLongMeasurement $newModuleTimeCounter) {
            $moduleRenamingTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)moduleRenamingTimeMs));
            $disposingTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)disposingTimeMs));
            $loadModuleTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadModuleTimeMs));
            $newModuleTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)newModuleTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

